/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.migration.common.CommonDeclares;
import com.ibm.websphere.migration.common.ConfigRepositoryHelper;
import com.ibm.websphere.migration.common.ConfigurationFile;
import com.ibm.websphere.migration.common.FileUtilities;
import com.ibm.websphere.migration.common.Logger;
import com.ibm.websphere.migration.common.OSInfo;
import com.ibm.websphere.migration.common.OSInfoFactory;
import com.ibm.websphere.migration.common.ReleaseVersion;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;

public class Configuration {
    protected static TraceComponent _tc = Tr.register((Class)Configuration.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    public static final String CLIENT_RESOURCE_FILE = "client-resource.xmi";
    public static final String J2C_PROPERTIES_FILE = "j2c.properties";
    public static final String CELL_FILE = "cell.xml";
    public static final String CLUSTERS_FILE = "cluster.xml";
    public static final String SECURITY_FILE = "security.xml";
    public static final String VIRTUAL_HOST_FILE = "virtualhosts.xml";
    public static final String ADMIN_AUTHZ_FILE = "admin-authz.xml";
    public static final String NAMING_AUTHZ_FILE = "naming-authz.xml";
    public static final String PMIRM_FILE = "pmirm.xml";
    public static final String INTEGRAL_JMS_AUTHORIZATIONS_FILE = "integral-jms-authorizations.xml";
    public static final String PERFTUNERS_FILE = "perftuners.xml";
    public static final String MULTIBROKER_FILE = "multibroker.xml";
    public static final String COREGROUP_FILE = "coregroup.xml";
    public static final String NODEGROUP_FILE = "nodegroup.xml";
    public static final String SIB_BUS_FILE = "sib-bus.xml";
    public static final String SIB_DESTINATIONS_FILE = "sib-destinations.xml";
    public static final String SIB_MEDIATIONS_FILE = "sib-mediations.xml";
    public static final String SIB_AUTHORISATIONS_FILE = "sib-authorisations.xml";
    public static final String SERVERS_FILE = "serverindex.xml";
    public static final String SERVERS_FILE_DISABLED = "serverindex.xml_disabled";
    public static final String NODE_FILE = "node.xml";
    public static final String SERVER_FILE = "server.xml";
    public static final String NAMESTORE_CELL_FILE = "namestore-cell.xml";
    public static final String NAMESTORE_NODE_FILE = "namestore-node.xml";
    public static final String WSSECURITY_FILE = "ws-security.xml";
    public static final String SIB_ENGINES_FILE = "sib-engines.xml";
    public static final String SIB_SERVICE_FILE = "sib-service.xml";
    public static final String HAMANAGER_SERVICE_FILE = "hamanagerservice.xml";
    public static final String PMI_FILE = "pmi-config.xml";
    public static final String PME_SERVER_FILE = "server-pme.xml";
    public static final String PME51_SERVER_FILE = "server-pme51.xml";
    public static final String NAMESTORE_FILE = "namestore.xml";
    public static final String RESOURCES_FILE = "resources.xml";
    public static final String VARIABLES_FILE = "variables.xml";
    public static final String NAMEBINDINGS_FILE = "namebindings.xml";
    public static final String LIBRARIES_FILE = "libraries.xml";
    public static final String PME_RESOURCES_FILE = "resources-pme.xml";
    public static final String PME502_RESOURCES_FILE = "resources-pme502.xml";
    public static final String CONFIG_DIRECTORY = "config";
    public static final String CELL_DIRECTORY = "cells";
    public static final String SERVER_DIRECTORY = "servers";
    public static final String NODES_DIRECTORY = "nodes";
    public static final String CLUSTERS_DIRECTORY = "clusters";
    public static final String COREGROUPS_DIRECTORY = "coregroups";
    public static final String DEFAULT_COREGROUP_DIRECTORY = "DefaultCoreGroup";
    public static final String NODEGROUPS_DIRECTORY = "nodegroups";
    public static final String DEFAULT_NODEGROUP_DIRECTORY = "DefaultNodeGroup";
    public static final String BUSES_DIRECTORY = "buses";
    public static final String DEFAULT_BUS_DIRECTORY = "DefaultBus";
    public static final String DEFAULT_DIRECTORY = "DEFAULT";
    public static final String APPLICATIONS_DIRECTORY = "applications";
    public static final String TEMPLATES_DIRECTORY = "templates";
    public static final String PROPERTIES_DIRECTORY = "properties";
    public static final String ORB_COMPATIBILITY_PROPERTYNAME = "com.ibm.websphere.ObjectIDVersionCompatibility";
    public static final String ORB_COMPATIBILITY_VALUE = "1";
    public static final String NO_CELLNAME = null;
    public static final String NO_NODENAME = null;
    public static final boolean NO_LOCK = false;
    public static final boolean YES_LOCK = true;
    public static final boolean NO_USEFILESYSTEM = false;
    public static final boolean YES_USEFILESYSTEM = true;
    public static final boolean NO_CREATE_FILE = false;
    public static final boolean YES_CREATE_FILE = true;
    public static final boolean WRITABLE = false;
    public static final boolean READONLY = true;
    public static final boolean NO_LOGGING = false;
    public static final boolean YES_LOGGING = true;
    private static ConfigRepositoryHelper _repositoryHelper = null;
    protected String _configDirectory = null;
    protected String _cellDirectory = null;
    protected String _nodeDirectory = null;
    protected String _cellName = null;
    protected String _nodeName = null;
    protected boolean _cellValid = false;
    protected boolean _nodeValid = false;
    protected Hashtable _configurationFilesList = new Hashtable();
    private Properties _cellVars = new Properties();
    private Properties _nodeVars = new Properties(this._cellVars);
    protected boolean _logReadMessages = false;
    protected ReleaseVersion _releaseVersion = null;
    protected String _owningNodeDirectory = null;
    protected String _owningNodeName = null;
    protected boolean _useFileSystem = false;
    boolean _isDeploymentManagerConfigurationDetermined = false;
    boolean _isDeploymentManagerConfiguration = false;

    public static void updateAll() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"updateAll");
        if (_repositoryHelper != null) {
            _repositoryHelper.updateAll();
        }
        String string = CommonDeclares._nls.getString("advise.logging.saved.configuration.success", "Configuration saved successfully.");
        Logger.printlnAll(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String resolveDirectory(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"resolveDirectory", (Object)string);
        String string2 = null;
        File file = new File(string);
        if (file == null || !file.exists()) throw new WASUpgradeException(CommonDeclares._nls.getFormattedMessage("advise.invalid.configuration", new Object[]{string}, "Unable to read configuration file " + string));
        File[] fileArray = file.listFiles();
        if (fileArray.length <= 0) return string2;
        Tr.debug((TraceComponent)_tc, (String)("Number of files in directory: " + file.getName() + " is: " + fileArray.length));
        if (fileArray.length == 1 && fileArray[0].isDirectory()) {
            return fileArray[0] + File.separator;
        }
        if (fileArray.length == 0) {
            throw new WASUpgradeException(CommonDeclares._nls.getFormattedMessage("advise.invalid.configuration", new Object[]{string}, "Unable to read configuration file " + string));
        }
        int n = 0;
        String string3 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            Tr.debug((TraceComponent)_tc, (String)("Checking name: " + file2.getName() + " in loop"));
            if (!file2.isDirectory()) continue;
            ++n;
            string3 = fileArray[i].getName();
        }
        if (n != true) throw new WASUpgradeException(CommonDeclares._nls.getFormattedMessage("advise.invalid.configuration", new Object[]{string}, "Unable to read configuration file " + string));
        return string + string3 + File.separator;
    }

    public Configuration(String string, String string2, String string3, boolean bl, ReleaseVersion releaseVersion, boolean bl2) throws WASUpgradeException {
        this(string, string2, string3, bl, releaseVersion, bl2, true);
    }

    public Configuration(String string, String string2, String string3, boolean bl, ReleaseVersion releaseVersion, boolean bl2, boolean bl3) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"Configuration", (Object)new Object[]{string, string2, string3, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        this._configDirectory = string;
        this._logReadMessages = bl;
        this._releaseVersion = releaseVersion;
        this._useFileSystem = bl3;
        if (string != null && !releaseVersion.isClient() && !releaseVersion.isR40()) {
            if (!this._useFileSystem && _repositoryHelper == null) {
                _repositoryHelper = new ConfigRepositoryHelper(string);
            }
            this._cellDirectory = this._configDirectory + CELL_DIRECTORY + File.separator;
            Tr.debug((TraceComponent)_tc, (String)("Config Path: " + this._cellDirectory));
            if (string2 != null) {
                this._cellName = string2;
                this._cellDirectory = this._cellDirectory + string2;
                if (!this._cellDirectory.endsWith(File.separator)) {
                    this._cellDirectory = this._cellDirectory + File.separator;
                }
            } else {
                this._cellDirectory = Configuration.resolveDirectory(this._cellDirectory);
                String string4 = this._cellDirectory.substring(0, this._cellDirectory.lastIndexOf(File.separator));
                this._cellName = string4.substring(string4.lastIndexOf(File.separator) + 1, string4.length());
            }
            this._cellValid = new File(this._cellDirectory).exists();
            this._nodeDirectory = this._cellDirectory + NODES_DIRECTORY + File.separator;
            Tr.debug((TraceComponent)_tc, (String)("Node Path: " + this._nodeDirectory));
            if (string3 != null) {
                this._nodeName = string3;
                this._nodeDirectory = this._nodeDirectory + this._nodeName;
                if (!this._nodeDirectory.endsWith(File.separator)) {
                    this._nodeDirectory = this._nodeDirectory + File.separator;
                }
            } else {
                this.setNodeDirectory(this.resolveNodeDirectory());
            }
            this._nodeValid = new File(this._nodeDirectory).exists();
            this._owningNodeDirectory = this.getNodeDirectory();
            try {
                this.populateVariableSet((List)this.getConfigurationFile(this.getNodeDirectory() + VARIABLES_FILE, false, true, false).getContents(), this._nodeVars);
            }
            catch (Exception exception) {
                Tr.entry((TraceComponent)_tc, (String)("No variables.xml file found at location: " + this.getNodeDirectory() + VARIABLES_FILE));
            }
            try {
                this.populateVariableSet((List)this.getConfigurationFile(this.getCellDirectory() + VARIABLES_FILE, false, true, false).getContents(), this._cellVars);
            }
            catch (Exception exception) {
                Tr.entry((TraceComponent)_tc, (String)("No variables.xml file found at location: " + this.getCellDirectory() + VARIABLES_FILE));
            }
        }
    }

    public void copyFile(String string, String string2) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyFile", (Object)new Object[]{string, string2});
        if (this._useFileSystem) {
            if (!new File(string2).exists()) {
                FileUtilities.copyFile(string, string2);
            }
        } else if (!_repositoryHelper.doesFileExistInConfigurationDir(string2)) {
            _repositoryHelper.createConfigurationDirFile(string2);
            _repositoryHelper.updateFile(string2, new File(string));
        }
    }

    public void copyFile(ByteArrayInputStream byteArrayInputStream, String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyFile", (Object)new Object[]{byteArrayInputStream, string});
        if (this._useFileSystem) {
            try {
                FileUtilities.copyBufferedInputStream(new BufferedInputStream(new FileInputStream(byteArrayInputStream.toString())), string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new WASUpgradeException();
            }
        } else {
            _repositoryHelper.createConfigurationDirFile(string);
            _repositoryHelper.updateFile(string, byteArrayInputStream);
        }
    }

    public boolean exists(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"exists", (Object)string);
        if (this._useFileSystem) {
            return new File(string).exists();
        }
        try {
            return _repositoryHelper.doesFileExistInConfigurationDir(string);
        }
        catch (WASUpgradeException wASUpgradeException) {
            return false;
        }
    }

    public ConfigRepositoryHelper getRepositoryHelper() {
        Tr.entry((TraceComponent)_tc, (String)"getConfigRepositoryHelper");
        return _repositoryHelper;
    }

    public String getPropertiesDirectory() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getPropertiesDirectory");
        return CommonDeclares._userRoot + File.separator + PROPERTIES_DIRECTORY + File.separator;
    }

    public String getCellName() {
        Tr.entry((TraceComponent)_tc, (String)"getCellName");
        Tr.debug((TraceComponent)_tc, (String)this._cellName);
        return this._cellName;
    }

    public String getCellDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getCellDirectory");
        Tr.debug((TraceComponent)_tc, (String)this._cellDirectory);
        return this._cellDirectory;
    }

    public String getConfigDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getConfigDirectory");
        Tr.debug((TraceComponent)_tc, (String)this._configDirectory);
        return this._configDirectory;
    }

    public String getNodeName() {
        Tr.entry((TraceComponent)_tc, (String)"getNodeName");
        Tr.debug((TraceComponent)_tc, (String)this._nodeName);
        return this._nodeName;
    }

    public String getOwningNodeDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getOwningNodeDirectory");
        Tr.debug((TraceComponent)_tc, (String)this._owningNodeDirectory);
        return this._owningNodeDirectory;
    }

    public String getOwningNodeName() {
        Tr.entry((TraceComponent)_tc, (String)"getOwningNodeName");
        Tr.debug((TraceComponent)_tc, (String)this._owningNodeName);
        String string = this._owningNodeName;
        if (this._owningNodeDirectory != null) {
            string = this._owningNodeDirectory.substring(0, this._owningNodeDirectory.length() - 1);
            return string.substring(string.lastIndexOf(File.separator) + 1, string.length());
        }
        return string;
    }

    public void setNodeDirectory(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setNodeDirectory", (Object)string);
        this._nodeDirectory = string;
        if (!string.endsWith(File.separator)) {
            this._nodeDirectory = this._nodeDirectory + File.separator;
        }
        String string2 = this._nodeDirectory.substring(0, this._nodeDirectory.lastIndexOf(File.separator));
        this._nodeName = string2.substring(string2.lastIndexOf(File.separator) + 1, string2.length());
        try {
            this.populateVariableSet((List)this.getConfigurationFile(this.getCellDirectory() + VARIABLES_FILE, false, true, false).getContents(), this._cellVars);
        }
        catch (Exception exception) {
            Tr.entry((TraceComponent)_tc, (String)("No variables.xml file found at location: " + this.getCellDirectory() + VARIABLES_FILE));
        }
    }

    public String getNodeDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getNodeDirectory", (Object)this._nodeDirectory);
        return this._nodeDirectory;
    }

    public String getBusDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getBusDirectory");
        return this._cellDirectory + BUSES_DIRECTORY + File.separator + this._nodeName + File.separator;
    }

    public String getCoregroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getCoregroupsDirectory");
        String string = this._cellDirectory + COREGROUPS_DIRECTORY + File.separator;
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + string));
        return string;
    }

    public String getDefaultCoregroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getDefaultCoregroupsDirectory");
        String string = this.getCoregroupsDirectory() + DEFAULT_COREGROUP_DIRECTORY + File.separator;
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + string));
        return string;
    }

    public String getNodegroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getNodegroupsDirectory");
        String string = this._cellDirectory + NODEGROUPS_DIRECTORY + File.separator;
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + string));
        return string;
    }

    public String getDefaultNodegroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getNodegroupsDirectory");
        String string = this.getNodegroupsDirectory() + DEFAULT_NODEGROUP_DIRECTORY + File.separator;
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + string));
        return string;
    }

    public ReleaseVersion getReleaseVersion() {
        Tr.entry((TraceComponent)_tc, (String)"getReleaseVersion", (Object)this._releaseVersion.toString());
        return this._releaseVersion;
    }

    public ServerIndex locateServerIndex(String string) throws WASUpgradeException {
        String string2;
        Tr.entry((TraceComponent)_tc, (String)"locateServerIndex", (Object)string);
        String string3 = string;
        if (!string.endsWith(File.separator)) {
            string3 = string + File.separator;
        }
        if (!this.exists(string2 = string3 + SERVERS_FILE)) {
            string2 = string3 + SERVERS_FILE_DISABLED;
        }
        ConfigurationFile configurationFile = this.getConfigurationFile(string2, false, true, false);
        Iterator iterator = configurationFile.getContents().iterator();
        ServerIndex serverIndex = null;
        while (iterator.hasNext() && serverIndex == null) {
            try {
                serverIndex = (ServerIndex)iterator.next();
            }
            catch (Exception exception) {}
        }
        return serverIndex;
    }

    public Security locateSecurity() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateSecurity");
        String string = this.getCellDirectory() + SECURITY_FILE;
        ConfigurationFile configurationFile = this.getConfigurationFile(string, false, true, false);
        Iterator iterator = configurationFile.getContents().iterator();
        Security security = null;
        while (iterator.hasNext() && security == null) {
            try {
                security = (Security)iterator.next();
            }
            catch (Exception exception) {}
        }
        return security;
    }

    public Object locateConfigFileObject(String string, Class clazz) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateConfigFileObject", (Object)new Object[]{string, clazz});
        return this.locateConfigFileObject(string, clazz, true);
    }

    public Object locateConfigFileObject(String string, Class clazz, boolean bl) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateConfigFileObject", (Object)new Object[]{string, clazz});
        EList eList = this.getConfigurationFile(string, false, bl, false).getContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isInstance(e)) continue;
            return e;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected String resolveNodeDirectory() throws WASUpgradeException {
        Tr.entry((TraceComponent)Configuration._tc, (String)"resolveNodeDirectory");
        if (!this._releaseVersion.areExtendedServerProductsInstalled()) ** GOTO lbl-1000
        if (this._releaseVersion.installedExtendedServerProducts().contains("ND")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_1 = false;
        }
        if (this._releaseVersion.isClient()) {
            return Configuration.resolveDirectory(this._nodeDirectory);
        }
        this._isDeploymentManagerConfigurationDetermined = true;
        if (var1_1) {
            try {
                Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for DMgr");
                var2_2 = this.resolveSpecificNodeType("DEPLOYMENT_MANAGER");
                this._isDeploymentManagerConfiguration = true;
                return var2_2;
            }
            catch (WASUpgradeException var2_3) {
                this._isDeploymentManagerConfiguration = false;
            }
        }
        try {
            Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for Node Agent");
            return this.resolveSpecificNodeType("NODE_AGENT");
        }
        catch (WASUpgradeException var2_4) {
            try {
                Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for ApplicationServer = Standalone");
                return this.resolveSpecificNodeType("APPLICATION_SERVER");
            }
            catch (WASUpgradeException var3_5) {
                try {
                    Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for Generic Server = Standalone");
                    return this.resolveSpecificNodeType("GENERIC_SERVER");
                }
                catch (WASUpgradeException var4_6) {
                    try {
                        Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for no Server = Custom");
                        return this.resolveSpecificNodeType(null);
                    }
                    catch (WASUpgradeException var5_7) {
                        throw new WASUpgradeException(this._cellDirectory);
                    }
                }
            }
        }
    }

    public String resolveSpecificNodeType(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"resolveSpecificNodeType", (Object)string);
        Object var2_2 = null;
        File file = new File(this._cellDirectory + File.separator + NODES_DIRECTORY);
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            Tr.debug((TraceComponent)_tc, (String)("Number of files in directory: " + file.getName() + " is: " + fileArray.length));
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                File[] fileArray2;
                File file2 = fileArray[i];
                Tr.debug((TraceComponent)_tc, (String)("Checking name: " + file2.getName() + " in loop"));
                if (!file2.isDirectory() || (fileArray2 = file2.listFiles()).length <= 1 || (string2 = this.getSetupCmdLineNodeName()) != null && !file2.getName().equals(string2)) continue;
                ServerIndex serverIndex = null;
                try {
                    serverIndex = this.locateServerIndex(file2.toString());
                    EList eList = serverIndex.getServerEntries();
                    Iterator iterator = eList.iterator();
                    if (string == null) {
                        if (iterator.hasNext()) {
                            Tr.debug((TraceComponent)_tc, (String)("Entry " + string + " in entry " + this._cellDirectory + " does not exist."));
                            throw new WASUpgradeException();
                        }
                        return file2.toString();
                    }
                    while (iterator.hasNext()) {
                        ServerEntry serverEntry = (ServerEntry)iterator.next();
                        if (!serverEntry.getServerType().equals(string)) continue;
                        return file2.toString();
                    }
                    continue;
                }
                catch (WASUpgradeException wASUpgradeException) {
                    Tr.debug((TraceComponent)_tc, (String)("Unable to open serverindex.xml file : " + file2.toString()));
                    Tr.debug((TraceComponent)_tc, (String)("Exception: " + wASUpgradeException.toString()));
                }
            }
        }
        Tr.debug((TraceComponent)_tc, (String)("Entry " + string + " in entry " + this._cellDirectory + " does not exist."));
        throw new WASUpgradeException();
    }

    private String getSetupCmdLineNodeName() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getSetupCmdLineNodeName");
        try {
            String string = System.getProperty("was.install.root");
            OSInfo oSInfo = OSInfoFactory.createOSInfo(string, string);
            String string2 = this._configDirectory + ".." + File.separator + "bin" + File.separator + "setupCmdLine" + oSInfo.fetchExecutableExtension();
            if (new File(string2).exists()) {
                BufferedReader bufferedReader = oSInfo.openFile(string2);
                String string3 = "";
                String string4 = null;
                String string5 = "";
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (!string4.trim().startsWith("WAS_NODE") && !string4.trim().startsWith("SET WAS_NODE")) continue;
                    string5 = string4.substring(string4.indexOf("=") + 1).trim();
                    break;
                }
                bufferedReader.close();
                return string5;
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WASUpgradeException();
        }
        catch (IOException iOException) {
            throw new WASUpgradeException();
        }
    }

    public boolean isFederatedNode() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isFederatedNode");
        return false;
    }

    public boolean isDeploymentManagerNode(String string) {
        block3: {
            Tr.entry((TraceComponent)_tc, (String)"isDeploymentManagerNode", (Object)string);
            try {
                ServerIndex serverIndex = this.locateServerIndex(string);
                EList eList = serverIndex.getServerEntries();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry = (ServerEntry)iterator.next();
                    if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_tc.isDebugEnabled()) break block3;
                Logger.printStackTrace(exception);
            }
        }
        return false;
    }

    public boolean isCellValid() {
        Tr.entry((TraceComponent)_tc, (String)"isCellValid", (Object)new Boolean(this._cellValid));
        return this._cellValid;
    }

    public boolean isNodeValid() {
        Tr.entry((TraceComponent)_tc, (String)"isNodeValid", (Object)new Boolean(this._nodeValid));
        return this._nodeValid;
    }

    public boolean isDeploymentManagerConfiguration() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isDeploymentManagerConfiguration");
        if (!this._isDeploymentManagerConfigurationDetermined) {
            Configuration configuration = new Configuration(this._configDirectory, this._cellName, this._nodeName, false, this._releaseVersion, true, false);
            try {
                configuration.resolveSpecificNodeType("DEPLOYMENT_MANAGER");
                this._isDeploymentManagerConfiguration = true;
            }
            catch (WASUpgradeException wASUpgradeException) {
                this._isDeploymentManagerConfiguration = false;
            }
            this._isDeploymentManagerConfigurationDetermined = true;
        }
        return this._isDeploymentManagerConfiguration;
    }

    public ConfigurationFile getConfigurationFile(String string, boolean bl) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{string, new Boolean(bl)});
        return this.getConfigurationFile(string, bl, true);
    }

    public ConfigurationFile getConfigurationFile(String string, boolean bl, boolean bl2) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{string, new Boolean(bl), new Boolean(bl2)});
        return this.getConfigurationFile(string, bl, false, bl2);
    }

    public ConfigurationFile getConfigurationFile(String string, boolean bl, boolean bl2, boolean bl3) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{string, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        return this.getConfigurationFile(string, bl, bl2, bl3, ConfigurationFile.class);
    }

    public ConfigurationFile getConfigurationFile(String string, boolean bl, boolean bl2, boolean bl3, Class clazz) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{string, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), clazz.getName()});
        if (this.isFileOpen(string)) {
            return this.getOpenConfigurationFileFromCache(string, bl2);
        }
        return this.openConfigurationFile(string, bl, bl2, bl3, clazz, bl2);
    }

    private ConfigurationFile openConfigurationFile(String string, boolean bl, boolean bl2, boolean bl3, Class clazz, boolean bl4) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"openConfigurationFile", (Object)new Object[]{string, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), clazz.getName()});
        ConfigurationFile configurationFile = null;
        try {
            Class[] classArray = new Class[]{Boolean.class, String.class, Configuration.class, Boolean.class};
            Object[] objectArray = new Object[]{new Boolean(this._useFileSystem), string, this, new Boolean(bl4)};
            Constructor constructor = clazz.getConstructor(classArray);
            configurationFile = (ConfigurationFile)constructor.newInstance(objectArray);
            boolean bl5 = false;
            bl5 = this._useFileSystem ? new File(string).exists() : this.exists(string);
            if (bl5) {
                if (this._logReadMessages && bl3) {
                    String string2 = CommonDeclares._nls.getFormattedMessage("advise.logging.read.success", new Object[]{string}, "Read configuration file " + string);
                    Logger.printlnAll(string2);
                }
            } else if (bl) {
                this.createConfigurationFile(configurationFile);
            } else {
                String string3 = CommonDeclares._nls.getFormattedMessage("advise.invalid.configuration", new Object[]{string}, "Unable to read configuration file: {0}");
                throw new WASUpgradeException(string3);
            }
            Tr.debug((TraceComponent)_tc, (String)("Opening ConfigurationFile named: " + string));
            configurationFile.open(this._configDirectory, this._cellName);
            this._configurationFilesList.put(this.normalizeFileName(string), configurationFile);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WASUpgradeException();
        }
        catch (WASUpgradeException wASUpgradeException) {
            throw wASUpgradeException;
        }
        catch (Exception exception) {
            throw new WASUpgradeException();
        }
        return configurationFile;
    }

    public void closeConfigurationFile(String string) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFile", (Object)new Object[]{string});
        this.closeConfigurationFile(string, true);
    }

    public void closeConfigurationFile(String string, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFile", (Object)new Object[]{string, new Boolean(bl)});
        try {
            if (this.isFileOpen(string)) {
                ConfigurationFile configurationFile = (ConfigurationFile)this._configurationFilesList.get(this.normalizeFileName(string));
                this.closeConfigurationFileCommon(configurationFile, bl);
                this._configurationFilesList.remove(this.normalizeFileName(string));
            }
        }
        catch (Exception exception) {
            Logger.printlnAll(CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.close", new Object[]{string}, "Could not close file {0}"));
        }
    }

    public void closeConfigurationFiles() {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFiles");
        this.closeConfigurationFiles(true);
    }

    public void closeConfigurationFiles(boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFiles", (Object)new Object[]{new Boolean(bl)});
        Enumeration enumeration = this._configurationFilesList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.closeConfigurationFile(string, bl);
        }
    }

    public boolean isFileOpen(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isFileOpen", (Object)new Object[]{string});
        return this._configurationFilesList.containsKey(this.normalizeFileName(string));
    }

    private ConfigurationFile getOpenConfigurationFileFromCache(String string, boolean bl) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getOpenConfigurationFileFromCache", (Object)new Object[]{string, new Boolean(bl)});
        ConfigurationFile configurationFile = (ConfigurationFile)this._configurationFilesList.get(this.normalizeFileName(string));
        if (!bl) {
            configurationFile.setWritable();
        }
        return configurationFile;
    }

    public ConfigurationFile getConfigurationFileWithSimpleFileName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFileWithSimpleFileName", (Object)new Object[]{string});
        ConfigurationFile configurationFile = null;
        Enumeration enumeration = this._configurationFilesList.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(TEMPLATES_DIRECTORY) >= 0 || !string.equals(string2.substring(n = string2.lastIndexOf(File.separator) + 1))) continue;
            configurationFile = (ConfigurationFile)this._configurationFilesList.get(string2);
            break;
        }
        return configurationFile;
    }

    protected void createConfigurationFile(ConfigurationFile configurationFile) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createConfigurationFile");
        String string = configurationFile.getFileName();
        try {
            configurationFile.create();
        }
        catch (WASUpgradeException wASUpgradeException) {
            String string2 = CommonDeclares._nls.getFormattedMessage("advise.unable.configuration.create", new Object[]{string}, "Unable to create configuration file: {0}");
            Logger.printlnErr(string2, wASUpgradeException);
            throw wASUpgradeException;
        }
        catch (Exception exception) {
            String string3 = CommonDeclares._nls.getFormattedMessage("advise.unable.configuration.create", new Object[]{string}, "Unable to create configuration file: {0}");
            Logger.printlnErr(string3, exception);
            throw new WASUpgradeException();
        }
    }

    protected void closeConfigurationFileCommon(ConfigurationFile configurationFile, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFileCommon", (Object)new Object[]{configurationFile, new Boolean(bl)});
        String string = configurationFile.getFileName();
        try {
            if (!this._useFileSystem || this._useFileSystem && configurationFile.isWritable()) {
                configurationFile.close();
                if (bl) {
                    String string2 = CommonDeclares._nls.getFormattedMessage("advise.logging.saved.success", new Object[]{string}, "Configuration file " + string + " ready to be saved.");
                    Logger.printlnAll(string2);
                }
            }
        }
        catch (Exception exception) {
            if (_tc.isDebugEnabled()) {
                Logger.printStackTrace(exception);
            }
            String string3 = CommonDeclares._nls.getFormattedMessage("advise.logging.no.save", new Object[]{string, exception}, "Unable to save configuration file {0}. Caught exception {1}.");
            Logger.printlnAll(string3);
        }
    }

    protected String normalizeFileName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"normalizeFileName", (Object)string);
        return new File(string).getAbsolutePath();
    }

    public Properties getNodeVariables() {
        return this._nodeVars;
    }

    public Properties getCellVariables() {
        return this._cellVars;
    }

    public void populateVariableSet(List list, Properties properties) {
        Tr.entry((TraceComponent)_tc, (String)"populateVariableSet", (Object)new Object[]{list, properties});
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof VariableMap)) continue;
            VariableMap variableMap = (VariableMap)e;
            EList eList = variableMap.getEntries();
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)iterator2.next();
                String string = variableSubstitutionEntry.getSymbolicName();
                String string2 = variableSubstitutionEntry.getValue();
                if (string == null || string2 == null) continue;
                properties.put(string, string2);
            }
        }
    }

    public String fixUpPath(String string) {
        Tr.entry((TraceComponent)_tc, (String)"fixUpPath", (Object)string);
        String string2 = this._nodeVars.getProperty("WAS_INSTALL_ROOT");
        String string3 = this._nodeVars.getProperty("USER_INSTALL_ROOT");
        String string4 = string;
        string = new File(string).getAbsolutePath().replace('\\', '/');
        if (!string2.endsWith("/") || !string2.endsWith("\\")) {
            string2 = string2 + File.separator;
        }
        if (!string3.endsWith("/") || !string3.endsWith("\\")) {
            string3 = string3 + File.separator;
        }
        if (string.startsWith(string2.replace('\\', '/'))) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(0, this._nodeVars.getProperty("WAS_INSTALL_ROOT").length(), "${WAS_INSTALL_ROOT}");
            return stringBuffer.toString();
        }
        if (string.startsWith(string3.replace('\\', '/'))) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(0, this._nodeVars.getProperty("USER_INSTALL_ROOT").length(), "${USER_INSTALL_ROOT}");
            return stringBuffer.toString();
        }
        return string4;
    }

    public String resolveEntryPath(String string) {
        Tr.entry((TraceComponent)_tc, (String)"resolveEntryPath", (Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "${}()", true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("$") && ((string2 = stringTokenizer.nextToken()).equals("{") || string2.equals("("))) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.equals("}") && !string2.equals(")")) {
                        stringBuffer.append(string2);
                    }
                    if (!string2.equals("}") && !string2.equals(")")) continue;
                    if (stringBuffer.toString().equalsIgnoreCase("CELL")) {
                        stringBuffer2.append(this.getCellName());
                    } else if (stringBuffer.toString().equalsIgnoreCase("NODE")) {
                        stringBuffer2.append(this.getNodeName());
                    } else {
                        stringBuffer2.append(this._nodeVars.getProperty(stringBuffer.toString()));
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer2.append(stringTokenizer.nextToken());
                    }
                    return this.resolveEntryPath(stringBuffer2.toString());
                }
            }
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }

    public void backupConfig() {
        Tr.entry((TraceComponent)_tc, (String)"backupConfig");
    }

    public String securitySettings() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"securitySettings");
        Security security = this.locateSecurity();
        boolean bl = security.isEnabled();
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(256).append("-username ").append("").append(" -password ").append("");
            return stringBuffer.toString();
        }
        if (bl) {
            UserRegistry userRegistry = security.getActiveUserRegistry();
            StringBuffer stringBuffer = new StringBuffer(256).append("-username ").append(userRegistry.getServerId()).append(" -password ").append(userRegistry.getServerPassword());
            return stringBuffer.toString();
        }
        return "";
    }
}

