/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.migration.common.CommonDeclares;
import com.ibm.websphere.migration.common.ErrHandler;
import com.ibm.websphere.migration.common.Logger;
import com.ibm.websphere.migration.common.OSInfo;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUtilities {
    protected static TraceComponent _tc = Tr.register((Class)FileUtilities.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    public static final String QUOTE = "\"";
    static final int BUFFER_SIZE = 4096;
    private static Hashtable _fileCollection = new Hashtable();

    public static void createDirectory(String string, String string2) throws WASUpgradeException {
        FileUtilities.traceEntry("createDirectory", new Object[]{string, string2});
        String string3 = string2 + " - " + string;
        File file = new File(string);
        if (file.exists()) {
            if (file.isFile()) {
                String string4 = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.create.directory.file", new Object[]{string}, "Unable to create directory. It already exists as a file: {0}");
                Logger.println(string4);
                throw new WASUpgradeException(string4);
            }
            FileUtilities.traceDebug("Directory already exists.");
        } else {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                FileUtilities.createDirectory(file2.getPath(), string2);
            }
            if (!file.mkdirs()) {
                String string5 = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.create.directory", new Object[]{string}, "Unable to create directory : {0}");
                Logger.println(string5);
                throw new WASUpgradeException(string5);
            }
            Logger.println(CommonDeclares._nls.getFormattedMessage("advise.logging.creating.directory", new Object[]{string3}, "Creating directory {0}"));
            FileUtilities.traceDebug("Create succeeded.");
        }
    }

    public static void copyDirectory(String string, String string2) throws WASUpgradeException {
        FileUtilities.traceEntry("copyDirectory; ", new Object[]{string, string2});
        File file = new File(string);
        if (!file.exists()) {
            String string3 = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.copy.no.source", new Object[]{string}, "Unable to copy directory.  Source does not exist: {0}");
            Logger.println(string3);
            throw new WASUpgradeException(string3);
        }
        if (!file.isDirectory()) {
            String string4 = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.copy.is.directory", new Object[]{string}, "Unable to copy directory.  Source directory is a file: {0}");
            Logger.println(string4);
            throw new WASUpgradeException(string4);
        }
        FileUtilities.createDirectory(string2, "destination directory");
        Logger.println(CommonDeclares._nls.getFormattedMessage("advise.logging.copying.directory", new Object[]{string2}, "Copying directory {0}"));
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            String string6 = string + File.separator + string5;
            File file2 = new File(string6);
            if (file2.isDirectory()) {
                FileUtilities.traceDebug("Processing Directory: ", string6);
                FileUtilities.copyDirectory(string6, string2 + File.separator + string5);
                continue;
            }
            FileUtilities.traceDebug("Processing File: ", string6);
            FileUtilities.copyFile(string6, string2 + File.separator + string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBufferedInputStream(BufferedInputStream bufferedInputStream, String string) throws WASUpgradeException {
        FileUtilities.traceEntry("copyBufferedInputStream", new Object[]{bufferedInputStream, string});
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            Object object2;
            try {
                object2 = new File(string);
                object = new FileOutputStream((File)object2);
                filterOutputStream = new BufferedOutputStream((OutputStream)object, 8192);
            }
            catch (IOException iOException) {
                String string2 = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.copy.file.target", new Object[]{string}, "Unable to copy file. Could not open destination file: {0}");
                Logger.println(string2);
                throw new WASUpgradeException(string2);
            }
            try {
                object2 = new byte[4096];
                while (bufferedInputStream.available() > 0) {
                    int n = bufferedInputStream.read((byte[])object2, 0, 4096);
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object2, 0, n);
                }
            }
            catch (IOException iOException) {
                object = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.copy.file.target", new Object[]{string}, "Unable to copy file. Could not open destination file: {0}");
                Logger.println(object);
                throw new WASUpgradeException((String)object);
            }
        }
        catch (Throwable throwable) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.println(CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.close", new Object[]{filterOutputStream}, "Could not close file: {0}"));
            }
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.println(CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.close", new Object[]{bufferedInputStream}, "Could not close file: {0}"));
            }
            throw throwable;
        }
        try {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
        catch (IOException iOException) {
            Logger.println(CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.close", new Object[]{filterOutputStream}, "Could not close file: {0}"));
        }
        try {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            Logger.println(CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.close", new Object[]{bufferedInputStream}, "Could not close file: {0}"));
        }
    }

    public static void copyFile(String string, String string2) throws WASUpgradeException {
        FileUtilities.traceEntry("copyFile", new Object[]{string, string2});
        BufferedInputStream bufferedInputStream = null;
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.copy.file", new Object[]{string}, "Unable to copy file.  Source does not exist: {0}");
            Logger.println(string3);
            throw new WASUpgradeException(string3);
        }
        FileUtilities.copyBufferedInputStream(bufferedInputStream, string2);
    }

    public static void copyFileOrDirectory(String string, String string2) throws WASUpgradeException {
        FileUtilities.traceEntry("copyFileOrDirectory");
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                FileUtilities.copyDirectory(string, string2);
            } else {
                File file2 = new File(string2);
                File file3 = file2.getParentFile();
                if (!file3.exists()) {
                    FileUtilities.createDirectory(file3.getPath(), "destination directory");
                }
                FileUtilities.copyFile(string, string2);
            }
        } else {
            String string3 = CommonDeclares._nls.getFormattedMessage("advise.logging.unable.to.copy.file", new Object[]{string}, "Unable to copy file.  Source does not exist: {0}");
            Logger.println(string3);
            throw new WASUpgradeException(string3);
        }
    }

    public static String generateFileName(String string) {
        FileUtilities.traceEntry("generateFileName", string);
        String string2 = null;
        int n = string.lastIndexOf(".");
        String string3 = string.substring(0, n);
        String string4 = string.substring(n);
        StringBuffer stringBuffer = new StringBuffer(new Date().toString().replace(' ', '-').replace(':', '.'));
        stringBuffer.replace(stringBuffer.length() - 8, stringBuffer.length() - 4, "");
        stringBuffer.insert(0, string3 + ".").append(string4);
        string2 = stringBuffer.toString();
        if (_fileCollection.containsKey(string)) {
            _fileCollection.remove(string);
        }
        _fileCollection.put(string, string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeBackupFile(String string) {
        FileUtilities.traceEntry("makeBackupFile", string);
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        String string2 = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            string2 = new String(FileUtilities.generateFileName(string));
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            randomAccessFile2 = new RandomAccessFile(string2, "rw");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.read(byArray);
            randomAccessFile2.write(byArray);
        }
        catch (Throwable throwable) {
            Logger.println(CommonDeclares._nls.getFormattedMessage("advise.logging.no.backup", new Object[]{string, throwable}, "Unable to make a backup of configuration file {0}. Caught exception {1}."));
        }
        finally {
            try {
                randomAccessFile.close();
                randomAccessFile2.close();
            }
            catch (Throwable throwable) {}
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreFromBackupFile(String string) {
        FileUtilities.traceEntry("restoreFromBackupFile", string);
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        try {
            String string2 = (String)_fileCollection.get(string);
            File file = new File(string2);
            if (!file.exists()) {
                Logger.printlnAll(CommonDeclares._nls.getFormattedMessage("advise.logging.no.restore", new Object[]{string, "none"}, "Unable to restore a configuration file {0}. Caught exception {1}."));
                return;
            }
            Object object = new File(string);
            ((File)object).delete();
            randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile2 = new RandomAccessFile(string2, "r");
            object = new byte[(int)randomAccessFile2.length()];
            randomAccessFile2.read((byte[])object);
            randomAccessFile.write((byte[])object);
        }
        catch (Throwable throwable) {
            Logger.printlnAll(CommonDeclares._nls.getFormattedMessage("advise.logging.no.restore", new Object[]{string, throwable}, "Unable to restore a configuration file {0}. Caught exception {1}."));
        }
        finally {
            try {
                randomAccessFile.close();
                randomAccessFile2.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String webSphereTreeRootForFile(String string, OSInfo oSInfo) {
        FileUtilities.traceEntry("webSphereTreeRootForFile");
        try {
            String string2 = new File(FileUtilities.getUnquotedName(string)).getCanonicalPath();
            String string3 = new File(FileUtilities.getUnquotedName(oSInfo.userRoot())).getCanonicalPath();
            if (string2.startsWith(string3)) {
                return string3;
            }
            String string4 = new File(FileUtilities.getUnquotedName(oSInfo.installRoot())).getCanonicalPath();
            if (string2.startsWith(string4)) {
                return string4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String webSphereTreeSuffixForFile(String string, OSInfo oSInfo) {
        FileUtilities.traceEntry("webSphereTreeSuffixForFile");
        String string2 = FileUtilities.webSphereTreeRootForFile(string, oSInfo);
        if (string2 == null) {
            return null;
        }
        try {
            String string3 = new File(FileUtilities.getUnquotedName(string)).getCanonicalPath();
            if (string2.length() + 1 < string3.length()) {
                return string3.substring(string2.length() + 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isInWebSphereTree(String string, OSInfo oSInfo) {
        FileUtilities.traceEntry("isInWebSphereTree");
        return FileUtilities.webSphereTreeRootForFile(string, oSInfo) != null;
    }

    public static void saveHashTable(Hashtable hashtable, String string) throws WASUpgradeException {
        FileUtilities.traceEntry("saveHashTable");
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            String string2 = CommonDeclares._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            Logger.println(string2);
            throw new WASUpgradeException(string2);
        }
    }

    public static Hashtable restoreHashTable(String string) throws WASUpgradeException {
        FileUtilities.traceEntry("restoreHashTable");
        Hashtable hashtable = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            String string2 = CommonDeclares._nls.getFormattedMessage("advise.error.reading.backup.options", new Object[]{string, exception}, "Unable to read backup options file {0}, exception {1}.");
            Logger.println(string2);
            throw new WASUpgradeException(string2);
        }
        return hashtable;
    }

    public static void saveVector(Vector vector, String string) throws WASUpgradeException {
        FileUtilities.traceEntry("saveVector", new Object[]{vector, string});
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(vector);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            String string2 = CommonDeclares._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            Logger.println(string2);
            throw new WASUpgradeException(string2);
        }
    }

    public static Vector restoreVector(String string) throws WASUpgradeException {
        FileUtilities.traceEntry("restoreVector", string);
        Vector vector = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            vector = (Vector)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            String string2 = CommonDeclares._nls.getFormattedMessage("advise.error.reading.backup.options", new Object[]{string, exception}, "Unable to read backup options file {0}, exception {1}.");
            Logger.println(string2);
            throw new WASUpgradeException(string2);
        }
        return vector;
    }

    public static void addToBackupList(Hashtable hashtable, String string, String string2, String string3) {
        FileUtilities.traceEntry("addToBackupList");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        hashtable.put(string + string3, string2 + string3);
    }

    public static String quotedFileName(String string) {
        FileUtilities.traceEntry("quotedFileName", string);
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return QUOTE + string + QUOTE;
    }

    public static String getUnquotedName(String string) {
        Object object;
        FileUtilities.traceEntry("getUnquotedName", string);
        File file = new File(string);
        file = new File(FileUtilities.unquoteString(file.getPath()));
        if (file.getPath().startsWith(QUOTE)) {
            object = new Vector();
            while (file.getName().length() > 0) {
                String string2 = file.getName();
                ((Vector)object).add(FileUtilities.unquoteString(string2));
                String string3 = file.getParent();
                file = new File(FileUtilities.unquoteString(string3));
            }
            for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
                file = new File(file, (String)((Vector)object).elementAt(i));
            }
        }
        object = file.getPath();
        if (string.endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return object;
    }

    public static String unquoteString(String string) {
        FileUtilities.traceEntry("unquoteString", string);
        if (FileUtilities.isQuoted(string)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isQuoted(String string) {
        FileUtilities.traceEntry("isQuoted", string);
        return string.length() > 2 && string.startsWith(QUOTE) && string.endsWith(QUOTE);
    }

    public static Element getDOMRoot(String string) throws WASUpgradeException {
        FileUtilities.traceEntry("getDOMRoot", new Object[]{string});
        Document document = null;
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrHandler());
            document = documentBuilder.parse(string);
            Element element = document.getDocumentElement();
            return element;
        }
        catch (Throwable throwable) {
            String string2 = CommonDeclares._nls.getFormattedMessage("advise.unable.to.read.XML", new Object[]{throwable.toString()}, "Unable to Read import XML document: {0}");
            Logger.printlnErr(string2, throwable);
            throw new WASUpgradeException(string2);
        }
    }

    private static void traceDebug(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)string);
        }
    }

    private static void traceDebug(String string, Object object) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)string, (Object)object);
        }
    }

    private static void traceEntry(String string, Object object) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)string, (Object)object);
        }
    }

    private static void traceEntry(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)string);
        }
    }

    public static void deleteDirectoryAndContents(File file) {
        FileUtilities.traceEntry("deleteDirectoryAndContents", new Object[]{file});
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                FileUtilities.deleteDirectoryAndContents(file2);
            }
        }
        file.delete();
    }

    public static byte[] serializeBinaryFile(String string) throws WASUpgradeException {
        FileUtilities.traceEntry("serializeBinaryFile", string);
        Vector vector = new Vector();
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WASUpgradeException();
        }
        catch (IOException iOException) {
            throw new WASUpgradeException();
        }
    }

    public static void deserializeBinaryFile(String string, byte[] byArray) throws WASUpgradeException {
        FileUtilities.traceEntry("deserializeBinaryFile", new Object[]{string, byArray});
        try {
            File file = new File(string);
            File file2 = new File(file.getParentFile().getAbsolutePath());
            if (!file2.exists()) {
                FileUtilities.createDirectory(file2.getAbsolutePath(), null);
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WASUpgradeException();
        }
        catch (IOException iOException) {
            throw new WASUpgradeException();
        }
    }

    public static Vector listFilesRecursively(String string) {
        FileUtilities.traceEntry("listFilesRecursively", string);
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                vector.add(fileArray[i].getAbsolutePath());
                continue;
            }
            vector.addAll(FileUtilities.listFilesRecursively(fileArray[i].getAbsolutePath()));
        }
        return vector;
    }

    public static void restoreArchive(String string, String string2) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"restoreArchive", (Object)string);
        try {
            ZipFile zipFile = new ZipFile(new File(string));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                File file = new File(string2 + File.separator + zipEntry.getName());
                if (file.exists()) {
                    file.delete();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                int n = bufferedInputStream.read();
                while (n != -1) {
                    ((OutputStream)fileOutputStream).write(n);
                    n = bufferedInputStream.read();
                }
                ((OutputStream)fileOutputStream).close();
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            throw new WASUpgradeException();
        }
    }

    public static String createArchive(String string, String string2, boolean bl, Vector vector) throws WASUpgradeException {
        FileUtilities.traceEntry("createArchive", new Object[]{string, string2});
        try {
            File file = new File(FileUtilities.generateFileName(string2));
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            File[] fileArray = new File(string).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                if (!fileArray[i].isFile() || !fileArray[i].getParentFile().equals(new File(string)) || fileArray[i].getAbsolutePath().equals(file.getAbsolutePath())) continue;
                int n = fileArray[i].getAbsolutePath().lastIndexOf(".");
                boolean bl2 = true;
                if (n != -1 && vector.contains(object = fileArray[i].getAbsolutePath().substring(n))) {
                    bl2 = false;
                }
                if (!bl2) continue;
                object = new FileInputStream(fileArray[i]);
                String string3 = fileArray[i].getAbsolutePath();
                if (!bl) {
                    String string4 = fileArray[i].getParentFile().getAbsolutePath();
                    string3 = string3.substring(string4.length() + 1);
                }
                zipOutputStream.putNextEntry(new ZipEntry(string3));
                int n2 = ((FileInputStream)object).read();
                while (n2 != -1) {
                    zipOutputStream.write(n2);
                    n2 = ((FileInputStream)object).read();
                }
                zipOutputStream.closeEntry();
                ((FileInputStream)object).close();
            }
            zipOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            throw new WASUpgradeException();
        }
    }
}

