/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.migration.common.CommonDeclares;
import com.ibm.websphere.migration.common.FileUtilities;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Logger {
    static FileOutputStream _logger = null;
    static FileOutputStream _statusFile = null;
    static final String messageHeader = "MIGR";
    protected static final String messageTemplate = "MIGRxxxxL";
    protected static final String warningMessage = "W";
    protected static final String errorMessage = "E";
    protected static TraceComponent _tc = Tr.register((Class)Logger.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    protected static boolean _initializedLogging = false;
    protected static PrintStream _originalErr = null;
    protected static PrintStream _originalOut = null;
    protected static PrintStream _newErr = null;
    protected static PrintStream _newOut = null;
    protected static PrintStream _statusErr = null;
    protected static PrintStream _statusOut = null;
    protected static boolean _loggedWarning = false;
    protected static boolean _loggedError = false;
    protected static boolean _skipStdout = false;
    protected static String _logLocation = null;

    public String getLogLocation() {
        Tr.entry((TraceComponent)_tc, (String)"getLogLocation");
        return _logLocation;
    }

    public Logger(String string, String string2, String string3) throws WASUpgradeException {
        this.initializeLogging(string, string2, string3);
    }

    public Logger(String string, String string2, String string3, boolean bl) throws WASUpgradeException {
        _skipStdout = bl;
        this.initializeLogging(string, string2, string3);
    }

    public static boolean Unregister() {
        if (Logger.isRegistered()) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
        }
        return Logger.isRegistered();
    }

    public static boolean isRegistered() {
        return _initializedLogging;
    }

    public static boolean loggedWarning() {
        return _loggedWarning;
    }

    public static boolean loggedError() {
        return _loggedError;
    }

    protected static void setWarningOrError(Object object) {
        String string = object.toString();
        if (string.lastIndexOf(messageHeader) != -1) {
            int n = string.lastIndexOf(messageHeader) + messageTemplate.length();
            String string2 = string.substring(n - 1, n);
            if (string2.equalsIgnoreCase(warningMessage)) {
                _loggedWarning = true;
            } else if (string2.equalsIgnoreCase(errorMessage)) {
                _loggedError = true;
            }
        }
    }

    protected void initializeLogging(String string, String string2, String string3) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"initializeLogging", (Object)new Object[]{string, string2, string3});
        if (Logger.isRegistered()) {
            return;
        }
        try {
            String string4 = FileUtilities.generateFileName(string2);
            _originalErr = System.err;
            _originalOut = System.out;
            _logLocation = string + string4;
            _logger = new FileOutputStream(_logLocation, true);
            if (string3 != null) {
                File file = new File(string3);
                if (!file.exists()) {
                    String string5 = file.getCanonicalPath();
                    File file2 = new File(string5 = string5.substring(0, string5.lastIndexOf(File.separator)));
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                } else {
                    file.delete();
                }
                _statusFile = new FileOutputStream(string3, true);
                _statusOut = new PrintStream(_statusFile);
                _statusErr = new PrintStream(_statusFile);
            }
            _newOut = new PrintStream(_logger);
            _newErr = new PrintStream(_logger);
            System.setOut(_newOut);
            System.setErr(_newErr);
            _initializedLogging = true;
            System.out.println(CommonDeclares._nls.getFormattedMessage("advise.logging.initialized", new Object[]{string2}, "Initialized Log File: {0}"));
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Logger failed to initialize with the following exception: ", (Object)exception);
            String string6 = CommonDeclares._nls.getFormattedMessage("advise.logging.initialized.failure", new Object[]{string2}, "Failure to initialize Log File: {0}");
            throw new WASUpgradeException(string6);
        }
    }

    public static void printStackTrace(Throwable throwable) {
        throwable.printStackTrace();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)throwable.toString());
        }
    }

    public static void printlnErr(Object object, Throwable throwable) {
        throwable.printStackTrace();
        Logger.printlnAll(throwable.toString());
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)object.toString());
        }
    }

    public static void println(Object object) {
        Logger.setWarningOrError(object);
        System.out.println(object);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)object.toString());
        }
    }

    public static void println(Object object, Object object2) {
        Logger.setWarningOrError(object);
        Logger.setWarningOrError(object2);
        System.out.print(object);
        System.out.println(object2);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)object.toString());
            Tr.debug((TraceComponent)_tc, (String)object2.toString());
        }
    }

    public static void printlnAll(Object object) {
        Logger.setWarningOrError(object);
        if (Logger.isRegistered()) {
            if (!_skipStdout) {
                System.setOut(_originalOut);
                System.setErr(_originalErr);
            }
            System.out.println(object);
            if (_statusFile != null) {
                System.setOut(_statusOut);
                System.setErr(_statusErr);
                System.out.println(object);
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.println(object);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)object.toString());
        }
    }

    public static void printlnAll(Object object, Object object2) {
        Logger.setWarningOrError(object);
        Logger.setWarningOrError(object2);
        if (Logger.isRegistered()) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
            System.out.println(object);
            System.out.println(object2);
            if (_statusFile != null) {
                System.setOut(_statusOut);
                System.setErr(_statusErr);
                System.out.println(object);
                System.out.println(object2);
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.print(object);
        System.out.println(object2);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)object.toString());
            Tr.debug((TraceComponent)_tc, (String)object2.toString());
        }
    }
}

