/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.migration.common.Configuration;
import com.ibm.websphere.migration.common.FileUtilities;
import com.ibm.websphere.migration.common.OSInfo;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.product.xml.websphere.websphere;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReleaseVersion {
    protected static TraceComponent _tc = Tr.register((Class)ReleaseVersion.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    public static final String ADMIN_CONFIG = "";
    public static final String SERVER_CONFIG = "config" + File.separator + "server-cfg.xml";
    public static final String CONFIG_DIRECTORY = "config";
    public static final ReleaseVersion UNKNOWN = new ReleaseVersion(false, false, "", false);
    public static final ReleaseVersion R40_AE = new ReleaseVersion(true, false, "", false);
    public static final ReleaseVersion R40_AES = new ReleaseVersion(false, false, SERVER_CONFIG, true);
    public static final ReleaseVersion R40_AE_WITH_EE = new ReleaseVersion(true, true, "", false);
    public static final ReleaseVersion R40_AES_WITH_EE = new ReleaseVersion(false, true, SERVER_CONFIG, true);
    public static final ReleaseVersion[] R40_INSTANCES = new ReleaseVersion[]{R40_AE, R40_AES, R40_AE_WITH_EE, R40_AES_WITH_EE};
    public static final ReleaseVersion[] R40_NON_EE_INSTANCES = new ReleaseVersion[]{R40_AE, R40_AES};
    public static final ReleaseVersion R50_EXPRESS = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R50_BOBCAT = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R50_BASE = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R50_ND = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R50_CLIENT = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R50_EXPRESS_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R50_BOBCAT_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R50_BASE_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R50_ND_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R50_CLIENT_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion[] R50_INSTANCES = new ReleaseVersion[]{R50_EXPRESS, R50_BOBCAT, R50_BASE, R50_ND, R50_CLIENT, R50_EXPRESS_WITH_PME, R50_BOBCAT_WITH_PME, R50_BASE_WITH_PME, R50_ND_WITH_PME, R50_CLIENT_WITH_PME};
    public static final ReleaseVersion[] R50_NON_EE_INSTANCES = new ReleaseVersion[]{R50_EXPRESS, R50_BOBCAT, R50_BASE, R50_ND, R50_CLIENT};
    public static final ReleaseVersion R51_EXPRESS = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R51_BOBCAT = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R51_BASE = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R51_ND = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R51_CLIENT = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R51_EXPRESS_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R51_BOBCAT_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R51_BASE_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R51_ND_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion R51_CLIENT_WITH_PME = new ReleaseVersion(true, true, "config", false);
    public static final ReleaseVersion[] R51_INSTANCES = new ReleaseVersion[]{R51_EXPRESS, R51_BOBCAT, R51_BASE, R51_ND, R51_CLIENT, R51_EXPRESS_WITH_PME, R51_BOBCAT_WITH_PME, R51_BASE_WITH_PME, R51_ND_WITH_PME, R51_CLIENT_WITH_PME};
    public static final ReleaseVersion[] R51_NON_EE_INSTANCES = new ReleaseVersion[]{R51_EXPRESS, R51_BOBCAT, R51_BASE, R51_ND, R51_CLIENT};
    public static final ReleaseVersion R60_EXPRESS = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R60_BOBCAT = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R60_BASE = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R60_ND = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion R60_CLIENT = new ReleaseVersion(true, false, "config", false);
    public static final ReleaseVersion[] R60_INSTANCES = new ReleaseVersion[]{R60_EXPRESS, R60_BOBCAT, R60_BASE, R60_ND, R60_CLIENT};
    public static final String JMS_LISTENER_SERVICE = "jmsListener";
    public static final String INTERNATIONALIZATION_SERVICE = "I18nService";
    public static final String WORK_AREA_SERVICE = "WorkAreaService";
    public static final String ACTIVITY_SESSION_SERVICE = "ActivitySessionService";
    public static final String APPLICATION_PROFILE_SERVICE = "ApplicationProfileService";
    public static final String EXTENDED_MESSAGING_SERVICE = "ExtendedMessagingService";
    public static final String FLOW_CONTAINER = "FlowContainer";
    public static final String MEMBER_MANAGER_SERVICE = "MemberManagerService";
    public static final String OBJECT_POOL_SERVICE = "ObjectPoolService";
    public static final String SCHEDULER_SERVICE = "SchedulerService";
    public static final String STAFF_SERVICE = "StaffService";
    public static final String WORK_MANAGER_SERVICE = "WorkManagerService";
    public static final String ADAPTIVE_ENTITY_SERVICE = "AdaptiveEntityService";
    public static final String BEI_SERVICE = "BeiService";
    public static final String CACHE_INSTANCE_SERVICE = "CacheInstanceService";
    public static final String ENTITY_CHANGE_NOTIFICATION_SERVICE = "EntityChangeNotificationService";
    public static final String WBIA_SERVICE = "WbiaService";
    public static final String COMPENSATION_SERVICE = "CompensationService";
    public static final String SERVICE_REFERENCE_SERVICE = "ServiceReferenceService";
    public static final String BUSINESS_CONTEXT_DATA_SERVICE = "BusinessContextDataService";
    public static final String EVENTS_SERVICE = "EventsService";
    public static final String WORK_AREA_PARTITION_SERVICE = "WorkAreaPartitionService";
    public static final String BUSINESS_RULE_BEANS = "BRBeans";
    public static final String CORBA_SDK = "CorbaSDK";
    public static final String DYNAMIC_QUERY = "EjbQuery";
    public static final String CLUSTERS = "Clusters";
    public static final String[][] PME_COMPONENT_TO_FEATURE_MAP = new String[][]{{"brb", "BRBeans"}, {"acwa", "WorkAreaService"}, {"i18nctx", "I18nService"}, {"eborb", "CorbaSDK"}, {"objsvcs", "CorbaSDK"}, {"vtlib", "CorbaSDK"}, {"activity.session.pme", "ActivitySessionService"}, {"appprofile.ee", "ApplicationProfileService"}, {"cmm", "ExtendedMessagingService"}, {"workflow", "FlowContainer"}, {"wmm", "MemberManagerService"}, {"objectpool", "ObjectPoolService"}, {"scheduler", "SchedulerService"}, {"staffsupport", "StaffService"}, {"asynchbeans.impl", "WorkManagerService"}, {"NOT_SHIPPED", "AdaptiveEntityService"}, {"bei", "BeiService"}, {"dynacache.pme", "CacheInstanceService"}, {"NOT_SHIPPED", "EntityChangeNotificationService"}, {"wbia", "WbiaService"}, {"compensation", "CompensationService"}, {"srm", "ServiceReferenceService"}, {"wei", "BusinessContextDataService"}, {"wei", "EventsService"}, {"acwa", "WorkAreaPartitionService"}, {"ejbquery", "EjbQuery"}};
    public static final String EXTENDED_SERVER_PRODUCT_BASE = "BASE";
    public static final String EXTENDED_SERVER_PRODUCT_PME = "PME";
    public static final String EXTENDED_SERVER_PRODUCT_ND = "ND";
    public static final String EXTENDED_SERVER_PRODUCT_CLIENT = "CLIENT";
    public static final String EXTENDED_SERVER_PRODUCT_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String EXTENDED_SERVER_PRODUCT_EXPRESS = "EXPRESS";
    private static final Vector _products = new Vector();
    private static Vector _wasProducts = null;
    private boolean _isEEInstalled;
    private int _ptfLevel = 0;
    private boolean _isAEInstalled;
    private String _defaultConfigFileName;
    private boolean _supportsUserSpecifiedConfigFileName;
    private OSInfo _osInfo;
    private Vector _installedEEFeatures;
    private Vector _extendedServerProducts;
    private Vector _expressServerProducts;
    private boolean _client;
    private String _version = null;

    public static ReleaseVersion getReleaseVersion(String string, OSInfo oSInfo) throws WASUpgradeException {
        ReleaseVersion.traceEntry("getReleaseVersion");
        ReleaseVersion releaseVersion = ReleaseVersion.useWASProduct(string, oSInfo);
        if (releaseVersion == null) {
            releaseVersion = ReleaseVersion.readProductInformation(string, oSInfo);
        }
        if (releaseVersion == null) {
            releaseVersion = UNKNOWN;
        }
        return releaseVersion;
    }

    private static void traceEntry(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)string);
        }
    }

    private static void traceEntry(String string, Object object) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)string, (Object)object);
        }
    }

    private static void traceDebug(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)string);
        }
    }

    private ReleaseVersion(boolean bl, boolean bl2, String string, boolean bl3) {
        ReleaseVersion.traceEntry("ReleaseVersion");
        this._isAEInstalled = bl;
        this._isEEInstalled = bl2;
        this._defaultConfigFileName = string;
        this._supportsUserSpecifiedConfigFileName = bl3;
    }

    public boolean isAEInstalled() {
        ReleaseVersion.traceEntry("isAEInstalled");
        if (this.isR50() || this.isR51() || this.isR60()) {
            throw new IllegalStateException();
        }
        return this._isAEInstalled;
    }

    public boolean isEEInstalled() {
        ReleaseVersion.traceEntry("isEEInstalled");
        return this._isEEInstalled;
    }

    public boolean isClient() {
        ReleaseVersion.traceEntry("isClient");
        return this._client;
    }

    public boolean isBase() {
        ReleaseVersion.traceEntry("isBase");
        if (this.areExpressServerProductsInstalled() || this.isClient()) {
            return false;
        }
        Vector vector = this.installedExtendedServerProducts();
        return vector.size() == 0 || vector.size() == 1 && vector.contains(EXTENDED_SERVER_PRODUCT_PME);
    }

    public boolean isBase(Configuration configuration) throws WASUpgradeException {
        ReleaseVersion.traceEntry("isBase", configuration);
        if (this.areExpressServerProductsInstalled() || this.isClient()) {
            return false;
        }
        return !configuration.isDeploymentManagerConfiguration();
    }

    public Vector installedExtendedServerProducts() {
        ReleaseVersion.traceEntry("installedExtendedServerProducts");
        return this._extendedServerProducts;
    }

    public boolean isExtendedServerProductInstalled(String string) {
        ReleaseVersion.traceEntry("isExtendedServerProductInstalled");
        return this.installedExtendedServerProducts().contains(string);
    }

    public boolean areExtendedServerProductsInstalled() {
        ReleaseVersion.traceEntry("areExtendedServerProductsInstalled");
        Vector vector = this.installedExtendedServerProducts();
        if (vector == null) {
            return false;
        }
        return vector.size() > 0;
    }

    public Vector installedExpressServerProducts() {
        ReleaseVersion.traceEntry("installedExpressServerProducts");
        return this._expressServerProducts;
    }

    public boolean isExpressServerProductInstalled(String string) {
        ReleaseVersion.traceEntry("isExpressServerProductInstalled");
        return this.installedExpressServerProducts().contains(string);
    }

    public boolean areExpressServerProductsInstalled() {
        ReleaseVersion.traceEntry("areExpressServerProductsInstalled");
        return this.installedExpressServerProducts().size() > 0;
    }

    public Vector installedEEFeatures() {
        ReleaseVersion.traceEntry("installedEEFeatures");
        return this._installedEEFeatures;
    }

    public boolean isEEFeatureInstalled(String string) {
        ReleaseVersion.traceEntry("isEEFeatureInstalled");
        return this.installedEEFeatures().contains(string);
    }

    public String version() {
        ReleaseVersion.traceEntry("version");
        return this._version;
    }

    protected void version(String string) {
        ReleaseVersion.traceEntry("version", string);
        this._version = string;
    }

    public int ptfLevel() {
        ReleaseVersion.traceEntry("ptfLevel");
        return this._ptfLevel;
    }

    protected void ptfLevel(int n) {
        ReleaseVersion.traceEntry("ptfLevel");
        this._ptfLevel = n;
    }

    public String defaultConfigFileName() {
        ReleaseVersion.traceEntry("defaultConfigFileName");
        if (this._defaultConfigFileName.equals(ADMIN_CONFIG)) {
            return this._osInfo.installRoot() + this._defaultConfigFileName;
        }
        return this._osInfo.userRoot() + this._defaultConfigFileName;
    }

    public boolean isConfigInDB() {
        ReleaseVersion.traceEntry("isConfigInDB");
        return this._defaultConfigFileName.equals(ADMIN_CONFIG);
    }

    public boolean supportsUserSpecifiedConfigFileName() {
        ReleaseVersion.traceEntry("supportsUserSpecifiedConfigFileName");
        return this._supportsUserSpecifiedConfigFileName;
    }

    public boolean isR40() {
        ReleaseVersion.traceEntry("isR40");
        for (int i = 0; i < R40_INSTANCES.length; ++i) {
            if (this != R40_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isR50() {
        ReleaseVersion.traceEntry("isR50");
        for (int i = 0; i < R50_INSTANCES.length; ++i) {
            if (this != R50_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isR51() {
        ReleaseVersion.traceEntry("isR51");
        for (int i = 0; i < R51_INSTANCES.length; ++i) {
            if (this != R51_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isR60() {
        ReleaseVersion.traceEntry("isR60");
        for (int i = 0; i < R60_INSTANCES.length; ++i) {
            if (this != R60_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isUnnamedDefaultInstanceProvided() throws WASUpgradeException {
        ReleaseVersion.traceEntry("isUnnamedDefaultInstanceProvided");
        if (this.isClient() || this.isR40() || this.isR50() || this.isR51()) {
            return true;
        }
        File file = new File(this._osInfo.configRoot());
        if (file.exists()) {
            try {
                new Configuration(file.getPath() + File.separator, null, null, false, this, false, true);
                return true;
            }
            catch (WASUpgradeException wASUpgradeException) {
                ReleaseVersion.traceDebug("Failed to instantiate a Configuration for a default instance.");
            }
        }
        return false;
    }

    public String installableAppsDirectoryName(OSInfo oSInfo) throws WASUpgradeException {
        ReleaseVersion.traceEntry("installableAppsDirectoryName", oSInfo);
        return oSInfo.userRoot() + "installableApps";
    }

    public boolean standardCharacterEncodingUsed() {
        ReleaseVersion.traceEntry("standardCharacterEncodingUsed");
        return !this.isR40();
    }

    public boolean commonUNIXCommandOptionsExist() {
        ReleaseVersion.traceEntry("commonUNIXCommandOptionsExist");
        return !this.isR40() || this.ptfLevel() >= 2;
    }

    public boolean useJRESh() {
        ReleaseVersion.traceEntry("useJRESh");
        return false;
    }

    public String xmlConfigFileName(OSInfo oSInfo) throws WASUpgradeException {
        ReleaseVersion.traceEntry("xmlConfigFileName");
        return this._osInfo.installRoot() + this.jarFileName();
    }

    public String jarFileName() {
        ReleaseVersion.traceEntry("jarFileName");
        return "lib" + File.separator + "xmlconfig.jar";
    }

    public String instance() {
        ReleaseVersion.traceEntry("instance");
        return this._osInfo.instance();
    }

    public String classLoaderSettings(String string) throws WASUpgradeException {
        ReleaseVersion.traceEntry("classLoaderSettings");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        if (this._osInfo.useWSLauncher()) {
            return this.extDirs(string2) + this.classPath() + " com.ibm.ws.bootstrap.WSLauncher";
        }
        return this.extDirs40(string2) + " -jar " + FileUtilities.quotedFileName(this._osInfo.installRoot() + "lib" + File.separator + "bootstrap.jar");
    }

    private String classPath() {
        ReleaseVersion.traceEntry("classPath");
        String string = " -classpath ";
        if (!this._osInfo.installRoot().equalsIgnoreCase(this._osInfo.userRoot())) {
            string = string + FileUtilities.quotedFileName(this._osInfo.userRoot() + "properties") + File.pathSeparator;
        }
        string = string + FileUtilities.quotedFileName(this._osInfo.installRoot() + "properties") + File.pathSeparator;
        string = string + FileUtilities.quotedFileName(this._osInfo.installRoot() + "lib" + File.separator + "bootstrap.jar");
        return string;
    }

    private String extDirs40(String string) throws WASUpgradeException {
        ReleaseVersion.traceEntry("extDirs40");
        String string2 = " -Dws.ext.dirs=" + FileUtilities.quotedFileName(string) + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.installRoot() + "classes") + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.installRoot() + "lib" + File.separator + "ext") + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.installRoot() + "lib") + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.installRoot() + "web" + File.separator + "help") + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.installRoot() + "properties") + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.dbDriverPath());
        return string2;
    }

    private String extDirs(String string) throws WASUpgradeException {
        ReleaseVersion.traceEntry("extDirs");
        String string2 = " -Dws.ext.dirs=" + FileUtilities.quotedFileName(string) + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.installRoot() + "classes") + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(this._osInfo.userRoot() + "lib" + File.separator + "ext") + File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(this._osInfo.getAdditionalExtDirs(), File.pathSeparator, false);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + FileUtilities.quotedFileName(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + File.pathSeparator;
        }
        return string2;
    }

    private static ReleaseVersion readProductInformation(String string, OSInfo oSInfo) throws WASUpgradeException {
        ReleaseVersion.traceEntry("getProductInformation", string);
        String string2 = string + "com" + File.separator + "ibm" + File.separator + "websphere" + File.separator + "product.xml";
        File file = new File(string2);
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        return ReleaseVersion.importProductXML(FileUtilities.getDOMRoot(string2), oSInfo);
    }

    private static ReleaseVersion importProductXML(Element element, OSInfo oSInfo) {
        ReleaseVersion.traceEntry("importProductXML", element);
        Object var2_2 = null;
        String string = null;
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName("appserver");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
        }
        NodeList nodeList2 = element2.getElementsByTagName("version");
        Element element3 = (Element)nodeList2.item(0);
        string = ReleaseVersion.getTextValue(element3);
        ReleaseVersion.traceDebug("Version = " + string);
        Element element4 = null;
        NodeList nodeList3 = element2.getElementsByTagName("edition");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            element4 = (Element)nodeList3.item(i);
        }
        Element element5 = null;
        NodeList nodeList4 = element4.getElementsByTagName("value");
        for (int i = 0; i < nodeList4.getLength(); ++i) {
            element5 = (Element)nodeList4.item(i);
        }
        String string2 = ReleaseVersion.getTextValue(element5);
        ReleaseVersion.traceDebug("Edition = " + string2);
        boolean bl = string2.equalsIgnoreCase("advanced") || string2.equalsIgnoreCase("AE");
        int n = 0;
        if (!bl) {
            ++n;
        }
        Vector vector = ReleaseVersion.installedEEFeatures(element2);
        Vector<String> vector2 = new Vector<String>();
        if (vector.size() > 0) {
            vector2.add(EXTENDED_SERVER_PRODUCT_PME);
        }
        return ReleaseVersion.getReleaseVersion(string, n, vector2, new Vector(), vector, oSInfo, false);
    }

    private static Vector installedEEFeatures(Element element) {
        ReleaseVersion.traceEntry("installedEEFeatures");
        Vector<String> vector = new Vector<String>();
        if (ReleaseVersion.isEEFeatureInstalled("WSEE Extended Messaging Support Feature", element)) {
            vector.add(JMS_LISTENER_SERVICE);
        }
        if (ReleaseVersion.isEEFeatureInstalled("WSEE Internationalization Service Feature", element)) {
            vector.add(INTERNATIONALIZATION_SERVICE);
        }
        if (ReleaseVersion.isEEFeatureInstalled("WSEE WorkArea Service Feature", element)) {
            vector.add(WORK_AREA_SERVICE);
        }
        if (ReleaseVersion.isEEFeatureInstalled("WSEE Business Rules Beans Feature", element)) {
            vector.add(BUSINESS_RULE_BEANS);
        }
        if (ReleaseVersion.isEEFeatureInstalled("WSEE CORBA C++ SDK Feature", element)) {
            vector.add(CORBA_SDK);
        }
        return vector;
    }

    private static boolean isEEFeatureInstalled(String string, Element element) {
        ReleaseVersion.traceEntry("isEEFeatureInstalled");
        NodeList nodeList = element.getElementsByTagName("extensions");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName("extension");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                if (!element3.getAttribute("name").equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getTextValue(Element element) {
        ReleaseVersion.traceEntry("getTextValue", element);
        element.normalize();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            String string = nodeList.item(i).getNodeValue();
            ReleaseVersion.traceDebug("Return string " + string);
            return string;
        }
        return ADMIN_CONFIG;
    }

    private static ReleaseVersion useWASProduct(String string, OSInfo oSInfo) {
        Object object;
        ReleaseVersion.traceEntry("useWASProduct", string);
        String string2 = string + "version";
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        string2 = file.getPath();
        WASProduct wASProduct = new WASProduct(string2.substring(0, string2.lastIndexOf("properties")));
        websphere websphere2 = wASProduct.getPlatform();
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        String string3 = null;
        Iterator iterator = wASProduct.getProducts();
        while (iterator.hasNext()) {
            product product2 = (product)iterator.next();
            object = product2.getId();
            if (!_wasProducts.contains(object)) continue;
            if (!((String)object).equals(EXTENDED_SERVER_PRODUCT_PME)) {
                string3 = product2.getVersion();
            }
            if (((String)object).equals(EXTENDED_SERVER_PRODUCT_BASE) || ((String)object).equals(EXTENDED_SERVER_PRODUCT_CLIENT)) continue;
            if (((String)object).equals(EXTENDED_SERVER_PRODUCT_EXPRESS) || ((String)object).equals(EXTENDED_SERVER_PRODUCT_EMBEDDED_EXPRESS)) {
                vector2.add(object);
                continue;
            }
            if (((String)object).equals(EXTENDED_SERVER_PRODUCT_ND) && wASProduct.productPresent(EXTENDED_SERVER_PRODUCT_BASE)) continue;
            vector.add(object);
        }
        int n = -1;
        iterator = _products.iterator();
        while (iterator.hasNext() && n == -1) {
            object = (String)iterator.next();
            if (wASProduct.getProductById((String)object) == null) continue;
            n = _products.indexOf(object);
        }
        object = new Vector();
        for (int i = 0; i < PME_COMPONENT_TO_FEATURE_MAP.length; ++i) {
            if (!wASProduct.componentPresent(PME_COMPONENT_TO_FEATURE_MAP[i][0]) || ((Vector)object).contains(PME_COMPONENT_TO_FEATURE_MAP[i][1])) continue;
            ((Vector)object).add(PME_COMPONENT_TO_FEATURE_MAP[i][1]);
        }
        return ReleaseVersion.getReleaseVersion(string3, n, vector, vector2, (Vector)object, oSInfo, n == _products.indexOf(EXTENDED_SERVER_PRODUCT_CLIENT));
    }

    private static ReleaseVersion getReleaseVersion(String string, int n, Vector vector, Vector vector2, Vector vector3, OSInfo oSInfo, boolean bl) {
        ReleaseVersion.traceEntry("getReleaseVersion");
        ReleaseVersion releaseVersion = UNKNOWN;
        if (string.startsWith("4.0")) {
            if (vector.contains(EXTENDED_SERVER_PRODUCT_PME)) {
                n += R40_NON_EE_INSTANCES.length;
            }
            releaseVersion = R40_INSTANCES[n];
        }
        if (string.startsWith("5.0")) {
            if (vector.contains(EXTENDED_SERVER_PRODUCT_PME)) {
                n += R50_NON_EE_INSTANCES.length;
            }
            releaseVersion = R50_INSTANCES[n];
        }
        if (string.startsWith("5.1")) {
            if (vector.contains(EXTENDED_SERVER_PRODUCT_PME)) {
                n += R51_NON_EE_INSTANCES.length;
            }
            releaseVersion = R51_INSTANCES[n];
        }
        if (string.startsWith("6.0")) {
            releaseVersion = R60_INSTANCES[n];
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() >= 3) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                releaseVersion.ptfLevel(Integer.parseInt(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        releaseVersion._osInfo = oSInfo;
        releaseVersion._installedEEFeatures = vector3;
        releaseVersion._extendedServerProducts = vector;
        releaseVersion._expressServerProducts = vector2;
        releaseVersion._client = bl;
        releaseVersion.version(string.substring(0, string.indexOf(".") + 2));
        return releaseVersion;
    }

    static {
        _products.add(EXTENDED_SERVER_PRODUCT_EXPRESS);
        _products.add(EXTENDED_SERVER_PRODUCT_EMBEDDED_EXPRESS);
        _products.add(EXTENDED_SERVER_PRODUCT_BASE);
        _products.add(EXTENDED_SERVER_PRODUCT_ND);
        _products.add(EXTENDED_SERVER_PRODUCT_CLIENT);
        _wasProducts = (Vector)_products.clone();
        _wasProducts.add(EXTENDED_SERVER_PRODUCT_PME);
    }
}

