/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.adapter.migration;

import com.ibm.db2j.tools.MigrateFrom51;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.wsspi.migration.utility.Logger;
import com.ibm.wsspi.migration.utility.ProductImage;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class CloudscapeMigrationUtility {
    private static final TraceComponent tc = Tr.register((Class)CloudscapeMigrationUtility.class, (String)"com.ibm.ws.migration.WASUpgrade", null);
    public static final String NLS_FILE = "IBMDataStoreAdapterNLS";
    private static final TraceNLS NLS = TraceNLS.getTraceNLS((String)"IBMDataStoreAdapterNLS");
    private static ArrayList sampleList = new ArrayList(17);

    public static String mapCloudscapeName(String string, Scenario scenario, String string2) {
        ProductImage productImage = scenario.getNewProductImage();
        Logger logger = scenario.getLogger();
        int n = Math.abs(string.hashCode());
        String string3 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        StringBuffer stringBuffer = new StringBuffer(128);
        String string4 = productImage.getProfile().getDirectory().getAbsolutePath();
        stringBuffer.append(string4).append(File.separatorChar).append("databases").append(File.separatorChar).append(string3).append("_").append(n).append("_").append(string2);
        logger.println(Logger.Level.INFORMATION, "new database to be created is: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    private static String returnMigrationLogName(String string, ProductImage productImage, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        string = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        stringBuffer.append(productImage.getProfile().getDirectory().getAbsolutePath()).append(File.separatorChar).append("logs").append(File.separatorChar).append(string).append("_migrationLog").append(string2).append(".log");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"migration log is: ", (Object)stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static String returnDebugFileName(String string, ProductImage productImage, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        string = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        stringBuffer.append(productImage.getProfile().getDirectory().getAbsolutePath()).append(File.separatorChar).append("logs").append(File.separatorChar).append(string).append("_migrationDebug").append(string2).append(".log");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"migration Debug file is: ", (Object)stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static Object[] migrateCloudscape(String string, String string2, Scenario scenario, String string3) {
        Exception exception = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"migrateCloudscape [oldName, newName, scenario, timestamp]:", (Object)new Object[]{string, string2, scenario, string3});
        }
        ProductImage productImage = scenario.getNewProductImage();
        Logger logger = scenario.getLogger();
        String string4 = string.replaceAll(";create=true", "");
        String string5 = string2.replaceAll(";create=true", "");
        String string6 = CloudscapeMigrationUtility.returnMigrationLogName(string4, productImage, string3);
        String string7 = productImage.getInstallationDirectory().getAbsolutePath();
        StringBuffer stringBuffer = new StringBuffer(string7);
        stringBuffer.append(File.separatorChar).append("derby");
        Properties properties = new Properties();
        if (tc.isDebugEnabled()) {
            properties.put("db2j.migrate.verbose", "true");
        }
        properties.put("db2j.migrate.newDBURL", "jdbc:derby:" + string5);
        properties.put("db2j.migrate.debugLog", CloudscapeMigrationUtility.returnDebugFileName(string4, productImage, string3));
        properties.put("db2j.migrate.migrateLog", string6);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("derby home + " + stringBuffer));
        }
        System.setProperty("derby.system.home", stringBuffer.toString());
        System.setProperty("db2j.system.home", stringBuffer.toString());
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Migrating with props = : " + properties));
            }
            MigrateFrom51.doMigrate((Properties)properties, (String)("jdbc:db2j:" + string4));
        }
        catch (SQLException sQLException) {
            String string8 = sQLException.getSQLState();
            int n = -1;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("exception is thrown : " + sQLException));
                Tr.debug((TraceComponent)tc, (String)("sqlState is: " + string8));
            }
            if (string8 != null) {
                n = new Integer(string8.substring(string8.length() - 2));
            }
            switch (n) {
                case 2: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("CLOUDSCAPE_MIGRATION_FAILURE", new Object[]{string4, string5, sQLException}));
                    exception = new Exception(CloudscapeMigrationUtility.getNLSMessage("CLOUDSCAPE_MIGRATION_FAILURE", new Object[]{string4, string5, sQLException}));
                }
                case 13: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("PARTIAL_CLOUDSCAPE_MIGRATION", new Object[]{string4, string5, "populating tables", "keys, checks, views, triggers, aliases, and stored statements"}));
                    break;
                }
                case 14: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("PARTIAL_CLOUDSCAPE_MIGRATION", new Object[]{string4, string5, "recreating keys", "checks, views, triggers, aliases, and stored statements"}));
                    break;
                }
                case 15: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("PARTIAL_CLOUDSCAPE_MIGRATION", new Object[]{string4, string5, "recreating checks", "views, triggers, aliases, and stored statements"}));
                    break;
                }
                case 16: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("PARTIAL_CLOUDSCAPE_MIGRATION", new Object[]{string4, string5, "recreating views", "triggers, aliases, and stored statements"}));
                    break;
                }
                case 17: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("PARTIAL_CLOUDSCAPE_MIGRATION", new Object[]{string4, string5, "recreating  triggers", "aliases, and stored statements"}));
                    break;
                }
                case 18: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("PARTIAL_CLOUDSCAPE_MIGRATION", new Object[]{string4, string5, "recreating  aliases", "stored statements"}));
                    break;
                }
                case 19: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("PARTIAL_CLOUDSCAPE_MIGRATION", new Object[]{string4, string5, "recreating  stored statements", "shutting down the database"}));
                    break;
                }
                default: {
                    logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("CLOUDSCAPE_MIGRATION_FAILURE", new Object[]{string4, string5, sQLException}));
                    CloudscapeMigrationUtility.deleteDirectoryAndContents(new File(string5));
                    exception = new Exception(CloudscapeMigrationUtility.getNLSMessage("CLOUDSCAPE_MIGRATION_FAILURE", new Object[]{string4, string5, sQLException}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"migrateCloudscape returned: ", (Object)new Object[]{string6, exception});
        }
        return new Object[]{string6, exception};
    }

    public static boolean validateDBExistance(String string, Scenario scenario) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateDBExistance: ", (Object)string);
        }
        boolean bl = false;
        ProductImage productImage = scenario.getOldProductImage();
        String string2 = productImage.getInstallationDirectory().getAbsolutePath();
        String string3 = string2 + "cloudscape";
        if (string.lastIndexOf(File.separator) == -1) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(File.separatorChar).append("cloudscape").append(File.separatorChar).append(string);
            string = stringBuffer.toString();
        }
        if (new File(string).exists()) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateDBExistance: returns: ", (Object)new Boolean(bl));
        }
        return bl;
    }

    public static void rollbackCloudscape(String string, Scenario scenario) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollbackCloudscape: [dbName, s]", (Object)new Object[]{string, scenario});
        }
        ProductImage productImage = scenario.getNewProductImage();
        Logger logger = scenario.getLogger();
        File file = new File(string);
        logger.println(Logger.Level.INFORMATION, CloudscapeMigrationUtility.getNLSMessage("CLOUDSCAPE_MIGRATION_DELETION_ATTEMPT", string));
        for (int i = 20; file.exists() && i > 0; --i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"database exist, attempting to delete it");
            }
            CloudscapeMigrationUtility.deleteDirectoryAndContents(new File(string));
        }
        if (file.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"database deletion failed");
            }
            logger.println(Logger.Level.WARNING, CloudscapeMigrationUtility.getNLSMessage("CLOUDSCAPE_MIGRATION_DELETION_FAILURE", string));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"database deletion succeeded");
            }
            logger.println(Logger.Level.INFORMATION, CloudscapeMigrationUtility.getNLSMessage("CLOUDSCAPE_MIGRATION_DELETION_DONE ", string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollbackCloudscape");
        }
    }

    private static void deleteDirectoryAndContents(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                CloudscapeMigrationUtility.deleteDirectoryAndContents(file2);
            }
        }
        file.delete();
    }

    public static final String getNLSMessage(String string) {
        return NLS.getString(string, string);
    }

    public static final String getNLSMessage(String string, Object object) {
        Object[] objectArray;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return NLS.getFormattedMessage(string, objectArray, string);
    }

    public static final boolean isSampleDS(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSampleDS", (Object)string);
        }
        boolean bl = sampleList.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSampleDS: returns", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        sampleList.add("Scheduler_AccountReport");
        sampleList.add("GreenhouseDB");
        sampleList.add("GreenhouseSchedulerDB");
        sampleList.add("OrderProcessorDB");
        sampleList.add("WarehouseDB");
        sampleList.add("ASSAMPLE");
        sampleList.add("AdventureDB");
        sampleList.add("CatalogDB");
        sampleList.add("AppProfileSampleDB");
        sampleList.add("WST_PriceGen");
        sampleList.add("BANKDS");
        sampleList.add("i18nctx");
        sampleList.add("PLANTSDB");
        sampleList.add("QuerySamp");
        sampleList.add("TechSamp");
        sampleList.add("AlbumDB");
        sampleList.add("Default Datasource");
    }
}

