/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.applicationinstalltask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.dom.DeferredElementImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationInstallTask
extends AbstractTask {
    private static TraceComponent _tc = Tr.register((Class)ApplicationInstallTask.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    protected TraceNLS _nls = TraceNLS.getTraceNLS((String)"com.ibm.websphere.migration.WASUpgrade");
    public static final String CONST_FOR_MIGR_DISABLE = "com.ibm.websphere.application.migration.disabled";
    public static final String FILE_SEP = java.io.File.separator;
    public static final String PATH_SEP = java.io.File.pathSeparator;
    public static final int BUFFER_SIZE = 4096;
    protected InstallScheduler _scheduler;
    protected Hashtable _errorFiles = new Hashtable();

    public boolean performTask() throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"performTask");
        this._scheduler = (InstallScheduler)this.scheduler;
        Tr.debug((TraceComponent)_tc, (String)("Found scheduler of type " + this._scheduler.getClass().getName()));
        Object v = this._scheduler.getProperties().get(CONST_FOR_MIGR_DISABLE);
        if (v != null && v instanceof String && new Boolean((String)v).booleanValue()) {
            return true;
        }
        EARFile eARFile = this._scheduler.getEarFile();
        this.validateArchive((Archive)eARFile, false);
        if (!this._errorFiles.isEmpty()) {
            java.io.File file = this.createTempFile((Archive)eARFile);
            ZipOutputStream zipOutputStream = this.createZipOutputStream(file);
            Tr.debug((TraceComponent)_tc, (String)("Attempting to create new ear file at " + file.getPath()));
            this.writeCorrectedArchiveContents((Archive)eARFile, zipOutputStream);
            this._scheduler.setEarPath(file.getPath());
            EARFile eARFile2 = this._scheduler.getEarFile(false, false);
            this.validateArchive((Archive)eARFile2, true);
        }
        return true;
    }

    protected void validateArchive(Archive archive, boolean bl) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"validateArchive", (Object)new Object[]{archive, new Boolean(bl)});
        EList eList = archive.getFiles();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Archive) {
                this.validateArchive((Archive)e, bl);
                continue;
            }
            this.validateArchiveFile((File)e, archive, bl);
        }
    }

    protected void validateArchiveFile(File file, Archive archive, boolean bl) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"validateArchiveFile", (Object)new Object[]{file, archive, new Boolean(bl)});
        String string = file.getURI();
        if (string.indexOf("-pme") != -1 && string.endsWith(".xmi")) {
            try {
                Resource resource = archive.getMofResource(string);
            }
            catch (ResourceLoadException resourceLoadException) {
                if (bl) {
                    String string2 = this._nls.getFormattedMessage("advise.unsupported.wbi.resource", new Object[]{resourceLoadException}, "Found unsupported IBM WebSphere Business Integration Server Foundation resource in application.");
                    throw new AdminException((Throwable)resourceLoadException, string2);
                }
                String string3 = this.createArchiveKey(archive);
                Hashtable<String, ResourceLoadException> hashtable = (Hashtable<String, ResourceLoadException>)this._errorFiles.get(string3);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, ResourceLoadException>();
                    this._errorFiles.put(string3, hashtable);
                }
                hashtable.put(string, resourceLoadException);
                Tr.debug((TraceComponent)_tc, (String)("Found file " + string + " in archive " + string3 + " which needs to be updated."));
                Container container = archive.getContainer();
                Archive archive2 = archive;
                while (container != null && container instanceof Archive) {
                    Archive archive3 = (Archive)container;
                    string3 = this.createArchiveKey(archive3);
                    hashtable = (Hashtable<String, ResourceLoadException>)this._errorFiles.get(string3);
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, ResourceLoadException>();
                        this._errorFiles.put(string3, hashtable);
                    }
                    hashtable.put(archive2.getURI(), (ResourceLoadException)((Object)string));
                    Tr.debug((TraceComponent)_tc, (String)("Found archive " + archive2.getURI() + " in parent archive " + string3 + " which needs to be updated."));
                    archive2 = archive3;
                    container = archive3.getContainer();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string4 = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{fileNotFoundException}, "An unexpected internal error occurred, exception {0}.");
                throw new AdminException((Throwable)fileNotFoundException, string4);
            }
        }
    }

    protected String createArchiveKey(Archive archive) {
        Tr.entry((TraceComponent)_tc, (String)"createArchiveKey", (Object)archive);
        String string = archive.getURI();
        for (Container container = archive.getContainer(); container != null && container instanceof Archive; container = container.getContainer()) {
            string = container.getURI() + PATH_SEP + string;
        }
        return string;
    }

    protected void writeCorrectedArchiveContents(Archive archive, ZipOutputStream zipOutputStream) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"writeCorrectedArchiveContents", (Object)new Object[]{archive, zipOutputStream});
        String string = this.createArchiveKey(archive);
        Hashtable hashtable = (Hashtable)this._errorFiles.get(string);
        Tr.debug((TraceComponent)_tc, (String)("Trying to update archive " + archive.getURI() + " in parent archive " + string + "."));
        EList eList = archive.getFiles();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.addArchiveEntry(file, zipOutputStream);
            if (file instanceof Archive) {
                Archive archive2 = (Archive)file;
                String string2 = this.createArchiveKey(archive2);
                if (this._errorFiles.containsKey(string2)) {
                    java.io.File file2 = this.createTempFile(archive2);
                    ZipOutputStream zipOutputStream2 = this.createZipOutputStream(file2);
                    this.writeCorrectedArchiveContents(archive2, zipOutputStream2);
                    InputStream inputStream = this.createInputStream(file2);
                    this.copyData(inputStream, zipOutputStream);
                } else {
                    this.copyDataFromFile((File)archive2, zipOutputStream);
                }
            } else if (hashtable.containsKey(file.getURI())) {
                Tr.debug((TraceComponent)_tc, (String)("Trying to update file " + file.getURI() + " in archive " + string + "."));
                this.attemptFixupXmiFile(file, zipOutputStream, (Exception)hashtable.get(file.getURI()));
            } else {
                this.copyDataFromFile(file, zipOutputStream);
            }
            this.closeArchiveEntry(zipOutputStream);
        }
        this.closeZipOutputStream(zipOutputStream);
    }

    protected void attemptFixupXmiFile(File file, ZipOutputStream zipOutputStream, Exception exception) throws AdminException {
        int n;
        NodeList nodeList;
        Tr.entry((TraceComponent)_tc, (String)"attemptFixupXmiFile", (Object)new Object[]{file, zipOutputStream});
        boolean bl = true;
        Document document = this.openXmiFile(file);
        Element element = document.getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("xmlns:cmmejbext");
        if (node != null) {
            Tr.debug((TraceComponent)_tc, (String)("Found attr: " + node.getNodeName() + " with value " + node.getNodeValue()));
        }
        if ((nodeList = element.getElementsByTagName("cmmEJBJarExtension")) != null) {
            Tr.debug((TraceComponent)_tc, (String)("Found " + nodeList.getLength() + " cmm stanzas"));
            block0: for (n = 0; n < nodeList.getLength() && bl; ++n) {
                Element element2 = (Element)nodeList.item(n);
                if (this.containsMoreThanSpecifiedAttributes(element2, "xmi:id")) {
                    bl = false;
                    break;
                }
                Vector vector = this.getChildElements(element2);
                Tr.debug((TraceComponent)_tc, (String)("Found " + vector.size() + " cmm children"));
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    Element element3 = (Element)iterator.next();
                    String string = element3.getNodeName();
                    if (string != null && string.equals("ejbJarExtension")) {
                        Vector vector2 = this.getChildElements(element3);
                        if (vector2.size() > 0) {
                            bl = false;
                            continue block0;
                        }
                        if (!this.containsMoreThanSpecifiedAttributes(element3, "href")) continue;
                        bl = false;
                        continue block0;
                    }
                    bl = false;
                    continue block0;
                }
            }
        }
        Tr.debug((TraceComponent)_tc, (String)("File is fixable: " + bl));
        if (bl) {
            element.removeAttribute("xmlns:cmmejbext");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element.removeChild(nodeList.item(n));
            }
        } else {
            String string = this._nls.getFormattedMessage("advise.unsupported.wbi.resource", new Object[]{exception}, "Found unsupported IBM WebSphere Business Integration Server Foundation resource in application.");
            throw new AdminException((Throwable)exception, string);
        }
        this.saveXmiFile(document, zipOutputStream);
    }

    protected Vector getChildElements(Element element) {
        Tr.entry((TraceComponent)_tc, (String)"getChildElements", (Object)element);
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof DeferredElementImpl)) continue;
            vector.addElement(node);
        }
        return vector;
    }

    protected boolean containsMoreThanSpecifiedAttributes(Element element, String string) {
        Tr.entry((TraceComponent)_tc, (String)"containsMoreThanSpecifiedAttributes", (Object)new Object[]{element, string});
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                String string2 = node.getNodeName();
                if (string2 != null && string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected Document openXmiFile(File file) throws AdminException {
        Document document;
        Tr.entry((TraceComponent)_tc, (String)"openXmiFile", (Object)file);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file.getInputStream());
            document.getDocumentElement().normalize();
        }
        catch (Exception exception) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)exception, string);
        }
        return document;
    }

    protected void saveXmiFile(Document document, OutputStream outputStream) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"saveXmiFile", (Object)outputStream);
        try {
            DOMSource dOMSource = new DOMSource(document.getDocumentElement());
            StreamResult streamResult = new StreamResult(outputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)exception, string);
        }
    }

    protected Archive openArchive(java.io.File file) throws AdminException {
        Archive archive;
        Tr.entry((TraceComponent)_tc, (String)"openArchive", (Object)file);
        try {
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            archive = commonarchiveFactory.openArchive(file.getPath());
        }
        catch (OpenFailureException openFailureException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{openFailureException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)openFailureException, string);
        }
        return archive;
    }

    protected InputStream createInputStream(java.io.File file) throws AdminException {
        BufferedInputStream bufferedInputStream;
        Tr.entry((TraceComponent)_tc, (String)"createInputStream", (Object)file);
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string);
        }
        return bufferedInputStream;
    }

    protected ZipOutputStream createZipOutputStream(java.io.File file) throws AdminException {
        ZipOutputStream zipOutputStream;
        Tr.entry((TraceComponent)_tc, (String)"createZipOutputStream", (Object)file);
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (IOException iOException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string);
        }
        return zipOutputStream;
    }

    protected void closeZipOutputStream(ZipOutputStream zipOutputStream) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"closeZipOutputStream", (Object)zipOutputStream);
        try {
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string);
        }
    }

    protected java.io.File createTempFile(Archive archive) throws AdminException {
        java.io.File file;
        String string;
        String string2;
        Tr.entry((TraceComponent)_tc, (String)"createTempFile", (Object)archive);
        String string3 = archive.getName();
        int n = string3.lastIndexOf(".");
        if (n == -1) {
            string2 = string3;
            string = ".ear";
        } else {
            string2 = string3.substring(0, n);
            string = string3.substring(n);
        }
        try {
            if (string2.length() < 3) {
                string2 = string2 + "xxx";
            }
            file = java.io.File.createTempFile(string2, string);
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            String string4 = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string4);
        }
        return file;
    }

    protected void addArchiveEntry(File file, ZipOutputStream zipOutputStream) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"addArchiveEntry", (Object)new Object[]{file, zipOutputStream});
        try {
            ZipEntry zipEntry = new ZipEntry(file.getURI());
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string);
        }
    }

    protected void closeArchiveEntry(ZipOutputStream zipOutputStream) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"closeArchiveEntry", (Object)zipOutputStream);
        try {
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string);
        }
    }

    protected void copyDataFromFile(File file, OutputStream outputStream) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"copyDataFromFile", (Object)new Object[]{file, outputStream});
        try {
            this.copyData(file.getInputStream(), outputStream);
        }
        catch (IOException iOException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string);
        }
    }

    protected void copyData(InputStream inputStream, OutputStream outputStream) throws AdminException {
        Tr.entry((TraceComponent)_tc, (String)"copyData", (Object)new Object[]{inputStream, outputStream});
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray, 0, 4096);
            while (n > 0) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray, 0, 4096);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            String string = this._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            throw new AdminException((Throwable)iOException, string);
        }
    }
}

