/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.clientupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.migration.utility.ArgumentException;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.util.Hashtable;

public class ArgumentCheck {
    private static TraceComponent _tc = Tr.register((Class)ArgumentCheck.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String EARLOCATION = "-earLocation";
    public static final String CLIENTJAR = "-clientJar";
    public static final String TRACEFILE = "-traceFile";
    public static final String TRACESTRING = "-traceString";
    public static final String LOGLOCATION = "-logFileLocation";

    public static Hashtable verifyArguments(TraceNLS traceNLS, String[] stringArray) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"verifyArguments", (Object)new Object[]{traceNLS, stringArray});
        if (stringArray.length == 0) {
            String string = LoggerImpl.get_nls().getString("client.usage.message10", "No parameters found, need to atleast specify ear file location.");
            throw new ArgumentException(string, null, true);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (!new File(stringArray[0]).exists()) {
            String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.message11", new Object[]{stringArray[0]}, "Ear file " + stringArray[0] + " does not exist.");
            throw new ArgumentException(string, null, true);
        }
        if (new File(stringArray[0]).isDirectory()) {
            String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.message12", new Object[]{stringArray[0]}, "Ear file " + stringArray[0] + " is a directory.");
            throw new ArgumentException(string, null, true);
        }
        if (!stringArray[0].toLowerCase().endsWith(".ear")) {
            String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.message8", new Object[]{stringArray[0]}, "Invalid Ear file " + stringArray[0] + ".");
            throw new ArgumentException(string, null, true);
        }
        hashtable.put(EARLOCATION, stringArray[0]);
        for (int i = 1; i < stringArray.length; i += 2) {
            if (stringArray[i].equals(CLIENTJAR)) {
                if (i + 1 > stringArray.length - 1 || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) {
                    String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.message7", new Object[]{CLIENTJAR}, "Missing value for attribute -clientJar.");
                    throw new ArgumentException(string, null, true);
                }
                hashtable.put(CLIENTJAR, stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals(TRACEFILE)) {
                if (i + 1 > stringArray.length - 1 || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) {
                    String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.line7", new Object[]{TRACEFILE}, "Missing value for attribute -traceFile.");
                    throw new ArgumentException(string, null, true);
                }
                boolean bl = false;
                for (int j = 1; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(TRACESTRING)) continue;
                    bl = true;
                }
                if (!bl) {
                    hashtable.put(TRACESTRING, "\"*=all=enabled\"");
                }
                hashtable.put(TRACEFILE, stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals(TRACESTRING)) {
                if (i + 1 > stringArray.length - 1 || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) {
                    String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.line7", new Object[]{TRACESTRING}, "Missing value for attribute -traceString.");
                    throw new ArgumentException(string, null, true);
                }
                hashtable.put(TRACESTRING, stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals(LOGLOCATION)) {
                if (i + 1 > stringArray.length - 1 || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) {
                    String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.line7", new Object[]{LOGLOCATION}, "Missing value for attribute -logFileLocation.");
                    throw new ArgumentException(string, null, true);
                }
                hashtable.put(LOGLOCATION, stringArray[i + 1]);
                continue;
            }
            String string = LoggerImpl.get_nls().getFormattedMessage("client.usage.message9", new Object[]{stringArray[i]}, "Invalid param specified " + stringArray[i] + ".");
            throw new ArgumentException(string, null, true);
        }
        return hashtable;
    }
}

