/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.clientupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.clientupgrade.ArgumentCheck;
import com.ibm.ws.migration.clientupgrade.Client.TransformBaseConfiguration;
import com.ibm.ws.migration.clientupgrade.ClientDocumentTransform;
import com.ibm.ws.migration.clientupgrade.EarHandler;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMTransformMapping;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ClientUpgrade
extends UpgradeBase {
    private static TraceComponent _tc = Tr.register((Class)ClientUpgrade.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String _wasInstallRoot = null;
    private static File _tempDir;
    private EarHandler _earHandler = null;
    private String _earFile = null;
    private String _specificClientJar = null;
    static /* synthetic */ Class class$com$ibm$ws$migration$document$BasicDocumentCollection;
    static /* synthetic */ Class class$com$ibm$ws$migration$document$FileDocumentCollection;
    static /* synthetic */ Class class$com$ibm$ws$migration$clientupgrade$Client$ClientResourceConfig;

    public ClientUpgrade() {
    }

    public ClientUpgrade(String[] stringArray) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"ClientUpgrade", (Object)stringArray);
        UpgradeBase._cmdLineArgs = ArgumentCheck.verifyArguments(LoggerImpl.get_nls(), stringArray);
        this._earFile = (String)UpgradeBase._cmdLineArgs.get("-earLocation");
        this._specificClientJar = (String)UpgradeBase._cmdLineArgs.get("-clientJar");
        this.setupTrace("ClientUpgrade");
    }

    protected void setupDefaultTrace(String string) {
        Tr.entry((TraceComponent)_tc, (String)"setupDefaultTrace", (Object)string);
        try {
            String string2;
            if (!UpgradeBase._cmdLineArgs.containsKey("-traceString") && !OSInfoFactory.isZSeries() && (string2 = System.getProperty("com.ibm.websphere.migration.serverRoot")) != null) {
                File file = new File(new File(string2, "logs"), string + ".trace");
                if (file.exists()) {
                    file.delete();
                }
                UpgradeBase._cmdLineArgs.put("-traceString", "com.ibm.websphere.migration.*=all=enabled");
                UpgradeBase._cmdLineArgs.put("-traceFile", file.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void doIt() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"doIt");
        Vector vector = this._earHandler.expand();
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < vector.size(); ++i) {
            File file = new File(new File(_tempDir, (String)vector.get(i)), "META-INF");
            try {
                if (this._specificClientJar != null && !this._specificClientJar.equals((String)vector.get(i))) continue;
                Tr.debug((TraceComponent)_tc, (String)("Processing client jar: " + vector.get(i)));
                bl = true;
                if (!new File(file, "client-resource.xmi").exists()) continue;
                BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(false, false, class$com$ibm$ws$migration$document$BasicDocumentCollection == null ? ClientUpgrade.class$("com.ibm.ws.migration.document.BasicDocumentCollection") : class$com$ibm$ws$migration$document$BasicDocumentCollection, class$com$ibm$ws$migration$document$FileDocumentCollection == null ? ClientUpgrade.class$("com.ibm.ws.migration.document.FileDocumentCollection") : class$com$ibm$ws$migration$document$FileDocumentCollection);
                BasicDocumentCollection basicDocumentCollection = new BasicDocumentCollection(file.getName(), null, descriptor, file.toURL());
                String string = FileUtilities.makeBackupFile(new File(file, "client-resource.xmi"));
                string = string.substring(string.lastIndexOf(File.separator) + 1);
                new File(file, "client-resource.xmi").delete();
                WCCMTransformMapping wCCMTransformMapping = new WCCMTransformMapping(new TransformMappingKey(string, "client-resource.xmi"), class$com$ibm$ws$migration$clientupgrade$Client$ClientResourceConfig == null ? ClientUpgrade.class$("com.ibm.ws.migration.clientupgrade.Client.ClientResourceConfig") : class$com$ibm$ws$migration$clientupgrade$Client$ClientResourceConfig);
                Vector vector2 = new Vector();
                new TransformBaseConfiguration().populateConfigTransform(vector2, basicDocumentCollection, basicDocumentCollection, wCCMTransformMapping);
                ClientDocumentTransform clientDocumentTransform = (ClientDocumentTransform)vector2.get(0);
                clientDocumentTransform.migrate();
                clientDocumentTransform.save();
                continue;
            }
            catch (UpgradeException upgradeException) {
                throw upgradeException;
            }
            catch (Exception exception) {
                UpgradeBase._logger.println(LoggerImpl.get_nls().getString("client.usage.message14", "No client jars found."));
                bl2 = false;
            }
        }
        if (!bl && this._specificClientJar != null) {
            UpgradeBase._logger.println(LoggerImpl.get_nls().getFormattedMessage("client.usage.message13", new Object[]{this._specificClientJar}, "No client jars found by the name " + this._specificClientJar + "."));
        } else if (!bl && this._specificClientJar == null) {
            UpgradeBase._logger.println(LoggerImpl.get_nls().getString("client.usage.message14", "No client jars found."));
        }
        if (bl2) {
            this._earHandler.collapse();
        } else {
            this._earHandler.closeEARFileWithoutChange();
        }
    }

    protected void restore() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"restore");
        this.setupLogging();
        try {
            _tempDir = ArchiveUtil.createTempDirectory((String)"CC", null);
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
        this._earHandler = new EarHandler(this._earFile, _tempDir.toString());
        String string = _wasInstallRoot;
        String string2 = System.getProperty("os.name");
        if (string2.equals("OS/400") && (string = System.getProperty("was.install.root")) != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        UpgradeBase._oldOSInfo = OSInfoFactory.createOSInfo(new File(string), new File(string));
        UpgradeBase._newOSInfo = OSInfoFactory.createOSInfo(new File(string), new File(string));
        this.doIt();
        String string3 = null;
        string3 = LoggerImpl.loggedError() ? LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "Completed with errors.") : (LoggerImpl.loggedWarning() ? LoggerImpl.get_nls().getString("advise.logging.completed.with.warnings", "Completed with warnings.") : LoggerImpl.get_nls().getString("advise.logging.completed", "Completed successfully."));
        UpgradeBase._logger.println(string3);
    }

    protected void setupLogging() throws UpgradeException {
        File file;
        Tr.entry((TraceComponent)_tc, (String)"setupLogging");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey("-logFileLocation")) {
            string = (String)UpgradeBase._cmdLineArgs.get("-logFileLocation");
        }
        if (string == null) {
            string = new File(_wasInstallRoot, "logs").getAbsolutePath();
        }
        if (!(file = new File(string)).exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)exception.toString());
            }
        }
        UpgradeBase._logger = new LoggerImpl(new File(string), "clientUpgrade.log");
    }

    protected static void displayOutput(String string) {
        Tr.entry((TraceComponent)_tc, (String)"displayOutput", (Object)string);
        if (LoggerImpl.isRegistered()) {
            ((LoggerImpl)UpgradeBase._logger).println(string);
        } else {
            System.err.println(string);
        }
    }

    private static String retrieveUsage() {
        Tr.entry((TraceComponent)_tc, (String)"retrieveUsage");
        String string = LoggerImpl.get_nls().getString("client.usage.line1", "MIGR0900E:ClientUpgrade: Invalid command line:");
        String string2 = "\t" + LoggerImpl.get_nls().getString("client.usage.line2", "<qualified path to EAR file>");
        String string3 = "\t" + LoggerImpl.get_nls().getString("client.usage.line3", "[-clientJar <client jar to migrate]");
        String string4 = "\t" + LoggerImpl.get_nls().getString("client.usage.line4", "[-traceString <trace spec> [-traceFile <traceFile>]]");
        String string5 = "\t" + LoggerImpl.get_nls().getString("client.usage.line5", "[-logFileLocation <log file location>]");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(_lineSeparator).append(string2).append(_lineSeparator).append(string3).append(_lineSeparator).append(string4).append(_lineSeparator).append(string5).append(_lineSeparator);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 99;
        boolean bl = false;
        try {
            ClientUpgrade.copyright("Product Upgrade client migration tool, Version 1.0");
            object = new ClientUpgrade(stringArray);
            ((ClientUpgrade)object).restore();
            System.exit(0);
        }
        catch (UpgradeException upgradeException) {
            bl = ClientUpgrade.handleException(upgradeException);
            if (upgradeException.shouldDisplayHelp()) {
                ClientUpgrade.displayOutput(ClientUpgrade.retrieveUsage());
            }
        }
        catch (Throwable throwable) {
            ClientUpgrade.handleException(throwable);
            bl = true;
        }
        object = null;
        object = LoggerImpl.loggedError() || bl ? LoggerImpl.get_nls().getString("advise.logging.completed.with.failures", "Unable to complete the command.") : LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "Completed with errors.");
        ClientUpgrade.displayOutput((String)object);
        System.exit(n);
    }

    static {
        _wasInstallRoot = System.getProperty("com.ibm.websphere.migration.serverRoot");
        _tempDir = null;
    }
}

