/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.clientupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.ApplicationClientFileImpl;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;

public class EarHandler {
    private static TraceComponent _tc = Tr.register((Class)EarHandler.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private EARFile _earFile = null;
    private String _earName = null;
    private String _expandDir = null;

    public EarHandler(String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"EarHandler", (Object)new Object[]{string, string2});
        this._expandDir = string2;
        this._earName = string;
    }

    public void closeEARFileWithoutChange() {
        Tr.entry((TraceComponent)_tc, (String)"closeEARFileWithoutChange");
        this._earFile.close();
    }

    protected Vector expand() throws UpgradeException {
        Vector<String> vector;
        Tr.entry((TraceComponent)_tc, (String)"expand");
        try {
            File file = new File(this._earName);
            if (file.isDirectory()) {
                return null;
            }
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            Archive archive = commonarchiveFactory.openArchive(this._earName);
            vector = new Vector<String>();
            if (archive != null && archive instanceof EARFile) {
                this._earFile = (EARFile)archive;
                this._earFile.extractTo(this._expandDir, 16);
                List list = this._earFile.getApplicationClientFiles();
                for (int i = 0; i < list.size(); ++i) {
                    ApplicationClientFileImpl applicationClientFileImpl = (ApplicationClientFileImpl)list.get(i);
                    vector.add(applicationClientFileImpl.getName());
                }
                this._earFile.close();
            }
        }
        catch (OpenFailureException openFailureException) {
            throw new UpgradeException(openFailureException);
        }
        catch (SaveFailureException saveFailureException) {
            throw new UpgradeException(saveFailureException);
        }
        return vector;
    }

    protected void collapse() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"collapse");
        try {
            File file = new File(this._expandDir);
            if (!file.isDirectory()) {
                return;
            }
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            Archive archive = commonarchiveFactory.openArchive(this._expandDir);
            if (archive instanceof EARFile) {
                this._earFile = (EARFile)archive;
                this._earFile.saveAsNoReopen(this._earName);
                this._earFile.close();
            }
            this._earFile = null;
        }
        catch (OpenFailureException openFailureException) {
            throw new UpgradeException(openFailureException);
        }
        catch (SaveFailureException saveFailureException) {
            throw new UpgradeException(saveFailureException);
        }
    }

    static {
        ModelMgr.initialize((String)"ws-server");
    }
}

