/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.CellType;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.migration.common.ConfigRepositoryHelper;
import com.ibm.ws.migration.common.ConfigurationFile;
import com.ibm.ws.migration.common.ConfigurationWCCMFile;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.Invoker;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;

public class Configuration {
    private static TraceComponent _tc = Tr.register((Class)Configuration.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String CLIENT_RESOURCE_FILE = "client-resource.xmi";
    public static final String J2C_PROPERTIES_FILE = "j2c.properties";
    public static final String CELL_FILE = "cell.xml";
    public static final String CLUSTERS_FILE = "cluster.xml";
    public static final String SECURITY_FILE = "security.xml";
    public static final String VIRTUAL_HOST_FILE = "virtualhosts.xml";
    public static final String ADMIN_AUTHZ_FILE = "admin-authz.xml";
    public static final String NAMING_AUTHZ_FILE = "naming-authz.xml";
    public static final String PMIRM_FILE = "pmirm.xml";
    public static final String INTEGRAL_JMS_AUTHORIZATIONS_FILE = "integral-jms-authorizations.xml";
    public static final String PERFTUNERS_FILE = "perftuners.xml";
    public static final String MULTIBROKER_FILE = "multibroker.xml";
    public static final String COREGROUP_FILE = "coregroup.xml";
    public static final String NODEGROUP_FILE = "nodegroup.xml";
    public static final String COREGROUPBRIDGE_FILE = "coregroupbridge.xml";
    public static final String SIBWS_WEBSERVICES_FILE = "sibws-webservices.xml";
    public static final String SIB_BUS_FILE = "sib-bus.xml";
    public static final String SIB_DESTINATIONS_FILE = "sib-destinations.xml";
    public static final String SIB_MEDIATIONS_FILE = "sib-mediations.xml";
    public static final String SIB_AUTHORISATIONS_FILE = "sib-authorisations.xml";
    public static final String SERVERS_FILE = "serverindex.xml";
    public static final String SERVERS_FILE_DISABLED = "serverindex.xml_disabled";
    public static final String NODE_FILE = "node.xml";
    public static final String SERVER_FILE = "server.xml";
    public static final String NAMESTORE_CELL_FILE = "namestore-cell.xml";
    public static final String NAMESTORE_NODE_FILE = "namestore-node.xml";
    public static final String WSSECURITY_FILE = "ws-security.xml";
    public static final String SIB_ENGINES_FILE = "sib-engines.xml";
    public static final String SIB_SERVICE_FILE = "sib-service.xml";
    public static final String HAMANAGER_SERVICE_FILE = "hamanagerservice.xml";
    public static final String PMI_FILE = "pmi-config.xml";
    public static final String PME_SERVER_FILE = "server-pme.xml";
    public static final String PME51_SERVER_FILE = "server-pme51.xml";
    public static final String INSTALLED_CHANNELS_FILE = "installed-channels.xml";
    public static final String SYSTEMAPPS_FILE = "systemapps.xml";
    public static final String PROXY_SETTINGS_FILE = "proxy-settings.xml";
    public static final String SIBWS_EPL_FILE = "sibws-epl.xml";
    public static final String SIBWS_GATEWAY_FILE = "sibws-gateway.xml";
    public static final String SIBWS_INBOUND_FILE = "sibws-inbound.xml";
    public static final String SIBWS_OUTBOUND_FILE = "sibws-outbound.xml";
    public static final String SIBWS_WSSECURITY_FILE = "sibws-wssecurity.xml";
    public static final String SIBWS_WSSECURITY_DRAFT13_FILE = "sibws-wssecurity-draft13.xml";
    public static final String NAMESTORE_FILE = "namestore.xml";
    public static final String RESOURCES_FILE = "resources.xml";
    public static final String RESOURCESPME_FILE = "resources-pme.xml";
    public static final String RESOURCESPME502_FILE = "resources-pme502.xml";
    public static final String VARIABLES_FILE = "variables.xml";
    public static final String NAMEBINDINGS_FILE = "namebindings.xml";
    public static final String LIBRARIES_FILE = "libraries.xml";
    public static final String PME_RESOURCES_FILE = "resources-pme.xml";
    public static final String PME502_RESOURCES_FILE = "resources-pme502.xml";
    public static final String DEPLOYMENT_FILE = "deployment.xml";
    public static final String APPLICATION_FILE = "application.xml";
    public static final String CONFIG_DIRECTORY = "config";
    public static final String CELL_DIRECTORY = "cells";
    public static final String SERVER_DIRECTORY = "servers";
    public static final String NODES_DIRECTORY = "nodes";
    public static final String CLUSTERS_DIRECTORY = "clusters";
    public static final String COREGROUPS_DIRECTORY = "coregroups";
    public static final String DEFAULT_COREGROUP_DIRECTORY = "DefaultCoreGroup";
    public static final String NODEGROUPS_DIRECTORY = "nodegroups";
    public static final String DEFAULT_NODEGROUP_DIRECTORY = "DefaultNodeGroup";
    public static final String BUSES_DIRECTORY = "buses";
    public static final String DEFAULT_BUS_DIRECTORY = "DefaultBus";
    public static final String DEFAULT_DIRECTORY = "DEFAULT";
    public static final String APPLICATIONS_DIRECTORY = "applications";
    public static final String TEMPLATES_DIRECTORY = "templates";
    public static final String PROPERTIES_DIRECTORY = "properties";
    public static final String INSTALLEDAPPS_DIRECTORY = "installedApps";
    public static final String ORB_COMPATIBILITY_PROPERTYNAME = "com.ibm.websphere.ObjectIDVersionCompatibility";
    public static final String ORB_COMPATIBILITY_VALUE = "1";
    public static final String DMGR_SERVER = "dmgr";
    public static final String NODE_AGENT = "nodeagent";
    public static final String NO_CELLNAME = null;
    public static final String NO_NODENAME = null;
    public static final boolean NO_LOCK = false;
    public static final boolean YES_LOCK = true;
    public static final boolean NO_USEFILESYSTEM = false;
    public static final boolean YES_USEFILESYSTEM = true;
    public static final boolean NO_CREATE_FILE = false;
    public static final boolean YES_CREATE_FILE = true;
    public static final boolean WRITABLE = false;
    public static final boolean READONLY = true;
    public static final boolean NO_LOGGING = false;
    public static final boolean YES_LOGGING = true;
    private static ConfigRepositoryHelper _repositoryHelper = null;
    protected File _configDirectory = null;
    protected File _cellDirectory = null;
    protected File _nodeDirectory = null;
    protected String _cellName = null;
    protected String _nodeName = null;
    protected boolean _cellValid = false;
    protected boolean _nodeValid = false;
    protected Hashtable _configurationFilesList = new Hashtable();
    private Properties _cellVars = new Properties();
    private Properties _nodeVars = new Properties(this._cellVars);
    protected boolean _logReadMessages = false;
    protected ReleaseVersion _releaseVersion = null;
    protected File _owningNodeDirectory = null;
    protected String _owningNodeName = null;
    protected boolean _useFileSystem = false;
    boolean _isDeploymentManagerConfigurationDetermined = false;
    boolean _isDeploymentManagerConfiguration = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File resolveDirectory(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"resolveDirectory", (Object)file);
        File file2 = null;
        File file3 = file;
        if (file3 == null || !file3.exists()) throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{file}, "Unable to read configuration file " + file), null, false);
        File[] fileArray = file3.listFiles();
        if (fileArray.length <= 0) return file2;
        Tr.debug((TraceComponent)_tc, (String)("Number of files in directory: " + file3.getName() + " is: " + fileArray.length));
        if (fileArray.length == 1 && fileArray[0].isDirectory()) {
            return fileArray[0];
        }
        if (fileArray.length == 0) {
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{file}, "Unable to read configuration file " + file), null, false);
        }
        int n = 0;
        String string = null;
        for (int i = 0; i < fileArray.length; ++i) {
            File file4 = fileArray[i];
            Tr.debug((TraceComponent)_tc, (String)("Checking name: " + file4.getName() + " in loop"));
            if (!file4.isDirectory()) continue;
            ++n;
            string = fileArray[i].getName();
        }
        if (n != true) throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{file}, "Unable to read configuration file " + file), null, false);
        return new File(file, string);
    }

    public Configuration(File file, String string, String string2, boolean bl, ReleaseVersion releaseVersion, boolean bl2) throws UpgradeException {
        this(file, string, string2, bl, releaseVersion, bl2, true);
    }

    public Configuration(File file, String string, String string2, boolean bl, ReleaseVersion releaseVersion, boolean bl2, boolean bl3) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"Configuration", (Object)new Object[]{file, string, string2, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        this._configDirectory = file;
        this._logReadMessages = bl;
        this._releaseVersion = releaseVersion;
        this._useFileSystem = bl3;
        if (file != null && !releaseVersion.isClient()) {
            if (!this._useFileSystem && _repositoryHelper == null) {
                _repositoryHelper = new ConfigRepositoryHelper(file);
            }
            this._cellDirectory = new File(this._configDirectory, CELL_DIRECTORY);
            Tr.debug((TraceComponent)_tc, (String)("Config Path: " + this._cellDirectory));
            if (string != null) {
                this._cellName = string;
                this._cellDirectory = new File(this._cellDirectory, string);
            } else {
                this._cellDirectory = Configuration.resolveDirectory(this._cellDirectory);
                this._cellName = this._cellDirectory.getAbsolutePath().substring(this._cellDirectory.getAbsolutePath().lastIndexOf(File.separator) + 1, this._cellDirectory.getAbsolutePath().length());
            }
            this._cellValid = this._cellDirectory.exists();
            this._nodeDirectory = new File(this._cellDirectory, NODES_DIRECTORY);
            Tr.debug((TraceComponent)_tc, (String)("Node Path: " + this._nodeDirectory));
            if (string2 != null) {
                this._nodeName = string2;
                this._nodeDirectory = new File(this._nodeDirectory, this._nodeName);
            } else {
                this.setNodeDirectory(this.resolveNodeDirectory());
            }
            this._nodeValid = this._nodeDirectory.exists();
            this._owningNodeDirectory = this.getNodeDirectory();
            if (bl3) {
                this.closeConfigurationFiles(false);
            }
            try {
                this.populateVariableSet((List)this.getConfigurationFile(new File(this.getNodeDirectory(), VARIABLES_FILE), false, true, false).getContents(), this._nodeVars);
            }
            catch (Exception exception) {
                Tr.entry((TraceComponent)_tc, (String)("No variables.xml file found at location: " + new File(this.getNodeDirectory(), VARIABLES_FILE).getAbsolutePath()));
            }
            try {
                this.populateVariableSet((List)this.getConfigurationFile(new File(this.getCellDirectory(), VARIABLES_FILE), false, true, false).getContents(), this._cellVars);
            }
            catch (Exception exception) {
                Tr.entry((TraceComponent)_tc, (String)("No variables.xml file found at location: " + new File(this.getCellDirectory(), VARIABLES_FILE).getAbsolutePath()));
            }
        }
    }

    public void copyFile(File file, File file2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyFile", (Object)new Object[]{file, file2});
        if (this._useFileSystem) {
            if (!file2.exists()) {
                FileUtilities.copyFile(file, file2);
            }
        } else if (!_repositoryHelper.doesFileExistInConfigurationDir(file2)) {
            _repositoryHelper.createConfigurationDirFile(file2);
        }
    }

    public void copyFile(ByteArrayInputStream byteArrayInputStream, File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyFile", (Object)new Object[]{byteArrayInputStream, file});
        if (this._useFileSystem) {
            try {
                FileUtilities.copyBufferedInputStream(new BufferedInputStream(new FileInputStream(byteArrayInputStream.toString())), file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UpgradeException(fileNotFoundException);
            }
        } else {
            _repositoryHelper.createConfigurationDirFile(file);
        }
    }

    public boolean exists(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"exists", (Object)file);
        if (this._useFileSystem) {
            return file.exists();
        }
        try {
            return _repositoryHelper.doesFileExistInConfigurationDir(file);
        }
        catch (UpgradeException upgradeException) {
            return false;
        }
    }

    public ConfigRepositoryHelper getRepositoryHelper() {
        Tr.entry((TraceComponent)_tc, (String)"getConfigRepositoryHelper");
        return _repositoryHelper;
    }

    public File getPropertiesDirectory() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getPropertiesDirectory");
        return new File(UpgradeBase._userRoot, PROPERTIES_DIRECTORY);
    }

    public File getInstalledAppsDirectory() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getInstalledAppsDirectory");
        return new File(this._configDirectory.getParent(), INSTALLEDAPPS_DIRECTORY);
    }

    public String getCellName() {
        Tr.entry((TraceComponent)_tc, (String)"getCellName");
        Tr.debug((TraceComponent)_tc, (String)this._cellName);
        return this._cellName;
    }

    public File getCellDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getCellDirectory");
        Tr.debug((TraceComponent)_tc, (String)this._cellDirectory.getAbsolutePath());
        return this._cellDirectory;
    }

    public File getConfigDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getConfigDirectory");
        Tr.debug((TraceComponent)_tc, (String)this._configDirectory.getAbsolutePath());
        return this._configDirectory;
    }

    public String getNodeName() {
        Tr.entry((TraceComponent)_tc, (String)"getNodeName");
        Tr.debug((TraceComponent)_tc, (String)this._nodeName);
        return this._nodeName;
    }

    public File getOwningNodeDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getOwningNodeDirectory");
        Tr.debug((TraceComponent)_tc, (String)this._owningNodeDirectory.getAbsolutePath());
        return this._owningNodeDirectory;
    }

    public String getOwningNodeName() {
        Tr.entry((TraceComponent)_tc, (String)"getOwningNodeName");
        Tr.debug((TraceComponent)_tc, (String)this._owningNodeName);
        String string = this._owningNodeName;
        if (this._owningNodeDirectory != null) {
            return this._owningNodeDirectory.getAbsolutePath().substring(this._owningNodeDirectory.getAbsolutePath().lastIndexOf(File.separator) + 1, this._owningNodeDirectory.getAbsolutePath().length());
        }
        return string;
    }

    public void setNodeDirectory(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setNodeDirectory", (Object)file);
        this._nodeDirectory = file;
        this._nodeName = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1, file.getAbsolutePath().length());
        try {
            this.populateVariableSet((List)this.getConfigurationFile(new File(this.getCellDirectory(), VARIABLES_FILE), false, true, false).getContents(), this._cellVars);
        }
        catch (Exception exception) {
            Tr.entry((TraceComponent)_tc, (String)("No variables.xml file found at location: " + new File(this.getCellDirectory(), VARIABLES_FILE).getAbsolutePath()));
        }
    }

    public File getNodeDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getNodeDirectory", (Object)this._nodeDirectory);
        return this._nodeDirectory;
    }

    public File getBusDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getBusDirectory");
        return new File(new File(this._cellDirectory, BUSES_DIRECTORY), this._nodeName);
    }

    public File getCoregroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getCoregroupsDirectory");
        File file = new File(this._cellDirectory, COREGROUPS_DIRECTORY);
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + file.getAbsolutePath()));
        return file;
    }

    public File getDefaultCoregroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getDefaultCoregroupsDirectory");
        File file = new File(this.getCoregroupsDirectory(), DEFAULT_COREGROUP_DIRECTORY);
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + file.getAbsolutePath()));
        return file;
    }

    public File getNodegroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getNodegroupsDirectory");
        File file = new File(this._cellDirectory, NODEGROUPS_DIRECTORY);
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + file.getAbsolutePath()));
        return file;
    }

    public File getDefaultNodegroupsDirectory() {
        Tr.entry((TraceComponent)_tc, (String)"getNodegroupsDirectory");
        File file = new File(this.getNodegroupsDirectory(), DEFAULT_NODEGROUP_DIRECTORY);
        Tr.debug((TraceComponent)_tc, (String)("Directory is: " + file.getAbsolutePath()));
        return file;
    }

    public ReleaseVersion getReleaseVersion() {
        Tr.entry((TraceComponent)_tc, (String)"getReleaseVersion", (Object)this._releaseVersion.toString());
        return this._releaseVersion;
    }

    public ServerIndex locateServerIndex(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateServerIndex", (Object)file);
        File file2 = file;
        File file3 = new File(file2, SERVERS_FILE);
        if (!this.exists(file3)) {
            file3 = new File(file2, SERVERS_FILE_DISABLED);
        }
        ConfigurationFile configurationFile = this.getConfigurationFile(file3, false, true, false);
        Iterator iterator = configurationFile.getContents().iterator();
        ServerIndex serverIndex = null;
        while (iterator.hasNext() && serverIndex == null) {
            try {
                serverIndex = (ServerIndex)iterator.next();
            }
            catch (Exception exception) {}
        }
        return serverIndex;
    }

    public Security locateSecurity() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateSecurity");
        File file = new File(this.getCellDirectory(), SECURITY_FILE);
        ConfigurationFile configurationFile = this.getConfigurationFile(file, false, true, false);
        Iterator iterator = configurationFile.getContents().iterator();
        Security security = null;
        while (iterator.hasNext() && security == null) {
            try {
                security = (Security)iterator.next();
            }
            catch (Exception exception) {}
        }
        return security;
    }

    public Object locateConfigFileObject(File file, Class clazz) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateConfigFileObject", (Object)new Object[]{file, clazz});
        return this.locateConfigFileObject(file, clazz, true);
    }

    public Object locateConfigFileObject(File file, Class clazz, boolean bl) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateConfigFileObject", (Object)new Object[]{file, clazz});
        EList eList = this.getConfigurationFile(file, false, bl, false).getContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isInstance(e)) continue;
            return e;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected File resolveNodeDirectory() throws UpgradeException {
        Tr.entry((TraceComponent)Configuration._tc, (String)"resolveNodeDirectory");
        if (!this._releaseVersion.areExtendedServerProductsInstalled()) ** GOTO lbl-1000
        if (this._releaseVersion.installedExtendedServerProducts().contains("ND")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_1 = false;
        }
        if (this._releaseVersion.isClient()) {
            return Configuration.resolveDirectory(this._nodeDirectory);
        }
        this._isDeploymentManagerConfigurationDetermined = true;
        if (var1_1) {
            try {
                Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for DMgr");
                var2_2 = this.resolveSpecificNodeType("DEPLOYMENT_MANAGER");
                this._isDeploymentManagerConfiguration = true;
                return var2_2;
            }
            catch (UpgradeException var2_3) {
                this._isDeploymentManagerConfiguration = false;
            }
        }
        try {
            Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for Node Agent");
            return this.resolveSpecificNodeType("NODE_AGENT");
        }
        catch (UpgradeException var2_4) {
            try {
                Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for ApplicationServer = Standalone");
                return this.resolveSpecificNodeType("APPLICATION_SERVER");
            }
            catch (UpgradeException var3_5) {
                try {
                    Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for Generic Server = Standalone");
                    return this.resolveSpecificNodeType("GENERIC_SERVER");
                }
                catch (UpgradeException var4_6) {
                    try {
                        Tr.debug((TraceComponent)Configuration._tc, (String)"Checking for no Server = Custom");
                        return this.resolveSpecificNodeType(null);
                    }
                    catch (UpgradeException var5_7) {
                        throw new UpgradeException(var5_7);
                    }
                }
            }
        }
    }

    public File resolveSpecificNodeType(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"resolveSpecificNodeType", (Object)string);
        Object var2_2 = null;
        File file = new File(this._cellDirectory, NODES_DIRECTORY);
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            Tr.debug((TraceComponent)_tc, (String)("Number of files in directory: " + file.getName() + " is: " + fileArray.length));
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                File[] fileArray2;
                File file2 = fileArray[i];
                Tr.debug((TraceComponent)_tc, (String)("Checking name: " + file2.getName() + " in loop"));
                if (!file2.isDirectory() || (fileArray2 = file2.listFiles()).length <= 1 || (string2 = this.getSetupCmdLineNodeName()) != null && !file2.getName().equals(string2)) continue;
                ServerIndex serverIndex = null;
                try {
                    serverIndex = this.locateServerIndex(file2);
                    EList eList = serverIndex.getServerEntries();
                    Iterator iterator = eList.iterator();
                    if (string == null) {
                        if (iterator.hasNext()) {
                            Tr.debug((TraceComponent)_tc, (String)("Entry " + string + " in entry " + this._cellDirectory + " does not exist."));
                            throw new UpgradeException(null);
                        }
                        return file2;
                    }
                    while (iterator.hasNext()) {
                        ServerEntry serverEntry = (ServerEntry)iterator.next();
                        if (!serverEntry.getServerType().equals(string)) continue;
                        return file2;
                    }
                    continue;
                }
                catch (UpgradeException upgradeException) {
                    Tr.debug((TraceComponent)_tc, (String)("Unable to open serverindex.xml file : " + file2.toString()));
                    Tr.debug((TraceComponent)_tc, (String)("Exception: " + upgradeException.toString()));
                }
            }
        }
        Tr.debug((TraceComponent)_tc, (String)("Entry " + string + " in entry " + this._cellDirectory + " does not exist."));
        throw new UpgradeException(null);
    }

    private String getSetupCmdLineNodeName() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getSetupCmdLineNodeName");
        try {
            OSInfo oSInfo = OSInfoFactory.createOSInfo(null, null);
            String string = this._configDirectory.getAbsolutePath() + File.separator + ".." + File.separator + "bin" + File.separator + "setupCmdLine" + oSInfo.fetchExecutableExtension();
            if (new File(string).exists()) {
                BufferedReader bufferedReader = oSInfo.openFile(new File(string));
                String string2 = "";
                String string3 = null;
                String string4 = "";
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (!string3.trim().startsWith("WAS_NODE") && !string3.trim().startsWith("SET WAS_NODE")) continue;
                    string4 = string3.substring(string3.indexOf("=") + 1).trim();
                    break;
                }
                bufferedReader.close();
                return string4;
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UpgradeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    public boolean isFederatedNode() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isFederatedNode");
        if (!this.isDeploymentManagerConfiguration()) {
            ConfigurationFile configurationFile = this.getConfigurationFile(new File(this._cellDirectory, CELL_FILE), false, true, false, ConfigurationWCCMFile.class);
            EList eList = configurationFile.getContents();
            Cell cell = (Cell)eList.get(0);
            return cell.getCellType() == CellType.DISTRIBUTED_LITERAL;
        }
        return false;
    }

    public boolean isDeploymentManagerNode(File file) {
        block3: {
            Tr.entry((TraceComponent)_tc, (String)"isDeploymentManagerNode", (Object)file);
            try {
                ServerIndex serverIndex = this.locateServerIndex(file);
                EList eList = serverIndex.getServerEntries();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry = (ServerEntry)iterator.next();
                    if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_tc.isDebugEnabled()) break block3;
                UpgradeBase._logger.printStackTrace(exception);
            }
        }
        return false;
    }

    public boolean isCellValid() {
        Tr.entry((TraceComponent)_tc, (String)"isCellValid", (Object)new Boolean(this._cellValid));
        return this._cellValid;
    }

    public boolean isNodeValid() {
        Tr.entry((TraceComponent)_tc, (String)"isNodeValid", (Object)new Boolean(this._nodeValid));
        return this._nodeValid;
    }

    public boolean isDeploymentManagerConfiguration() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isDeploymentManagerConfiguration");
        if (!this._isDeploymentManagerConfigurationDetermined) {
            Configuration configuration = new Configuration(this._configDirectory, this._cellName, this._nodeName, false, this._releaseVersion, true, false);
            try {
                configuration.resolveSpecificNodeType("DEPLOYMENT_MANAGER");
                this._isDeploymentManagerConfiguration = true;
            }
            catch (UpgradeException upgradeException) {
                this._isDeploymentManagerConfiguration = false;
            }
            this._isDeploymentManagerConfigurationDetermined = true;
        }
        return this._isDeploymentManagerConfiguration;
    }

    public ConfigurationFile getConfigurationFile(File file, boolean bl) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{file, new Boolean(bl)});
        return this.getConfigurationFile(file, bl, true);
    }

    public ConfigurationFile getConfigurationFile(File file, boolean bl, boolean bl2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{file, new Boolean(bl), new Boolean(bl2)});
        return this.getConfigurationFile(file, bl, false, bl2);
    }

    public ConfigurationFile getConfigurationFile(File file, boolean bl, boolean bl2, boolean bl3) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{file, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        return this.getConfigurationFile(file, bl, bl2, bl3, ConfigurationWCCMFile.class);
    }

    public ConfigurationFile getConfigurationFile(File file, boolean bl, boolean bl2, boolean bl3, Class clazz) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getConfigurationFile", (Object)new Object[]{file, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), clazz.getName()});
        if (this.isFileOpen(file)) {
            return this.getOpenConfigurationFileFromCache(file, bl2);
        }
        return this.openConfigurationFile(file, bl, bl2, bl3, clazz, bl2);
    }

    private ConfigurationFile openConfigurationFile(File file, boolean bl, boolean bl2, boolean bl3, Class clazz, boolean bl4) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"openConfigurationFile", (Object)new Object[]{file, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), clazz.getName()});
        ConfigurationFile configurationFile = null;
        try {
            Class[] classArray = new Class[]{Boolean.class, File.class, Configuration.class, Boolean.class};
            Object[] objectArray = new Object[]{new Boolean(this._useFileSystem), file, this, new Boolean(bl4)};
            Constructor constructor = clazz.getConstructor(classArray);
            configurationFile = (ConfigurationFile)constructor.newInstance(objectArray);
            boolean bl5 = false;
            bl5 = this._useFileSystem ? file.exists() : this.exists(file);
            if (bl5) {
                if (this._logReadMessages && bl3) {
                    String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.read.success", new Object[]{file.getName()}, "Read configuration file " + file.getName(), true);
                    UpgradeBase.get_logger().println(string);
                }
            } else if (bl) {
                this.createConfigurationFile(configurationFile);
            } else {
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{file.getName()}, "Unable to read configuration file: {0}");
                throw new UpgradeException(string, null, false);
            }
            Tr.debug((TraceComponent)_tc, (String)("Opening ConfigurationFile named: " + file.getName()));
            configurationFile.open(this._configDirectory, this._cellName);
            this._configurationFilesList.put(file.getAbsolutePath(), configurationFile);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UpgradeException(invocationTargetException);
        }
        catch (UpgradeException upgradeException) {
            throw upgradeException;
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
        return configurationFile;
    }

    public void closeConfigurationFile(File file) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFile", (Object)new Object[]{file});
        this.closeConfigurationFile(file, true);
    }

    public void closeConfigurationFile(File file, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFile", (Object)new Object[]{file, new Boolean(bl)});
        try {
            if (this.isFileOpen(file)) {
                ConfigurationFile configurationFile = (ConfigurationFile)this._configurationFilesList.get(file.getAbsolutePath());
                this.closeConfigurationFileCommon(configurationFile, bl);
                this._configurationFilesList.remove(file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.close", new Object[]{file.getName()}, "Could not close file {0}"));
        }
    }

    public void closeConfigurationFiles() {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFiles");
        this.closeConfigurationFiles(true);
    }

    public void closeConfigurationFiles(boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFiles", (Object)new Object[]{new Boolean(bl)});
        Enumeration enumeration = this._configurationFilesList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.closeConfigurationFile(new File(string), bl);
        }
    }

    public boolean isFileOpen(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isFileOpen", (Object)new Object[]{file});
        return this._configurationFilesList.containsKey(file.getAbsolutePath());
    }

    private ConfigurationFile getOpenConfigurationFileFromCache(File file, boolean bl) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getOpenConfigurationFileFromCache", (Object)new Object[]{file, new Boolean(bl)});
        ConfigurationFile configurationFile = (ConfigurationFile)this._configurationFilesList.get(file.getAbsolutePath());
        if (!bl) {
            configurationFile.setWritable();
        }
        return configurationFile;
    }

    protected void createConfigurationFile(ConfigurationFile configurationFile) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createConfigurationFile");
        String string = configurationFile.getFileName();
        try {
            configurationFile.create();
        }
        catch (UpgradeException upgradeException) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unable.configuration.create", new Object[]{string}, "Unable to create configuration file: {0}");
            UpgradeBase.get_logger().println(string2, upgradeException);
            throw upgradeException;
        }
        catch (Exception exception) {
            String string3 = LoggerImpl.get_nls().getFormattedMessage("advise.unable.configuration.create", new Object[]{string}, "Unable to create configuration file: {0}");
            UpgradeBase.get_logger().println(string3, exception);
            throw new UpgradeException(exception);
        }
    }

    protected void closeConfigurationFileCommon(ConfigurationFile configurationFile, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFileCommon", (Object)new Object[]{configurationFile, new Boolean(bl)});
        String string = configurationFile.getFileName();
        try {
            if (!this._useFileSystem || this._useFileSystem && configurationFile.isWritable()) {
                configurationFile.close();
                if (bl) {
                    String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.logging.saved.success", new Object[]{string}, "Configuration file " + string + " ready to be saved.");
                    UpgradeBase.get_logger().println(string2, true);
                }
            }
        }
        catch (Exception exception) {
            if (_tc.isDebugEnabled()) {
                UpgradeBase._logger.printStackTrace(exception);
            }
            String string3 = LoggerImpl.get_nls().getFormattedMessage("advise.logging.no.save", new Object[]{string, exception}, "Unable to save configuration file {0}. Caught exception {1}.");
            UpgradeBase.get_logger().println(string3);
        }
    }

    public Properties getNodeVariables() {
        return this._nodeVars;
    }

    public Properties getCellVariables() {
        return this._cellVars;
    }

    public void populateVariableSet(List list, Properties properties) {
        Tr.entry((TraceComponent)_tc, (String)"populateVariableSet", (Object)new Object[]{list, properties});
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof VariableMap)) continue;
            VariableMap variableMap = (VariableMap)e;
            EList eList = variableMap.getEntries();
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)iterator2.next();
                String string = variableSubstitutionEntry.getSymbolicName();
                String string2 = variableSubstitutionEntry.getValue();
                if (string == null || string2 == null) continue;
                properties.put(string, string2);
            }
        }
    }

    public String fixUpPath(String string) {
        Tr.entry((TraceComponent)_tc, (String)"fixUpPath", (Object)string);
        String string2 = this._nodeVars.getProperty("WAS_INSTALL_ROOT");
        String string3 = this._nodeVars.getProperty("USER_INSTALL_ROOT");
        String string4 = string;
        string = new File(string).getAbsolutePath().replace('\\', '/');
        if (!string2.endsWith("/") || !string2.endsWith("\\")) {
            string2 = string2 + File.separator;
        }
        if (!string3.endsWith("/") || !string3.endsWith("\\")) {
            string3 = string3 + File.separator;
        }
        if (string.startsWith(string2.replace('\\', '/'))) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(0, this._nodeVars.getProperty("WAS_INSTALL_ROOT").length(), "${WAS_INSTALL_ROOT}");
            return stringBuffer.toString();
        }
        if (string.startsWith(string3.replace('\\', '/'))) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(0, this._nodeVars.getProperty("USER_INSTALL_ROOT").length(), "${USER_INSTALL_ROOT}");
            return stringBuffer.toString();
        }
        return string4;
    }

    public String resolveEntryPath(String string) {
        Tr.entry((TraceComponent)_tc, (String)"resolveEntryPath", (Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "${}()", true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("$") && ((string2 = stringTokenizer.nextToken()).equals("{") || string2.equals("("))) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.equals("}") && !string2.equals(")")) {
                        stringBuffer.append(string2);
                    }
                    if (!string2.equals("}") && !string2.equals(")")) continue;
                    if (stringBuffer.toString().equalsIgnoreCase("CELL")) {
                        stringBuffer2.append(this.getCellName());
                    } else if (stringBuffer.toString().equalsIgnoreCase("NODE")) {
                        stringBuffer2.append(this.getNodeName());
                    } else {
                        stringBuffer2.append(this._nodeVars.getProperty(stringBuffer.toString()));
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer2.append(stringTokenizer.nextToken());
                    }
                    return this.resolveEntryPath(stringBuffer2.toString());
                }
            }
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }

    public void backupConfig() {
        Tr.entry((TraceComponent)_tc, (String)"backupConfig");
        if (WASPostUpgrade.is_backupConfig()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.information.backup.start", "Starting to backup current WebSphere environment."));
            String string = null;
            try {
                File file = new File(new File(UpgradeBase._userRoot, "temp"), FileUtilities.generateFileName("MigrationBackup.zip"));
                File file2 = new File(new File(UpgradeBase._userRoot, "bin"), "backupConfig" + UpgradeBase._newOSInfo.fetchExecutableExtension());
                StringBuffer stringBuffer = new StringBuffer(256).append(FileUtilities.quotedFileName(file2.getAbsolutePath())).append(" ").append(FileUtilities.quotedFileName(file.getAbsolutePath())).append(" -nostop ").append(this.securitySettings()).append(" ");
                string = stringBuffer.toString();
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"Final string for executable: ", (Object)string);
                }
                new Invoker(UpgradeBase._newOSInfo).exec(string, "backupConfig");
            }
            catch (Exception exception) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("", new Object[]{string}, "Unable to execute: {0}."), exception);
            }
        }
    }

    public String securitySettings() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"securitySettings");
        Security security = this.locateSecurity();
        boolean bl = security.isEnabled();
        if (bl && WASPostUpgrade.get_userName() != null) {
            StringBuffer stringBuffer = new StringBuffer(256).append("-username ").append(WASPostUpgrade.get_userName()).append(" -password ").append(WASPostUpgrade.get_password());
            return stringBuffer.toString();
        }
        if (bl) {
            UserRegistry userRegistry = security.getActiveUserRegistry();
            StringBuffer stringBuffer = new StringBuffer(256).append("-username ").append(userRegistry.getServerId()).append(" -password ").append(userRegistry.getServerPassword());
            return stringBuffer.toString();
        }
        return "";
    }
}

