/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.DefaultConfigurationFile;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;

public class ConfigurationPropertiesFile
extends DefaultConfigurationFile {
    private static TraceComponent _tc = Tr.register((Class)ConfigurationPropertiesFile.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String lineSeparator = System.getProperty("line.separator");
    public static String COMMENT_PREFIX = "INTERNAL_GENERATED_MIGRATION_COMMENT_PREFIX_";
    public static String BLANKLINE_PREFIX = "INTERNAL_GENERATED_MIGRATION_BLANK_PREFIX_";
    private static final String COMMENT_CHAR = "#";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private boolean _createdNew = false;
    private Vector _vFileContents = new Vector();
    private Vector _vExtraContents = new Vector();
    private Properties _properties = new Properties();

    public ConfigurationPropertiesFile(Boolean bl, File file, Configuration configuration, Boolean bl2) {
        super(bl, file, configuration, bl2);
    }

    public void create() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"create");
        this._createdNew = true;
        try {
            if (!this._file.exists()) {
                int n = this._file.getAbsolutePath().lastIndexOf(File.separator);
                String string = this._file.getAbsolutePath().substring(0, n);
                new File(string).mkdirs();
            }
            this._file.createNewFile();
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    public void open(File file, String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"open");
        try {
            this._properties.load(new FileInputStream(this._file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UpgradeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    public void close() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"close");
        try {
            int n;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._file), "8859_1"));
            String string = null;
            for (n = 0; n < this._vFileContents.size(); ++n) {
                string = (String)this._vFileContents.get(n);
                if (string.startsWith(COMMENT_PREFIX) || string.startsWith(BLANKLINE_PREFIX)) {
                    bufferedWriter.write((String)this._vFileContents.get(++n));
                } else {
                    bufferedWriter.write(this.saveConvert(string, true));
                    bufferedWriter.write("=");
                    bufferedWriter.write(this.saveConvert((String)this._vFileContents.get(++n), false));
                }
                bufferedWriter.write(lineSeparator);
            }
            if (this._vExtraContents.size() != 0) {
                if (!this._createdNew) {
                    bufferedWriter.write(lineSeparator);
                    bufferedWriter.write(COMMENT_CHAR + LoggerImpl.get_nls().getString("advise.properties.leftover", "name=value pairs found in old file, but not in new file."));
                    bufferedWriter.write(lineSeparator);
                }
                for (n = 0; n < this._vExtraContents.size(); ++n) {
                    string = (String)this._vExtraContents.get(n);
                    bufferedWriter.write(this.saveConvert(string, true));
                    bufferedWriter.write("=");
                    bufferedWriter.write(this.saveConvert((String)this._vExtraContents.get(++n), false));
                    bufferedWriter.write(lineSeparator);
                }
            }
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UpgradeException(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UpgradeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    public Vector getFileContents() {
        return this._vFileContents;
    }

    public Vector getExtraContents() {
        return this._vExtraContents;
    }

    public Properties getFileProperties() {
        return this._properties;
    }

    private String saveConvert(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(ConfigurationPropertiesFile.toHex(c >> 12 & 0xF));
                        stringBuffer.append(ConfigurationPropertiesFile.toHex(c >> 8 & 0xF));
                        stringBuffer.append(ConfigurationPropertiesFile.toHex(c >> 4 & 0xF));
                        stringBuffer.append(ConfigurationPropertiesFile.toHex(c & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    public static String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }
}

