/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ConfigurationFile;
import com.ibm.ws.migration.common.DefaultConfigurationFile;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigurationWCCMFile
extends DefaultConfigurationFile {
    private static TraceComponent _tc = Tr.register((Class)ConfigurationFile.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected Resource _resource = null;
    protected EList _contents = null;

    public ConfigurationWCCMFile(Boolean bl, File file, Configuration configuration, Boolean bl2) {
        super(bl, file, configuration, bl2);
    }

    public EList getContents() {
        Tr.entry((TraceComponent)_tc, (String)"getContents");
        return this._contents;
    }

    public Resource getResource() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getResource");
        return this._resource;
    }

    protected void createUsingFileSystem() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createUsingFileSystem");
        try {
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createFileURI((String)this._file.getAbsolutePath());
            Resource resource = wASResourceSetImpl.createResource(uRI);
            resource.save(new HashMap());
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.create.success", new Object[]{this._file.getAbsolutePath()}, "Created configuration file " + this._file.getAbsolutePath() + " successfully.  ");
            UpgradeBase.get_logger().println(string, true);
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    protected void createUsingConfigRepository() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createUsingConfigRepository");
        this._configuration.getRepositoryHelper().createConfigurationDirFile(this._file);
        String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.create.success", new Object[]{this._file.getAbsolutePath()}, "Created configuration file " + this._file.getAbsolutePath() + " successfully.  ");
        UpgradeBase.get_logger().println(string, true);
    }

    protected void openUsingFileSystem(File file, String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"openUsingFileSystem", (Object)new Object[]{file, string});
        try {
            Tr.debug((TraceComponent)_tc, (String)"Creating RepositoryImpl");
            Repository repository = RepositoryFactory.createRepository((String)file.getAbsolutePath(), (String)string, null, null);
            String string2 = "cells" + File.separator + string;
            int n = this._file.getAbsolutePath().indexOf(string2) + string2.length() + 1;
            try {
                this.printFileContentsToTrace(new FileInputStream(this._file));
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Problem reading/writing file to trace.");
                Tr.debug((TraceComponent)_tc, (String)exception.toString());
            }
            String string3 = this._file.getAbsolutePath().substring(n, this._file.getAbsolutePath().length());
            Tr.debug((TraceComponent)_tc, (String)("Reading shortFileName: " + string3));
            this._resource = repository.getConfigRoot().getResource(0, string3);
            this._contents = this._resource.getContents();
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
    }

    protected void openUsingConfigRepository() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"openUsingConfigRepository");
        this.printFileContentsToTrace(this._configuration.getRepositoryHelper().openFileForReadOnly(this._file));
        InputStream inputStream = this._configuration.getRepositoryHelper().openConfigurationDirFile(this._file);
        this._resource = this._configuration.getRepositoryHelper().getResource(inputStream, this._file);
        this._contents = this._resource.getContents();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    private void printFileContentsToTrace(InputStream inputStream) {
        Tr.debug((TraceComponent)_tc, (String)"printFileContentsToTrace", (Object)inputStream);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            Tr.debug((TraceComponent)_tc, (String)("Contents of file: " + this._file.getAbsolutePath()));
            String string = bufferedReader.readLine();
            while (string != null) {
                Tr.debug((TraceComponent)_tc, (String)string);
                string = bufferedReader.readLine();
            }
            Tr.debug((TraceComponent)_tc, (String)("End of contents of file: " + this._file.getAbsolutePath()));
            bufferedReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Problem reading/writing file to trace.");
            Tr.debug((TraceComponent)_tc, (String)exception.toString());
        }
    }

    protected void closeUsingFileSystem() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"closeUsingFileSystem");
        try {
            if (this._resource != null) {
                this._resource.save(new HashMap());
            }
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    protected void closeUsingConfigRepository() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"closeUsingConfigRepository");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this._resource.save((OutputStream)byteArrayOutputStream, new HashMap());
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }
}

