/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ConfigurationFile;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class DefaultConfigurationFile
implements ConfigurationFile {
    private static TraceComponent _tc = Tr.register((Class)ConfigurationFile.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected boolean _useFileSystem = false;
    protected File _file = null;
    protected Configuration _configuration;
    boolean _readOnly = true;

    public DefaultConfigurationFile(Boolean bl, File file, Configuration configuration, Boolean bl2) {
        this._useFileSystem = bl;
        this._file = file;
        this._configuration = configuration;
        this._readOnly = bl2;
    }

    public void setWritable() {
        this._readOnly = false;
    }

    public boolean isWritable() {
        Tr.entry((TraceComponent)_tc, (String)"isWritable");
        return !this._readOnly;
    }

    public EList getContents() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getContents");
        throw new UpgradeException(null);
    }

    public Resource getResource() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getResource");
        throw new UpgradeException(null);
    }

    public String getFileName() {
        Tr.entry((TraceComponent)_tc, (String)"getFileName");
        return this._file.getAbsolutePath();
    }

    protected void createUsingFileSystem() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createUsingFileSystem");
        throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{new IllegalAccessException()}, "An unexpected internal error occurred, exception {0}."), null, false);
    }

    protected void createUsingConfigRepository() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createUsingConfigRepository");
        throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{new IllegalAccessException()}, "An unexpected internal error occurred, exception {0}."), null, false);
    }

    protected void openUsingFileSystem(File file, String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"openUsingFileSystem");
        throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{new IllegalAccessException()}, "An unexpected internal error occurred, exception {0}."), null, false);
    }

    protected void openUsingConfigRepository() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"openUsingConfigRepository");
        throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{new IllegalAccessException()}, "An unexpected internal error occurred, exception {0}."), null, false);
    }

    protected void closeUsingFileSystem() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"closeUsingFileSystem");
        throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{new IllegalAccessException()}, "An unexpected internal error occurred, exception {0}."), null, false);
    }

    protected void closeUsingConfigRepository() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"closeUsingConfigRepository");
        throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{new IllegalAccessException()}, "An unexpected internal error occurred, exception {0}."), null, false);
    }

    public void create() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"create");
        if (this._useFileSystem) {
            this.createUsingFileSystem();
        } else {
            this.createUsingConfigRepository();
        }
    }

    public void open(File file, String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"open", (Object)new Object[]{file, string});
        if (this._useFileSystem) {
            this.openUsingFileSystem(file, string);
        } else {
            this.openUsingConfigRepository();
        }
    }

    public void close() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"close");
        if (this._useFileSystem) {
            this.closeUsingFileSystem();
        } else {
            this.closeUsingConfigRepository();
        }
    }
}

