/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.Invoker;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.BasicTransformMapping;
import com.ibm.wsspi.migration.document.CopyDocumentProcessor;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.TransformMapping;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.preupgrade.PreUpgradeDocumentTransform;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public abstract class DefaultOSInfo
implements OSInfo {
    private static TraceComponent _tc = Tr.register((Class)DefaultOSInfo.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String WSINSTANCE_CONFIG = "wsinstance.config";
    public static final String PROFILE_LIST = "profileList.ser";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String CLIENTSAS = "CLIENTSAS";
    public static final String WAS_HOME = "WAS_HOME";
    public static final String DBDRIVER_PATH = "DBDRIVER_PATH";
    public static final String CONFIG_ROOT = "CONFIG_ROOT";
    public static final String USER_INSTALL_ROOT = "USER_INSTALL_ROOT";
    protected static final String JAVA_HOME_PREFIX = "JAVA_HOME=";
    protected static final String PATH_PREFIX = "PATH=";
    protected static final String LD_LIBRARY_PREFIX = "LD_LIBRARY_PATH=";
    protected static final String LIBPATH_PREFIX = "LIBPATH=";
    protected static final String SHLIB_PATH_PREFIX = "SHLIB_PATH=";
    protected String _javaHome = null;
    protected String _javaVersion = null;
    protected String _clientSAS = null;
    protected String _dbDriverPath = null;
    protected String _configRoot = null;
    protected boolean _setupCmdLineRead = false;
    protected File _userRoot;
    protected File _installRoot;
    protected DefaultOSInfo _parent;
    protected ReleaseVersion _releaseVersion = null;
    private Hashtable _environmentVariables = null;
    protected Properties _instances;
    protected DefaultOSInfo _defaultInstance;
    protected String _defaultInstanceName;
    static /* synthetic */ Class class$com$ibm$wsspi$migration$document$BasicDocument;

    public DefaultOSInfo(File file, File file2, OSInfo oSInfo) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"DefaultOSInfo", (Object)new Object[]{file, file2, oSInfo});
        this._userRoot = file;
        this._installRoot = file2;
        this._parent = (DefaultOSInfo)oSInfo;
    }

    public File installRoot() {
        Tr.entry((TraceComponent)_tc, (String)"installRoot");
        if (this._installRoot == null) {
            return this._userRoot;
        }
        return this._installRoot;
    }

    public File userRoot() {
        Tr.entry((TraceComponent)_tc, (String)"userRoot");
        return this._userRoot;
    }

    public ReleaseVersion releaseVersion() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"releaseVersion");
        if (this._releaseVersion == null) {
            if (this._parent == null) {
                this.determineReleaseVersion();
            } else {
                this._releaseVersion = this._parent.releaseVersion();
            }
        }
        return this._releaseVersion;
    }

    public void backupFiles(PreUpgradeDocumentTransform preUpgradeDocumentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"backupFiles", (Object)preUpgradeDocumentTransform);
        this.baseBackupFiles(preUpgradeDocumentTransform);
        PreUpgradeDocumentTransform preUpgradeDocumentTransform2 = null;
        try {
            preUpgradeDocumentTransform2 = (PreUpgradeDocumentTransform)preUpgradeDocumentTransform.getChild("classes");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (preUpgradeDocumentTransform2 != null) {
            preUpgradeDocumentTransform2.markDocumentCollectionForBackup(true);
        }
    }

    protected void baseBackupFiles(PreUpgradeDocumentTransform preUpgradeDocumentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"baseBackupFiles", (Object)preUpgradeDocumentTransform);
        this.savePropertiesDirectory(preUpgradeDocumentTransform);
        PreUpgradeDocumentTransform preUpgradeDocumentTransform2 = null;
        try {
            preUpgradeDocumentTransform2 = (PreUpgradeDocumentTransform)preUpgradeDocumentTransform.getChild("bin");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (preUpgradeDocumentTransform2 != null) {
            Vector vector = preUpgradeDocumentTransform2.getTransformMappings();
            TransformMappingKey transformMappingKey = new TransformMappingKey("setupCmdLine" + this.fetchExecutableExtension());
            vector.addElement(new BasicTransformMapping(transformMappingKey, CopyDocumentProcessor.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePropertiesDirectory(PreUpgradeDocumentTransform preUpgradeDocumentTransform) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"savePropertiesDirectory", (Object)preUpgradeDocumentTransform);
        PreUpgradeDocumentTransform preUpgradeDocumentTransform2 = (PreUpgradeDocumentTransform)preUpgradeDocumentTransform.getChild("properties");
        preUpgradeDocumentTransform2.markDocumentCollectionForBackup(false);
        PreUpgradeDocumentTransform preUpgradeDocumentTransform3 = null;
        try {
            preUpgradeDocumentTransform3 = (PreUpgradeDocumentTransform)preUpgradeDocumentTransform2.getChild("version");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (preUpgradeDocumentTransform3 != null) {
            preUpgradeDocumentTransform3.markDocumentCollectionForBackup(false);
            if (OSInfoFactory.isZSeries()) {
                object = ".component";
                Vector vector = preUpgradeDocumentTransform3.getTransformMappings();
                for (int i = 0; i < vector.size(); ++i) {
                    TransformMapping transformMapping = (TransformMapping)vector.get(i);
                    String string = transformMapping.getKey().getOldDocumentName();
                    if (string == null || !string.endsWith((String)object)) continue;
                    Document document = null;
                    try {
                        document = preUpgradeDocumentTransform3.getOldDocumentCollection().openDocument(string, class$com$ibm$wsspi$migration$document$BasicDocument == null ? DefaultOSInfo.class$("com.ibm.wsspi.migration.document.BasicDocument") : class$com$ibm$wsspi$migration$document$BasicDocument);
                        continue;
                    }
                    catch (Exception exception) {
                        Tr.event((TraceComponent)_tc, (String)("savePropertiesDirectory - exception occurred while opening " + string), (Object)exception.getMessage());
                        vector.remove(i);
                        --i;
                        continue;
                    }
                    finally {
                        if (document != null) {
                            document.close();
                        }
                    }
                }
            }
            object = null;
            try {
                object = (PreUpgradeDocumentTransform)preUpgradeDocumentTransform3.getChild("dtd");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (object != null) {
                ((PreUpgradeDocumentTransform)object).markDocumentCollectionForBackup(false);
            }
        }
        object = null;
        try {
            object = (PreUpgradeDocumentTransform)preUpgradeDocumentTransform2.getChild("fsdb");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (object != null) {
            ((PreUpgradeDocumentTransform)object).markDocumentCollectionForBackup(true);
        }
    }

    public String getAdditionalExtDirs() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getAdditionalExtDirs");
        String string = new File(this.javaHome(), "lib").getAbsolutePath();
        string = string + File.pathSeparator + this.installRoot() + File.separator + "lib" + File.pathSeparator;
        string = string + this.installRoot() + File.separator + "web" + File.separator + "help" + File.pathSeparator;
        string = string + this.dbDriverPath();
        return string;
    }

    public File javaHome() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"javaHome");
        if (this._javaHome == null) {
            this.fetchSetupSettings();
        }
        File file = new File(this._javaHome);
        if (System.getProperties().containsKey("com.ibm.websphere.migration.javaHome") && !file.exists()) {
            this._javaHome = System.getProperty("com.ibm.websphere.migration.javaHome");
        }
        String string = FileUtilities.getUnquotedName(this._javaHome);
        return new File(string);
    }

    public final String javaVersion() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"javaVersion");
        if (this._javaVersion == null) {
            this.fetchSetupSettings();
        }
        return this._javaVersion;
    }

    public File configRoot() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"configRoot");
        String string = null;
        if (!this._setupCmdLineRead && !this.releaseVersion().isClient()) {
            this.fetchSetupSettings();
        }
        string = this._configRoot == null ? (this._parent == null ? this.releaseVersion().defaultConfigFileName() : this.userRoot() + File.separator + "config") : this._configRoot;
        string = FileUtilities.getUnquotedName(string);
        return new File(string);
    }

    public String classLoaderSettings(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"classLoaderSettings");
        return this.releaseVersion().classLoaderSettings(string);
    }

    private String dbDriverPath() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"dbDriverPath");
        if (this._dbDriverPath == null) {
            this.fetchSetupSettings();
        }
        return this._dbDriverPath;
    }

    protected void fetchSetupSettings() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"fetchSetupSettings");
        Properties properties = this.readCmdLineFile(this.installRoot());
        String string = properties.getProperty(WAS_HOME);
        this._javaHome = properties.getProperty(JAVA_HOME);
        this._clientSAS = properties.getProperty(CLIENTSAS);
        this._dbDriverPath = properties.getProperty(DBDRIVER_PATH);
        if (this._parent != null) {
            properties = this.readCmdLineFile(this.userRoot());
        }
        this._configRoot = properties.getProperty(CONFIG_ROOT);
        this._setupCmdLineRead = true;
        if (this._javaHome == null) {
            Tr.debug((TraceComponent)_tc, (String)"Could not find JAVA_HOME");
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.setupCmdLine.file.not.valid", new Object[]{JAVA_HOME}, "The following setupCmdLine setting cannot be found: {0}"), null, false);
        }
        Tr.debug((TraceComponent)_tc, (String)("Checking JAVA_HOME: " + this._javaHome));
        if (this._javaHome.lastIndexOf("..") != -1) {
            String string2 = this._javaHome.substring(0, this._javaHome.lastIndexOf("..") - 1);
            this._javaHome = string2.substring(0, string2.lastIndexOf(File.separator) + 1);
            Tr.debug((TraceComponent)_tc, (String)("JAVA_HOME ended with a .., new value is: " + this._javaHome));
        } else if (!this._javaHome.endsWith(File.separator)) {
            this._javaHome = this._javaHome + File.separator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readCmdLineFile(File file) throws UpgradeException {
        String string;
        Tr.entry((TraceComponent)_tc, (String)"readCmdLineFile", (Object)file);
        String string2 = this.installRoot().getAbsolutePath();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        File file2 = new File(new File(file.getAbsolutePath(), "bin"), "setupCmdLine" + this.fetchExecutableExtension());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.openFile(file2);
        }
        catch (Throwable throwable) {
            Tr.debug((TraceComponent)_tc, (String)("Could not open cmdline file: " + file2));
            bufferedReader = null;
        }
        if (bufferedReader != null) {
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    int n;
                    if (string.startsWith("#") || string.startsWith("REM ") || this.containsConditionalLogic(string) || (n = string.indexOf("=")) == -1) continue;
                    int n2 = 0;
                    if (string3 == null && (n2 = string.indexOf(JAVA_HOME)) != -1 && n2 < n) {
                        string3 = string.substring(string.indexOf("=") + 1);
                        string3 = string3.trim();
                    }
                    if (string4 == null && (n2 = string.indexOf(CLIENTSAS)) != -1 && n2 < n) {
                        string4 = string.substring(string.indexOf("=") + 1);
                        string4 = string4.trim();
                    }
                    if (string5 == null && (n2 = string.indexOf(DBDRIVER_PATH)) != -1 && n2 < n) {
                        string5 = string.substring(string.indexOf("=") + 1);
                        string5 = string5.trim();
                    }
                    if (string6 != null || (n2 = string.indexOf(CONFIG_ROOT)) == -1 || n2 >= n) continue;
                    string6 = string.substring(string.indexOf("=") + 1);
                    string6 = string6.trim();
                }
            }
            catch (IOException iOException) {
                Tr.debug((TraceComponent)_tc, (String)("Could not read cmdline file: " + file2));
            }
            finally {
                if (string5 == null) {
                    string5 = "";
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Tr.debug((TraceComponent)_tc, (String)("Could not close cmdline file: " + file2));
                }
            }
        }
        string2 = FileUtilities.getUnquotedName(string2);
        string = this.convertToEnvironmentVariable(WAS_HOME);
        if (string4 != null) {
            string4 = this.resolveEmbeddedVariableInString(string2, string, string4);
        }
        if (string3 != null) {
            string3 = this.resolveEmbeddedVariableInString(string2, string, string3);
        }
        if (string6 != null) {
            string6 = this.resolveEmbeddedVariableInString(string2, string, string6);
        }
        String string7 = FileUtilities.getUnquotedName(this.userRoot().getAbsolutePath());
        String string8 = this.convertToEnvironmentVariable(USER_INSTALL_ROOT);
        if (string6 != null) {
            string6 = this.resolveEmbeddedVariableInString(string7, string8, string6);
        }
        Properties properties = new Properties();
        if (string2 != null) {
            properties.setProperty(WAS_HOME, string2);
        }
        if (string3 != null) {
            properties.setProperty(JAVA_HOME, string3);
        }
        if (string4 != null) {
            properties.setProperty(CLIENTSAS, string4);
        }
        if (string5 != null) {
            properties.setProperty(DBDRIVER_PATH, string5);
        }
        if (string6 != null) {
            properties.setProperty(CONFIG_ROOT, string6);
        }
        return properties;
    }

    public BufferedReader openFile(File file) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"openFile", (Object)file.getAbsolutePath());
        return new BufferedReader(new FileReader(file));
    }

    protected boolean containsConditionalLogic(String string) {
        Tr.entry((TraceComponent)_tc, (String)"containsConditionalLogic", (Object)string);
        String string2 = string.trim();
        return string2.startsWith("if");
    }

    protected String convertToEnvironmentVariable(String string) {
        Tr.entry((TraceComponent)_tc, (String)"convertToEnvironmentVariable", (Object)string);
        return "$" + string;
    }

    protected String resolveEmbeddedVariableInString(String string, String string2, String string3) {
        Tr.entry((TraceComponent)_tc, (String)"resolveEmbeddedVariableInString", (Object)new Object[]{string, string2, string3});
        int n = string3.indexOf(string2);
        if (n == -1) {
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3.substring(0, n));
        stringBuffer.append(string);
        stringBuffer.append(string3.substring(n + string2.length()));
        return stringBuffer.toString();
    }

    protected String addSystemProperty(String string) {
        Tr.entry((TraceComponent)_tc, (String)"addSystemProperty");
        File file = new File(this.installRoot(), "bin");
        String string2 = System.getProperty(string);
        if (string2 != null) {
            file = new File(file, string2);
        }
        return file.getAbsolutePath();
    }

    protected String classPathEntry(File file, String string) {
        Tr.entry((TraceComponent)_tc, (String)"classPathEntry");
        return new File(new File(file.getAbsolutePath(), "lib"), string).getAbsolutePath();
    }

    protected void determineReleaseVersion() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"determineReleaseVersion");
        this._releaseVersion = ReleaseVersion.getReleaseVersion(this.fetchPropertiesPath(), this);
    }

    protected File fetchPropertiesPath() {
        Tr.entry((TraceComponent)_tc, (String)"fetchPropertiesPath", (Object)this.installRoot());
        return new File(this.installRoot(), "properties");
    }

    protected String resolveLinks(String string) throws UpgradeException {
        try {
            File file = new File(FileUtilities.getUnquotedName(string));
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string2);
            throw new UpgradeException(string2, null, false);
        }
    }

    protected String commonUnixAddtoExecutable() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"commonUnixAddtoExecutable");
        String string = new File(new File(this.javaHome(), "bin"), "java").getAbsolutePath();
        string = this.resolveLinks(string);
        string = string + " " + this.wasJavaOpts();
        return string;
    }

    protected String wasJavaOpts() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"wasJavaOpts");
        return "";
    }

    public String instance() {
        Tr.entry((TraceComponent)_tc, (String)"instance");
        return "";
    }

    public String modifyFileName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"modifyFileName");
        String[] stringArray = new String[]{"/", "\\", "*", ":", "?", "\"", "<", ">", "|", " ", "#", "$", "&", "(", ")", "-", "`", "'", ";", "!", "^"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            char[] cArray = stringArray[i].toCharArray();
            string = string.replace(cArray[0], '_');
        }
        return string;
    }

    public String removeJVMCommandLineDefaults(String string) {
        Tr.entry((TraceComponent)_tc, (String)"removeJVMCommandLineDefaults", (Object)string);
        return string;
    }

    public void changeOwnership(File file) {
        Tr.entry((TraceComponent)_tc, (String)"changeOwnership", (Object)file);
    }

    public boolean updateBootStrapPort() {
        Tr.entry((TraceComponent)_tc, (String)"updateBootStrapPort");
        return true;
    }

    public boolean isInvalidReleaseOnOS(ReleaseVersion releaseVersion, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"isInvalidReleaseOnOS", (Object)releaseVersion);
        return bl;
    }

    public Vector getAdditionalExcludeVariables() {
        Tr.entry((TraceComponent)_tc, (String)"getAddtionalExcludeVariables");
        return new Vector();
    }

    public Vector getAdditionalTransformVariables() {
        return new Vector();
    }

    public void configToNative(File file, String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"configToNative", (Object)new Object[]{file, string, string2});
    }

    public void validatePostUpgradeParms(Hashtable hashtable) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"validatePostUpgradeParms", (Object)UtilityImpl.replacePassword(hashtable.toString()));
    }

    public Properties getInstances() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getInstances");
        if (this._parent != null) {
            return new Properties();
        }
        this.loadInstances();
        return this.getParentInstance()._instances;
    }

    public void setInstances(Properties properties) throws UpgradeException {
        File file;
        Tr.entry((TraceComponent)_tc, (String)"setInstances", (Object)properties);
        if (this._parent != null) {
            return;
        }
        this.loadInstances();
        File file2 = new File(this.installRoot(), "properties");
        file2.mkdirs();
        File file3 = new File(file2, WSINSTANCE_CONFIG);
        if (file3.exists()) {
            file3.delete();
        }
        if ((file = new File(file2, PROFILE_LIST)).exists()) {
            file.delete();
        }
        Vector<OSInfoProfile> vector = new Vector<OSInfoProfile>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            String string3 = this.getParentInstance()._defaultInstanceName;
            boolean bl = string3 != null && string3.equals(string);
            vector.addElement(new OSInfoProfile(string, string2, bl));
        }
        if (this.getParentInstance()._defaultInstance != null && this.getParentInstance()._defaultInstanceName == null) {
            vector.addElement(new OSInfoProfile(null, this.getParentInstance()._defaultInstance.userRoot().getAbsolutePath(), true));
        }
        FileUtilities.saveVector(vector, file.getPath());
        this.getParentInstance()._instances = properties;
    }

    public OSInfo getInstance(String string) throws UpgradeException {
        String string2;
        Tr.entry((TraceComponent)_tc, (String)"getInstance", (Object)string);
        OSInfo oSInfo = null;
        if (this._parent != null) {
            return oSInfo;
        }
        Properties properties = this.getInstances();
        if (properties != null && (string2 = properties.getProperty(string)) != null) {
            String string3 = this.getParentInstance()._defaultInstanceName;
            oSInfo = string3 != null && string3.equals(string) ? this.getDefaultInstance() : OSInfoFactory.createOSInfo(new File(string2), this.installRoot(), this);
        }
        return oSInfo;
    }

    public String getProfileName() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getProfileName");
        this.loadInstances();
        Properties properties = this.getParentInstance()._instances;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (!new File(string2).equals(this.userRoot())) continue;
            return string;
        }
        return null;
    }

    public OSInfo getDefaultInstance() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getDefaultInstance");
        this.loadInstances();
        if (this.getParentInstance()._defaultInstance == null && this.getParentInstance()._defaultInstanceName == null) {
            return null;
        }
        if (this.getParentInstance()._defaultInstance == null) {
            this.getParentInstance()._defaultInstance = (DefaultOSInfo)OSInfoFactory.createOSInfo(new File(this.getParentInstance()._instances.getProperty(this.getParentInstance()._defaultInstanceName)), this.installRoot(), this);
        }
        return this.getParentInstance()._defaultInstance;
    }

    protected void loadInstances() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"loadInstances");
        if (this.getParentInstance()._instances == null) {
            Object object;
            File file;
            this.getParentInstance()._instances = new Properties();
            File file2 = new File(this.installRoot(), "properties");
            File file3 = new File(file2, PROFILE_LIST);
            if (file3.exists()) {
                Vector vector = FileUtilities.restoreVector(file3);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    OSInfoProfile oSInfoProfile = (OSInfoProfile)iterator.next();
                    if (oSInfoProfile.getName() == null) {
                        this.getParentInstance()._defaultInstance = this.getParentInstance();
                        continue;
                    }
                    String string = new File(oSInfoProfile.getPath()).getPath();
                    if (UpgradeBase._backupDirectory != null) {
                        File file4 = new File(UpgradeBase._backupDirectory, "profiles");
                        if (!string.equals((file4 = new File(file4, oSInfoProfile.getName())).getPath())) {
                            Tr.debug((TraceComponent)_tc, (String)("Overrode original instance path from " + string + " to " + file4.getPath()));
                            string = file4.getPath();
                        }
                    }
                    this.getParentInstance()._instances.setProperty(oSInfoProfile.getName(), string);
                    if (!oSInfoProfile.isDefault()) continue;
                    this.getParentInstance()._defaultInstanceName = oSInfoProfile.getName();
                }
                return;
            }
            try {
                Tr.debug((TraceComponent)_tc, (String)"Calling WSProfile.getRegistryFile()");
                file = WSProfile.getRegistryFile((String)this.installRoot().getAbsolutePath());
                Tr.debug((TraceComponent)_tc, (String)"Return from WSProfile.getRegistryFile()");
                if (file.exists()) {
                    String string = null;
                    String string2 = System.getProperty("com.ibm.ws.migration.currentProfileLogLocation");
                    File file5 = null;
                    if (string2 != null) {
                        file5 = new File(string2);
                    }
                    List list = WSProfile.getProfileList((File)file);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Profile profile = (Profile)iterator.next();
                        this.getParentInstance()._instances.setProperty(profile.getName(), profile.getPath().getPath());
                        if (profile.isDefault()) {
                            string = profile.getName();
                        }
                        if (file5 == null || !file5.equals(profile.getPath())) continue;
                        this.getParentInstance()._defaultInstanceName = profile.getName();
                    }
                    if (this.getParentInstance()._defaultInstanceName == null) {
                        this.getParentInstance()._defaultInstanceName = string;
                    }
                    return;
                }
            }
            catch (Exception exception) {
                object = exception.getCause();
                if (object instanceof FileNotFoundException) {
                    Tr.entry((TraceComponent)_tc, (String)"File not found while trying to call WSProfile.getRegistryFile(...) ");
                }
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
                UpgradeBase.get_logger().println(string);
                throw new UpgradeException(string, null, false);
            }
            file = new File(file2, WSINSTANCE_CONFIG);
            if (file.exists()) {
                try {
                    object = new FileInputStream(file);
                    this.getParentInstance()._instances.load((InputStream)object);
                    ((InputStream)object).close();
                }
                catch (Exception exception) {
                    String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
                    UpgradeBase.get_logger().println(string);
                    throw new UpgradeException(string, null, false);
                }
                this.getParentInstance()._defaultInstance = this.getParentInstance();
                return;
            }
            if (this.releaseVersion().isUnnamedDefaultInstanceProvided()) {
                this.getParentInstance()._defaultInstance = this.getParentInstance();
            }
        }
    }

    protected DefaultOSInfo getParentInstance() {
        Tr.entry((TraceComponent)_tc, (String)"getParentInstance");
        if (this._parent == null) {
            return this;
        }
        return this._parent;
    }

    public String[] getProcessEnvironmentVariables() throws UpgradeException {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"getProcessEnvironmentVariables");
        Hashtable hashtable = this.getCurrentEnvironmentVariables();
        if (hashtable.containsKey("WAS_USER_SCRIPT")) {
            hashtable.remove("WAS_USER_SCRIPT");
        }
        if (this._parent != null) {
            object = new File(new File(this.userRoot(), "bin"), "setupCmdLine" + this.fetchExecutableExtension());
            hashtable.put("WAS_USER_SCRIPT", ((File)object).getAbsolutePath());
        }
        object = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            object[n++] = string + "=" + string2;
        }
        return object;
    }

    public Hashtable getCurrentEnvironmentVariables() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getCurrentEnvironmentVariables");
        if (this._environmentVariables == null) {
            int n;
            Vector vector = new Vector();
            Invoker invoker = new Invoker(this, null, vector);
            String string = this.getEnvironmentVariableListCommand();
            invoker.exec(string);
            String string2 = "";
            Vector<String> vector2 = new Vector<String>();
            for (n = 0; n < vector.size(); ++n) {
                String string3 = (String)vector.elementAt(n);
                if (string3.startsWith(" ") || string3.startsWith("}")) {
                    string2 = string2 + "\n" + string3;
                    continue;
                }
                if (string2.length() > 0) {
                    vector2.addElement(string2);
                }
                string2 = string3;
            }
            if (vector.size() > 0) {
                vector2.addElement(string2);
            }
            this._environmentVariables = new Hashtable();
            for (n = 0; n < vector2.size(); ++n) {
                string2 = (String)vector2.elementAt(n);
                int n2 = string2.indexOf("=");
                int n3 = string2.indexOf(" ");
                if (n2 != -1) {
                    if (n3 == -1 || n2 < n3) {
                        String string4 = string2.substring(0, n2);
                        String string5 = "";
                        if (n2 + 1 < string2.length()) {
                            string5 = string2.substring(n2 + 1, string2.length());
                        }
                        Tr.debug((TraceComponent)_tc, (String)("Putting key: [" + string4 + "] with value: [" + UtilityImpl.replacePassword(string5) + "] into table."));
                        this._environmentVariables.put(string4, string5);
                        continue;
                    }
                    Tr.debug((TraceComponent)_tc, (String)("Found entry [" + string2 + "] which appears to be invalid."));
                    continue;
                }
                Tr.debug((TraceComponent)_tc, (String)("Found entry [" + string2 + "] which appears to be invalid."));
            }
        }
        return this._environmentVariables;
    }

    protected String getEnvironmentVariableListCommand() {
        Tr.entry((TraceComponent)_tc, (String)"getEnvironmentVariableListCommand");
        return "env";
    }

    public InputStream translateStream(InputStream inputStream) {
        Tr.entry((TraceComponent)_tc, (String)"translateStream");
        return inputStream;
    }

    public BufferedWriter closeFile(File file) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"closeFile", (Object)file.getAbsolutePath());
        return new BufferedWriter(new FileWriter(file));
    }

    public void addManagedObjectMetadataProperties(Properties properties, String string) {
        Tr.entry((TraceComponent)_tc, (String)"addManagedObjectMetadataProperties", (Object)properties);
        properties.setProperty("com.ibm.websphere.baseProductVersion", string);
    }

    public String getServerIndexTemplateServerEntryName() {
        Tr.entry((TraceComponent)_tc, (String)"getServerIndexTemplateServerEntryName");
        return "default";
    }

    public BufferedReader getBufferedReader(InputStream inputStream) throws UnsupportedEncodingException {
        Tr.entry((TraceComponent)_tc, (String)"getBufferedReader");
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    private static class OSInfoProfile
    implements Serializable {
        private static final long serialVersionUID = 1857287086197378634L;
        protected String _name;
        protected String _path;
        protected boolean _isDefault;

        public OSInfoProfile(String string, String string2, boolean bl) {
            this._name = string;
            this._path = string2;
            this._isDefault = bl;
        }

        public String getName() {
            return this._name;
        }

        public String getPath() {
            return this._path;
        }

        public boolean isDefault() {
            return this._isDefault;
        }
    }
}

