/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ConfigurationFile;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class DeploymentInformation {
    private static TraceComponent _tc = Tr.register((Class)DeploymentInformation.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected Configuration _configuration = null;

    public DeploymentInformation(Configuration configuration) {
        this._configuration = configuration;
    }

    public HashSet getOldDeployedApps() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getOldDeployedApps");
        ServerIndex serverIndex = this._configuration.locateServerIndex(this._configuration.getNodeDirectory());
        EList eList = serverIndex.getServerEntries();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerType().equals("APPLICATION_SERVER")) continue;
            EList eList2 = serverEntry.getDeployedApplications();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
                Tr.debug((TraceComponent)_tc, (String)("Added the deployment information " + string + " to the oldDeployedApps list"));
            }
        }
        return hashSet;
    }

    public String getApplicationBinariesURL(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getApplicationBinariesURL", (Object)new Object[]{string});
        String string2 = this._configuration.getCellDirectory() + File.separator + "applications" + File.separator + string.replace('/', File.separator.charAt(0)) + File.separator + "deployment.xml";
        Tr.debug((TraceComponent)_tc, (String)("Attempting to access the deployment.xml file located at " + string2));
        ConfigurationFile configurationFile = this._configuration.getConfigurationFile(new File(string2), false, true, false);
        EList eList = configurationFile.getContents();
        Deployment deployment = (Deployment)eList.get(0);
        ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        String string3 = applicationDeployment.getBinariesURL();
        Tr.debug((TraceComponent)_tc, (String)("The application's binariesURL is " + string3));
        string3 = this._configuration.resolveEntryPath(string3);
        File file = new File(UpgradeBase._oldOSInfo.userRoot(), string3);
        File file2 = new File(UpgradeBase._oldOSInfo.installRoot(), string3);
        File file3 = new File(string3);
        if (file3.exists()) {
            string3 = file3.getAbsolutePath();
        } else if (file.exists()) {
            string3 = file.getAbsolutePath();
        } else if (file2.exists()) {
            string3 = file2.getAbsolutePath();
        }
        Tr.debug((TraceComponent)_tc, (String)("The resolved binariesURL is " + string3));
        return string3;
    }
}

