/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.ErrHandler;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUtilities {
    private static TraceComponent _tc = Tr.register((Class)FileUtilities.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String QUOTE = "\"";
    public static final int BUFFER_SIZE = 4096;
    private static Hashtable _fileCollection = new Hashtable();

    public static void createDirectory(File file, String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createDirectory", (Object)new Object[]{file.getAbsolutePath(), string});
        String string2 = string + " - " + file.getAbsolutePath();
        if (file.exists()) {
            if (file.isFile()) {
                String string3 = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.create.directory.file", new Object[]{file.getAbsolutePath()}, "Unable to create directory. It already exists as a file: {0}");
                UpgradeBase.get_logger().println(string3);
                throw new UpgradeException(string3, null, false);
            }
            Tr.debug((TraceComponent)_tc, (String)"Directory already exists.");
        } else {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                FileUtilities.createDirectory(file2, string);
            }
            if (!file.mkdirs()) {
                String string4 = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.create.directory", new Object[]{file.getAbsolutePath()}, "Unable to create directory : {0}");
                UpgradeBase.get_logger().println(string4);
                throw new UpgradeException(string4, null, false);
            }
            UpgradeBase._logger.println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.creating.directory", new Object[]{string2}, "Creating directory {0}"));
            Tr.debug((TraceComponent)_tc, (String)"Create succeeded.");
        }
    }

    public static void copyDirectory(File file, File file2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyDirectory; ", (Object)new Object[]{file, file2});
        if (!file.exists()) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.copy.no.source", new Object[]{file.getAbsolutePath()}, "Unable to copy directory.  Source does not exist: {0}");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, null, false);
        }
        if (!file.isDirectory()) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.copy.is.directory", new Object[]{file.getAbsolutePath()}, "Unable to copy directory.  Source directory is a file: {0}");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, null, false);
        }
        FileUtilities.createDirectory(file2, "destination directory");
        UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.copying.directory", new Object[]{file2.getAbsolutePath()}, "Copying directory {0}"));
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file3 = new File(file, string);
            if (file3.isDirectory()) {
                Tr.debug((TraceComponent)_tc, (String)"Processing Directory: ", (Object)file3.getAbsolutePath());
                FileUtilities.copyDirectory(file3, new File(file2, string));
                continue;
            }
            Tr.debug((TraceComponent)_tc, (String)"Processing File: ", (Object)file3.getAbsolutePath());
            FileUtilities.copyFile(file3, new File(file2, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBufferedInputStream(InputStream inputStream, File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyBufferedInputStream", (Object)new Object[]{inputStream, file.getAbsolutePath()});
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            try {
                object = new FileOutputStream(file);
                filterOutputStream = new BufferedOutputStream((OutputStream)object, 8192);
            }
            catch (IOException iOException) {
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.copy.file.target", new Object[]{file.getAbsolutePath()}, "Unable to copy file. Could not open destination file: {0}");
                UpgradeBase.get_logger().println(string);
                throw new UpgradeException(string, null, false);
            }
            try {
                object = new byte[4096];
                int n = 0;
                while ((n = inputStream.read((byte[])object)) > 0) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                }
            }
            catch (IOException iOException) {
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.copy.file.target", new Object[]{file.getAbsolutePath()}, "Unable to copy file. Could not open destination file: {0}");
                UpgradeBase.get_logger().println(string);
                throw new UpgradeException(string, null, false);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.close", new Object[]{filterOutputStream}, "Could not close file: {0}"));
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.close", new Object[]{inputStream}, "Could not close file: {0}"));
            }
            throw throwable;
        }
        try {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
        catch (IOException iOException) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.close", new Object[]{filterOutputStream}, "Could not close file: {0}"));
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.close", new Object[]{inputStream}, "Could not close file: {0}"));
        }
    }

    public static void copyFile(File file, File file2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyFile", (Object)new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
        BufferedInputStream bufferedInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.copy.file", new Object[]{file.getAbsolutePath()}, "Unable to copy file.  Source does not exist: {0}");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, fileNotFoundException, false);
        }
        FileUtilities.copyBufferedInputStream(bufferedInputStream, file2);
    }

    public static void copyFileOrDirectory(File file, File file2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyFileOrDirectory", (Object)new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
        if (file.exists()) {
            if (file.isDirectory()) {
                FileUtilities.copyDirectory(file, file2);
            } else {
                File file3 = file2.getParentFile();
                if (!file3.exists()) {
                    FileUtilities.createDirectory(file3, "destination directory");
                }
                FileUtilities.copyFile(file, file2);
            }
        } else {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.logging.unable.to.copy.file", new Object[]{file.getAbsolutePath()}, "Unable to copy file.  Source does not exist: {0}");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, null, false);
        }
    }

    public static String generateFileName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"generateFileName", (Object)string);
        return FileUtilities.generateFileName(string, FileUtilities.generateTimeStamp());
    }

    public static String generateFileName(String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"generateFileName", (Object)new Object[]{string, string2});
        String string3 = null;
        int n = string.lastIndexOf(".");
        String string4 = string.substring(0, n);
        String string5 = string.substring(n);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.replace(stringBuffer.length() - 8, stringBuffer.length() - 4, "");
        stringBuffer.insert(0, string4 + ".").append(string5);
        string3 = stringBuffer.toString();
        if (_fileCollection.containsKey(string)) {
            _fileCollection.remove(string);
        }
        _fileCollection.put(string, string3);
        return string3;
    }

    public static String generateTimeStamp() {
        Tr.entry((TraceComponent)_tc, (String)"generateTimeStamp");
        return new Date().toString().replace(' ', '-').replace(':', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeBackupFile(File file) {
        Tr.entry((TraceComponent)_tc, (String)"makeBackupFile", (Object)file.getAbsolutePath());
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        String string = null;
        try {
            randomAccessFile = new RandomAccessFile(file.getAbsolutePath(), "r");
            string = new String(FileUtilities.generateFileName(file.getAbsolutePath()));
            File file2 = new File(string);
            if (file2.exists()) {
                file2.delete();
            }
            randomAccessFile2 = new RandomAccessFile(string, "rw");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.read(byArray);
            randomAccessFile2.write(byArray);
        }
        catch (Throwable throwable) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.no.backup", new Object[]{file.getAbsolutePath(), throwable}, "Unable to make a backup of configuration file {0}. Caught exception {1}."));
        }
        finally {
            try {
                randomAccessFile.close();
                randomAccessFile2.close();
            }
            catch (Throwable throwable) {}
        }
        return string;
    }

    public static String webSphereTreeRootForFile(File file, OSInfo oSInfo) {
        Tr.entry((TraceComponent)_tc, (String)"webSphereTreeRootForFile");
        try {
            String string = new File(FileUtilities.getUnquotedName(file.getAbsolutePath())).getCanonicalPath();
            String string2 = new File(FileUtilities.getUnquotedName(oSInfo.userRoot().getAbsolutePath())).getCanonicalPath();
            if (string.startsWith(string2)) {
                return string2;
            }
            String string3 = new File(FileUtilities.getUnquotedName(oSInfo.installRoot().getAbsolutePath())).getCanonicalPath();
            if (string.startsWith(string3)) {
                return string3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String webSphereTreeSuffixForFile(File file, OSInfo oSInfo) {
        Tr.entry((TraceComponent)_tc, (String)"webSphereTreeSuffixForFile");
        String string = FileUtilities.webSphereTreeRootForFile(file, oSInfo);
        if (string == null) {
            return null;
        }
        try {
            String string2 = new File(FileUtilities.getUnquotedName(file.getAbsolutePath())).getCanonicalPath();
            if (string.length() + 1 < string2.length()) {
                return string2.substring(string.length() + 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isInWebSphereTree(File file, OSInfo oSInfo) {
        Tr.entry((TraceComponent)_tc, (String)"isInWebSphereTree");
        return FileUtilities.webSphereTreeRootForFile(file, oSInfo) != null;
    }

    public static void saveHashTable(Hashtable hashtable, File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"saveHashTable");
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, exception, false);
        }
    }

    public static Hashtable restoreHashTable(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"restoreHashTable", (Object)file.getAbsolutePath());
        Hashtable hashtable = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.error.reading.backup.options", new Object[]{file.getAbsolutePath(), exception}, "Unable to read backup options file {0}, exception {1}.");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, exception, false);
        }
        return hashtable;
    }

    public static void saveVector(Vector vector, String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"saveVector", (Object)new Object[]{vector, string});
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(vector);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string2);
            throw new UpgradeException(string2, exception, false);
        }
    }

    public static Vector restoreVector(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"restoreVector", (Object)file.getAbsolutePath());
        Vector vector = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            vector = (Vector)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.error.reading.backup.options", new Object[]{file.getAbsolutePath(), exception}, "Unable to read backup options file {0}, exception {1}.");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, exception, false);
        }
        return vector;
    }

    public static void addToBackupList(Hashtable hashtable, File file, File file2, String string) {
        Tr.entry((TraceComponent)_tc, (String)"addToBackupList");
        hashtable.put(new File(file, string).getAbsolutePath(), new File(file2, string));
    }

    public static String quotedFileName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"quotedFileName", (Object)string);
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return QUOTE + string + QUOTE;
    }

    public static String getUnquotedName(String string) {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"getUnquotedName", (Object)string);
        File file = new File(string);
        file = new File(FileUtilities.unquoteString(file.getPath()));
        if (file.getPath().startsWith(QUOTE)) {
            object = new Vector();
            while (file.getName().length() > 0) {
                String string2 = file.getName();
                ((Vector)object).add(FileUtilities.unquoteString(string2));
                String string3 = file.getParent();
                file = new File(FileUtilities.unquoteString(string3));
            }
            for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
                file = new File(file, (String)((Vector)object).elementAt(i));
            }
        }
        object = file.getPath();
        if (string.endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return object;
    }

    public static String unquoteString(String string) {
        Tr.entry((TraceComponent)_tc, (String)"unquoteString", (Object)string);
        if (FileUtilities.isQuoted(string)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isQuoted(String string) {
        Tr.entry((TraceComponent)_tc, (String)"isQuoted", (Object)string);
        return string.length() > 2 && string.startsWith(QUOTE) && string.endsWith(QUOTE);
    }

    public static Element getDOMRoot(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getDOMRoot", (Object)new Object[]{file});
        Document document = null;
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrHandler());
            document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            return element;
        }
        catch (Throwable throwable) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.unable.to.read.XML", new Object[]{throwable.toString()}, "Unable to Read import XML document: {0}");
            UpgradeBase.get_logger().println(string, throwable);
            throw new UpgradeException(string, throwable, false);
        }
    }

    public static void deleteDirectoryAndContents(File file) {
        Tr.entry((TraceComponent)_tc, (String)"deleteDirectoryAndContents", (Object)new Object[]{file});
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                FileUtilities.deleteDirectoryAndContents(file2);
            }
        }
        file.delete();
    }
}

