/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.DefaultOSInfo;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.Invoker;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ISeriesInfo
extends DefaultOSInfo {
    private static TraceComponent _tc = Tr.register((Class)ISeriesInfo.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String ROOT_DIRECTORY = "/QIBM/";
    public static final String USER_DIRECTORY = "UserData";
    public static final String PRODUCT_DIRECTORY = "ProdData";
    public static final String USER_ROOT_PREFIX = "/QIBM/UserData/";
    public static final String PRODUCT_ROOT_PREFIX = "/QIBM/ProdData/";
    private String _javaInstallDirectory = null;
    private String _bootClassPath = "";

    public ISeriesInfo(File file, File file2, OSInfo oSInfo) throws UpgradeException {
        super(file, file2, oSInfo);
        Tr.debug((TraceComponent)_tc, (String)("ISeriesInfo const. userRoot=" + file));
        Tr.debug((TraceComponent)_tc, (String)("ISeriesInfo const. installRoot=" + file2));
    }

    public File installRoot() {
        Tr.entry((TraceComponent)_tc, (String)"installRoot");
        if (this._installRoot == null) {
            return this.calculateInstallRoot();
        }
        return this._installRoot;
    }

    public File calculateInstallRoot() {
        Tr.entry((TraceComponent)_tc, (String)"calculateInstallRoot");
        String string = this.userRoot().getAbsolutePath();
        if (string.toUpperCase().startsWith(USER_ROOT_PREFIX.toUpperCase()) && string.length() > USER_ROOT_PREFIX.length() + 1) {
            Vector<String> vector = new Vector<String>();
            for (File file = new File(string).getParentFile(); file != null; file = file.getParentFile()) {
                vector.add(file.getName());
            }
            Vector vector2 = new Vector();
            for (int i = vector.size(); i > 0; --i) {
                vector2.addElement(vector.elementAt(i - 1));
            }
            File file = new File(PRODUCT_ROOT_PREFIX);
            for (int i = 2; i < vector2.size(); ++i) {
                File file2 = new File(file, (String)vector2.elementAt(i));
                if (!file2.exists()) continue;
                file = file2;
            }
            Tr.debug((TraceComponent)_tc, (String)("calculateInstallRoot() return value=" + file.getAbsolutePath()));
            return file;
        }
        Tr.debug((TraceComponent)_tc, (String)("calculateInstallRoot() return value=" + this.userRoot()));
        return this.userRoot();
    }

    public String fetchExecutableExtension() {
        Tr.entry((TraceComponent)_tc, (String)"fetchExecutableExtension");
        return "";
    }

    public String getAdditionalExtDirs() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getAdditionalExtDirs");
        String string = this.installRoot() + File.separator + "java" + File.separator + "tools" + File.pathSeparator;
        string = string + this.installRoot() + File.separator + "lib" + File.separator + "server" + File.pathSeparator;
        string = string + this.userRoot() + File.separator + "properties" + File.pathSeparator;
        string = string + this.installRoot() + File.separator + "properties" + File.pathSeparator;
        string = string + File.separator + "QIBM" + File.separator + PRODUCT_DIRECTORY + File.separator + "HTTP" + File.separator + "Public" + File.separator + "jt400" + File.separator + "lib";
        return string;
    }

    public File javaHome() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"javaHome");
        String string = super.javaHome().getAbsolutePath();
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return new File(string);
    }

    public String addtoExecutable() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"addtoExecutable");
        String string = new File(this.javaHome(), this._bootClassPath).getAbsolutePath() + " -D" + this.javaVersion();
        return string;
    }

    protected void fetchSetupSettings() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"fetchSetupSettings");
        Properties properties = this.readCmdLineFile(this.userRoot());
        this._configRoot = properties.getProperty("CONFIG_ROOT");
        this._setupCmdLineRead = true;
        this._clientSAS = "-Dcom.ibm.CORBA.ConfigURL=file://" + new File(this._userRoot, "properties/sas.client.props").getAbsolutePath();
        ReleaseVersion releaseVersion = this.releaseVersion();
        if (releaseVersion.isR50()) {
            String string = "/QIBM/ProdData/Java400/jdk13";
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                this._javaHome = "java";
                this._javaVersion = "java.version=1.3";
                this._javaInstallDirectory = string;
                this._bootClassPath = this.getBootClassPath();
            }
        } else {
            String string = "/QIBM/ProdData/Java400/jdk14";
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                this._javaHome = "java";
                this._javaVersion = "java.version=1.4";
                this._javaInstallDirectory = string;
                this._bootClassPath = this.getBootClassPath();
            }
        }
        if (this._javaHome == null) {
            Tr.debug((TraceComponent)_tc, (String)"Could not find JAVA_HOME");
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.logging.internal.error", new Object[]{"JAVA_HOME"}, "Environment variable (0) was not set."), null, false);
        }
    }

    protected String convertToEnvironmentVariable(String string) {
        Tr.entry((TraceComponent)_tc, (String)"convertToEnvironmentVariable", (Object)string);
        return "${" + string + "}";
    }

    private String getBootClassPath() {
        String string = " -Xbootclasspath/a:" + new File(this.installRoot(), "java/ext/ibmorb.jar").getAbsolutePath();
        string = string + " -Dos400.websphere.orb.properties=" + new File(this.installRoot(), "java/extlib/orb.properties").getAbsolutePath();
        string = string + " -Dos400.jdk.provider=sun";
        string = string + " -Dwas.install.root=" + this.installRoot();
        string = string + " -Dwas.standalone=true";
        string = string + " -Djava.ext.dirs=" + this.installRoot() + "java/ext:" + new File(this._javaInstallDirectory, "/lib/ext:/QIBM/UserData/Java400/ext").getAbsolutePath();
        return string;
    }

    public String instance() {
        Tr.entry((TraceComponent)_tc, (String)"instance");
        String string = System.getProperty("com.ibm.websphere.migration.os400Instance");
        Tr.debug((TraceComponent)_tc, (String)("-instance=" + string));
        if (string == null || string.length() == 0) {
            return "";
        }
        if (this._releaseVersion.isR60() || this._releaseVersion.isR61()) {
            return " -profileName " + string;
        }
        try {
            Hashtable hashtable = FileUtilities.restoreHashTable(new File(UpgradeBase._backupDirectory, "websphere_backup_cmd_line_args.ser"));
            String string2 = (String)hashtable.get("-currentWASDirectory");
            if (string2.endsWith(File.separator)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return " -instance " + string2.substring(string2.lastIndexOf(File.separator) + 1, string2.length());
        }
        catch (UpgradeException upgradeException) {
            Tr.entry((TraceComponent)_tc, (String)upgradeException.toString());
            return "";
        }
    }

    public String removeJVMCommandLineDefaults(String string) {
        Tr.entry((TraceComponent)_tc, (String)"removeJVMCommandLineDefaults", (Object)string);
        StringBuffer stringBuffer = new StringBuffer(string);
        String[] stringArray = new String[]{"-Djava.ext.dirs", "-Dos400.jdk.provider", "-Dwas.install.root", "-Dwas.install.library", "-Dos400.file.create.auth", "-Dos400.dir.create.auth", "-Dos400.runtime.exec"};
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            n = string.indexOf(stringArray[i]);
            if (n != -1) {
                n2 = string.indexOf(" ", n);
                if (n2 == -1) {
                    n2 = string.length();
                }
                if (n2 != -1) {
                    stringBuffer.replace(n, n2, " ");
                } else {
                    n2 = string.indexOf(";", n);
                    if (n2 != -1) {
                        stringBuffer.replace(n, n2, " ");
                    }
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public void changeOwnership(File file) {
        Tr.entry((TraceComponent)_tc, (String)"changeOwnership", (Object)file);
        try {
            String string = null;
            string = file.getAbsolutePath().endsWith(File.separator) ? file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)) : file.getAbsolutePath();
            String string2 = "chown -R QEJBSVR " + string;
            Tr.debug((TraceComponent)_tc, (String)("Final string for executable: " + string2));
            new Invoker(this).exec(string2, "chown");
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string, exception);
        }
    }

    public boolean updateBootStrapPort() {
        Tr.entry((TraceComponent)_tc, (String)"updateBootStrapPort");
        return false;
    }

    public String modifyFileName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"modifyFileName");
        String[] stringArray = new String[]{"/", "\\", "*", ":", "?", "\"", "<", ">", "|", " ", "#"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            char[] cArray = stringArray[i].toCharArray();
            string = string.replace(cArray[0], '_');
        }
        return string;
    }

    public void validatePostUpgradeParms(Hashtable hashtable) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"validatePostUpgradeParms", (Object)UtilityImpl.replacePassword(hashtable.toString()));
        if (hashtable.containsKey("-newProfile")) {
            throw new UpgradeException(LoggerImpl.get_nls().getString("advise.invalid.cmd.line", "Invalid command line:"), null, true);
        }
        if (hashtable.containsKey("-oldProfile")) {
            throw new UpgradeException(LoggerImpl.get_nls().getString("advise.invalid.cmd.line", "Invalid command line:"), null, true);
        }
        if (hashtable.containsKey("-profile")) {
            throw new UpgradeException(LoggerImpl.get_nls().getString("advise.invalid.cmd.line", "Invalid command line:"), null, true);
        }
    }

    public Properties getInstances() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getInstances");
        return new Properties();
    }

    public void setInstances(Properties properties) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setInstances", (Object)properties);
    }

    public OSInfo getInstance(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getInstance", (Object)string);
        return null;
    }

    public OSInfo getDefaultInstance() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getDefaultInstance");
        if (this._parent == null) {
            if (this.getParentInstance()._defaultInstance == null) {
                this.getParentInstance()._defaultInstance = (DefaultOSInfo)OSInfoFactory.createOSInfo(this.userRoot(), this.installRoot(), this);
            }
            return this.getParentInstance()._defaultInstance;
        }
        return this;
    }
}

