/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.FilteringStreamRedirector;
import com.ibm.ws.migration.common.FilteringStreamRedirectorTarget;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.StreamRedirectorTarget;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import java.io.InputStream;
import java.util.Vector;

public class Invoker
implements StreamRedirectorTarget,
FilteringStreamRedirectorTarget {
    private static TraceComponent _tc = Tr.register((Class)Invoker.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected String[] _envp = null;
    protected OSInfo _osInfo;
    protected Vector _results;

    public Invoker(OSInfo oSInfo) throws UpgradeException {
        this(oSInfo, oSInfo.getProcessEnvironmentVariables(), null);
    }

    public Invoker(OSInfo oSInfo, String[] stringArray, Vector vector) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"Invoker", (Object)new Object[]{oSInfo, stringArray});
        this._osInfo = oSInfo;
        this._envp = stringArray;
        this._results = vector;
    }

    public void processLine(String string) {
        Tr.entry((TraceComponent)_tc, (String)"processLine", (Object)UtilityImpl.replacePassword(string));
        if (this._results == null) {
            ((LoggerImpl)UpgradeBase._logger).println(string, true);
        } else {
            this._results.addElement(string);
        }
    }

    public void processException(String string, Exception exception) {
        Tr.entry((TraceComponent)_tc, (String)"processException", (Object)new Object[]{string, exception});
        UpgradeBase._logger.println("Error Reading output of (" + string + "): ", exception);
    }

    public String[] filters() {
        Tr.entry((TraceComponent)_tc, (String)"filters");
        return FilteringStreamRedirector._standardFilters;
    }

    public int exec(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"exec", (Object)UtilityImpl.replacePassword(string));
        return this.execImpl(string, null);
    }

    public int exec(String string, String string2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"exec", (Object)new Object[]{UtilityImpl.replacePassword(string), string2});
        String string3 = LoggerImpl.get_nls().getFormattedMessage("advise.logging.capture.output", new Object[]{string2}, "Output of {0}.");
        return this.execImpl(string, string3);
    }

    protected int execImpl(String string, String string2) throws UpgradeException {
        Tr.debug((TraceComponent)_tc, (String)"exec", (Object)new Object[]{UtilityImpl.replacePassword(string), string2});
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string, this._envp);
            InputStream inputStream = process.getInputStream();
            inputStream = this._osInfo.translateStream(inputStream);
            FilteringStreamRedirector filteringStreamRedirector = new FilteringStreamRedirector(inputStream, string2, this._osInfo, this, this);
            filteringStreamRedirector.start();
            InputStream inputStream2 = process.getErrorStream();
            inputStream2 = this._osInfo.translateStream(inputStream2);
            FilteringStreamRedirector filteringStreamRedirector2 = new FilteringStreamRedirector(inputStream2, null, this._osInfo, this, this);
            filteringStreamRedirector2.start();
            process.waitFor();
            filteringStreamRedirector.join();
            filteringStreamRedirector2.join();
            return process.exitValue();
        }
        catch (Throwable throwable) {
            Tr.debug((TraceComponent)_tc, (String)"Invoker.execImpl Root Exception: ", (Object)throwable);
            Tr.debug((TraceComponent)_tc, (String)("Unabled to execute (" + UtilityImpl.replacePassword(string) + "): "));
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unable.to.execute", new Object[]{string}, "Unabled to execute: {0}"), null, false);
        }
    }
}

