/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.AIXInfo;
import com.ibm.ws.migration.common.HPUXInfo;
import com.ibm.ws.migration.common.ISeriesInfo;
import com.ibm.ws.migration.common.LinuxInfo;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.SunInfo;
import com.ibm.ws.migration.common.WindowsInfo;
import com.ibm.ws.migration.common.ZSeriesInfo;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;

public class OSInfoFactory {
    private static TraceComponent _tc = Tr.register((Class)OSInfoFactory.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static String _osName = null;

    public static OSInfo createOSInfo(File file, File file2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createOSInfo", (Object)new Object[]{file, file2});
        return OSInfoFactory.createOSInfo(file, file2, null);
    }

    public static OSInfo createOSInfo(File file, File file2, OSInfo oSInfo) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"createOSInfo", (Object)new Object[]{file, file2, oSInfo});
        if (OSInfoFactory.isSun()) {
            return new SunInfo(file, file2, oSInfo);
        }
        if (OSInfoFactory.isISeries()) {
            return new ISeriesInfo(file, file2, oSInfo);
        }
        if (OSInfoFactory.isZSeries()) {
            return new ZSeriesInfo(file, file2, oSInfo);
        }
        if (OSInfoFactory.isWindows()) {
            return new WindowsInfo(file, file2, oSInfo);
        }
        if (OSInfoFactory.isAIX()) {
            return new AIXInfo(file, file2, oSInfo);
        }
        if (OSInfoFactory.isHPUX()) {
            return new HPUXInfo(file, file2, oSInfo);
        }
        if (OSInfoFactory.isLinux()) {
            return new LinuxInfo(file, file2, oSInfo);
        }
        return null;
    }

    protected static void prepareOSName() {
        Tr.entry((TraceComponent)_tc, (String)"prepareOSName");
        _osName = System.getProperty("os.name");
    }

    public static boolean isSun() {
        Tr.entry((TraceComponent)_tc, (String)"isSun");
        return _osName.indexOf("SunOS") != -1 || _osName.indexOf("Solaris") != -1;
    }

    public static boolean isISeries() {
        Tr.entry((TraceComponent)_tc, (String)"isISeries");
        return _osName.indexOf("OS/400") != -1;
    }

    public static boolean isZSeries() {
        Tr.entry((TraceComponent)_tc, (String)"isZSeries");
        return _osName.indexOf("OS/390") != -1 || _osName.indexOf("z/OS") != -1;
    }

    public static boolean isWindows() {
        Tr.entry((TraceComponent)_tc, (String)"isWindows");
        return _osName.indexOf("Windows") != -1;
    }

    public static boolean isAIX() {
        Tr.entry((TraceComponent)_tc, (String)"isAIX");
        return _osName.indexOf("AIX") != -1;
    }

    public static boolean isHPUX() {
        Tr.entry((TraceComponent)_tc, (String)"isHPUX");
        return _osName.indexOf("HP-UX") != -1;
    }

    public static boolean isLinux() {
        Tr.entry((TraceComponent)_tc, (String)"isLinux");
        return !OSInfoFactory.isSun() && !OSInfoFactory.isISeries() && !OSInfoFactory.isWindows() && !OSInfoFactory.isAIX() && !OSInfoFactory.isHPUX() && !OSInfoFactory.isZSeries();
    }

    static {
        OSInfoFactory.prepareOSName();
    }
}

