/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.product.xml.websphere.websphere;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ReleaseVersion {
    private static TraceComponent _tc = Tr.register((Class)ReleaseVersion.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String CONFIG_DIRECTORY = "config";
    public static final ReleaseVersion UNKNOWN = new ReleaseVersion(false, "");
    public static final ReleaseVersion R50_EXPRESS = new ReleaseVersion(false, "EXPRESS");
    public static final ReleaseVersion R50_BOBCAT = new ReleaseVersion(false, "embeddedEXPRESS");
    public static final ReleaseVersion R50_BASE = new ReleaseVersion(false, "BASE");
    public static final ReleaseVersion R50_ND = new ReleaseVersion(false, "ND");
    public static final ReleaseVersion R50_CLIENT = new ReleaseVersion(false, "CLIENT");
    public static final ReleaseVersion R50_EXPRESS_WITH_PME = new ReleaseVersion(true, "EXPRESS");
    public static final ReleaseVersion R50_BOBCAT_WITH_PME = new ReleaseVersion(true, "embeddedEXPRESS");
    public static final ReleaseVersion R50_BASE_WITH_PME = new ReleaseVersion(true, "BASE");
    public static final ReleaseVersion R50_ND_WITH_PME = new ReleaseVersion(true, "ND");
    public static final ReleaseVersion R50_CLIENT_WITH_PME = new ReleaseVersion(true, "CLIENT");
    public static final ReleaseVersion[] R50_INSTANCES = new ReleaseVersion[]{R50_EXPRESS, R50_BOBCAT, R50_BASE, R50_ND, R50_CLIENT, R50_EXPRESS_WITH_PME, R50_BOBCAT_WITH_PME, R50_BASE_WITH_PME, R50_ND_WITH_PME, R50_CLIENT_WITH_PME};
    public static final ReleaseVersion[] R50_NON_EE_INSTANCES = new ReleaseVersion[]{R50_EXPRESS, R50_BOBCAT, R50_BASE, R50_ND, R50_CLIENT};
    public static final ReleaseVersion R51_EXPRESS = new ReleaseVersion(false, "EXPRESS");
    public static final ReleaseVersion R51_BOBCAT = new ReleaseVersion(false, "embeddedEXPRESS");
    public static final ReleaseVersion R51_BASE = new ReleaseVersion(false, "BASE");
    public static final ReleaseVersion R51_ND = new ReleaseVersion(false, "ND");
    public static final ReleaseVersion R51_CLIENT = new ReleaseVersion(false, "CLIENT");
    public static final ReleaseVersion R51_EXPRESS_WITH_PME = new ReleaseVersion(true, "EXPRESS");
    public static final ReleaseVersion R51_BOBCAT_WITH_PME = new ReleaseVersion(true, "embeddedEXPRESS");
    public static final ReleaseVersion R51_BASE_WITH_PME = new ReleaseVersion(true, "BASE");
    public static final ReleaseVersion R51_ND_WITH_PME = new ReleaseVersion(true, "ND");
    public static final ReleaseVersion R51_CLIENT_WITH_PME = new ReleaseVersion(true, "CLIENT");
    public static final ReleaseVersion[] R51_INSTANCES = new ReleaseVersion[]{R51_EXPRESS, R51_BOBCAT, R51_BASE, R51_ND, R51_CLIENT, R51_EXPRESS_WITH_PME, R51_BOBCAT_WITH_PME, R51_BASE_WITH_PME, R51_ND_WITH_PME, R51_CLIENT_WITH_PME};
    public static final ReleaseVersion[] R51_NON_EE_INSTANCES = new ReleaseVersion[]{R51_EXPRESS, R51_BOBCAT, R51_BASE, R51_ND, R51_CLIENT};
    public static final ReleaseVersion R60_EXPRESS = new ReleaseVersion(false, "EXPRESS");
    public static final ReleaseVersion R60_BOBCAT = new ReleaseVersion(false, "embeddedEXPRESS");
    public static final ReleaseVersion R60_BASE = new ReleaseVersion(false, "BASE");
    public static final ReleaseVersion R60_ND = new ReleaseVersion(false, "ND");
    public static final ReleaseVersion R60_CLIENT = new ReleaseVersion(false, "CLIENT");
    public static final ReleaseVersion[] R60_INSTANCES = new ReleaseVersion[]{R60_EXPRESS, R60_BOBCAT, R60_BASE, R60_ND, R60_CLIENT};
    public static final ReleaseVersion R61_EXPRESS = new ReleaseVersion(false, "EXPRESS");
    public static final ReleaseVersion R61_BOBCAT = new ReleaseVersion(false, "embeddedEXPRESS");
    public static final ReleaseVersion R61_BASE = new ReleaseVersion(false, "BASE");
    public static final ReleaseVersion R61_ND = new ReleaseVersion(false, "ND");
    public static final ReleaseVersion R61_CLIENT = new ReleaseVersion(false, "CLIENT");
    public static final ReleaseVersion[] R61_INSTANCES = new ReleaseVersion[]{R61_EXPRESS, R61_BOBCAT, R61_BASE, R61_ND, R61_CLIENT};
    public static final String JMS_LISTENER_SERVICE = "jmsListener";
    public static final String INTERNATIONALIZATION_SERVICE = "I18nService";
    public static final String WORK_AREA_SERVICE = "WorkAreaService";
    public static final String ACTIVITY_SESSION_SERVICE = "ActivitySessionService";
    public static final String APPLICATION_PROFILE_SERVICE = "ApplicationProfileService";
    public static final String EXTENDED_MESSAGING_SERVICE = "ExtendedMessagingService";
    public static final String FLOW_CONTAINER = "FlowContainer";
    public static final String MEMBER_MANAGER_SERVICE = "MemberManagerService";
    public static final String OBJECT_POOL_SERVICE = "ObjectPoolService";
    public static final String SCHEDULER_SERVICE = "SchedulerService";
    public static final String STAFF_SERVICE = "StaffService";
    public static final String WORK_MANAGER_SERVICE = "WorkManagerService";
    public static final String ADAPTIVE_ENTITY_SERVICE = "AdaptiveEntityService";
    public static final String BEI_SERVICE = "BeiService";
    public static final String CACHE_INSTANCE_SERVICE = "CacheInstanceService";
    public static final String ENTITY_CHANGE_NOTIFICATION_SERVICE = "EntityChangeNotificationService";
    public static final String WBIA_SERVICE = "WbiaService";
    public static final String COMPENSATION_SERVICE = "CompensationService";
    public static final String SERVICE_REFERENCE_SERVICE = "ServiceReferenceService";
    public static final String BUSINESS_CONTEXT_DATA_SERVICE = "BusinessContextDataService";
    public static final String EVENTS_SERVICE = "EventsService";
    public static final String WORK_AREA_PARTITION_SERVICE = "WorkAreaPartitionService";
    public static final String BUSINESS_RULE_BEANS = "BRBeans";
    public static final String CORBA_SDK = "CorbaSDK";
    public static final String DYNAMIC_QUERY = "EjbQuery";
    public static final String CLUSTERS = "Clusters";
    public static final String[][] PME_COMPONENT_TO_FEATURE_MAP = new String[][]{{"brb", "BRBeans"}, {"acwa", "WorkAreaService"}, {"i18nctx", "I18nService"}, {"eborb", "CorbaSDK"}, {"objsvcs", "CorbaSDK"}, {"vtlib", "CorbaSDK"}, {"activity.session.pme", "ActivitySessionService"}, {"appprofile.ee", "ApplicationProfileService"}, {"cmm", "ExtendedMessagingService"}, {"workflow", "FlowContainer"}, {"wmm", "MemberManagerService"}, {"objectpool", "ObjectPoolService"}, {"scheduler", "SchedulerService"}, {"staffsupport", "StaffService"}, {"asynchbeans.impl", "WorkManagerService"}, {"NOT_SHIPPED", "AdaptiveEntityService"}, {"bei", "BeiService"}, {"dynacache.pme", "CacheInstanceService"}, {"NOT_SHIPPED", "EntityChangeNotificationService"}, {"wbia", "WbiaService"}, {"compensation", "CompensationService"}, {"srm", "ServiceReferenceService"}, {"wei", "BusinessContextDataService"}, {"wei", "EventsService"}, {"acwa", "WorkAreaPartitionService"}, {"ejbquery", "EjbQuery"}};
    public static final String EXTENDED_SERVER_PRODUCT_BASE = "BASE";
    public static final String EXTENDED_SERVER_PRODUCT_PME = "PME";
    public static final String EXTENDED_SERVER_PRODUCT_ND = "ND";
    public static final String EXTENDED_SERVER_PRODUCT_CLIENT = "CLIENT";
    public static final String EXTENDED_SERVER_PRODUCT_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String EXTENDED_SERVER_PRODUCT_EXPRESS = "EXPRESS";
    private static final Vector _products = new Vector();
    private static Vector _wasProducts = null;
    private boolean _isEEInstalled;
    private int _ptfLevel = 0;
    private String _wasReleaseVersion;
    private OSInfo _osInfo;
    private Vector _installedEEFeatures;
    private Vector _extendedServerProducts;
    private Vector _expressServerProducts;
    private boolean _client;
    private String _version = null;

    public static ReleaseVersion getReleaseVersion(File file, OSInfo oSInfo) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getReleaseVersion");
        ReleaseVersion releaseVersion = ReleaseVersion.useWASProduct(file, oSInfo);
        if (releaseVersion == null) {
            releaseVersion = UNKNOWN;
        }
        return releaseVersion;
    }

    private ReleaseVersion(boolean bl, String string) {
        Tr.entry((TraceComponent)_tc, (String)"ReleaseVersion", (Object)new Object[]{new Boolean(bl), string});
        this._isEEInstalled = bl;
        this._wasReleaseVersion = string;
    }

    public boolean isEEInstalled() {
        Tr.entry((TraceComponent)_tc, (String)"isEEInstalled");
        return this._isEEInstalled;
    }

    public boolean isClient() {
        Tr.entry((TraceComponent)_tc, (String)"isClient");
        return this._client;
    }

    public boolean isBase() {
        Tr.entry((TraceComponent)_tc, (String)"isBase");
        if (this.areExpressServerProductsInstalled() || this.isClient()) {
            return false;
        }
        Vector vector = this.installedExtendedServerProducts();
        return vector.size() == 0 || vector.size() == 1 && vector.contains(EXTENDED_SERVER_PRODUCT_PME);
    }

    public boolean isBase(Configuration configuration) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isBase", (Object)configuration);
        if (this.areExpressServerProductsInstalled() || this.isClient()) {
            return false;
        }
        return !configuration.isDeploymentManagerConfiguration();
    }

    public Vector installedExtendedServerProducts() {
        Tr.entry((TraceComponent)_tc, (String)"installedExtendedServerProducts");
        return this._extendedServerProducts;
    }

    public boolean isExtendedServerProductInstalled(String string) {
        Tr.entry((TraceComponent)_tc, (String)"isExtendedServerProductInstalled");
        return this.installedExtendedServerProducts().contains(string);
    }

    public boolean areExtendedServerProductsInstalled() {
        Tr.entry((TraceComponent)_tc, (String)"areExtendedServerProductsInstalled");
        Vector vector = this.installedExtendedServerProducts();
        if (vector == null) {
            return false;
        }
        return vector.size() > 0;
    }

    public Vector installedExpressServerProducts() {
        Tr.entry((TraceComponent)_tc, (String)"installedExpressServerProducts");
        return this._expressServerProducts;
    }

    public boolean isExpressServerProductInstalled(String string) {
        Tr.entry((TraceComponent)_tc, (String)"isExpressServerProductInstalled");
        return this.installedExpressServerProducts().contains(string);
    }

    public boolean areExpressServerProductsInstalled() {
        Tr.entry((TraceComponent)_tc, (String)"areExpressServerProductsInstalled");
        return this.installedExpressServerProducts().size() > 0;
    }

    public Vector installedEEFeatures() {
        Tr.entry((TraceComponent)_tc, (String)"installedEEFeatures");
        return this._installedEEFeatures;
    }

    public boolean isEEFeatureInstalled(String string) {
        Tr.entry((TraceComponent)_tc, (String)"isEEFeatureInstalled");
        return this.installedEEFeatures().contains(string);
    }

    public String version() {
        Tr.entry((TraceComponent)_tc, (String)"version");
        return this._version;
    }

    protected void version(String string) {
        Tr.entry((TraceComponent)_tc, (String)"version", (Object)string);
        this._version = string;
    }

    public int ptfLevel() {
        Tr.entry((TraceComponent)_tc, (String)"ptfLevel");
        return this._ptfLevel;
    }

    protected void ptfLevel(int n) {
        Tr.entry((TraceComponent)_tc, (String)"ptfLevel");
        this._ptfLevel = n;
    }

    public String defaultConfigFileName() {
        Tr.entry((TraceComponent)_tc, (String)"defaultConfigFileName");
        return this._osInfo.userRoot() + CONFIG_DIRECTORY;
    }

    public boolean isR50() {
        Tr.entry((TraceComponent)_tc, (String)"isR50");
        for (int i = 0; i < R50_INSTANCES.length; ++i) {
            if (this != R50_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isR51() {
        Tr.entry((TraceComponent)_tc, (String)"isR51");
        for (int i = 0; i < R51_INSTANCES.length; ++i) {
            if (this != R51_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isR60() {
        Tr.entry((TraceComponent)_tc, (String)"isR60");
        for (int i = 0; i < R60_INSTANCES.length; ++i) {
            if (this != R60_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isR61() {
        Tr.entry((TraceComponent)_tc, (String)"isR61");
        for (int i = 0; i < R61_INSTANCES.length; ++i) {
            if (this != R61_INSTANCES[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isLatestRelease() {
        Tr.entry((TraceComponent)_tc, (String)"isLatestRelease");
        return this.isR61();
    }

    public String getWASReleaseVersion() {
        Tr.entry((TraceComponent)_tc, (String)"getWASReleaseVersion");
        return this._wasReleaseVersion;
    }

    public boolean isUnnamedDefaultInstanceProvided() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isUnnamedDefaultInstanceProvided");
        if (this.isClient() || this.isR50() || this.isR51() || this.isR60()) {
            return true;
        }
        if (this._osInfo.configRoot().exists()) {
            try {
                new Configuration(this._osInfo.configRoot(), null, null, false, this, false, true);
                return true;
            }
            catch (UpgradeException upgradeException) {
                Tr.debug((TraceComponent)_tc, (String)"Failed to instantiate a Configuration for a default instance.");
            }
        }
        return false;
    }

    public String installableAppsDirectoryName(OSInfo oSInfo) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"installableAppsDirectoryName", (Object)oSInfo);
        return new File(oSInfo.userRoot(), "installableApps").getAbsolutePath();
    }

    public String instance() {
        Tr.entry((TraceComponent)_tc, (String)"instance");
        return this._osInfo.instance();
    }

    public String classLoaderSettings(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"classLoaderSettings");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        return this.extDirs(string2) + this.classPath() + " com.ibm.ws.bootstrap.WSLauncher";
    }

    private String classPath() {
        Tr.entry((TraceComponent)_tc, (String)"classPath");
        String string = " -classpath ";
        if (!this._osInfo.installRoot().getAbsolutePath().equalsIgnoreCase(this._osInfo.userRoot().getAbsolutePath())) {
            string = string + FileUtilities.quotedFileName(this._osInfo.userRoot() + "properties") + File.pathSeparator;
        }
        string = string + FileUtilities.quotedFileName(new File(this._osInfo.installRoot(), "properties").getAbsolutePath()) + File.pathSeparator;
        string = string + FileUtilities.quotedFileName(new File(new File(this._osInfo.installRoot(), "lib"), "bootstrap.jar").getAbsolutePath());
        return string;
    }

    private String extDirs(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"extDirs");
        String string2 = " -Dws.ext.dirs=" + FileUtilities.quotedFileName(string) + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(new File(this._osInfo.installRoot(), "classes").getAbsolutePath()) + File.pathSeparator;
        string2 = string2 + FileUtilities.quotedFileName(new File(new File(this._osInfo.userRoot(), "lib"), "ext").getAbsolutePath()) + File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(this._osInfo.getAdditionalExtDirs(), File.pathSeparator, false);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + FileUtilities.quotedFileName(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + File.pathSeparator;
        }
        return string2;
    }

    private static ReleaseVersion useWASProduct(File file, OSInfo oSInfo) {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"useWASProduct", (Object)file);
        File file2 = new File(file, "version");
        if (!file2.exists() || !file2.isDirectory()) {
            return null;
        }
        String string = file2.getAbsolutePath();
        WASProduct wASProduct = new WASProduct(string.substring(0, string.lastIndexOf("properties")));
        websphere websphere2 = wASProduct.getPlatform();
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        String string2 = null;
        Iterator iterator = wASProduct.getProducts();
        while (iterator.hasNext()) {
            product product2 = (product)iterator.next();
            object = product2.getId();
            if (!_wasProducts.contains(object)) continue;
            if (!((String)object).equals(EXTENDED_SERVER_PRODUCT_PME)) {
                string2 = product2.getVersion();
            }
            if (((String)object).equals(EXTENDED_SERVER_PRODUCT_BASE) || ((String)object).equals(EXTENDED_SERVER_PRODUCT_CLIENT)) continue;
            if (((String)object).equals(EXTENDED_SERVER_PRODUCT_EXPRESS) || ((String)object).equals(EXTENDED_SERVER_PRODUCT_EMBEDDED_EXPRESS)) {
                vector2.add(object);
                continue;
            }
            if (((String)object).equals(EXTENDED_SERVER_PRODUCT_ND) && wASProduct.productPresent(EXTENDED_SERVER_PRODUCT_BASE)) continue;
            vector.add(object);
        }
        int n = -1;
        iterator = _products.iterator();
        while (iterator.hasNext() && n == -1) {
            object = (String)iterator.next();
            if (wASProduct.getProductById((String)object) == null) continue;
            n = _products.indexOf(object);
        }
        object = new Vector();
        for (int i = 0; i < PME_COMPONENT_TO_FEATURE_MAP.length; ++i) {
            if (!wASProduct.componentPresent(PME_COMPONENT_TO_FEATURE_MAP[i][0]) || ((Vector)object).contains(PME_COMPONENT_TO_FEATURE_MAP[i][1])) continue;
            ((Vector)object).add(PME_COMPONENT_TO_FEATURE_MAP[i][1]);
        }
        return ReleaseVersion.getReleaseVersion(string2, n, vector, vector2, (Vector)object, oSInfo, n == _products.indexOf(EXTENDED_SERVER_PRODUCT_CLIENT));
    }

    private static ReleaseVersion getReleaseVersion(String string, int n, Vector vector, Vector vector2, Vector vector3, OSInfo oSInfo, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"getReleaseVersion");
        ReleaseVersion releaseVersion = UNKNOWN;
        if (string.startsWith("5.0")) {
            if (vector.contains(EXTENDED_SERVER_PRODUCT_PME)) {
                n += R50_NON_EE_INSTANCES.length;
            }
            releaseVersion = R50_INSTANCES[n];
        }
        if (string.startsWith("5.1")) {
            if (vector.contains(EXTENDED_SERVER_PRODUCT_PME)) {
                n += R51_NON_EE_INSTANCES.length;
            }
            releaseVersion = R51_INSTANCES[n];
        }
        if (string.startsWith("6.0")) {
            releaseVersion = R60_INSTANCES[n];
        }
        if (string.startsWith("6.1")) {
            releaseVersion = R61_INSTANCES[n];
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() >= 3) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                releaseVersion.ptfLevel(Integer.parseInt(string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        releaseVersion._osInfo = oSInfo;
        releaseVersion._installedEEFeatures = vector3;
        releaseVersion._extendedServerProducts = vector;
        releaseVersion._expressServerProducts = vector2;
        releaseVersion._client = bl;
        releaseVersion.version(string.substring(0, string.indexOf(".") + 2));
        return releaseVersion;
    }

    static {
        _products.add(EXTENDED_SERVER_PRODUCT_EXPRESS);
        _products.add(EXTENDED_SERVER_PRODUCT_EMBEDDED_EXPRESS);
        _products.add(EXTENDED_SERVER_PRODUCT_BASE);
        _products.add(EXTENDED_SERVER_PRODUCT_ND);
        _products.add(EXTENDED_SERVER_PRODUCT_CLIENT);
        _wasProducts = (Vector)_products.clone();
        _wasProducts.add(EXTENDED_SERVER_PRODUCT_PME);
    }
}

