/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.StreamRedirectorTarget;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class StreamRedirector
implements Runnable {
    private static TraceComponent _tc = Tr.register((Class)StreamRedirector.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected OSInfo _osInfo;
    protected BufferedReader _reader;
    protected String _streamName;
    protected StreamRedirectorTarget _target;
    protected Thread _redirectorThread;

    public StreamRedirector(InputStream inputStream, String string, OSInfo oSInfo, StreamRedirectorTarget streamRedirectorTarget) throws UpgradeException {
        this._osInfo = oSInfo;
        try {
            this._reader = this._osInfo.getBufferedReader(inputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{unsupportedEncodingException}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string2);
            throw new UpgradeException(string2, unsupportedEncodingException, false);
        }
        this._streamName = string;
        this._target = streamRedirectorTarget;
    }

    protected void processLine(String string) {
        this._target.processLine(string);
    }

    protected void processException(Exception exception) {
        this._target.processException(this._streamName, exception);
    }

    protected void start() {
        this._redirectorThread = new Thread(this);
        this._redirectorThread.start();
    }

    protected void join() {
        try {
            this._redirectorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        try {
            String string;
            if (this._streamName != null) {
                this._target.processLine(this._streamName);
            }
            while ((string = this._reader.readLine()) != null) {
                this.processLine(string);
            }
        }
        catch (IOException iOException) {
            this.processException(iOException);
        }
    }
}

