/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.utility.ArgumentException;
import com.ibm.ws.migration.utility.ArgumentsImpl;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.utility.WASLogger;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class UpgradeBase {
    private static TraceComponent _tc = Tr.register((Class)UpgradeBase.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static String copyright1 = "Product #,  (C) COPYRIGHT International Business Machines Corp., 2000, 2002 **";
    protected static String copyright2 = "All Rights Reserved * Licensed Materials - Property of IBM";
    protected static String copyright3 = "US Government Users Restricted Rights - Use, duplication or disclosure";
    protected static String copyright4 = "restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String websphere3xBackup = "websphere_backup";
    public static final String cmdLineArgsFile = "websphere_backup_cmd_line_args.ser";
    public static final String externalConfigURLFile = "websphere_backup_external_config_url.ser";
    public static final String migrationJarPath = "bin" + File.separator + "migration" + File.separator;
    protected static WASLogger _logger = null;
    protected static String _lineSeparator = null;
    protected boolean _calledByInstall = false;
    protected String _newProfileName = null;
    private static ArgumentsImpl _arguments = new ArgumentsImpl();
    protected static Hashtable _cmdLineArgs = null;
    protected static OSInfo _oldOSInfo = null;
    protected static OSInfo _newOSInfo = null;
    protected static File _userRoot = null;
    protected static File _backupDirectory = null;
    protected static File _installRoot = null;
    protected static ReleaseVersion _currentRelease = null;

    protected static void initializeNLS() {
        if (LoggerImpl.get_nls() == null) {
            LoggerImpl.set_nls(TraceNLS.getTraceNLS((String)"com.ibm.websphere.migration.WASUpgrade"));
        }
    }

    protected void parseArgs(String[] stringArray, String[] stringArray2) throws UpgradeException {
        int n;
        _cmdLineArgs = new Hashtable();
        for (n = 0; n < stringArray2.length; ++n) {
            if (n >= stringArray.length) {
                return;
            }
            if (stringArray[n].startsWith("-")) break;
            _cmdLineArgs.put(stringArray2[n], stringArray[n]);
        }
        if ((n = _cmdLineArgs.size()) >= stringArray.length) {
            return;
        }
        if (!stringArray[n].startsWith("-")) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.max.positional.parameters", new Object[]{new Integer(stringArray2.length)}, "You cannot specify more than {0} positional parameters.");
            throw new UpgradeException(string, null, true);
        }
        try {
            for (int i = n; i < stringArray.length; ++i) {
                _cmdLineArgs.put(stringArray[i++], stringArray[i]);
            }
        }
        catch (Throwable throwable) {
            throw new ArgumentException(LoggerImpl.get_nls().getString("advise.cmd.line.illegal.number.arg", "Illegal number of arguments, there must be an even number."), throwable, true);
        }
    }

    protected void parseArgs(String[] stringArray) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"parseArgs", (Object)stringArray);
        _cmdLineArgs = new Hashtable();
        if (stringArray.length >= 1) {
            _cmdLineArgs.put("-backupDirectory", stringArray[0]);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-installLogFile")) continue;
            this._calledByInstall = true;
            break;
        }
    }

    protected void parsePositionalParms(String[] stringArray, String[] stringArray2) throws UpgradeException {
        int n = 0;
        for (n = 0; n < stringArray2.length; ++n) {
            if (n >= stringArray.length) {
                return;
            }
            if (stringArray[n].startsWith("-")) break;
            _arguments.setPositionalParm(stringArray2[n], stringArray[n]);
        }
        Vector<String> vector = new Vector<String>();
        while (n < stringArray.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        _arguments.parseArgs(vector);
    }

    protected void setupTrace(String string) throws UpgradeException {
        this.checkTraceFile();
        this.setupDefaultTrace(string);
        String string2 = (String)_cmdLineArgs.get("-traceString");
        if (_cmdLineArgs.containsKey("-traceString") && !_cmdLineArgs.get("-traceString").equals("*=all=disabled")) {
            if (_cmdLineArgs.containsKey("-traceFile")) {
                String string3 = (String)_cmdLineArgs.get("-traceFile");
                if (string3 != null && !string3.equals("")) {
                    if (string2 != null && !string2.equals("")) {
                        ManagerAdmin.configureClientTrace((String)string2, (String)"named file", (String)string3, (boolean)false, (String)"basic", (boolean)true);
                    } else {
                        ManagerAdmin.configureClientTrace((String)"*=all=disabled", (String)"named file", (String)string3, (boolean)false, (String)"basic", (boolean)true);
                    }
                } else if (string2 != null && !string2.equals("")) {
                    ManagerAdmin.configureClientTrace((String)string2, (String)"stdout", null, (boolean)false, (String)"basic", (boolean)true);
                }
            } else {
                ManagerAdmin.configureClientTrace((String)string2, (String)"stdout", null, (boolean)false, (String)"basic", (boolean)true);
            }
        }
    }

    protected void setupDefaultTrace(String string) {
        Tr.entry((TraceComponent)_tc, (String)"setupDefaultTrace", (Object)string);
        try {
            String string2;
            if (!_cmdLineArgs.containsKey("-traceString") && !OSInfoFactory.isZSeries() && (string2 = System.getProperty("com.ibm.ws.migration.currentProfileLogLocation")) != null) {
                File file = new File(new File(string2, "logs"), string + ".trace");
                if (file.exists()) {
                    file.delete();
                }
                _cmdLineArgs.put("-traceString", "*=all=enabled");
                _cmdLineArgs.put("-traceFile", file.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void copyright(String string) {
        Tr.entry((TraceComponent)_tc, (String)"copyright", (Object)string);
        System.out.println("IBM WebSphere Application Server, Release 6.1");
        System.out.println(string);
        System.out.println("Copyright IBM Corp., 1997-2005");
        System.out.println("");
    }

    protected static void displayOutput(String string) {
        Tr.entry((TraceComponent)_tc, (String)"displayOutput", (Object)string);
        if (LoggerImpl.isRegistered()) {
            ((LoggerImpl)_logger).println(string);
        } else {
            System.err.println(string);
        }
    }

    protected void checkArguments() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArguments");
        this.checkRequiredArguments();
    }

    protected void checkRequiredArguments() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkRequiredArguments");
        if (!_cmdLineArgs.containsKey("-backupDirectory")) {
            throw new ArgumentException(LoggerImpl.get_nls().getString("advise.cmd.line.backupDirectory", "You must specify the backup directory name."), null, true);
        }
        if (!_cmdLineArgs.containsKey("-currentWASDirectory")) {
            throw new ArgumentException(LoggerImpl.get_nls().getString("advise.cmd.line.currentWASDirectory", "You must specify the currently installed WebSphere directory name."), null, true);
        }
        _backupDirectory = new File((String)_cmdLineArgs.get("-backupDirectory"));
        _userRoot = new File((String)_cmdLineArgs.get("-currentWASDirectory"));
    }

    public static boolean isInvalidKey(String[] stringArray, String string) {
        Tr.entry((TraceComponent)_tc, (String)"isInvalidKey", (Object)new Object[]{stringArray, string});
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        return !bl;
    }

    protected boolean checkOldWASVersion(ReleaseVersion releaseVersion) throws UpgradeException {
        return !releaseVersion.isR50() && !releaseVersion.isR51() && !releaseVersion.isR60();
    }

    protected static boolean handleException(Throwable throwable) {
        Tr.entry((TraceComponent)_tc, (String)"handleException", (Object)throwable);
        boolean bl = false;
        if (LoggerImpl.isRegistered()) {
            _logger.println(throwable.getMessage(), false);
            _logger.printStackTrace(throwable, false);
        } else {
            bl = true;
            if (!(throwable instanceof ArgumentException)) {
                throwable.printStackTrace(System.err);
            } else {
                System.err.println(throwable.getMessage());
            }
        }
        return bl;
    }

    protected void checkTraceFile() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkTraceFile");
        if (_cmdLineArgs.containsKey("-traceFile")) {
            File file = new File((String)_cmdLineArgs.get("-traceFile"));
            try {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
                if (!file.canWrite()) {
                    throw new IOException();
                }
            }
            catch (IOException iOException) {
                String string = LoggerImpl.get_nls().getString("advise.trace.initialization.failed", "Can not initialize trace services.");
                throw new UpgradeException(string, iOException, true);
            }
        }
    }

    protected void checkNewProfile() throws UpgradeException {
        OSInfo oSInfo;
        Tr.entry((TraceComponent)_tc, (String)"checkNewProfile");
        if (_currentRelease.isClient()) {
            return;
        }
        if (this._newProfileName == null) {
            oSInfo = _newOSInfo.getDefaultInstance();
            if (oSInfo == null) {
                String string = LoggerImpl.get_nls().getString("advise.default.profile.missing", "The currently installed WebSphere does not contain a default profile.");
                throw new ArgumentException(string, null, true);
            }
        } else {
            oSInfo = _newOSInfo.getInstance(this._newProfileName);
            if (oSInfo == null) {
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.new.profile.incorrect", new Object[]{this._newProfileName}, "Profile {0} not found in the currently installed WebSphere.");
                throw new ArgumentException(string, null, true);
            }
        }
        _newOSInfo = oSInfo;
        _userRoot = oSInfo.userRoot();
    }

    public String getNewProfileName() {
        Tr.entry((TraceComponent)_tc, (String)"getNewprofileName");
        return this._newProfileName;
    }

    public static File get_backupDirectory() {
        return _backupDirectory;
    }

    public static void set_backupDirectory(File file) {
        _backupDirectory = file;
    }

    public static Hashtable get_cmdLineArgs() {
        return _cmdLineArgs;
    }

    public static void set_cmdLineArgs(Hashtable hashtable) {
        _cmdLineArgs = hashtable;
    }

    public static File get_installRoot() {
        return _installRoot;
    }

    public static void set_installRoot(File file) {
        _installRoot = file;
    }

    public static OSInfo get_newOSInfo() {
        return _newOSInfo;
    }

    public static void set_newOSInfo(OSInfo oSInfo) {
        _newOSInfo = oSInfo;
    }

    public static OSInfo get_oldOSInfo() {
        return _oldOSInfo;
    }

    public static void set_oldOSInfo(OSInfo oSInfo) {
        _oldOSInfo = oSInfo;
    }

    public static File get_userRoot() {
        return _userRoot;
    }

    public static void set_userRoot(File file) {
        _userRoot = file;
    }

    public static ReleaseVersion get_currentRelease() {
        return _currentRelease;
    }

    public static void set_currentRelease(ReleaseVersion releaseVersion) {
        _currentRelease = releaseVersion;
    }

    public static WASLogger get_logger() {
        return _logger;
    }

    public static void set_logger(WASLogger wASLogger) {
        _logger = wASLogger;
    }

    public static ArgumentsImpl getArguments() {
        return _arguments;
    }

    static {
        UpgradeBase.initializeNLS();
        _lineSeparator = System.getProperty("line.separator");
    }
}

