/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.common.XMLReflectionHelper;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class WCCMDocumentReflector
extends XMLReflectionHelper
implements WCCMDocumentProcessorHelper {
    private static TraceComponent _tc = Tr.register((Class)WCCMDocumentReflector.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static final String SETTER_PREFIX = "set";
    private static final String COMPARATOR_METHOD_NAME = "arePrimaryKeysEqual";
    private static final String DEFAULT_COMPARATOR_METHOD_NAME = "arePrimaryKeysEqualDefault";
    private Object _currentNewElement = null;
    private Hashtable _overrideList = new Hashtable();
    private Vector _crossReferenceMethodsList = new Vector();
    private Hashtable _methodInvocationSequenceList = new Hashtable();
    private WCCMDocument _oldDocument = null;
    private WCCMDocument _newDocument = null;
    private Vector _oldObjects = new Vector();
    private Vector _newObjects = new Vector();
    private Hashtable _crossReferences = new Hashtable();
    private Method _abstractEnumeratorComparator;
    private Method _defaultComparator;
    private WCCMDocumentProcessor _wccmDocumentProcessor;
    private DocumentTransform _transform;
    private TransformMappingKey _transformMappingKey;

    public Object getCurrentNewElement() {
        Tr.entry((TraceComponent)_tc, (String)"getCurrentNewTag");
        return this._currentNewElement;
    }

    public WCCMDocumentReflector(DocumentTransform documentTransform, TransformMappingKey transformMappingKey) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"WCCMDocumentReflector", (Object)new Object[]{documentTransform, transformMappingKey});
        this._transform = documentTransform;
        this._transformMappingKey = transformMappingKey;
        try {
            this._abstractEnumeratorComparator = this.getClass().getMethod(COMPARATOR_METHOD_NAME, AbstractEnumerator.class, AbstractEnumerator.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.debug((TraceComponent)_tc, (String)"Failed to find method arePrimaryKeysEqual(AbstractEnumerator, AbstractEnumerator) in class.");
            WCCMDocumentReflector.throwInternalErrorException(noSuchMethodException);
        }
        try {
            this._defaultComparator = this.getClass().getMethod(DEFAULT_COMPARATOR_METHOD_NAME, Object.class, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.debug((TraceComponent)_tc, (String)"Failed to find method arePrimaryKeysEqualDefault(Object, Object) in class.");
            WCCMDocumentReflector.throwInternalErrorException(noSuchMethodException);
        }
    }

    public void setWCCMDocumentProcessor(WCCMDocumentProcessor wCCMDocumentProcessor) {
        Tr.entry((TraceComponent)_tc, (String)"setWCCMDocumentProcessor", (Object)wCCMDocumentProcessor);
        this._wccmDocumentProcessor = wCCMDocumentProcessor;
    }

    public void migrate() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        DocumentCollection documentCollection = this._transform.getOldDocumentCollection();
        DocumentCollection documentCollection2 = this._transform.getNewDocumentCollection();
        this._wccmDocumentProcessor.migrate(documentCollection, documentCollection2);
    }

    public void migrate(DocumentCollection documentCollection, DocumentCollection documentCollection2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate", (Object)new Object[]{documentCollection, documentCollection2});
        if (documentCollection == null || documentCollection2 == null) {
            throw new IllegalArgumentException();
        }
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.openDocument(this._transformMappingKey.getOldDocumentName(), WCCMDocument.class);
        WCCMDocument wCCMDocument2 = this.openNewDocument(documentCollection2);
        this._wccmDocumentProcessor.migrate(wCCMDocument, wCCMDocument2);
    }

    public void migrate(WCCMDocument wCCMDocument, WCCMDocument wCCMDocument2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate", (Object)new Object[]{wCCMDocument, wCCMDocument2});
        if (wCCMDocument == null || wCCMDocument2 == null) {
            throw new IllegalArgumentException();
        }
        this._oldDocument = wCCMDocument;
        this._newDocument = wCCMDocument2;
        this._wccmDocumentProcessor.processContents(wCCMDocument.getList(), wCCMDocument2.getList());
    }

    public Document getOldDocument() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getOldDocument");
        if (this._oldDocument == null) {
            throw new IllegalStateException();
        }
        return this._oldDocument;
    }

    public Class getInterfaceClass(Object object) {
        Tr.entry((TraceComponent)_tc, (String)"getInterfaceClass", (Object)object);
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Tr.entry((TraceComponent)_tc, (String)"getInterfaceClass", (Object)object);
        return super.getInterfaceClass(object);
    }

    public Document getNewDocument() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getNewDocument");
        if (this._newDocument == null) {
            try {
                this._newDocument = this.openNewDocument(this._transform.getNewDocumentCollection());
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException();
                illegalStateException.initCause(exception);
                throw illegalStateException;
            }
        }
        return this._newDocument;
    }

    protected WCCMDocument openNewDocument(DocumentCollection documentCollection) throws Exception {
        Document document;
        Tr.entry((TraceComponent)_tc, (String)"openNewDocument", (Object)documentCollection);
        WCCMDocument wCCMDocument = null;
        if (!documentCollection.documentExists(this._transformMappingKey.getNewDocumentName()) && (document = this._wccmDocumentProcessor.getTemplateDocument()) != null) {
            wCCMDocument = (WCCMDocument)documentCollection.openDocument(this._transformMappingKey.getNewDocumentName(), WCCMDocument.class, true, false);
            wCCMDocument.setInputStream(document.getInputStream());
        }
        if (wCCMDocument == null) {
            wCCMDocument = (WCCMDocument)documentCollection.openDocument(this._transformMappingKey.getNewDocumentName(), WCCMDocument.class, true, false);
        }
        return wCCMDocument;
    }

    public void addOverride(Class clazz, String string, Class[] classArray) throws Exception {
        if (clazz == null || string == null || classArray == null) {
            throw new IllegalArgumentException();
        }
        Tr.entry((TraceComponent)_tc, (String)"addOverride", (Object)new Object[]{clazz, string, classArray});
        Method method = null;
        Method method2 = null;
        try {
            method = clazz.getMethod(string, classArray);
            Tr.debug((TraceComponent)_tc, (String)("Found WCCM method: " + method));
            Method[][] methodArray = this.getAttributeMethods(clazz);
            Object[] objectArray = this.getChildTagListMethods(clazz);
            Method[][] methodArray2 = this.getChildTagSingleMethods(clazz);
            if (!(this.objectInArray(method, methodArray[0]) || this.objectInArray(method, methodArray[1]) || this.objectInArray(method, objectArray) || this.objectInArray(method, methodArray2[0]) || this.objectInArray(method, methodArray2[1]))) {
                Tr.debug((TraceComponent)_tc, (String)("The specified method cannot be overridden: " + method));
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{null}, "An unexpected internal error occurred, exception {0}.");
                UpgradeBase.get_logger().println(string2);
                throw new IllegalArgumentException(string2);
            }
            Class[] classArray2 = null;
            int n = -1;
            if (string.startsWith(SETTER_PREFIX)) {
                classArray2 = new Class[classArray.length + 1];
                n = 0;
            } else {
                classArray2 = new Class[classArray.length + 2];
                classArray2[0] = Boolean.TYPE;
                n = 1;
            }
            classArray2[n] = clazz;
            ++n;
            for (int i = 0; i < classArray.length; ++i) {
                classArray2[i + n] = classArray[i];
            }
            method2 = this._wccmDocumentProcessor.getClass().getMethod(string, classArray2);
            Tr.debug((TraceComponent)_tc, (String)("Found Migration method: " + method2));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(noSuchMethodException);
            throw illegalArgumentException;
        }
        this._overrideList.put(new OverrideKey(method, clazz), method2);
    }

    public void addMultipleCrossReferenceMethod(Class clazz, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addMultipleCrossReferenceMethod", (Object)new Object[]{clazz, string});
        Method method = null;
        try {
            method = clazz.getMethod(string, new Class[0]);
            Tr.debug((TraceComponent)_tc, (String)("Found WCCM method: " + method));
            Object[] objectArray = this.getChildTagListMethods(clazz);
            if (!this.objectInArray(method, objectArray)) {
                Tr.debug((TraceComponent)_tc, (String)("The specified method cannot be defined as returning multiple cross references: " + method));
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{null}, "An unexpected internal error occurred, exception {0}.");
                UpgradeBase.get_logger().println(string2);
                throw new Exception(string2);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            WCCMDocumentReflector.throwInternalErrorException(noSuchMethodException);
        }
        if (!this._crossReferenceMethodsList.contains(method)) {
            this._crossReferenceMethodsList.addElement(method);
        }
    }

    public Vector getMethodSequence(Class clazz) throws Exception {
        Vector<Method> vector;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Tr.entry((TraceComponent)_tc, (String)"getMethodSequence", (Object)new Object[]{clazz});
        if (this._methodInvocationSequenceList.containsKey(clazz)) {
            vector = (Vector<Method>)this._methodInvocationSequenceList.get(clazz);
            vector = (Vector)vector.clone();
        } else {
            int n;
            Method[] methodArray = this.getChildTagListMethods(clazz);
            Method[][] methodArray2 = this.getChildTagSingleMethods(clazz);
            Method[] methodArray3 = methodArray2[0];
            vector = new Vector<Method>(methodArray.length + methodArray3.length);
            for (n = 0; n < methodArray.length; ++n) {
                vector.addElement(methodArray[n]);
            }
            for (n = 0; n < methodArray3.length; ++n) {
                vector.addElement(methodArray3[n]);
            }
        }
        return vector;
    }

    public void setMethodSequence(Class clazz, Vector vector) throws Exception {
        if (clazz == null || vector == null) {
            throw new IllegalArgumentException();
        }
        Tr.entry((TraceComponent)_tc, (String)"setMethodSequence", (Object)new Object[]{clazz, vector});
        Object[] objectArray = this.getChildTagListMethods(clazz);
        Method[][] methodArray = this.getChildTagSingleMethods(clazz);
        Object[] objectArray2 = methodArray[0];
        Vector vector2 = new Vector(objectArray.length + objectArray2.length);
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e == null) continue;
            if (!this.objectInArray(e, objectArray) && !this.objectInArray(e, objectArray2)) {
                Tr.debug((TraceComponent)_tc, (String)("The specified method cannot have its sequence set: " + e));
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{null}, "An unexpected internal error occurred, exception {0}.");
                UpgradeBase.get_logger().println(string);
                throw new IllegalArgumentException(string);
            }
            vector2.addElement(e);
        }
        this._methodInvocationSequenceList.put(clazz, vector2);
    }

    public void processContents(List list, List list2) throws Exception {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException();
        }
        Tr.entry((TraceComponent)_tc, (String)"processContents", (Object)new Object[]{list, list2});
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.processXML(iterator.next(), list2);
        }
        this.processCrossReferences();
    }

    private void processXML(Object object, Object object2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXML", (Object)new Object[]{object, object2});
        Class clazz = this.getInterfaceClass(object);
        String string = clazz.getName();
        Object object3 = null;
        if (object2 instanceof List) {
            object3 = this.useSubclassToFindMatchingObject(object, clazz, (List)object2);
            this.logProgressMessage(object, clazz, object3 == null);
            if (object3 == null) {
                object3 = object instanceof AbstractEnumerator ? this.getAbstractEnumerator((AbstractEnumerator)object) : this.create(string);
                Tr.debug((TraceComponent)_tc, (String)("Created object of type: " + object3.getClass().getName()));
                ((List)object2).add(object3);
            }
        } else {
            object3 = object2;
        }
        this._currentNewElement = object3;
        this._oldObjects.addElement(object);
        this._newObjects.addElement(object3);
        this.collectCrossReferences(object);
        this.processXMLAttributes(object, object3, clazz);
        Method[][] methodArray = this.getChildTagSingleMethods(clazz);
        Object[] objectArray = methodArray[0];
        Method[] methodArray2 = methodArray[1];
        Vector vector = this.getMethodSequence(clazz);
        for (int i = 0; i < vector.size(); ++i) {
            Method method = (Method)vector.elementAt(i);
            if (this.objectInArray(method, objectArray)) {
                int n = -1;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (!method.equals(objectArray[j])) continue;
                    n = j;
                    break;
                }
                this.processXMLChildTagSingleObject(object, object3, clazz, method, methodArray2[n]);
                continue;
            }
            this.processXMLChildTagList(object, object3, clazz, method);
        }
    }

    private void processXMLAttributes(Object object, Object object2, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLAttributes", (Object)new Object[]{object, object2, clazz});
        Method[][] methodArray = this.getAttributeMethods(clazz);
        Method[] methodArray2 = methodArray[0];
        Method[] methodArray3 = methodArray[1];
        for (int i = 0; i < methodArray2.length; ++i) {
            Object object3 = null;
            object3 = this.invoke(methodArray2[i], object, new Object[0], true, clazz);
            if (object3 == null) continue;
            this.invoke(methodArray3[i], object2, new Object[]{object3}, false, clazz);
        }
    }

    private void processXMLChildTagList(Object object, Object object2, Class clazz, Method method) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLChildTagLists", (Object)new Object[]{object, object2, clazz, method});
        List list = (List)this.invoke(method, object, new Object[0], true, clazz);
        List list2 = (List)this.invoke(method, object2, new Object[0], false, clazz);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this._crossReferenceMethodsList.contains(method)) {
                Vector vector = (Vector)this._crossReferences.get(new CrossReferenceKey(e, object));
                if (vector == null) continue;
                Tr.debug((TraceComponent)_tc, (String)("Found a cross XML reference on method: " + method));
                vector.addElement(new CrossReferenceData(object2, method));
                continue;
            }
            if (this._wccmDocumentProcessor.processClass(e.getClass())) {
                this.processXML(e, list2);
                continue;
            }
            if (e.getClass().getName().equals("java.lang.String")) {
                this.addUniqueStringEntry(list2, (String)e);
                continue;
            }
            if (e instanceof Short || e instanceof Integer || e instanceof Long) {
                this.addUniqueNonfractionalNumericEntry(list2, (Number)e);
                continue;
            }
            if (!this._wccmDocumentProcessor.isUnexpectedClass(e.getClass())) continue;
            Tr.debug((TraceComponent)_tc, (String)("Found an List entry of unexpected type: " + e.getClass().getName()));
            WCCMDocumentReflector.throwInternalErrorException(null);
        }
    }

    private void processXMLChildTagSingleObject(Object object, Object object2, Class clazz, Method method, Method method2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLChildTagSingleObjects", (Object)new Object[]{object, object2, clazz, method, method2});
        Object object3 = this.invoke(method, object, new Object[0], true, clazz);
        if (object3 == null) {
            return;
        }
        Tr.debug((TraceComponent)_tc, (String)("Found object of class: " + object3.getClass().getName()));
        if (this._oldObjects.contains(object3)) {
            Tr.debug((TraceComponent)_tc, (String)("Found a back XML reference on method: " + method));
            int n = this._oldObjects.indexOf(object3);
            Object e = this._newObjects.elementAt(n);
            this.invoke(method2, object2, new Object[]{e}, false, clazz);
            return;
        }
        Vector vector = (Vector)this._crossReferences.get(new CrossReferenceKey(object3, object));
        if (vector != null) {
            Tr.debug((TraceComponent)_tc, (String)("Found a cross XML reference on method: " + method));
            vector.addElement(new CrossReferenceData(object2, method2));
            return;
        }
        if (object3 instanceof AbstractEnumerator) {
            this.processAbstractEnumerator((AbstractEnumerator)object3, method2, object2, clazz);
            return;
        }
        Object object4 = this.invoke(method, object2, new Object[0], false, clazz);
        if (object4 == null) {
            object4 = this.create(this.getInterfaceClass(object3).getName());
            Tr.debug((TraceComponent)_tc, (String)("Created object of type: " + object4.getClass().getName()));
        }
        this.invoke(method2, object2, new Object[]{object4}, false, clazz);
        this.processXML(object3, object4);
    }

    private void processAbstractEnumerator(AbstractEnumerator abstractEnumerator, Method method, Object object, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processAbstractEnumerator", (Object)new Object[]{abstractEnumerator, method, object, clazz});
        Object object2 = this.getAbstractEnumerator(abstractEnumerator);
        this.invoke(method, object, new Object[]{object2}, false, clazz);
    }

    private Object getAbstractEnumerator(AbstractEnumerator abstractEnumerator) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getAbstractEnumerator", (Object)abstractEnumerator);
        Object object = null;
        Class clazz = this.getInterfaceClass(abstractEnumerator);
        try {
            Method method = clazz.getMethod("get", String.class);
            String string = abstractEnumerator.getName();
            object = method.invoke(null, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            WCCMDocumentReflector.throwInternalErrorException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            WCCMDocumentReflector.throwInternalErrorException(illegalAccessException);
        }
        return object;
    }

    public Object invoke(Method method, Object object, Object[] objectArray, boolean bl, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"invoke", (Object)new Object[]{method, object, objectArray, new Boolean(bl), clazz});
        Object object2 = null;
        Method method2 = (Method)this._overrideList.get(new OverrideKey(method, clazz));
        try {
            if (method2 != null) {
                Object[] objectArray2 = null;
                int n = -1;
                if (method.getName().startsWith(SETTER_PREFIX)) {
                    objectArray2 = new Object[objectArray.length + 1];
                    n = 0;
                } else {
                    objectArray2 = new Object[objectArray.length + 2];
                    objectArray2[0] = new Boolean(bl);
                    n = 1;
                }
                objectArray2[n] = object;
                ++n;
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i + n] = objectArray[i];
                }
                object2 = method2.invoke((Object)this._wccmDocumentProcessor, objectArray2);
            } else {
                object2 = method.invoke(object, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.debug((TraceComponent)_tc, (String)("Method call to " + method2.getName() + " failed because method is not public."));
            WCCMDocumentReflector.throwInternalErrorException(illegalAccessException);
        }
        return object2;
    }

    private Method getIsSetMethod(String string, Method[] methodArray) {
        Tr.entry((TraceComponent)_tc, (String)"getIsSetMethod", (Object)new Object[]{string, methodArray});
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            return methodArray[i];
        }
        return null;
    }

    private void logProgressMessage(Object object, Class clazz, boolean bl) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{object, clazz, new Boolean(bl)});
        String string = "logProgressMessage";
        try {
            Method method = this._wccmDocumentProcessor.getClass().getMethod(string, clazz, Boolean.class);
            method.invoke((Object)this._wccmDocumentProcessor, object, new Boolean(bl));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.debug((TraceComponent)_tc, (String)("Method call to " + string + " failed because method is not public."));
            WCCMDocumentReflector.throwInternalErrorException(illegalAccessException);
        }
    }

    public Object useSubclassToFindMatchingObject(Object object, Class clazz, List list) throws Exception {
        Method method;
        Tr.entry((TraceComponent)_tc, (String)"useSubclassToFindMatchingObject", (Object)new Object[]{object, clazz, list});
        Method method2 = null;
        Method method3 = null;
        Object object2 = this;
        try {
            method3 = this.getPrimaryKeysComparisonMethod(clazz);
            object2 = this._wccmDocumentProcessor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (object instanceof AbstractEnumerator) {
                method3 = this._abstractEnumeratorComparator;
            }
            try {
                method = this.getDefaultAttributeComparisonMethod(clazz);
                method3 = this._defaultComparator;
                Tr.debug((TraceComponent)_tc, (String)("WARNING: Failed to find method arePrimaryKeysEqual(" + clazz.getName() + ", " + clazz.getName() + ") in subclass. Attempting to use default arePrimaryKeysEqual()."));
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                Tr.debug((TraceComponent)_tc, (String)("Failed to find method arePrimaryKeysEqual(" + clazz.getName() + ", " + clazz.getName() + ") in subclass."));
                WCCMDocumentReflector.throwInternalErrorException(noSuchMethodException);
            }
        }
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                method = iterator.next();
                if (!method.getClass().equals(object.getClass())) continue;
                Boolean bl = (Boolean)method3.invoke(object2, object, method);
                if (!bl.booleanValue()) continue;
                method2 = method;
                break;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.debug((TraceComponent)_tc, (String)"Method call to arePrimaryKeysEqual failed because method is not public.");
            WCCMDocumentReflector.throwInternalErrorException(illegalAccessException);
        }
        return method2;
    }

    private Method getPrimaryKeysComparisonMethod(Class clazz) throws NoSuchMethodException {
        Tr.entry((TraceComponent)_tc, (String)"getPrimaryKeysComparisonMethod", (Object)clazz);
        return this._wccmDocumentProcessor.getClass().getMethod(COMPARATOR_METHOD_NAME, clazz, clazz);
    }

    private Method getDefaultAttributeComparisonMethod(Class clazz) throws NoSuchMethodException {
        Tr.entry((TraceComponent)_tc, (String)"getDefaultAttributeComparisonMethod", (Object)clazz);
        return clazz.getMethod("getName", new Class[0]);
    }

    public boolean arePrimaryKeysEqualDefault(Object object, Object object2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)DEFAULT_COMPARATOR_METHOD_NAME, (Object)object.getClass().getName());
        String string = null;
        String string2 = null;
        try {
            Method method = this.getDefaultAttributeComparisonMethod(object.getClass());
            string = (String)method.invoke(object, new Object[0]);
            string2 = (String)method.invoke(object2, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.debug((TraceComponent)_tc, (String)"Method call to arePrimaryKeysEqualDefault failed because method is not public.");
            WCCMDocumentReflector.throwInternalErrorException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.debug((TraceComponent)_tc, (String)("Failed to find method getName() for class " + object.getClass() + "."));
            WCCMDocumentReflector.throwInternalErrorException(noSuchMethodException);
        }
        if (string == null || string2 == null) {
            Tr.debug((TraceComponent)_tc, (String)("Failed to find method arePrimaryKeysEqual(" + object.getClass().getName() + ", " + object2.getClass().getName() + ") in subclass."));
            try {
                this.getPrimaryKeysComparisonMethod(object.getClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                WCCMDocumentReflector.throwInternalErrorException(noSuchMethodException);
            }
        }
        return string.equals(string2);
    }

    public boolean arePrimaryKeysEqual(AbstractEnumerator abstractEnumerator, AbstractEnumerator abstractEnumerator2) {
        Tr.entry((TraceComponent)_tc, (String)COMPARATOR_METHOD_NAME, (Object)abstractEnumerator.getClass().getName());
        return abstractEnumerator.getName().equals(abstractEnumerator2.getName());
    }

    public boolean isWebSphereClass(Class clazz) {
        Tr.entry((TraceComponent)_tc, (String)"isWebSphereClass", (Object)clazz);
        return this._wccmDocumentProcessor.processClass(clazz);
    }

    public boolean processClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Tr.entry((TraceComponent)_tc, (String)"processClass", (Object)clazz);
        return super.isWebSphereClass(clazz);
    }

    public boolean isUnexpectedClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Tr.entry((TraceComponent)_tc, (String)"isUnexpectedClass", (Object)clazz);
        return super.isWebSphereClass(clazz);
    }

    private boolean objectInArray(Object object, Object[] objectArray) {
        Tr.entry((TraceComponent)_tc, (String)"objectInArray", (Object)new Object[]{object, objectArray});
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void collectCrossReferences(Object object) {
        Tr.entry((TraceComponent)_tc, (String)"collectCrossReferences", (Object)object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EList eList = eObject.eCrossReferences();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Tr.debug((TraceComponent)_tc, (String)("Found cross reference to object of type: " + e.getClass().getName()));
                CrossReferenceKey crossReferenceKey = new CrossReferenceKey(e, object);
                Vector vector = (Vector)this._crossReferences.get(crossReferenceKey);
                if (vector != null) continue;
                Tr.debug((TraceComponent)_tc, (String)("Cross reference for " + e + "," + object + " added to list"));
                this._crossReferences.put(crossReferenceKey, new Vector());
            }
        }
    }

    private void processCrossReferences() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processCrossReferences");
        Enumeration enumeration = this._crossReferences.keys();
        while (enumeration.hasMoreElements()) {
            CrossReferenceKey crossReferenceKey = (CrossReferenceKey)enumeration.nextElement();
            Object object = crossReferenceKey.getCrossReference();
            int n = this._oldObjects.indexOf(object);
            if (n == -1) {
                Tr.debug((TraceComponent)_tc, (String)("Skipped processing cross reference for missing object: " + object));
                continue;
            }
            Object e = this._newObjects.elementAt(n);
            Vector vector = (Vector)this._crossReferences.get(crossReferenceKey);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                CrossReferenceData crossReferenceData = (CrossReferenceData)enumeration2.nextElement();
                Object object2 = crossReferenceData.getInvokee();
                Class clazz = this.getInterfaceClass(object2);
                if (this._crossReferenceMethodsList.contains(crossReferenceData.getSetter())) {
                    List list = (List)this.invoke(crossReferenceData.getSetter(), object2, new Object[0], false, clazz);
                    if (list.contains(e)) continue;
                    list.add(e);
                    continue;
                }
                this.invoke(crossReferenceData.getSetter(), object2, new Object[]{e}, false, clazz);
            }
        }
    }

    private class CrossReferenceData {
        protected Object _invokee;
        protected Method _setter;

        public CrossReferenceData(Object object, Method method) {
            this._invokee = object;
            this._setter = method;
        }

        public Object getInvokee() {
            return this._invokee;
        }

        public Method getSetter() {
            return this._setter;
        }
    }

    private class CrossReferenceKey {
        protected Object _crossReferenceDefiner;
        protected Object _crossReference;

        public CrossReferenceKey(Object object, Object object2) {
            this._crossReference = object;
            this._crossReferenceDefiner = object2;
        }

        public Object getCrossReferenceDefiner() {
            return this._crossReferenceDefiner;
        }

        public Object getCrossReference() {
            return this._crossReference;
        }

        public int hashCode() {
            long l = this._crossReference.hashCode();
            return (int)(l += (long)this._crossReferenceDefiner.hashCode());
        }

        public boolean equals(Object object) {
            if (object instanceof CrossReferenceKey) {
                CrossReferenceKey crossReferenceKey = (CrossReferenceKey)object;
                return this._crossReference.equals(crossReferenceKey._crossReference) && this._crossReferenceDefiner.equals(crossReferenceKey._crossReferenceDefiner);
            }
            return false;
        }
    }

    private class OverrideKey {
        protected Method _overriddenMethod;
        protected Class _overriddenClass;

        public OverrideKey(Method method, Class clazz) {
            this._overriddenMethod = method;
            this._overriddenClass = clazz;
        }

        public int hashCode() {
            return this._overriddenMethod.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof OverrideKey) {
                OverrideKey overrideKey = (OverrideKey)object;
                return this._overriddenMethod.equals(overrideKey._overriddenMethod) && (this._overriddenClass.isAssignableFrom(overrideKey._overriddenClass) || overrideKey._overriddenClass.isAssignableFrom(this._overriddenClass));
            }
            return false;
        }
    }
}

