/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.DefaultOSInfo;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class WindowsInfo
extends DefaultOSInfo {
    private static TraceComponent _tc = Tr.register((Class)WindowsInfo.class, null, (String)"com.ibm.ws.migration.WASUpgrade");

    public WindowsInfo(File file, File file2, OSInfo oSInfo) throws UpgradeException {
        super(file, file2, oSInfo);
    }

    public String fetchExecutableExtension() {
        Tr.entry((TraceComponent)_tc, (String)"fetchExecutableExtension");
        return ".bat";
    }

    public String addtoExecutable() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"addtoExecutable");
        return new File(new File(this.javaHome(), "bin"), "java").getAbsolutePath();
    }

    protected String convertToEnvironmentVariable(String string) {
        Tr.entry((TraceComponent)_tc, (String)"convertToEnvironmentVariable", (Object)string);
        return "%" + string + "%";
    }

    protected String getEnvironmentVariableListCommand() {
        Tr.entry((TraceComponent)_tc, (String)"getEnvironmentVariableListCommand");
        return "CMD.EXE /C set";
    }

    public BufferedReader openFile(File file) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"openFile", (Object)file.getAbsolutePath());
        if (System.getProperty("file.encoding").equals("Cp1252")) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "Cp850"));
        }
        return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
    }

    public BufferedWriter closeFile(File file) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"closeFile", (Object)file.getAbsolutePath());
        if (System.getProperty("file.encoding").equals("Cp1252")) {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "Cp850"));
        }
        return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
    }

    public BufferedReader getBufferedReader(InputStream inputStream) throws UnsupportedEncodingException {
        Tr.entry((TraceComponent)_tc, (String)"getBufferedReader");
        if (System.getProperty("file.encoding").equals("Cp1252")) {
            return new BufferedReader(new InputStreamReader(inputStream, "Cp850"));
        }
        return new BufferedReader(new InputStreamReader(inputStream));
    }
}

