/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;

public class XMLReflectionHelper {
    private static TraceComponent _tc = Tr.register((Class)XMLReflectionHelper.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String SETTER_PREFIX = "set";
    public static final String GETTER_PREFIX = "get";
    public static final String BOOLEAN_GETTER_PREFIX = "is";
    private Hashtable _factories = new Hashtable();
    static /* synthetic */ Class class$java$util$List;

    public XMLReflectionHelper() {
        Tr.entry((TraceComponent)_tc, (String)"XMLReflectionHelper");
    }

    public Method[][] getAttributeMethods(Class clazz) throws Exception {
        Method[][] methodArray;
        Tr.entry((TraceComponent)_tc, (String)"getAttributeMethods", (Object)clazz);
        Method[] methodArray2 = clazz.getMethods();
        Hashtable<String, Method> hashtable = new Hashtable<String, Method>();
        Hashtable<String, Method> hashtable2 = new Hashtable<String, Method>();
        for (int i = 0; i < methodArray2.length; ++i) {
            if (methodArray2[i].getName().startsWith(GETTER_PREFIX) && methodArray2[i].getParameterTypes().length == 0 && (methodArray2[i].getReturnType().getName().startsWith("java.lang.") || methodArray2[i].getReturnType().isPrimitive())) {
                hashtable.put(methodArray2[i].getName(), methodArray2[i]);
                Tr.debug((TraceComponent)_tc, (String)("Added getter " + methodArray2[i].getName()));
                continue;
            }
            if (methodArray2[i].getName().startsWith(BOOLEAN_GETTER_PREFIX) && methodArray2[i].getParameterTypes().length == 0 && methodArray2[i].getReturnType() == Boolean.TYPE) {
                hashtable.put(methodArray2[i].getName(), methodArray2[i]);
                Tr.debug((TraceComponent)_tc, (String)("Added boolean getter " + methodArray2[i].getName()));
                continue;
            }
            if (!methodArray2[i].getName().startsWith(SETTER_PREFIX) || methodArray2[i].getParameterTypes().length != 1 || !methodArray2[i].getParameterTypes()[0].getName().startsWith("java.lang.") && !methodArray2[i].getParameterTypes()[0].isPrimitive() || !methodArray2[i].getReturnType().getName().equals("void")) continue;
            hashtable2.put(methodArray2[i].getName(), methodArray2[i]);
            Tr.debug((TraceComponent)_tc, (String)("Added setter " + methodArray2[i].getName()));
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            methodArray = (Method[][])enumeration.nextElement();
            String string = null;
            string = methodArray.startsWith(GETTER_PREFIX) ? SETTER_PREFIX + methodArray.substring(GETTER_PREFIX.length(), methodArray.length()) : SETTER_PREFIX + methodArray.substring(BOOLEAN_GETTER_PREFIX.length(), methodArray.length());
            if (!hashtable2.containsKey(string)) continue;
            vector.addElement(hashtable.get(methodArray));
            vector2.addElement(hashtable2.get(string));
        }
        methodArray = new Method[2][vector.size()];
        vector.copyInto(methodArray[0]);
        vector2.copyInto(methodArray[1]);
        return methodArray;
    }

    public Method[] getChildTagListMethods(Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getChildTagListMethods", (Object)clazz);
        Method[] methodArray = clazz.getMethods();
        Vector<Method> vector = new Vector<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith(GETTER_PREFIX) || !this.isChildTagInclusion(methodArray[i].getName()) && methodArray[i].getName().endsWith("Refs") || methodArray[i].getParameterTypes().length != 0 || !(class$java$util$List == null ? XMLReflectionHelper.class$("java.util.List") : class$java$util$List).isAssignableFrom(methodArray[i].getReturnType())) continue;
            vector.addElement(methodArray[i]);
            Tr.debug((TraceComponent)_tc, (String)("Added getter " + methodArray[i].getName()));
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Method[][] getChildTagSingleMethods(Class clazz) throws Exception {
        Method[][] methodArray;
        Tr.entry((TraceComponent)_tc, (String)"getChildTagSingleMethods", (Object)clazz);
        Method[] methodArray2 = clazz.getMethods();
        Hashtable<String, Method> hashtable = new Hashtable<String, Method>();
        Hashtable<String, Method> hashtable2 = new Hashtable<String, Method>();
        for (int i = 0; i < methodArray2.length; ++i) {
            if (methodArray2[i].getName().startsWith(GETTER_PREFIX) && !methodArray2[i].getName().endsWith("Refs") && methodArray2[i].getParameterTypes().length == 0 && this.isWebSphereClass(methodArray2[i].getReturnType())) {
                hashtable.put(methodArray2[i].getName(), methodArray2[i]);
                Tr.debug((TraceComponent)_tc, (String)("Added getter " + methodArray2[i].getName()));
                continue;
            }
            if (!methodArray2[i].getName().startsWith(SETTER_PREFIX) || methodArray2[i].getName().endsWith("Refs") || methodArray2[i].getParameterTypes().length != 1 || !this.isWebSphereClass(methodArray2[i].getParameterTypes()[0]) || !methodArray2[i].getReturnType().getName().equals("void")) continue;
            hashtable2.put(methodArray2[i].getName(), methodArray2[i]);
            Tr.debug((TraceComponent)_tc, (String)("Added setter " + methodArray2[i].getName()));
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            methodArray = (Method[][])enumeration.nextElement();
            String string = SETTER_PREFIX + methodArray.substring(GETTER_PREFIX.length(), methodArray.length());
            if (!hashtable2.containsKey(string)) continue;
            vector.addElement(hashtable.get(methodArray));
            vector2.addElement(hashtable2.get(string));
        }
        methodArray = new Method[2][vector.size()];
        vector.copyInto(methodArray[0]);
        vector2.copyInto(methodArray[1]);
        return methodArray;
    }

    protected boolean isChildTagInclusion(String string) {
        Tr.entry((TraceComponent)_tc, (String)"isChildTagInclusion");
        return string.equals("getLocalizationPointRefs");
    }

    public boolean isWebSphereClass(Class clazz) {
        Tr.entry((TraceComponent)_tc, (String)"isWebSphereClass", (Object)clazz);
        return clazz.getName().startsWith("com.ibm.websphere.") || clazz.getName().startsWith("com.ibm.etools.webservice.") || clazz.getName().startsWith("com.ibm.ejs.") || clazz.getName().startsWith("com.ibm.etools.emf.ecore.") || clazz.getName().startsWith("com.ibm.etools.jca.") || clazz.getName().startsWith("com.ibm.etools.j2ee.") || clazz.getName().startsWith("org.eclipse.jst.j2ee.jca.");
    }

    public Class getInterfaceClass(Object object) {
        Tr.entry((TraceComponent)_tc, (String)"getInterfaceClass", (Object)object);
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        Tr.debug((TraceComponent)_tc, (String)("Original class name: " + string));
        String string2 = ".impl";
        String string3 = ".internal.impl";
        int n = string.indexOf(string3);
        if (n == -1) {
            n = string.indexOf(string2);
        } else {
            string2 = string3;
        }
        if (n != -1 && string.endsWith("Impl")) {
            String string4 = string.substring(0, n) + string.substring(n + string2.length(), string.length() - "Impl".length());
            try {
                clazz = Class.forName(string4);
                string = clazz.getName();
                Tr.debug((TraceComponent)_tc, (String)("Interface class name: " + string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public void addUniqueStringEntry(List list, String string) {
        Tr.entry((TraceComponent)_tc, (String)"addUniqueStringEntry", (Object)new Object[]{list, string});
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string)) continue;
            return;
        }
        list.add(string);
    }

    public void addUniqueNonfractionalNumericEntry(List list, Number number) {
        Tr.entry((TraceComponent)_tc, (String)"addUniqueNonfractionalNumericEntry", (Object)new Object[]{list, number});
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Number number2 = (Number)iterator.next();
            if (number2.longValue() != number.longValue()) continue;
            return;
        }
        list.add(number);
    }

    public Object invoke(Method method, Object object, Object[] objectArray, boolean bl, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"invoke", (Object)new Object[]{method, object, objectArray, new Boolean(bl), clazz});
        Object object2 = null;
        try {
            object2 = method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.debug((TraceComponent)_tc, (String)("Method call to " + method.getName() + " failed because method is not public."));
            XMLReflectionHelper.throwInternalErrorException(illegalAccessException);
        }
        return object2;
    }

    public Object create(Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"create", (Object)clazz);
        return this.create(clazz.getName());
    }

    public Object create(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"create", (Object)string);
        String string2 = string.substring(0, string.lastIndexOf("."));
        String string3 = string.substring(string.lastIndexOf(".") + 1);
        EFactory eFactory = this.getFactory(string2);
        Object object = null;
        Class<?> clazz = eFactory.getClass();
        Method method = clazz.getMethod("create" + string3, new Class[0]);
        object = method.invoke((Object)eFactory, new Object[0]);
        return object;
    }

    public EFactory getFactory(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getFactory", (Object)string);
        EFactory eFactory = (EFactory)this._factories.get(string);
        if (eFactory == null) {
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            Class<?> clazz = Class.forName(string + "." + string2 + "Package");
            Field field = clazz.getField("eNS_URI");
            String string3 = (String)field.get(null);
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string3);
            Method method = clazz.getMethod(GETTER_PREFIX + string2 + "Factory", new Class[0]);
            eFactory = (EFactory)method.invoke((Object)ePackage, new Object[0]);
            this._factories.put(string, eFactory);
        }
        return eFactory;
    }

    public void handleInvocationTargetException(InvocationTargetException invocationTargetException) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"handleInvocationTargetException", (Object)invocationTargetException);
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        XMLReflectionHelper.throwInternalErrorException(throwable);
    }

    public static void throwInternalErrorException(Throwable throwable) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"throwInternalErrorException", (Object)throwable);
        throw new Exception(throwable);
    }
}

