/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.DefaultOSInfo;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.Invoker;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Vector;

public class ZSeriesInfo
extends DefaultOSInfo {
    private static TraceComponent _tc = Tr.register((Class)ZSeriesInfo.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String SETUPCMDLINE = "setupCmdLine";
    private static final Vector _excludeVariables = new Vector();
    private static final Vector _transformVariables = new Vector();

    public ZSeriesInfo(File file, File file2, OSInfo oSInfo) throws UpgradeException {
        super(file, file2, oSInfo);
    }

    public String fetchExecutableExtension() {
        Tr.entry((TraceComponent)_tc, (String)"fetchExecutableExtension");
        return ".sh";
    }

    public String addtoExecutable() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"addtoExecutable");
        return this.commonUnixAddtoExecutable() + " -Dfile.encoding=ISO8859-1 -Xnoargsconversion";
    }

    protected void determineReleaseVersion() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"determineReleaseVersion");
        super.determineReleaseVersion();
        if (this._releaseVersion == ReleaseVersion.UNKNOWN) {
            return;
        }
        Vector vector = this._releaseVersion.installedExtendedServerProducts();
        if (!vector.contains("ND")) {
            vector.add("ND");
        }
    }

    public boolean isInvalidReleaseOnOS(ReleaseVersion releaseVersion, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"isInvalidReleaseOnOS", (Object)new Object[]{releaseVersion, new Boolean(bl)});
        return !releaseVersion.isR50() && !releaseVersion.isR51() && !releaseVersion.isR60() || releaseVersion.areExpressServerProductsInstalled();
    }

    public Vector getAdditionalExcludeVariables() {
        Tr.entry((TraceComponent)_tc, (String)"getAddtionalExcludeVariables");
        return _excludeVariables;
    }

    public Vector getAdditionalTransformVariables() {
        Tr.entry((TraceComponent)_tc, (String)"getAdditionalTransformVariables");
        return _transformVariables;
    }

    public void configToNative(File file, String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"configToNative", (Object)new Object[]{file, string, string2});
        try {
            String string3 = FileUtilities.quotedFileName(new File(new File(file.getAbsolutePath(), "bin"), "wsc2n" + this.fetchExecutableExtension()).getAbsolutePath());
            Tr.debug((TraceComponent)_tc, (String)("The wsc2n path is " + string3));
            String string4 = string3 + " -s " + string + " " + string2;
            Tr.debug((TraceComponent)_tc, (String)("Final string for executable: " + string4));
            new Invoker(this).exec(string4, "wsc2n");
        }
        catch (Exception exception) {
            String string5 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string5, exception);
        }
    }

    public BufferedReader openFile(File file) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"openFile", (Object)file);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "cp1047"));
    }

    public BufferedWriter closeFile(File file) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"closeFile", (Object)file);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "cp1047"));
    }

    public void addManagedObjectMetadataProperties(Properties properties, String string) {
        Tr.entry((TraceComponent)_tc, (String)"addManagedObjectMetadataProperties", (Object)new Object[]{properties, string});
        super.addManagedObjectMetadataProperties(properties, string);
        properties.setProperty("com.ibm.websphere.nodeOperatingSystem", "os390");
    }

    public String getServerIndexTemplateServerEntryName() {
        Tr.entry((TraceComponent)_tc, (String)"getServerIndexTemplateServerEntryName");
        return "defaultZOS";
    }
}

