/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.convertscriptcompatibility;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.ArgumentException;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.util.Hashtable;

public class ArgumentCheck {
    private static TraceComponent _tc = Tr.register((Class)ArgumentCheck.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    private static String _lineSeparator = System.getProperty("line.separator");
    public static final String BACKUP = "-backupConfig";
    public static final String HELP = "-help";
    public static final String NODENAME = "-nodeName";
    public static final String PROFILE = "-profileName";
    public static final String SERVERNAME = "-serverName";
    public static final String TRACEFILE = "-traceFile";
    public static final String TRACESTRING = "-traceString";

    public static Hashtable verifyArguments(String[] stringArray) throws UpgradeException {
        String string;
        Tr.entry((TraceComponent)_tc, (String)"verifyArguments", (Object)new Object[]{stringArray});
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray2 = new String[]{BACKUP, HELP, PROFILE, NODENAME, SERVERNAME, TRACEFILE, TRACESTRING};
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (UpgradeBase.isInvalidKey(stringArray2, string)) {
                throw new ArgumentException(LoggerImpl.get_nls().getFormattedMessage("advise.cmd.line.illegal", new Object[]{string}, "Illegal Argument Specified: {0}"), null, true);
            }
            if (string.equals(HELP)) {
                hashtable.put(string, "true");
                Tr.debug((TraceComponent)_tc, (String)("Parameter:" + string + " value: " + "true"));
                ++n;
                continue;
            }
            if (n + 1 < stringArray.length) {
                String string2 = stringArray[n + 1];
                if (string.equals(BACKUP) && !(string2 = string2.toLowerCase()).equals("true") && !string2.equals("false")) {
                    throw new ArgumentException(LoggerImpl.get_nls().getFormattedMessage("advise.invalid.value", new Object[]{BACKUP, string2}, "Invalid value specified for {0}: {1}."), null, true);
                }
                hashtable.put(string, string2);
                Tr.debug((TraceComponent)_tc, (String)("Parameter:" + string + " value: " + string2));
                n += 2;
                continue;
            }
            throw new ArgumentException(LoggerImpl.get_nls().getString("advise.cmd.line.illegal.number.arg", "There must be an even number of optional parameters."), null, true);
        }
        string = (String)hashtable.get(BACKUP);
        if (string == null) {
            hashtable.put(BACKUP, "true");
        }
        return hashtable;
    }
}

