/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.convertscriptcompatibility;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.convertscriptcompatibility.ArgumentCheck;
import com.ibm.ws.migration.convertscriptcompatibility.TransformBaseConfiguration;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.document.CellDocumentCollectionImpl;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionHelper;
import com.ibm.ws.migration.document.FileDocumentCollection;
import com.ibm.ws.migration.document.NodeDocumentCollectionImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionImpl;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.transform.TransactionalDocumentTransform;
import java.io.File;
import java.util.Vector;

public class ConvertScriptCompatibility
extends UpgradeBase {
    private static TraceComponent _tc = Tr.register((Class)ConvertScriptCompatibility.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static String _nodeName = null;
    protected static String _serverName = null;

    static String getNodeName() {
        Tr.entry((TraceComponent)_tc, (String)"getNodeName", (Object)_nodeName);
        return _nodeName;
    }

    static String getServerName() {
        Tr.entry((TraceComponent)_tc, (String)"getServerName", (Object)_serverName);
        return _serverName;
    }

    public ConvertScriptCompatibility() {
    }

    public ConvertScriptCompatibility(String[] stringArray) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"ConvertScriptCompatibility", (Object)stringArray);
        UpgradeBase._cmdLineArgs = ArgumentCheck.verifyArguments(stringArray);
        WASPostUpgrade.set_scriptCompatibility(false);
        WASPostUpgrade.set_wasPostUpgrade(false);
        this.setupTrace("ConvertScriptCompatibility");
    }

    private BasicDocumentCollection createConfigDocumentCollection(boolean bl, File file, File file2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createConfigDocumentCollection", (Object)new Object[]{new Boolean(bl), file});
        String string = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
        BasicDocumentCollection basicDocumentCollection = null;
        if (bl) {
            BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(false, true, BasicDocumentCollection.class, ConfigRepositoryDocumentCollectionHelper.class);
            basicDocumentCollection = new BasicDocumentCollection(string, null, descriptor, file.toURL(), file2.toURL());
            BasicDocumentCollection.Descriptor descriptor2 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor.setChildDescriptor("cells", descriptor2);
            BasicDocumentCollection.Descriptor descriptor3 = new BasicDocumentCollection.Descriptor(descriptor, CellDocumentCollectionPostImpl.class);
            descriptor2.setDefaultChildDescriptor(descriptor3);
            BasicDocumentCollection.Descriptor descriptor4 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor3.setDefaultChildDescriptor(descriptor4);
            BasicDocumentCollection.Descriptor descriptor5 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor3.setChildDescriptor("applications", descriptor5);
            BasicDocumentCollection.Descriptor descriptor6 = new BasicDocumentCollection.Descriptor(true, false, BasicDocumentCollection.class, ConfigRepositoryDocumentCollectionHelper.class);
            descriptor.setChildDescriptor("templates", descriptor6);
            descriptor.setChildDescriptor("temp", descriptor6);
            descriptor.setChildDescriptor("backup", descriptor6);
            descriptor.setChildDescriptor(".repository", descriptor6);
            BasicDocumentCollection.Descriptor descriptor7 = new BasicDocumentCollection.Descriptor(descriptor, NodeDocumentCollectionImpl.class);
            descriptor4.setDefaultChildDescriptor(descriptor7);
            BasicDocumentCollection.Descriptor descriptor8 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor7.setDefaultChildDescriptor(descriptor8);
            BasicDocumentCollection.Descriptor descriptor9 = new BasicDocumentCollection.Descriptor(descriptor, ServerDocumentCollectionImpl.class);
            descriptor8.setDefaultChildDescriptor(descriptor9);
        } else {
            BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(false, true, BasicDocumentCollection.class, FileDocumentCollection.class);
            basicDocumentCollection = new BasicDocumentCollection(string, null, descriptor, file.toURL(), file2.toURL());
            BasicDocumentCollection.Descriptor descriptor10 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor.setChildDescriptor("cells", descriptor10);
            BasicDocumentCollection.Descriptor descriptor11 = new BasicDocumentCollection.Descriptor(descriptor, CellDocumentCollectionImpl.class);
            descriptor10.setDefaultChildDescriptor(descriptor11);
            BasicDocumentCollection.Descriptor descriptor12 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor11.setDefaultChildDescriptor(descriptor12);
            descriptor.setChildDescriptor("templates", BasicDocumentCollection.HIDE_CHILD);
            descriptor.setChildDescriptor("temp", BasicDocumentCollection.HIDE_CHILD);
            descriptor.setChildDescriptor("backup", BasicDocumentCollection.HIDE_CHILD);
            descriptor.setChildDescriptor(".repository", BasicDocumentCollection.HIDE_CHILD);
            BasicDocumentCollection.Descriptor descriptor13 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor11.setChildDescriptor("applications", descriptor13);
            BasicDocumentCollection.Descriptor descriptor14 = new BasicDocumentCollection.Descriptor(descriptor, NodeDocumentCollectionImpl.class);
            descriptor12.setDefaultChildDescriptor(descriptor14);
            BasicDocumentCollection.Descriptor descriptor15 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor14.setDefaultChildDescriptor(descriptor15);
            BasicDocumentCollection.Descriptor descriptor16 = new BasicDocumentCollection.Descriptor(descriptor, ServerDocumentCollectionImpl.class);
            descriptor15.setDefaultChildDescriptor(descriptor16);
        }
        return basicDocumentCollection;
    }

    protected void initialize() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"initialize");
        String string = System.getProperty("com.ibm.websphere.migration.serverRoot");
        File file = null;
        if (string != null) {
            file = new File(string);
        }
        Tr.debug((TraceComponent)_tc, (String)("com.ibm.websphere.migration.serverRoot " + file));
        UpgradeBase._oldOSInfo = UpgradeBase._newOSInfo = OSInfoFactory.createOSInfo(file, null);
        UpgradeBase._currentRelease = UpgradeBase._newOSInfo.releaseVersion();
        UpgradeBase._installRoot = UpgradeBase._newOSInfo.installRoot();
        this._newProfileName = (String)UpgradeBase._cmdLineArgs.get("-profileName");
        this.checkNewProfile();
        System.setProperty("was.install.root", UpgradeBase._newOSInfo.installRoot().getAbsolutePath());
        System.setProperty("user.install.root", UpgradeBase._newOSInfo.userRoot().getAbsolutePath());
        System.setProperty("was.repository.root", UpgradeBase._newOSInfo.configRoot().getAbsolutePath());
        UpgradeBase._userRoot = UpgradeBase._newOSInfo.userRoot();
        WASPostUpgrade.set_configRoot(UpgradeBase._newOSInfo.configRoot());
    }

    protected void backupConfig(Configuration configuration) {
        Tr.entry((TraceComponent)_tc, (String)"backupConfig", (Object)configuration);
        configuration.backupConfig();
    }

    protected boolean doIt() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"doIt");
        String string = (String)UpgradeBase._cmdLineArgs.get("-help");
        if (string != null) {
            ConvertScriptCompatibility.displayOutput(ConvertScriptCompatibility.retrieveUsage());
            return false;
        }
        this._newProfileName = (String)UpgradeBase._cmdLineArgs.get("-profileName");
        _nodeName = (String)UpgradeBase._cmdLineArgs.get("-nodeName");
        _serverName = (String)UpgradeBase._cmdLineArgs.get("-serverName");
        Configuration configuration = new Configuration(WASPostUpgrade.get_configRoot(), Configuration.NO_CELLNAME, Configuration.NO_NODENAME, false, UpgradeBase._currentRelease, false, false);
        if (configuration.isFederatedNode()) {
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.already.federated", new Object[0], "This node has already been federated into a cell manager configuration."), null, false);
        }
        String string2 = (String)UpgradeBase._cmdLineArgs.get("-backupConfig");
        if (string2 != null && string2.equals("true")) {
            this.backupConfig(configuration);
        }
        boolean bl = false;
        try {
            configuration.resolveSpecificNodeType("DEPLOYMENT_MANAGER");
            bl = true;
        }
        catch (UpgradeException upgradeException) {
            bl = false;
        }
        if (bl) {
            Tr.debug((TraceComponent)_tc, (String)"Configuration is DeploymentManager");
            if (_serverName != null && _nodeName == null) {
                throw new UpgradeException(LoggerImpl.get_nls().getString("advise.servername.parameter.not.allowed", "The -nodeName parameter must also be provided if the -serverName parameter is provided for this profile type."), null, false);
            }
            this.migrate();
        } else {
            this.migrate();
        }
        return true;
    }

    protected void migrate() throws Exception {
        File file = new File(UpgradeBase._newOSInfo.userRoot(), "config");
        BasicDocumentCollection basicDocumentCollection = this.createConfigDocumentCollection(false, file, file);
        BasicDocumentCollection basicDocumentCollection2 = this.createConfigDocumentCollection(true, file, file);
        basicDocumentCollection2.setPeer(basicDocumentCollection);
        basicDocumentCollection.setPeer(basicDocumentCollection2);
        Vector vector = new Vector();
        new TransformBaseConfiguration().populateConfigTransform(vector, basicDocumentCollection, basicDocumentCollection2);
        TransactionalDocumentTransform transactionalDocumentTransform = (TransactionalDocumentTransform)vector.get(0);
        transactionalDocumentTransform.migrate();
        transactionalDocumentTransform.save();
    }

    protected void convert() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"convert");
        this.initialize();
        UpgradeBase._logger = new LoggerImpl(new File(UpgradeBase._userRoot, "logs"), "convertScriptCompatibility.log");
        boolean bl = this.doIt();
        if (bl) {
            String string = null;
            string = LoggerImpl.loggedError() ? LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "Completed with errors.") : (LoggerImpl.loggedWarning() ? LoggerImpl.get_nls().getString("advise.logging.completed.with.warnings", "Completed with warnings.") : LoggerImpl.get_nls().getString("advise.logging.completed", "Completed successfully."));
            UpgradeBase._logger.println(string);
        }
    }

    private static String retrieveUsage() {
        Tr.entry((TraceComponent)_tc, (String)"retrieveUsage");
        String string = LoggerImpl.get_nls().getString("convert.usage.line1", "convertScriptCompatibility");
        String string2 = "\t" + LoggerImpl.get_nls().getString("convert.usage.line2", "[-help]");
        String string3 = "\t" + LoggerImpl.get_nls().getString("usage.post.line10", "[-backupConfig < true | false >]");
        String string4 = "\t" + LoggerImpl.get_nls().getString("convert.usage.line3", "[-profileName <profile name>]");
        String string5 = "\t" + LoggerImpl.get_nls().getString("convert.usage.line4", "[-nodeName <node name to convert> [-serverName <server name to convert> ]]");
        String string6 = "\t" + LoggerImpl.get_nls().getString("convert.usage.line5", "[-traceString <trace spec> [-traceFile <traceFile>]]");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(_lineSeparator).append(string2).append(_lineSeparator).append(string3).append(_lineSeparator).append(string4).append(_lineSeparator).append(string5).append(_lineSeparator).append(string6).append(_lineSeparator);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 99;
        boolean bl = false;
        try {
            ConvertScriptCompatibility.copyright("Product Upgrade script compatibility conversion tool, Version 1.0");
            object = new ConvertScriptCompatibility(stringArray);
            ((ConvertScriptCompatibility)object).convert();
            System.exit(0);
        }
        catch (UpgradeException upgradeException) {
            bl = ConvertScriptCompatibility.handleException(upgradeException);
            if (upgradeException.shouldDisplayHelp()) {
                ConvertScriptCompatibility.displayOutput(ConvertScriptCompatibility.retrieveUsage());
            }
        }
        catch (Exception exception) {
            ConvertScriptCompatibility.handleException(exception);
            bl = true;
        }
        object = null;
        object = LoggerImpl.loggedError() || bl ? LoggerImpl.get_nls().getString("advise.logging.completed.with.failures", "Unable to complete the command.") : LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "Completed with errors.");
        ConvertScriptCompatibility.displayOutput((String)object);
        System.exit(n);
    }
}

