/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.convertscriptcompatibility;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.convertscriptcompatibility.ConvertScriptCompatibility;
import com.ibm.ws.migration.convertscriptcompatibility.ServerConfig;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.document.CellDocumentCollectionImpl;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.CellsDocumentCollectionImpl;
import com.ibm.ws.migration.document.ConfigDocumentCollectionFederatedPostImpl;
import com.ibm.ws.migration.document.ConfigDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionFederatedHelper;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionHelper;
import com.ibm.ws.migration.document.FileDocumentCollection;
import com.ibm.ws.migration.document.NodeDocumentCollectionDmgrPostImpl;
import com.ibm.ws.migration.document.NodeDocumentCollectionImpl;
import com.ibm.ws.migration.document.NodesDocumentCollectionDmgrPostImpl;
import com.ibm.ws.migration.document.NodesDocumentCollectionImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionDmgrPostImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionFederatedPostImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionPostImpl;
import com.ibm.ws.migration.postupgrade.common.CellConfig;
import com.ibm.ws.migration.postupgrade.common.SecurityConfig;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProductImageImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.ScenarioImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMTransformMapping;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.transform.TransactionalDocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.util.Properties;
import java.util.Vector;

public class TransformBaseConfiguration {
    private static TraceComponent _tc = Tr.register((Class)TransformBaseConfiguration.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected Configuration _oldConfiguration = null;
    protected Configuration _newConfiguration = null;
    protected static final WCCMTransformMapping SERVER_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("server.xml"), ServerConfig.class);
    protected static final WCCMTransformMapping CELL_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("cell.xml"), CellConfig.class);
    protected static final WCCMTransformMapping SECURITY_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("security.xml"), SecurityConfig.class);

    public void populateConfigTransform(Vector vector, DocumentCollection documentCollection, DocumentCollection documentCollection2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"populateconfigTransform", (Object)new Object[]{vector, documentCollection, documentCollection2});
        Scenario scenario = this.populateScenario();
        TransactionalDocumentTransform transactionalDocumentTransform = new TransactionalDocumentTransform(scenario, documentCollection, documentCollection2, null);
        vector.add(transactionalDocumentTransform);
        DocumentTransform documentTransform = (DocumentTransform)transactionalDocumentTransform.getChild("cells").getChildren().get(0);
        documentTransform.getTransformMappings().add(CELL_FILE_MAPPING);
        documentTransform.getTransformMappings().add(SECURITY_FILE_MAPPING);
        Vector vector2 = ((DocumentTransform)transactionalDocumentTransform.getChild("cells").getChildren().get(0)).getChild("nodes").getChildren();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector2.size(); ++i) {
            Object object;
            DocumentTransform documentTransform2 = (DocumentTransform)vector2.get(i);
            if (ConvertScriptCompatibility.getNodeName() != null && !documentTransform2.getName().equals(ConvertScriptCompatibility.getNodeName())) continue;
            if (!this.isLatestRelease(documentTransform.getName(), documentTransform2.getName())) {
                object = LoggerImpl.get_nls().getFormattedMessage("advise.node.already.exists.convert", new Object[]{documentTransform2.getName()}, "Node name {0} does not exist in the configuration at the current WebSphere Application Server version level. It will not be updated.");
                UpgradeBase.get_logger().println((String)object);
                throw new Exception((String)object);
            }
            try {
                object = documentTransform2.getChild("servers").getChildren();
                bl = true;
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    DocumentTransform documentTransform3 = (DocumentTransform)((Vector)object).get(j);
                    if (ConvertScriptCompatibility.getServerName() != null && !documentTransform3.getName().equals(ConvertScriptCompatibility.getServerName())) continue;
                    bl2 = true;
                    documentTransform3.getTransformMappings().add(SERVER_FILE_MAPPING);
                    documentTransform3.getTransformMappings().add(SECURITY_FILE_MAPPING);
                }
                continue;
            }
            catch (NotFoundException notFoundException) {
                Tr.event((TraceComponent)_tc, (String)"Cannot locate server information to populate transform for: ", (Object)new Object[]{documentTransform2.getName(), notFoundException});
            }
        }
        if (!bl) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.node.server.not.found.convertscriptcompatibility", new Object[]{"Node", ConvertScriptCompatibility.getNodeName()}, "{0} {1} does not exist, will not continue.");
            UpgradeBase.get_logger().println(string);
            throw new Exception(string);
        }
        if (!bl2) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.node.server.not.found.convertscriptcompatibility", new Object[]{"Server", ConvertScriptCompatibility.getServerName()}, "{0} {1} does not exist, will not continue.");
            UpgradeBase.get_logger().println(string);
            throw new Exception(string);
        }
    }

    protected boolean isLatestRelease(String string, String string2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isLatestRelease", (Object)new Object[]{string, string2});
        String string3 = null;
        String string4 = null;
        try {
            Properties properties = new Properties();
            properties.put("local.cell", string);
            ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor((Properties)properties);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
            string3 = managedObjectMetadataHelper.getNodeMajorVersion(string2);
            string4 = managedObjectMetadataHelper.getNodeMinorVersion(string2);
            Tr.debug((TraceComponent)_tc, (String)("Major version for nodename: " + string2 + "is: " + string3));
            Tr.debug((TraceComponent)_tc, (String)("Minor version for nodename: " + string2 + "is: " + string4));
        }
        catch (AdminException adminException) {
            throw new Exception(adminException);
        }
        return string3.equals("6") && string4.equals("1");
    }

    protected Scenario populateScenario() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"populateScenario");
        ScenarioImpl scenarioImpl = null;
        try {
            File file = UpgradeBase.get_newOSInfo().installRoot();
            File file2 = UpgradeBase.get_newOSInfo().installRoot();
            File file3 = UpgradeBase.get_newOSInfo().userRoot();
            File file4 = UpgradeBase.get_newOSInfo().userRoot();
            this._oldConfiguration = new Configuration(new File(file3, "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
            this._newConfiguration = new Configuration(new File(file4, "config"), null, null, false, UpgradeBase.get_newOSInfo().releaseVersion(), false, true);
            String string = this._oldConfiguration.getOwningNodeName();
            File file5 = new File(this._oldConfiguration.getNodeVariables().getProperty("WAS_INSTALL_ROOT"));
            File file6 = new File(this._oldConfiguration.resolveEntryPath(this._oldConfiguration.getNodeVariables().getProperty("USER_INSTALL_ROOT")));
            BasicDocumentCollection basicDocumentCollection = this.createProfileDocumentCollection(false, file6, file3);
            BasicDocumentCollection basicDocumentCollection2 = this.createProfileDocumentCollection(true, file4, file4);
            basicDocumentCollection2.setPeer(basicDocumentCollection);
            basicDocumentCollection.setPeer(basicDocumentCollection2);
            ProfileImpl profileImpl = new ProfileImpl(basicDocumentCollection, this._oldConfiguration.getOwningNodeName(), this._oldConfiguration.isDeploymentManagerConfiguration(), this._oldConfiguration.isFederatedNode(), file3, UpgradeBase.get_oldOSInfo());
            ProfileImpl profileImpl2 = new ProfileImpl(basicDocumentCollection2, this._newConfiguration.getOwningNodeName(), this._newConfiguration.isDeploymentManagerConfiguration(), this._newConfiguration.isFederatedNode(), file4, UpgradeBase.get_newOSInfo());
            ReleaseVersion releaseVersion = UpgradeBase.get_oldOSInfo().releaseVersion();
            ReleaseVersion releaseVersion2 = UpgradeBase.get_newOSInfo().releaseVersion();
            boolean bl = false;
            if (releaseVersion.isR61()) {
                bl = true;
            }
            boolean bl2 = false;
            if (releaseVersion2.isR61()) {
                bl2 = true;
            }
            String string2 = this.getVersion(releaseVersion);
            String string3 = this.getVersion(releaseVersion2);
            ReleaseVersionImpl releaseVersionImpl = new ReleaseVersionImpl(false, bl, string2, releaseVersion);
            ReleaseVersionImpl releaseVersionImpl2 = new ReleaseVersionImpl(true, bl2, string3, releaseVersion2);
            ProductImageImpl productImageImpl = new ProductImageImpl(file5, file, profileImpl, releaseVersionImpl, UpgradeBase.get_oldOSInfo());
            ProductImageImpl productImageImpl2 = new ProductImageImpl(file2, file2, profileImpl2, releaseVersionImpl2, UpgradeBase.get_newOSInfo());
            scenarioImpl = new ScenarioImpl(file5.toURL(), productImageImpl, productImageImpl2, UpgradeBase.get_logger());
            basicDocumentCollection.setScenario(scenarioImpl);
            basicDocumentCollection2.setScenario(scenarioImpl);
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
        return scenarioImpl;
    }

    private BasicDocumentCollection createProfileDocumentCollection(boolean bl, File file, File file2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createProfileDocumentCollection", (Object)new Object[]{new Boolean(bl), file, file2});
        String string = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
        BasicDocumentCollection basicDocumentCollection = null;
        if (bl) {
            BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(false, true, BasicDocumentCollection.class, FileDocumentCollection.class);
            basicDocumentCollection = new BasicDocumentCollection(string, null, descriptor, file.toURL(), file2.toURL());
            BasicDocumentCollection.Descriptor descriptor2 = null;
            if (this._oldConfiguration.isFederatedNode()) {
                descriptor2 = new BasicDocumentCollection.Descriptor(descriptor, ConfigDocumentCollectionFederatedPostImpl.class, ConfigRepositoryDocumentCollectionFederatedHelper.class);
                descriptor.setChildDescriptor("config", descriptor2);
            } else {
                descriptor2 = new BasicDocumentCollection.Descriptor(descriptor, ConfigDocumentCollectionPostImpl.class, ConfigRepositoryDocumentCollectionHelper.class);
                descriptor.setChildDescriptor("config", descriptor2);
            }
            BasicDocumentCollection.Descriptor descriptor3 = new BasicDocumentCollection.Descriptor(descriptor2, CellsDocumentCollectionImpl.class);
            descriptor2.setChildDescriptor("cells", descriptor3);
            BasicDocumentCollection.Descriptor descriptor4 = new BasicDocumentCollection.Descriptor(descriptor2, CellDocumentCollectionPostImpl.class);
            descriptor3.setDefaultChildDescriptor(descriptor4);
            BasicDocumentCollection.Descriptor descriptor5 = new BasicDocumentCollection.Descriptor(descriptor2, BasicDocumentCollection.class);
            descriptor4.setDefaultChildDescriptor(descriptor5);
            BasicDocumentCollection.Descriptor descriptor6 = null;
            if (this._oldConfiguration.isDeploymentManagerConfiguration() || this._oldConfiguration.isFederatedNode()) {
                descriptor6 = new BasicDocumentCollection.Descriptor(descriptor2, NodesDocumentCollectionDmgrPostImpl.class);
                descriptor4.setChildDescriptor("nodes", descriptor6);
            } else {
                descriptor6 = new BasicDocumentCollection.Descriptor(descriptor2, NodesDocumentCollectionImpl.class);
                descriptor4.setChildDescriptor("nodes", descriptor6);
            }
            BasicDocumentCollection.Descriptor descriptor7 = new BasicDocumentCollection.Descriptor(true, false, BasicDocumentCollection.class, ConfigRepositoryDocumentCollectionHelper.class);
            descriptor2.setChildDescriptor("templates", descriptor7);
            descriptor2.setChildDescriptor("temp", descriptor7);
            descriptor2.setChildDescriptor("backup", descriptor7);
            descriptor2.setChildDescriptor(".repository", descriptor7);
            BasicDocumentCollection.Descriptor descriptor8 = null;
            if (this._oldConfiguration.isDeploymentManagerConfiguration()) {
                descriptor8 = new BasicDocumentCollection.Descriptor(descriptor2, NodeDocumentCollectionDmgrPostImpl.class);
                descriptor6.setDefaultChildDescriptor(descriptor8);
            } else {
                descriptor8 = new BasicDocumentCollection.Descriptor(descriptor2, NodeDocumentCollectionImpl.class);
                descriptor6.setDefaultChildDescriptor(descriptor8);
            }
            BasicDocumentCollection.Descriptor descriptor9 = new BasicDocumentCollection.Descriptor(descriptor2, BasicDocumentCollection.class);
            descriptor8.setDefaultChildDescriptor(descriptor9);
            if (this._oldConfiguration.isDeploymentManagerConfiguration()) {
                BasicDocumentCollection.Descriptor descriptor10 = new BasicDocumentCollection.Descriptor(descriptor2, ServerDocumentCollectionDmgrPostImpl.class);
                descriptor9.setDefaultChildDescriptor(descriptor10);
            } else if (this._oldConfiguration.isFederatedNode()) {
                BasicDocumentCollection.Descriptor descriptor11 = new BasicDocumentCollection.Descriptor(descriptor2, ServerDocumentCollectionFederatedPostImpl.class);
                descriptor9.setDefaultChildDescriptor(descriptor11);
            } else {
                BasicDocumentCollection.Descriptor descriptor12 = new BasicDocumentCollection.Descriptor(descriptor2, ServerDocumentCollectionPostImpl.class);
                descriptor9.setDefaultChildDescriptor(descriptor12);
            }
        } else {
            BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(true, false, BasicDocumentCollection.class, FileDocumentCollection.class);
            basicDocumentCollection = new BasicDocumentCollection(string, null, descriptor, file.toURL(), file2.toURL());
            BasicDocumentCollection.Descriptor descriptor13 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor.setChildDescriptor("config", descriptor13);
            BasicDocumentCollection.Descriptor descriptor14 = new BasicDocumentCollection.Descriptor(descriptor, CellsDocumentCollectionImpl.class);
            descriptor13.setChildDescriptor("cells", descriptor14);
            BasicDocumentCollection.Descriptor descriptor15 = new BasicDocumentCollection.Descriptor(descriptor, CellDocumentCollectionImpl.class);
            descriptor14.setDefaultChildDescriptor(descriptor15);
            BasicDocumentCollection.Descriptor descriptor16 = new BasicDocumentCollection.Descriptor(descriptor13, BasicDocumentCollection.class);
            descriptor15.setDefaultChildDescriptor(descriptor16);
            BasicDocumentCollection.Descriptor descriptor17 = null;
            if (this._oldConfiguration.isDeploymentManagerConfiguration() || this._oldConfiguration.isFederatedNode()) {
                descriptor17 = new BasicDocumentCollection.Descriptor(descriptor13, NodesDocumentCollectionDmgrPostImpl.class);
                descriptor15.setChildDescriptor("nodes", descriptor17);
            } else {
                descriptor17 = new BasicDocumentCollection.Descriptor(descriptor13, NodesDocumentCollectionImpl.class);
                descriptor15.setChildDescriptor("nodes", descriptor17);
            }
            descriptor13.setChildDescriptor("templates", BasicDocumentCollection.HIDE_CHILD);
            descriptor13.setChildDescriptor("temp", BasicDocumentCollection.HIDE_CHILD);
            descriptor13.setChildDescriptor("backup", BasicDocumentCollection.HIDE_CHILD);
            descriptor13.setChildDescriptor(".repository", BasicDocumentCollection.HIDE_CHILD);
            BasicDocumentCollection.Descriptor descriptor18 = new BasicDocumentCollection.Descriptor(descriptor, NodeDocumentCollectionImpl.class);
            descriptor17.setDefaultChildDescriptor(descriptor18);
            BasicDocumentCollection.Descriptor descriptor19 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor18.setDefaultChildDescriptor(descriptor19);
            BasicDocumentCollection.Descriptor descriptor20 = new BasicDocumentCollection.Descriptor(descriptor, ServerDocumentCollectionImpl.class);
            descriptor19.setDefaultChildDescriptor(descriptor20);
        }
        return basicDocumentCollection;
    }

    private String getVersion(ReleaseVersion releaseVersion) {
        Tr.entry((TraceComponent)_tc, (String)"getVersion", (Object)releaseVersion);
        String string = null;
        if (releaseVersion.isBase()) {
            string = "BASE";
        } else if (releaseVersion.isClient()) {
            string = "CLIENT";
        } else if (releaseVersion.isExpressServerProductInstalled("embeddedEXPRESS")) {
            string = "embeddedEXPRESS";
        } else if (releaseVersion.isExpressServerProductInstalled("EXPRESS")) {
            string = "EXPRESS";
        } else if (releaseVersion.areExtendedServerProductsInstalled() && releaseVersion.installedExtendedServerProducts().contains("ND")) {
            string = "ND";
        }
        return string;
    }
}

