/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.DocumentCollectionHelper;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransactionalDocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.AlreadyExistsException;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.exceptions.ReadOnlyException;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BasicDocumentCollection
implements TransactionalDocumentCollection {
    private static TraceComponent _tc = Tr.register((Class)BasicDocumentCollection.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final Descriptor HIDE_CHILD = new Descriptor(false, false, null, null);
    protected DocumentCollection _parent;
    protected String _name;
    protected String[] _hierarchicalName;
    protected Descriptor _descriptor;
    protected boolean _saveCompletedSuccessfully = false;
    protected boolean _unsavedChanges = false;
    protected URL _url;
    protected URL _aliasedUrl;
    protected DocumentCollectionHelper _helper;
    protected DocumentCollection _peer;
    protected Scenario _scenario;
    protected Vector _children;
    protected Hashtable _openDocuments;

    public BasicDocumentCollection(String string, DocumentCollection documentCollection, Descriptor descriptor, URL uRL) throws Exception {
        this(string, documentCollection, descriptor, uRL, null);
    }

    public BasicDocumentCollection(String string, DocumentCollection documentCollection, Descriptor descriptor, URL uRL, URL uRL2) throws Exception {
        this._name = string;
        this._parent = documentCollection;
        this._descriptor = descriptor;
        this._url = new File(uRL.getFile()).getCanonicalFile().toURL();
        this._aliasedUrl = uRL2;
        this._helper = this.instantiateCollectionHelper(this._descriptor);
    }

    public Descriptor getDescriptor() {
        Tr.entry((TraceComponent)_tc, (String)"getDescriptor");
        return this._descriptor;
    }

    public DocumentCollection getPeer() throws NotFoundException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getPeer");
        if (this._peer == null) {
            if (this._parent == null) {
                throw new NotFoundException(this.getUrl().getFile());
            }
            DocumentCollection documentCollection = ((BasicDocumentCollection)this._parent).getPeer();
            return documentCollection.getPeerDocumentCollection(this);
        }
        return this._peer;
    }

    public void setPeer(DocumentCollection documentCollection) {
        Tr.entry((TraceComponent)_tc, (String)"setPeer", (Object)documentCollection);
        this._peer = documentCollection;
    }

    public String[] getDocumentNames() {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentNames");
        Object[] objectArray = this._helper.getChildNames(true, false);
        if (this._openDocuments != null && this._openDocuments.size() > 0) {
            int n;
            Vector<String> vector = new Vector<String>(objectArray.length);
            for (n = 0; n < objectArray.length; ++n) {
                vector.addElement(objectArray[n]);
            }
            n = 0;
            Enumeration enumeration = this._openDocuments.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (vector.contains(string)) continue;
                vector.addElement(string);
                n = 1;
            }
            if (n != 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public boolean documentExists(String string) {
        Tr.entry((TraceComponent)_tc, (String)"documentExists", (Object)string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = this.getDocumentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public DocumentCollection[] getChildren() throws Exception {
        Object[] objectArray;
        Tr.entry((TraceComponent)_tc, (String)"getChildren");
        if (this._children == null) {
            objectArray = this._helper.getChildNames(false, true);
            this._children = new Vector(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                DocumentCollection documentCollection = this.createChildCollection((String)objectArray[i], false);
                if (documentCollection == null) continue;
                this._children.addElement(documentCollection);
            }
        }
        objectArray = new DocumentCollection[this._children.size()];
        this._children.copyInto(objectArray);
        return objectArray;
    }

    public DocumentCollection getChild(String string) throws NotFoundException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getChild", (Object)string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        DocumentCollection documentCollection = null;
        DocumentCollection[] documentCollectionArray = this.getChildren();
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            DocumentCollection documentCollection2 = documentCollectionArray[i];
            if (!string.equals(documentCollection2.getName())) continue;
            documentCollection = documentCollection2;
            break;
        }
        if (documentCollection == null) {
            throw new NotFoundException(string);
        }
        return documentCollection;
    }

    public URL getUrl() {
        Tr.entry((TraceComponent)_tc, (String)"getUrl");
        return this._url;
    }

    public URL getAbsoluteUrl() {
        Tr.entry((TraceComponent)_tc, (String)"getAbsoluteUrl");
        return this._aliasedUrl;
    }

    public URL getAliasUrl() {
        Tr.entry((TraceComponent)_tc, (String)"getAliasUrl");
        return this._url;
    }

    public URL getAliasedUrl() {
        Tr.entry((TraceComponent)_tc, (String)"getAliasedUrl");
        return this._aliasedUrl;
    }

    public boolean contains(URL uRL) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"contains", (Object)uRL);
        uRL = new File(uRL.getFile()).getCanonicalFile().toURL();
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        if (uRL.getProtocol().equals(this._url.getProtocol()) || this._aliasedUrl != null && uRL.getProtocol().equals(this._aliasedUrl.getProtocol())) {
            return this._helper.contains(uRL);
        }
        DocumentCollection[] documentCollectionArray = this.getChildren();
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            DocumentCollection documentCollection = documentCollectionArray[i];
            if (!documentCollection.contains(uRL)) continue;
            return true;
        }
        return false;
    }

    public DocumentCollection getDocumentCollection(URL uRL) throws NotFoundException, Exception {
        DocumentCollection documentCollection;
        block10: {
            Tr.entry((TraceComponent)_tc, (String)"getDocumentCollection", (Object)uRL);
            uRL = new File(uRL.getFile()).getCanonicalFile().toURL();
            if (uRL == null) {
                throw new IllegalArgumentException();
            }
            documentCollection = null;
            if (this.getUrl().equals(uRL) || this._aliasedUrl != null && this._aliasedUrl.equals(uRL)) {
                return this;
            }
            if (this.contains(uRL)) {
                DocumentCollection[] documentCollectionArray = this.getChildren();
                for (int i = 0; i < documentCollectionArray.length; ++i) {
                    DocumentCollection documentCollection2 = documentCollectionArray[i];
                    if (documentCollection2.getUrl().equals(uRL) || documentCollection2.getAbsoluteUrl() != null && documentCollection2.getAbsoluteUrl().equals(uRL)) {
                        return documentCollection2;
                    }
                    if (!documentCollection2.contains(uRL)) continue;
                    return documentCollection2.getDocumentCollection(uRL);
                }
                documentCollection = this;
            } else {
                DocumentCollection documentCollection3 = this;
                try {
                    while (true) {
                        documentCollection3 = documentCollection3.getParent();
                    }
                }
                catch (NotFoundException notFoundException) {
                    if (documentCollection3 == this) break block10;
                    documentCollection = documentCollection3.getDocumentCollection(uRL);
                }
            }
        }
        if (documentCollection == null) {
            throw new NotFoundException(uRL.getFile());
        }
        return documentCollection;
    }

    public Document openDocument(String string, Class clazz) throws NotFoundException, IOException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"openDocument", (Object)new Object[]{string, clazz});
        try {
            return this.openDocument(string, clazz, false, true);
        }
        catch (ReadOnlyException readOnlyException) {
            IOException iOException = new IOException();
            iOException.initCause(readOnlyException);
            throw iOException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document openDocument(String string, Class clazz, boolean bl, boolean bl2) throws IOException, NotFoundException, ReadOnlyException, Exception {
        Object v;
        Tr.entry((TraceComponent)_tc, (String)"openDocument", (Object)new Object[]{string, clazz, new Boolean(bl), new Boolean(bl2)});
        if (string == null || clazz == null) {
            throw new IllegalArgumentException();
        }
        if (this._descriptor.isReadOnly() && (bl || !bl2)) {
            throw new ReadOnlyException(this.getUrl().getFile());
        }
        if (this._openDocuments == null) {
            this._openDocuments = new Hashtable();
        }
        if ((v = this._openDocuments.get(string)) != null) {
            Object object;
            if (v instanceof Document) {
                object = (Document)v;
                if (!object.isClosed()) throw new IOException(v.toString());
                this._helper.setDocumentContents((Document)object);
                this._openDocuments.remove(string);
            } else {
                object = (Vector)v;
                this.cleanupReaderList((Vector)object);
                if (!bl2) {
                    if (((Vector)object).size() != 0) throw new IOException(v.toString());
                    this._openDocuments.remove(string);
                }
            }
        }
        if (!bl && !this.documentExists(string)) {
            throw new NotFoundException(string);
        }
        boolean bl3 = this.documentExists(string);
        Document document = this.instantiateDocument(string, clazz);
        if (!this._descriptor.isReadOnly()) {
            v = this._openDocuments.get(string);
            if (v == null) {
                if (bl2) {
                    Vector<Document> vector = new Vector<Document>();
                    vector.addElement(document);
                    this._openDocuments.put(string, vector);
                } else {
                    this._openDocuments.put(string, document);
                }
            } else if (bl2) {
                Vector vector = (Vector)v;
                vector.addElement(document);
                this._openDocuments.put(string, vector);
            } else {
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", null, "An unexpected internal error occurred, exception {0}.");
                UpgradeBase.get_logger().println(string2);
                throw new Exception(string2);
            }
        }
        if (bl3) {
            document.setInputStream(this._helper.getDocumentContents(string, bl2));
        }
        if (bl2) return document;
        this._unsavedChanges = true;
        return document;
    }

    public DocumentCollection getParent() throws NotFoundException {
        Tr.entry((TraceComponent)_tc, (String)"getParent");
        if (this._parent == null) {
            throw new NotFoundException(this.getUrl().getFile());
        }
        return this._parent;
    }

    public Scenario getScenario() {
        Tr.entry((TraceComponent)_tc, (String)"getScenario");
        return this._scenario;
    }

    public void setScenario(Scenario scenario) {
        Tr.entry((TraceComponent)_tc, (String)"setScenario", (Object)scenario);
        this._scenario = scenario;
    }

    public String getName() {
        Tr.entry((TraceComponent)_tc, (String)"getName");
        return this._name;
    }

    public String[] getHierarchicalName() {
        Tr.entry((TraceComponent)_tc, (String)"getHierachicalName");
        if (this._hierarchicalName == null) {
            if (this._parent == null) {
                this._hierarchicalName = new String[]{this.getName()};
            } else {
                String[] stringArray = this._parent.getHierarchicalName();
                this._hierarchicalName = new String[stringArray.length + 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    this._hierarchicalName[i] = stringArray[i];
                }
                this._hierarchicalName[stringArray.length] = this.getName();
            }
        }
        return this._hierarchicalName;
    }

    public void save() throws Exception {
        DocumentCollection[] documentCollectionArray;
        Tr.entry((TraceComponent)_tc, (String)"save");
        if (this._openDocuments != null) {
            documentCollectionArray = this._openDocuments.keys();
            while (documentCollectionArray.hasMoreElements()) {
                Object object;
                String string = (String)documentCollectionArray.nextElement();
                Object v = this._openDocuments.get(string);
                if (v instanceof Document) {
                    object = (Document)v;
                    if (!object.isClosed()) {
                        object.close();
                    }
                    this._helper.setDocumentContents((Document)object);
                    this._openDocuments.remove(string);
                    continue;
                }
                object = (Vector)v;
                this.cleanupReaderList((Vector)object);
                if (((Vector)object).size() != 0) continue;
                this._openDocuments.remove(string);
            }
        }
        try {
            if (!this._descriptor.isReadOnly() && this._unsavedChanges) {
                this._helper.save();
                this._unsavedChanges = false;
            }
            this._saveCompletedSuccessfully = true;
            if (this._children != null) {
                documentCollectionArray = this.getChildren();
                for (int i = 0; i < documentCollectionArray.length; ++i) {
                    documentCollectionArray[i].save();
                }
            }
        }
        catch (Exception exception) {
            this.rollback();
        }
    }

    public boolean saveCompletedSuccessfully() {
        Tr.entry((TraceComponent)_tc, (String)"saveCompletedSuccessfully");
        return this._saveCompletedSuccessfully;
    }

    public void rollback() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"rollback");
        if (this.saveCompletedSuccessfully()) {
            if (!this._descriptor.isReadOnly()) {
                this._helper.rollback();
            }
            this._saveCompletedSuccessfully = false;
            if (this._children != null) {
                DocumentCollection[] documentCollectionArray = this.getChildren();
                for (int i = 0; i < documentCollectionArray.length; ++i) {
                    ((TransactionalDocumentCollection)documentCollectionArray[i]).rollback();
                }
            }
        }
    }

    public DocumentCollection getPeerDocumentCollection(DocumentCollection documentCollection) throws NotFoundException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getPeerDocumentCollection", (Object)documentCollection);
        if (documentCollection == null) {
            throw new IllegalArgumentException();
        }
        return this.getChild(documentCollection.getName());
    }

    public DocumentCollection addPeerDocumentCollection(DocumentCollection documentCollection) throws Exception, ReadOnlyException {
        Tr.entry((TraceComponent)_tc, (String)"addPeerDocumentCollection", (Object)documentCollection);
        if (documentCollection == null) {
            throw new IllegalArgumentException();
        }
        return this.addDocumentCollection(documentCollection.getName());
    }

    public DocumentCollection addDocumentCollection(String string) throws IllegalArgumentException, ReadOnlyException, AlreadyExistsException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"addDocumentCollection", (Object)string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this._descriptor.isReadOnly()) {
            throw new ReadOnlyException(this.getUrl().getFile());
        }
        try {
            this.getChild(string);
            throw new AlreadyExistsException(string);
        }
        catch (NotFoundException notFoundException) {
            DocumentCollection documentCollection = this.createChildCollection(string, true);
            if (documentCollection != null) {
                this._children.addElement(documentCollection);
            }
            return documentCollection;
        }
    }

    protected Document instantiateDocument(String string, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateDocument", (Object)new Object[]{string, clazz});
        if (!Document.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        Document document = null;
        try {
            Class[] classArray = new Class[]{String.class, DocumentCollection.class};
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string, this};
            document = (Document)constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(noSuchMethodException);
            throw illegalArgumentException;
        }
        catch (InstantiationException instantiationException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(instantiationException);
            throw illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(illegalAccessException);
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (RuntimeException)throwable;
        }
        return document;
    }

    protected DocumentCollection createChildCollection(String string, boolean bl) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createChildCollection", (Object)new Object[]{string, new Boolean(bl)});
        DocumentCollection documentCollection = null;
        Descriptor descriptor = this._descriptor.getChildDescriptor(string);
        if (descriptor != HIDE_CHILD || bl) {
            documentCollection = this.instantiateChildCollection(string, descriptor);
        }
        return documentCollection;
    }

    protected DocumentCollection instantiateChildCollection(String string, Descriptor descriptor) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateChildCollection", (Object)new Object[]{string, descriptor});
        BasicDocumentCollection basicDocumentCollection = null;
        try {
            Class[] classArray = new Class[]{String.class, DocumentCollection.class, Descriptor.class, URL.class, URL.class};
            Constructor constructor = descriptor.getCollectionClass().getConstructor(classArray);
            Object[] objectArray = new Object[]{string, this, descriptor, this._helper.getChildUrl(this._url, string), this._helper.getChildUrl(this._aliasedUrl, string)};
            basicDocumentCollection = (BasicDocumentCollection)constructor.newInstance(objectArray);
            basicDocumentCollection.setScenario(this._scenario);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (RuntimeException)throwable;
        }
        return basicDocumentCollection;
    }

    protected DocumentCollectionHelper instantiateCollectionHelper(Descriptor descriptor) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateCollectionHelper", (Object)descriptor);
        DocumentCollectionHelper documentCollectionHelper = null;
        try {
            Class[] classArray = new Class[]{BasicDocumentCollection.class};
            Constructor constructor = descriptor.getHelperClass().getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            documentCollectionHelper = (DocumentCollectionHelper)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (RuntimeException)throwable;
        }
        return documentCollectionHelper;
    }

    private void cleanupReaderList(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"cleanupReaderList", (Object)vector);
        for (int i = vector.size() - 1; i >= 0; --i) {
            Document document = (Document)vector.elementAt(i);
            if (!document.isClosed()) continue;
            vector.remove(i);
        }
    }

    public static class Descriptor {
        private boolean _readOnly;
        private boolean _rollbackEnabled;
        private Class _collectionClass;
        private Class _helperClass;
        private Descriptor _defaultChildDescriptor;
        private Hashtable _childDescriptors;

        public Descriptor(boolean bl, boolean bl2, Class clazz, Class clazz2) {
            Tr.entry((TraceComponent)_tc, (String)"Descriptor", (Object)new Object[]{new Boolean(bl), new Boolean(bl2), clazz, clazz2});
            this._readOnly = bl;
            this._rollbackEnabled = bl2;
            this._collectionClass = clazz;
            this._helperClass = clazz2;
            this._defaultChildDescriptor = null;
        }

        public Descriptor(Descriptor descriptor, Class clazz, Class clazz2) {
            this(descriptor.isReadOnly(), descriptor.isRollbackEnabled(), clazz, clazz2);
        }

        public Descriptor(Descriptor descriptor, Class clazz) {
            this(descriptor, clazz, descriptor.getHelperClass());
        }

        public Descriptor(Descriptor descriptor) {
            this(descriptor, descriptor.getCollectionClass());
        }

        public boolean isReadOnly() {
            Tr.entry((TraceComponent)_tc, (String)"isReadOnly");
            return this._readOnly;
        }

        public boolean isRollbackEnabled() {
            Tr.entry((TraceComponent)_tc, (String)"isRollbackEnabled");
            return this._rollbackEnabled;
        }

        public Class getCollectionClass() {
            Tr.entry((TraceComponent)_tc, (String)"getCollectionClass");
            return this._collectionClass;
        }

        public Class getHelperClass() {
            Tr.entry((TraceComponent)_tc, (String)"getHelperClass");
            return this._helperClass;
        }

        public void setChildDescriptor(String string, Descriptor descriptor) {
            Tr.entry((TraceComponent)_tc, (String)"setChildDescriptor", (Object)new Object[]{string, descriptor});
            if (this._childDescriptors == null) {
                this._childDescriptors = new Hashtable();
            }
            this._childDescriptors.put(string, descriptor);
        }

        public Descriptor getChildDescriptor(String string) {
            Tr.entry((TraceComponent)_tc, (String)"getChildDescriptor", (Object)string);
            if (this._childDescriptors != null && this._childDescriptors.containsKey(string)) {
                return (Descriptor)this._childDescriptors.get(string);
            }
            return this.getDefaultChildDescriptor();
        }

        public void setDefaultChildDescriptor(Descriptor descriptor) {
            Tr.entry((TraceComponent)_tc, (String)"setDefaultChildDescriptor", (Object)descriptor);
            this._defaultChildDescriptor = descriptor;
        }

        public Descriptor getDefaultChildDescriptor() {
            Tr.entry((TraceComponent)_tc, (String)"getDefaultChildDescriptor");
            if (this._defaultChildDescriptor == null) {
                this._defaultChildDescriptor = new Descriptor(this);
            }
            return this._defaultChildDescriptor;
        }
    }
}

