/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.document.FileUrlDocumentCollectionHelper;
import com.ibm.ws.migration.utility.ConfigRepositoryConnectionImpl;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ConfigRepositoryDocumentCollectionHelper
extends FileUrlDocumentCollectionHelper {
    private static TraceComponent _tc = Tr.register((Class)ConfigRepositoryDocumentCollectionHelper.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static ConfigRepositoryConnectionImpl _configRepositoryConnection = null;
    protected static ConfigRepository _repository = null;
    protected ArrayList _dCSConfigExistingDocuments = new ArrayList();
    protected ArrayList _dCSConfigNewDocuments = new ArrayList();
    protected ArrayList _dConfigDeletedDocuments = new ArrayList();
    protected Hashtable _originalConfigExistingDocuments = new Hashtable();
    protected ArrayList _originalDeletedDocuments = new ArrayList();

    public ConfigRepositoryDocumentCollectionHelper(BasicDocumentCollection basicDocumentCollection) throws Exception {
        super(basicDocumentCollection);
        this.instantiateRepository();
    }

    public ConfigRepository getLocalConfigRepository() {
        Tr.entry((TraceComponent)_tc, (String)"getLocalConfigRepository");
        return _configRepositoryConnection.getLocalConfigRepository();
    }

    protected void instantiateRepository() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateRepository");
        if (_repository == null) {
            _configRepositoryConnection = new ConfigRepositoryConnectionImpl(new File(UpgradeBase.get_newOSInfo().userRoot(), "config"));
            _repository = _configRepositoryConnection.getConfigRepository();
        }
    }

    public void setDocumentContents(com.ibm.wsspi.migration.document.Document document) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"setDocumentContents", (Object)document);
        String string = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(new File(this._aliasedFile, document.getName()).getAbsolutePath());
        DocumentContentSource documentContentSource = this.getDocumentFromCache(string);
        if (documentContentSource != null) {
            documentContentSource.setSource(document.getInputStream());
        } else {
            documentContentSource = new DocumentContentSource(new Document(string), document.getInputStream());
            this._dCSConfigNewDocuments.add(documentContentSource);
        }
    }

    public InputStream getDocumentContents(String string) throws IOException, NotFoundException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentContents", (Object)string);
        return this.getDocumentContents(string, true);
    }

    public InputStream getDocumentContents(String string, boolean bl) throws IOException, NotFoundException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentContents", (Object)new Object[]{string, new Boolean(bl)});
        Object var3_3 = null;
        String string2 = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(new File(this._aliasedFile, string).getAbsolutePath());
        DocumentContentSource documentContentSource = this.getDocumentFromCache(string2);
        if (documentContentSource == null) {
            documentContentSource = _repository.extract(string2);
            this._dCSConfigExistingDocuments.add(documentContentSource);
        }
        return this.getSourceFromDocumentContentSource(documentContentSource);
    }

    protected InputStream getSourceFromDocumentContentSource(DocumentContentSource documentContentSource) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getSourceFromDocumentContentSource", (Object)documentContentSource);
        byte[] byArray = this.getStreamAsByteArray(documentContentSource.getSource());
        byte[] byArray2 = (byte[])byArray.clone();
        documentContentSource.setSource(byArray);
        return new ByteArrayInputStream(byArray2);
    }

    protected byte[] getStreamAsByteArray(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getStreamAsByteArray", (Object)inputStream);
        byte[] byArray = new byte[]{};
        Vector<Byte> vector = new Vector<Byte>();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte by = (byte)bufferedInputStream.read();
        while (by != -1) {
            vector.add(new Byte(by));
            by = (byte)bufferedInputStream.read();
        }
        byArray = new byte[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            byArray[i] = (Byte)vector.get(i);
        }
        return byArray;
    }

    protected DocumentContentSource getDocumentFromCache(String string) {
        DocumentContentSource documentContentSource;
        int n;
        Tr.entry((TraceComponent)_tc, (String)"getDocumentFromCache", (Object)string);
        DocumentContentSource documentContentSource2 = null;
        for (n = 0; n < this._dCSConfigExistingDocuments.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfigExistingDocuments.get(n);
            if (!documentContentSource.getDocument().getURI().toString().equals(string)) continue;
            documentContentSource2 = documentContentSource;
            break;
        }
        if (documentContentSource2 == null) {
            for (n = 0; n < this._dCSConfigNewDocuments.size(); ++n) {
                documentContentSource = (DocumentContentSource)this._dCSConfigNewDocuments.get(n);
                if (!documentContentSource.getDocument().getURI().toString().equals(string)) continue;
                documentContentSource2 = documentContentSource;
                break;
            }
        }
        return documentContentSource2;
    }

    public String[] getChildNames(boolean bl, boolean bl2) {
        String string;
        int n;
        Tr.entry((TraceComponent)_tc, (String)"getChildNames", (Object)new Object[]{new Boolean(bl), new Boolean(bl2)});
        Vector<String> vector = new Vector<String>();
        if (bl) {
            String string2;
            int n2;
            for (n2 = 0; n2 < this._dCSConfigExistingDocuments.size(); ++n2) {
                string2 = ((DocumentContentSource)this._dCSConfigExistingDocuments.get(n2)).getDocument().getURI();
                if (vector.contains(string2 = string2.substring(string2.lastIndexOf("/") + 1))) continue;
                vector.add(string2);
            }
            for (n2 = 0; n2 < this._dCSConfigNewDocuments.size(); ++n2) {
                string2 = ((DocumentContentSource)this._dCSConfigNewDocuments.get(n2)).getDocument().getURI();
                if (vector.contains(string2 = string2.substring(string2.lastIndexOf("/") + 1))) continue;
                vector.add(string2);
            }
        }
        String[] stringArray = null;
        stringArray = bl2 ? _repository.listResourceNames(ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(this._aliasedFile.getAbsolutePath()), 2, 1) : _repository.listResourceNames(ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(this._aliasedFile.getAbsolutePath()), 1, 1);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string.indexOf("/") == -1) continue;
            stringArray[n] = string.substring(string.lastIndexOf("/") + 1);
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (vector.contains(string)) continue;
            vector.add(string);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getConfigRepositoryCompliantPath(String string) {
        Tr.entry((TraceComponent)_tc, (String)"getConfigRepositoryCompliantPath", (Object)string);
        string = string.replace('\\', '/');
        string = string.endsWith("/config") ? "/" : string.substring(string.lastIndexOf("/config/") + "/config/".length());
        return string;
    }

    protected void displayCachedDocumentPaths() {
        DocumentContentSource documentContentSource;
        int n;
        Tr.entry((TraceComponent)_tc, (String)"displayCachedDocumentPaths");
        Tr.debug((TraceComponent)_tc, (String)"Current cached document information:");
        Tr.debug((TraceComponent)_tc, (String)("Contents of _dCSConfigExistingDocuments -- Size: " + this._dCSConfigExistingDocuments.size()));
        for (n = 0; n < this._dCSConfigExistingDocuments.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfigExistingDocuments.get(n);
            Tr.debug((TraceComponent)_tc, (String)("File#" + n + ": " + documentContentSource.getDocument().getURI().toString()));
        }
        Tr.debug((TraceComponent)_tc, (String)("Contents of _dCSConfigNewDocuments -- Size: " + this._dCSConfigExistingDocuments.size()));
        for (n = 0; n < this._dCSConfigNewDocuments.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfigNewDocuments.get(n);
            Tr.debug((TraceComponent)_tc, (String)("File#" + n + ": " + documentContentSource.getDocument().getURI().toString()));
        }
    }

    public void save() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"save");
        this.prepContentListsForRollback();
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[this._dCSConfigExistingDocuments.size()];
        this._dCSConfigExistingDocuments.toArray(documentContentSourceArray);
        Tr.debug((TraceComponent)_tc, (String)"Existing Documents to be saved: ");
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            Tr.debug((TraceComponent)_tc, (String)("File#" + i + ": " + documentContentSourceArray[i].getDocument().getURI()));
        }
        DocumentContentSource[] documentContentSourceArray2 = new DocumentContentSource[this._dCSConfigNewDocuments.size()];
        this._dCSConfigNewDocuments.toArray(documentContentSourceArray2);
        Tr.debug((TraceComponent)_tc, (String)"New Documents to be created/saved: ");
        for (int i = 0; i < documentContentSourceArray2.length; ++i) {
            Tr.debug((TraceComponent)_tc, (String)("File#" + i + ": " + documentContentSourceArray2[i].getDocument().getURI()));
        }
        Document[] documentArray = new Document[this._dConfigDeletedDocuments.size()];
        this._dConfigDeletedDocuments.toArray(documentArray);
        Tr.debug((TraceComponent)_tc, (String)"Existing Documents to be deleted: ");
        for (int i = 0; i < documentArray.length; ++i) {
            Tr.debug((TraceComponent)_tc, (String)("File#" + i + ": " + documentArray[i].getURI()));
        }
        Tr.debug((TraceComponent)_tc, (String)"Making call to _repository.update(...)");
        _repository.update(documentContentSourceArray2, documentContentSourceArray, documentArray);
        Tr.debug((TraceComponent)_tc, (String)"Returned from call to _repository.update(...)");
        this._dCSConfigExistingDocuments.clear();
        this._dCSConfigNewDocuments.clear();
        this._dConfigDeletedDocuments.clear();
    }

    protected void prepContentListsForRollback() throws Exception {
        String string;
        DocumentContentSource documentContentSource;
        int n;
        Tr.entry((TraceComponent)_tc, (String)"prepContentListsForRollback");
        for (n = 0; n < this._dCSConfigExistingDocuments.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfigExistingDocuments.get(n);
            string = documentContentSource.getDocument().getURI();
            this._originalConfigExistingDocuments.put(string, this.getStreamAsByteArrayInputStream(_repository.extract(string).getSource()));
        }
        for (n = 0; n < this._dCSConfigNewDocuments.size(); ++n) {
            documentContentSource = (DocumentContentSource)this._dCSConfigNewDocuments.get(n);
            string = documentContentSource.getDocument().getURI();
            this._originalDeletedDocuments.add(new Document(string));
        }
    }

    protected ByteArrayInputStream getStreamAsByteArrayInputStream(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getStreamAsByteArrayInputStream", (Object)inputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            Vector<Byte> vector = new Vector<Byte>();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte by = (byte)bufferedInputStream.read();
            while (by != -1) {
                vector.add(new Byte(by));
                by = (byte)bufferedInputStream.read();
            }
            byte[] byArray = new byte[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                byArray[i] = (Byte)vector.get(i);
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
        return byteArrayInputStream;
    }

    public void rollback() throws Exception {
        Document[] documentArray;
        DocumentContentSource[] documentContentSourceArray;
        Tr.entry((TraceComponent)_tc, (String)"rollback");
        ArrayList<Document[]> arrayList = new ArrayList<Document[]>(this._originalConfigExistingDocuments.size());
        Iterator iterator = this._originalConfigExistingDocuments.keySet().iterator();
        while (iterator.hasNext()) {
            documentContentSourceArray = (DocumentContentSource[])iterator.next();
            documentArray = _repository.extract((String)documentContentSourceArray);
            documentArray.setSource((InputStream)((ByteArrayInputStream)this._originalConfigExistingDocuments.get(documentContentSourceArray)));
            arrayList.add(documentArray);
        }
        documentContentSourceArray = new DocumentContentSource[arrayList.size()];
        arrayList.toArray(documentContentSourceArray);
        documentArray = new Document[this._originalDeletedDocuments.size()];
        this._originalDeletedDocuments.toArray(documentArray);
        _repository.update(new DocumentContentSource[0], documentContentSourceArray, documentArray);
    }
}

