/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.document.FileUrlDocumentCollectionHelper;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FileDocumentCollection
extends FileUrlDocumentCollectionHelper {
    private static TraceComponent _tc = Tr.register((Class)FileDocumentCollection.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected Hashtable _modifiedDocuments;
    protected Hashtable _originalDocuments;
    protected boolean _newDirectory;

    public FileDocumentCollection(BasicDocumentCollection basicDocumentCollection) throws Exception {
        super(basicDocumentCollection);
        this._newDirectory = !this._aliasedFile.exists();
    }

    public void setDocumentContents(Document document) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"setDocumentContents", (Object)new Object[]{document});
        if (this._collection.getDescriptor().isRollbackEnabled()) {
            if (this._modifiedDocuments == null) {
                this._modifiedDocuments = new Hashtable();
            }
            this._modifiedDocuments.put(document.getName(), document);
        } else {
            this.setDocumentContentsToFileSystem(document.getName(), document.getInputStream());
        }
    }

    public InputStream getDocumentContents(String string, boolean bl) throws IOException, NotFoundException {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentContents", (Object)new Object[]{string, new Boolean(bl)});
        InputStream inputStream = null;
        if (this._modifiedDocuments != null && this._modifiedDocuments.containsKey(string)) {
            Document document = (Document)this._modifiedDocuments.get(string);
            inputStream = document.getInputStream();
        } else {
            inputStream = this.getDocumentContentsFromFileSystem(string);
        }
        return inputStream;
    }

    public String[] getChildNames(boolean bl, boolean bl2) {
        Object[] objectArray;
        Tr.entry((TraceComponent)_tc, (String)"getChildNames", (Object)new Object[]{new Boolean(bl), new Boolean(bl2)});
        File[] fileArray = this._aliasedFile.listFiles();
        int n = 0;
        if (fileArray != null) {
            n += fileArray.length;
        }
        if (this._modifiedDocuments != null) {
            n += this._modifiedDocuments.size();
        }
        if (n == 0) {
            objectArray = new String[]{};
        } else {
            Vector<String> vector = new Vector<String>(n);
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (bl && !fileArray[i].isDirectory()) {
                        vector.addElement(fileArray[i].getName());
                    }
                    if (!bl2 || !fileArray[i].isDirectory()) continue;
                    vector.addElement(fileArray[i].getName());
                }
            }
            if (this._modifiedDocuments != null) {
                Enumeration enumeration = this._modifiedDocuments.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (vector.contains(string)) continue;
                    vector.addElement(string);
                }
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void save() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"save");
        if (this._collection.getDescriptor().isRollbackEnabled() && this._modifiedDocuments != null) {
            try {
                this._aliasedFile.mkdirs();
                this._originalDocuments = new Hashtable();
                Enumeration enumeration = this._modifiedDocuments.keys();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    String string = (String)enumeration.nextElement();
                    File file = new File(this._aliasedFile, string);
                    if (file.exists()) {
                        object = this.getDocumentContentsFromFileSystem(string);
                        int n = new Long(file.length()).intValue();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                        byte[] byArray = new byte[4096];
                        while (((BufferedInputStream)object).available() > 0) {
                            int n2 = ((BufferedInputStream)object).read(byArray, 0, 4096);
                            byteArrayOutputStream.write(byArray, 0, n2);
                        }
                        ((BufferedInputStream)object).close();
                        byteArrayOutputStream.close();
                        this._originalDocuments.put(string, byteArrayOutputStream.toByteArray());
                    }
                    object = (Document)this._modifiedDocuments.get(string);
                    this.setDocumentContentsToFileSystem(object.getName(), object.getInputStream());
                }
            }
            catch (Exception exception) {
                this.rollback();
                throw exception;
            }
        }
    }

    public void rollback() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"rollback");
        if (this._newDirectory) {
            if (this._aliasedFile.exists()) {
                FileUtilities.deleteDirectoryAndContents(this._aliasedFile);
            }
        } else if (this._modifiedDocuments != null) {
            Enumeration enumeration = this._modifiedDocuments.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                if (this._originalDocuments.containsKey(string)) {
                    object = new ByteArrayInputStream((byte[])this._originalDocuments.get(string));
                    this.setDocumentContentsToFileSystem(string, (InputStream)object);
                    continue;
                }
                object = new File(this._aliasedFile, string);
                if (!((File)object).exists()) continue;
                ((File)object).delete();
            }
        }
    }

    protected void setDocumentContentsToFileSystem(String string, InputStream inputStream) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"setDocumentContentsToFileSystem", (Object)new Object[]{string, inputStream});
        this.createDirectories();
        try {
            FileUtilities.copyBufferedInputStream(inputStream, new File(this._aliasedFile, string));
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Exception thrown by copyBufferedInpuStream: ", (Object)exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected void createDirectories() {
        Tr.entry((TraceComponent)_tc, (String)"createDirectories");
        if (!this._collection.getDescriptor().isRollbackEnabled() && this._newDirectory) {
            this._aliasedFile.mkdirs();
        }
    }

    protected BufferedInputStream getDocumentContentsFromFileSystem(String string) throws IOException, NotFoundException {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentContentsFromFileSystem", (Object)string);
        BufferedInputStream bufferedInputStream = null;
        File file = new File(this._aliasedFile, string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
        }
        catch (FileNotFoundException fileNotFoundException) {
            NotFoundException notFoundException = new NotFoundException(file.getPath());
            notFoundException.initCause(fileNotFoundException);
            throw notFoundException;
        }
        return bufferedInputStream;
    }
}

