/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class NodeDocumentCollectionImpl
extends BasicDocumentCollection
implements NodeDocumentCollection {
    private static TraceComponent _tc = Tr.register((Class)NodeDocumentCollectionImpl.class, null, (String)"com.ibm.ws.migration.WASUpgrade");

    public NodeDocumentCollectionImpl(String string, DocumentCollection documentCollection, BasicDocumentCollection.Descriptor descriptor, URL uRL) throws Exception {
        this(string, documentCollection, descriptor, uRL, null);
    }

    public NodeDocumentCollectionImpl(String string, DocumentCollection documentCollection, BasicDocumentCollection.Descriptor descriptor, URL uRL, URL uRL2) throws Exception {
        super(string, documentCollection, descriptor, uRL, uRL2);
    }

    public Properties getVariables() {
        Tr.entry((TraceComponent)_tc, (String)"getVariables");
        Properties properties = new Properties();
        try {
            properties = ((CellDocumentCollection)this.getParent().getParent()).getVariables();
            WCCMDocument wCCMDocument = (WCCMDocument)this.openDocument("variables.xml", WCCMDocument.class, false, true);
            properties = UtilityImpl.getVariables(wCCMDocument, properties);
            wCCMDocument.close();
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Variables.xml not found( This usually an OK condition): ", (Object)exception);
        }
        return properties;
    }

    public boolean isDeploymentManager() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isDeploymentManager");
        boolean bl = false;
        try {
            WCCMDocument wCCMDocument = (WCCMDocument)this.openDocument("serverindex.xml", WCCMDocument.class, false, true);
            ServerIndex serverIndex = (ServerIndex)this.locateConfigFileObject(wCCMDocument, ServerIndex.class);
            Iterator iterator = serverIndex.getServerEntries().iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                bl = true;
                break;
            }
            wCCMDocument.close();
        }
        catch (NotFoundException notFoundException) {
            Tr.debug((TraceComponent)_tc, (String)"Could not find the serverindex.xml which is possible if I'm not working with the DMgr node.");
        }
        return bl;
    }

    public boolean isFederated() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isFederated");
        String string = ((ProfileImpl)this.getScenario().getOldProductImage().getProfile()).getOwningNodeName();
        return string.equals(this.getName());
    }

    private Object locateConfigFileObject(WCCMDocument wCCMDocument, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"locateConfigFileObject", (Object)new Object[]{wCCMDocument, clazz});
        List list = wCCMDocument.getList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isInstance(e)) continue;
            return e;
        }
        return null;
    }

    public NodeDocumentCollection.Release getRelease() {
        try {
            return new WASReleaseImpl(this._name);
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Exception thrown from getRelease()", (Object)exception);
            return null;
        }
    }

    public class WASReleaseImpl
    implements NodeDocumentCollection.WASRelease {
        private ManagedObjectMetadataHelper _helper = null;
        private String _nodeName = null;

        public WASReleaseImpl(String string) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"WASReleaseImpl");
            this._nodeName = string;
            ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            this._helper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
        }

        public boolean isCurrentRelease() {
            Tr.entry((TraceComponent)_tc, (String)"isCurrentRelease");
            return this.isR61();
        }

        public boolean isR61() {
            Tr.entry((TraceComponent)_tc, (String)"isR61");
            try {
                if (this._helper.getNodeMajorVersion(this._nodeName).equals("6") && this._helper.getNodeMinorVersion(this._nodeName).equals("1")) {
                    return true;
                }
            }
            catch (AdminException adminException) {
                Tr.debug((TraceComponent)_tc, (String)"isR61() exception: ", (Object)((Object)adminException));
            }
            return false;
        }

        public boolean isR60() {
            Tr.entry((TraceComponent)_tc, (String)"isR60");
            try {
                if (this._helper.getNodeMajorVersion(this._nodeName).equals("6") && this._helper.getNodeMinorVersion(this._nodeName).equals("0")) {
                    return true;
                }
            }
            catch (AdminException adminException) {
                Tr.debug((TraceComponent)_tc, (String)"isR60() exception: ", (Object)((Object)adminException));
            }
            return false;
        }

        public boolean isR5x() {
            Tr.entry((TraceComponent)_tc, (String)"isR5x");
            try {
                if (this._helper.getNodeMajorVersion(this._nodeName).equals("5")) {
                    return true;
                }
            }
            catch (AdminException adminException) {
                Tr.debug((TraceComponent)_tc, (String)"isR5x() exception: ", (Object)((Object)adminException));
                return true;
            }
            return false;
        }
    }
}

