/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class TextDocument
implements Document {
    private static TraceComponent _tc = Tr.register((Class)TextDocument.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String lineSeparator = System.getProperty("line.separator");
    private Vector _vFileContents = new Vector();
    private byte[] _bArray = null;
    private String _fileName = null;
    private boolean _internalContentsModified = false;
    private boolean _closed = false;
    DocumentCollection _dc;

    public TextDocument(String string, DocumentCollection documentCollection) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"TextDocument", (Object)new Object[]{string, documentCollection});
        this._dc = documentCollection;
        this._fileName = string;
    }

    public Vector getFileContents() {
        Tr.entry((TraceComponent)_tc, (String)"getFileContents");
        this._internalContentsModified = true;
        return this._vFileContents;
    }

    public void close() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"close");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "8859_1"));
            for (int i = 0; i < this._vFileContents.size(); ++i) {
                bufferedWriter.write((String)this._vFileContents.get(i));
            }
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        this._bArray = byteArrayOutputStream.toByteArray();
        this._internalContentsModified = false;
        this._closed = true;
    }

    public InputStream getInputStream() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getInputStream");
        if (this._internalContentsModified) {
            throw new IllegalStateException();
        }
        return new ByteArrayInputStream(this._bArray);
    }

    public void setInputStream(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInputStream", (Object)inputStream);
        inputStream = this.setInitialState(inputStream);
        this._vFileContents = new Vector();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this._vFileContents.add(string + lineSeparator);
            }
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
    }

    private InputStream setInitialState(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInitialState", (Object)inputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            Vector<Byte> vector = new Vector<Byte>();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte by = (byte)bufferedInputStream.read();
            while (by != -1) {
                vector.add(new Byte(by));
                by = (byte)bufferedInputStream.read();
            }
            byte[] byArray = new byte[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                byArray[i] = (Byte)vector.get(i);
            }
            this._bArray = byArray;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            Tr.debug((TraceComponent)_tc, (String)"Exception thrown setting initial state of TextDocument: ", (Object)iOException);
            throw iOException;
        }
        return byteArrayInputStream;
    }

    public DocumentCollection getDocumentCollection() {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentCollection");
        return this._dc;
    }

    public String getName() {
        Tr.entry((TraceComponent)_tc, (String)"getName");
        return this._fileName;
    }

    public boolean isClosed() {
        Tr.entry((TraceComponent)_tc, (String)"isClosed");
        return this._closed;
    }

    public URL getAbsoluteUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAbsoluteUrl");
        return new File(this.getDocumentCollection().getAbsoluteUrl().getFile(), this.getName()).toURL();
    }

    public URL getAliasUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAliasUrl");
        return new File(this.getDocumentCollection().getAliasUrl().getFile(), this.getName()).toURL();
    }
}

