/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.document.TextDocument;
import com.ibm.ws.migration.document.policy.PolicyParser;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.DocumentProcessor;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.Vector;

public final class BasicPolicyDocumentProcessor
implements DocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)BasicPolicyDocumentProcessor.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String lineSeparator = System.getProperty("line.separator");
    private DocumentTransform _transform;
    private TransformMappingKey _transformMappingKey;
    private TextDocument _newPolicyDocument = null;
    private TextDocument _oldPolicyDocument = null;
    protected Vector _vOldPolicy = null;
    protected Vector _vNewPolicy = null;
    protected Vector _vCombinedPolicy = new Vector();
    protected Vector _vFileContents = null;

    public BasicPolicyDocumentProcessor(DocumentTransform documentTransform, TransformMappingKey transformMappingKey) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"BasicPolicyDocumentProcessor", (Object)new Object[]{documentTransform, transformMappingKey});
        this._transform = documentTransform;
        this._transformMappingKey = transformMappingKey;
        this._transform = documentTransform;
        this._oldPolicyDocument = (TextDocument)this._transform.getOldDocumentCollection().openDocument(transformMappingKey.getOldDocumentName(), TextDocument.class);
        this._newPolicyDocument = (TextDocument)this._transform.getNewDocumentCollection().openDocument(transformMappingKey.getNewDocumentName(), TextDocument.class, true, false);
        Vector vector = null;
        vector = this._oldPolicyDocument.getFileContents();
        this._vFileContents = this._newPolicyDocument.getFileContents();
        Tr.debug((TraceComponent)_tc, (String)"Parsing old Policy document.");
        this._vOldPolicy = PolicyParser.parse(this._oldPolicyDocument.getFileContents());
        Tr.debug((TraceComponent)_tc, (String)"Parsing new Policy document.");
        this._vNewPolicy = PolicyParser.parse(this._newPolicyDocument.getFileContents());
    }

    public void migrate() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        this.mergePolicy();
        this.appendMergedPolicy();
        this._oldPolicyDocument.close();
        this._newPolicyDocument.close();
    }

    private void mergePolicy() {
        Tr.entry((TraceComponent)_tc, (String)"mergePolicy");
        PolicyParser.Grant grant = null;
        PolicyParser.Grant grant2 = null;
        for (int i = 0; i < this._vNewPolicy.size(); ++i) {
            grant = (PolicyParser.Grant)this._vNewPolicy.get(i);
            for (int j = 0; j < this._vOldPolicy.size(); ++j) {
                grant2 = (PolicyParser.Grant)this._vOldPolicy.get(j);
                if (!grant2.getGrantSignature().equals(grant.getGrantSignature())) continue;
                Vector vector = grant2.getPermissions();
                Vector vector2 = grant.getPermissions();
                for (int k = 0; k < vector.size(); ++k) {
                    String string = (String)vector.get(k);
                    if (!vector2.contains(string)) continue;
                    grant2.removePermission(string);
                    if (vector.size() == 0) continue;
                    k = -1;
                }
                if (grant2.getPermissions().size() != 0) continue;
                this._vOldPolicy.remove(grant2);
                if (this._vOldPolicy.size() == 0) continue;
                j = -1;
            }
        }
        this._vCombinedPolicy = this._vOldPolicy;
    }

    private void appendMergedPolicy() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"appendMergedPolicy");
        this.weedOutGrants(this._vCombinedPolicy);
        if (this._vCombinedPolicy.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Object var2_2 = null;
            this._vFileContents.add(lineSeparator + "//" + LoggerImpl.get_nls().getString("advise.policy.leftover", "MIGR0372I: Migrated grant permissions follow.") + lineSeparator);
            PolicyParser.Grant grant = null;
            Vector vector = null;
            for (int i = 0; i < this._vCombinedPolicy.size(); ++i) {
                grant = (PolicyParser.Grant)this._vCombinedPolicy.get(i);
                this._vFileContents.add(grant.getGrantSignature() + " {" + lineSeparator);
                vector = grant.getPermissions();
                for (int j = 0; j < vector.size(); ++j) {
                    this._vFileContents.add("   " + vector.get(j) + ";" + lineSeparator);
                }
                this._vFileContents.add("};" + lineSeparator + lineSeparator);
            }
        }
    }

    private void weedOutGrants(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"weedOutGrants", (Object)vector);
        for (int i = 0; i < vector.size(); ++i) {
            PolicyParser.Grant grant = (PolicyParser.Grant)vector.get(i);
            if (grant.getGrantSignature().indexOf("file:/QIBM/ProdData/Java400/jdk13/lib/tools.jar") == -1) continue;
            vector.remove(i);
            --i;
        }
    }
}

