/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.common.StringRegionTokenizer;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolicyParser {
    private static TraceComponent _tc = Tr.register((Class)PolicyParser.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String lineSeparator = System.getProperty("line.separator");
    private static final String GRANT = "grant";
    private static final String FILTERMASK = "filtermask";
    private static final String RUNTIMEFILTERMASK = "runtimefiltermask";
    private static final String PERMISSION = "permission";
    private static File _tempFile = null;

    public static Vector parse(Vector vector) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"parse", (Object)vector);
        File file = PolicyParser.prepareForParse(vector);
        Vector<Grant> vector2 = new Vector<Grant>();
        Grant grant = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            string = bufferedReader.readLine();
            while (string != null) {
                bl = false;
                if (!PolicyParser.stripSpaces(string).startsWith("//") && string.toLowerCase().indexOf(GRANT) != -1 || string.toLowerCase().indexOf(FILTERMASK) != -1 || string.toLowerCase().indexOf(RUNTIMEFILTERMASK) != -1) {
                    if (PolicyParser.stripSpaces(string).startsWith(";") || PolicyParser.stripSpaces(string).startsWith("}")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ";}");
                        string2 = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = string2 + stringTokenizer.nextToken();
                        }
                        string = string2;
                    }
                    int n = -1;
                    n = string.indexOf(PERMISSION);
                    if (n != -1) {
                        string2 = string.substring(0, n);
                        string2 = string2.substring(0, string2.lastIndexOf(123));
                        PolicyParser policyParser = new PolicyParser();
                        policyParser.getClass();
                        grant = policyParser.new Grant(string2.trim());
                        string = string.substring(n);
                    } else if (string.endsWith("{")) {
                        string = string.substring(0, string.length() - 1);
                        PolicyParser policyParser = new PolicyParser();
                        policyParser.getClass();
                        grant = policyParser.new Grant(string.trim());
                    } else {
                        int n2;
                        if (PolicyParser.stripSpaces(string).endsWith("};")) {
                            n2 = string.lastIndexOf(123);
                            string2 = string.substring(0, n2);
                            PolicyParser policyParser = new PolicyParser();
                            policyParser.getClass();
                            grant = policyParser.new Grant(string2.trim());
                            vector2.add(grant);
                            string = bufferedReader.readLine();
                            continue;
                        }
                        if (PolicyParser.stripSpaces(string).endsWith("}")) {
                            n2 = string.lastIndexOf(123);
                            string2 = string.substring(0, n2);
                            PolicyParser policyParser = new PolicyParser();
                            policyParser.getClass();
                            grant = policyParser.new Grant(string2.trim());
                            vector2.add(grant);
                            string = bufferedReader.readLine();
                            continue;
                        }
                        PolicyParser policyParser = new PolicyParser();
                        policyParser.getClass();
                        grant = policyParser.new Grant(string.trim());
                    }
                    while (string != null) {
                        if (string.trim().startsWith("//")) {
                            string = bufferedReader.readLine();
                            continue;
                        }
                        if (string.trim().equals("")) {
                            string = bufferedReader.readLine();
                            continue;
                        }
                        if (PolicyParser.stripSpaces(string).startsWith(";") && string.indexOf(PERMISSION) != -1) {
                            string = string.trim();
                            string = string.substring(1);
                            continue;
                        }
                        if (string.startsWith(";")) {
                            string = bufferedReader.readLine();
                            continue;
                        }
                        if (string.toLowerCase().trim().startsWith(GRANT) || string.toLowerCase().trim().startsWith(RUNTIMEFILTERMASK) || string.toLowerCase().trim().startsWith(FILTERMASK)) {
                            string = bufferedReader.readLine();
                            continue;
                        }
                        if (string.toLowerCase().trim().startsWith(PERMISSION)) {
                            string2 = PolicyParser.stripSpaces(string);
                            if (string2.endsWith("};")) {
                                int n3 = string.lastIndexOf(125);
                                string = string.substring(0, n3);
                                PolicyParser.parseAddPermission(string, grant);
                                break;
                            }
                            if (string.endsWith("}")) {
                                string = string.substring(0, string.lastIndexOf(59));
                                PolicyParser.parseAddPermission(string, grant);
                                break;
                            }
                            if (string.endsWith(";")) {
                                PolicyParser.parseAddPermission(string, grant);
                            } else {
                                PolicyParser.parseAddPermission(string, grant);
                            }
                        } else {
                            if (PolicyParser.stripSpaces(string).endsWith("};")) break;
                            if (PolicyParser.stripSpaces(string).startsWith("};")) {
                                bl = true;
                                break;
                            }
                            if (PolicyParser.stripSpaces(string).equals("{}")) {
                                while ((string = bufferedReader.readLine()) != null && !string.equals(";")) {
                                }
                                break;
                            }
                            if (PolicyParser.stripSpaces(string).startsWith("{") && string.indexOf(PERMISSION) != -1) {
                                StringTokenizer stringTokenizer = new StringTokenizer(string, "{");
                                string2 = "";
                                while (stringTokenizer.hasMoreTokens()) {
                                    string2 = string2 + stringTokenizer.nextToken();
                                }
                                string = string2;
                                continue;
                            }
                            if (!string.startsWith("{")) break;
                            string = bufferedReader.readLine();
                            continue;
                        }
                        string = bufferedReader.readLine();
                    }
                    vector2.add(grant);
                }
                if (bl) continue;
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
        return vector2;
    }

    private static File prepareForParse(Vector vector) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"prepareForParse", (Object)vector);
        try {
            _tempFile = PolicyParser.createTempFile();
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
        File file = PolicyParser.stripOutComments(vector);
        file = PolicyParser.formatFile(file);
        return file;
    }

    private static File createTempFile() throws UpgradeException {
        File file;
        Tr.entry((TraceComponent)_tc, (String)"createTempFile");
        if (!new File(UpgradeBase.get_userRoot(), "temp").exists()) {
            new File(UpgradeBase.get_userRoot(), "temp").mkdirs();
        }
        if (!(file = new File(new File(UpgradeBase.get_userRoot(), "temp"), FileUtilities.generateFileName("temp.policy"))).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new UpgradeException(iOException);
            }
        }
        return file;
    }

    private static File stripOutComments(Vector vector) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"stripOutComments", (Object)vector);
        String string = "/*";
        String string2 = "*/";
        String string3 = "//";
        String string4 = lineSeparator;
        String string5 = "\"";
        try {
            Object object;
            String string6 = "";
            Object var7_8 = null;
            for (int i = 0; i < vector.size(); ++i) {
                string6 = string6 + vector.get(i) + lineSeparator;
            }
            StringRegionTokenizer stringRegionTokenizer = new StringRegionTokenizer(string6, new String[]{string, string2, string3, string4, string5}, true);
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            while (stringRegionTokenizer.hasMoreTokens()) {
                object = stringRegionTokenizer.nextToken();
                if (((String)object).equals(string) && !bl) {
                    while (!((String)(object = stringRegionTokenizer.nextToken())).equals(string2)) {
                    }
                    continue;
                }
                if (((String)object).equals(string3) && !bl) {
                    while (!((String)(object = stringRegionTokenizer.nextToken())).equals(string4)) {
                    }
                    stringBuffer.append(lineSeparator);
                    continue;
                }
                if (((String)object).equals(string5)) {
                    bl = !bl;
                    stringBuffer.append(((String)object).trim());
                    continue;
                }
                stringBuffer.append((String)object);
            }
            object = new BufferedWriter(new FileWriter(_tempFile));
            ((Writer)object).write(stringBuffer.toString());
            ((BufferedWriter)object).close();
            return _tempFile;
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
    }

    private static File formatFile(File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"formatFile", (Object)file);
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = "";
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2 + lineSeparator;
            }
            StringRegionTokenizer stringRegionTokenizer = new StringRegionTokenizer(string, new String[]{GRANT, PERMISSION, FILTERMASK, RUNTIMEFILTERMASK}, true);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringRegionTokenizer.hasMoreTokens()) {
                object = stringRegionTokenizer.nextToken();
                if (((String)object).equals(GRANT) || ((String)object).equals(PERMISSION) || ((String)object).equals(FILTERMASK) || ((String)object).equals(RUNTIMEFILTERMASK)) {
                    stringBuffer.append(lineSeparator);
                }
                stringBuffer.append((String)object);
            }
            object = new BufferedWriter(new FileWriter(_tempFile));
            ((Writer)object).write(stringBuffer.toString());
            ((BufferedWriter)object).close();
            return _tempFile;
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
    }

    private static String stripSpaces(String string) {
        Tr.entry((TraceComponent)_tc, (String)"stripSpaces", (Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    private static void parseAddPermission(String string, Grant grant) {
        Tr.entry((TraceComponent)_tc, (String)"parseAddPermission", (Object)new Object[]{string, grant});
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            grant.addPermission(stringTokenizer.nextToken().trim());
        }
    }

    public class Grant {
        private String _grantSignature = null;
        private Vector _permissions = new Vector();

        public Grant(String string) {
            this._grantSignature = string;
        }

        public String getGrantSignature() {
            return this._grantSignature;
        }

        public void setGrantSignature(String string) {
            this._grantSignature = string;
        }

        public Vector getPermissions() {
            return this._permissions;
        }

        public void addPermission(String string) {
            if (string == null || string.trim().length() < 1) {
                return;
            }
            this._permissions.add(string);
        }

        public void removePermission(String string) {
            this._permissions.remove(string);
        }
    }
}

