/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.document.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class PropertiesDocument
implements Document {
    private static TraceComponent _tc = Tr.register((Class)PropertiesDocument.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String lineSeparator = System.getProperty("line.separator");
    public static String COMMENT_PREFIX = "INTERNAL_GENERATED_MIGRATION_COMMENT_PREFIX_";
    public static String BLANKLINE_PREFIX = "INTERNAL_GENERATED_MIGRATION_BLANK_PREFIX_";
    private static final String COMMENT_CHAR = "#";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private Properties _properties = new Properties();
    private Vector _vFileContents = new Vector();
    private Vector _vExtraContents = new Vector();
    private byte[] _bArray = null;
    private String _fileName = null;
    private boolean _internalContentsModified = false;
    private boolean _closed = false;
    private DocumentCollection _collection;

    public PropertiesDocument(String string, DocumentCollection documentCollection) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"PropertiesDocument", (Object)new Object[]{string, documentCollection});
        this._fileName = string;
        this._collection = documentCollection;
        this.preInitialization();
    }

    private void preInitialization() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"preInitialization");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        this.setInputStream(byteArrayInputStream);
    }

    Vector getContents() {
        Tr.entry((TraceComponent)_tc, (String)"getContents");
        return this._vFileContents;
    }

    Vector getExtraContents() {
        Tr.entry((TraceComponent)_tc, (String)"getExtraContents");
        return this._vExtraContents;
    }

    public Properties getProperties() {
        Tr.entry((TraceComponent)_tc, (String)"getProperties");
        return this._properties;
    }

    public InputStream getInputStream() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getInputStream");
        if (this._internalContentsModified) {
            throw new IllegalStateException();
        }
        return new ByteArrayInputStream(this._bArray);
    }

    public void setInputStream(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInputStream", (Object)inputStream);
        inputStream = this.setInitialState(inputStream);
        try {
            this._properties.load(inputStream);
            this._properties.remove("");
            this._vFileContents = new Vector();
            this._vExtraContents = new Vector();
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
    }

    private InputStream setInitialState(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInitialState", (Object)inputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        Vector<Byte> vector = new Vector<Byte>();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte by = (byte)bufferedInputStream.read();
        while (by != -1) {
            vector.add(new Byte(by));
            by = (byte)bufferedInputStream.read();
        }
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            byArray[i] = (Byte)vector.get(i);
        }
        this._bArray = byArray;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public String getName() {
        Tr.entry((TraceComponent)_tc, (String)"getName");
        return this._fileName;
    }

    public void close() throws Exception {
        int n;
        Tr.entry((TraceComponent)_tc, (String)"close");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "8859_1"));
        String string = null;
        for (n = 0; n < this._vFileContents.size(); ++n) {
            string = (String)this._vFileContents.get(n);
            if (string.startsWith(COMMENT_PREFIX) || string.startsWith(BLANKLINE_PREFIX)) {
                bufferedWriter.write((String)this._vFileContents.get(++n));
            } else {
                bufferedWriter.write(this.saveConvert(string, true));
                bufferedWriter.write("=");
                bufferedWriter.write(this.saveConvert((String)this._vFileContents.get(++n), false));
            }
            bufferedWriter.write(lineSeparator);
        }
        if (this._vExtraContents.size() != 0) {
            bufferedWriter.write(lineSeparator);
            bufferedWriter.write(COMMENT_CHAR + LoggerImpl.get_nls().getString("advise.properties.leftover", "name=value pairs found in old file, but not in new file."));
            bufferedWriter.write(lineSeparator);
            for (n = 0; n < this._vExtraContents.size(); ++n) {
                string = (String)this._vExtraContents.get(n);
                bufferedWriter.write(this.saveConvert(string, true));
                bufferedWriter.write("=");
                bufferedWriter.write(this.saveConvert((String)this._vExtraContents.get(++n), false));
                bufferedWriter.write(lineSeparator);
            }
        }
        bufferedWriter.close();
        this._bArray = byteArrayOutputStream.toByteArray();
        this._internalContentsModified = false;
        this._closed = true;
    }

    public boolean isClosed() {
        Tr.entry((TraceComponent)_tc, (String)"isClosed");
        return this._closed;
    }

    public DocumentCollection getDocumentCollection() {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentCollection");
        return this._collection;
    }

    private String saveConvert(String string, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"saveConvert", (Object)new Object[]{string, new Boolean(bl)});
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(PropertiesDocument.toHex(c >> 12 & 0xF));
                        stringBuffer.append(PropertiesDocument.toHex(c >> 8 & 0xF));
                        stringBuffer.append(PropertiesDocument.toHex(c >> 4 & 0xF));
                        stringBuffer.append(PropertiesDocument.toHex(c & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        Tr.entry((TraceComponent)_tc, (String)"toHex", (Object)new Integer(n));
        return hexDigit[n & 0xF];
    }

    private static String loadConvert(String string) {
        Tr.entry((TraceComponent)_tc, (String)"loadConvert", (Object)string);
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public URL getAbsoluteUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAbsoluteUrl");
        return new File(this.getDocumentCollection().getAbsoluteUrl().getFile(), this.getName()).toURL();
    }

    public URL getAliasUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAliasUrl");
        return new File(this.getDocumentCollection().getAliasUrl().getFile(), this.getName()).toURL();
    }
}

