/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.Express;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;

public class ServerIndexConfig
extends BasicWCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)ServerIndexConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private String _originalHostName = null;
    private boolean _existingServerEntry = false;
    private int _endPointPort = 0;
    protected CellDocumentCollectionPostImpl _cellDocumentCollectionPostImpl = null;

    public ServerIndexConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this._cellDocumentCollectionPostImpl = (CellDocumentCollectionPostImpl)documentTransform.getNewDocumentCollection().getParent().getParent();
        this.getProcessorHelper().addOverride(ServerEntry.class, "getDeployedApplications", new Class[0]);
        this.getProcessorHelper().addOverride(ServerIndex.class, "setHostName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(EndPoint.class, "setHost", new Class[]{String.class});
        this.getProcessorHelper().addOverride(EndPoint.class, "setPort", new Class[]{Integer.TYPE});
    }

    public Document getTemplateDocument() {
        return null;
    }

    public void logProgressMessage(ServerEntry serverEntry, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)serverEntry);
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"ServerEntry", serverEntry.getServerName()}, "Adding {0} entry {1} to the model."), true);
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"ServerEntry", serverEntry.getServerName()}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."), true);
        }
    }

    public List getDeployedApplications(boolean bl, ServerEntry serverEntry) {
        Tr.entry((TraceComponent)_tc, (String)"getDeployedApplications");
        return new BasicEList();
    }

    public boolean arePrimaryKeysEqual(ServerIndex serverIndex, ServerIndex serverIndex2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + serverIndex.getClass().getName()));
        this._originalHostName = serverIndex2.getHostName();
        Tr.debug((TraceComponent)_tc, (String)("_originalHostName = " + this._originalHostName));
        return true;
    }

    public boolean arePrimaryKeysEqual(ServerEntry serverEntry, ServerEntry serverEntry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + serverEntry.getClass().getName()));
        this._existingServerEntry = serverEntry.getServerName().equals(serverEntry2.getServerName());
        Tr.debug((TraceComponent)_tc, (String)("_existingServerEntry  = " + new Boolean(this._existingServerEntry).toString()));
        return this._existingServerEntry;
    }

    public boolean arePrimaryKeysEqual(NamedEndPoint namedEndPoint, NamedEndPoint namedEndPoint2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + namedEndPoint.getClass().getName()));
        boolean bl = namedEndPoint.getEndPointName().equals(namedEndPoint2.getEndPointName());
        Tr.debug((TraceComponent)_tc, (String)("existingNamedEndPoint  = " + new Boolean(bl).toString()));
        this._endPointPort = bl ? namedEndPoint2.getEndPoint().getPort() : namedEndPoint.getEndPoint().getPort();
        Tr.debug((TraceComponent)_tc, (String)("_endPointPort = " + this._endPointPort));
        return bl;
    }

    public void setHostName(ServerIndex serverIndex, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setHostName", (Object)new Object[]{serverIndex.getClass().getName(), string});
        if (this._originalHostName != null) {
            serverIndex.setHostName(this._originalHostName);
        } else {
            serverIndex.setHostName(string);
        }
    }

    public void setHost(EndPoint endPoint, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setHost", (Object)new Object[]{endPoint.getClass().getName(), string});
        if (this._originalHostName != null) {
            endPoint.setHost(this._originalHostName);
        } else {
            endPoint.setHost(string);
        }
    }

    public void setPort(EndPoint endPoint, int n) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setPort", (Object)new Object[]{endPoint.getClass().getName(), new Integer(n)});
        File file = new File(this.getTransform().getNewDocumentCollection().getUrl().getPath(), this.getTransform().getName());
        if (this._existingServerEntry) {
            this._cellDocumentCollectionPostImpl.getPortUsage().checkForPortUsage(new Integer(this._endPointPort), file, true);
            endPoint.setPort(this._endPointPort);
        } else {
            endPoint.setPort(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(Integer.toString(n), file));
        }
    }
}

