/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.Federated;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.ConfigDocumentCollectionFederatedPostImpl;
import com.ibm.ws.migration.postupgrade.Federated.ResourceCellConfig;
import com.ibm.ws.migration.postupgrade.Federated.ResourceClusterConfig;
import com.ibm.ws.migration.postupgrade.Federated.SecurityConfig;
import com.ibm.ws.migration.postupgrade.Federated.SetupCmdLine;
import com.ibm.ws.migration.postupgrade.Federated.SyncNodeAgent;
import com.ibm.ws.migration.postupgrade.Federated.UploadConfigRepository;
import com.ibm.ws.migration.postupgrade.NetworkDeployment.DisableOldEnvironment;
import com.ibm.ws.migration.postupgrade.NetworkDeployment.NodeConfig;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ApplicationMigrationHelper;
import com.ibm.ws.migration.transform.DescriptorEnabledTransform;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.BasicTransformMapping;
import com.ibm.wsspi.migration.document.CopyDocumentProcessor;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMapping;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMTransformMapping;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ConfigTransactionalDocumentTransform
extends com.ibm.ws.migration.postupgrade.common.ConfigTransactionalDocumentTransform {
    private static TraceComponent _tc = Tr.register((Class)ConfigTransactionalDocumentTransform.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static final WCCMTransformMapping NODE_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("node.xml"), NodeConfig.class);
    protected static final WCCMTransformMapping RESOURCE_CLUSTER_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("resources.xml"), ResourceClusterConfig.class);
    protected static final WCCMTransformMapping RESOURCE_CELL_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("resources.xml"), ResourceCellConfig.class);
    protected static final WCCMTransformMapping SECURITY_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("security.xml"), SecurityConfig.class);
    protected UploadConfigRepository _uploadConfigRepository = null;
    protected Hashtable _baseInstalledApplications = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ws$migration$postupgrade$Federated$ResourceConfig;
    static /* synthetic */ Class class$com$ibm$ws$migration$postupgrade$Federated$R60$ResourceConfig;
    static /* synthetic */ Class class$com$ibm$ws$migration$postupgrade$Federated$ServerIndexConfig;
    static /* synthetic */ Class class$com$ibm$ws$migration$postupgrade$Federated$ServerConfig;

    public ConfigTransactionalDocumentTransform(Scenario scenario, DocumentCollection documentCollection, DocumentCollection documentCollection2, DocumentTransform documentTransform, DescriptorEnabledTransform.Descriptor descriptor) throws Exception {
        super(scenario, documentCollection, documentCollection2, documentTransform, descriptor);
    }

    public void setup() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setup");
        super.setup();
        DocumentCollection documentCollection = this.getNewDocumentCollection().getChild("cells").getChildren()[0].getChild("nodes").getChildren()[0];
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.openDocument("serverindex.xml", WCCMDocument.class, false, false);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            Tr.debug((TraceComponent)_tc, (String)("Found new Server: " + serverEntry.getServerName()));
            Vector<String> vector = new Vector<String>();
            Iterator iterator2 = serverEntry.getDeployedApplications().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                Tr.debug((TraceComponent)_tc, (String)("Found new deployed application: " + string));
                vector.add(string);
                iterator2.remove();
            }
            if (vector.size() == 0) continue;
            this._baseInstalledApplications.put(serverEntry.getServerName(), vector);
        }
        wCCMDocument.close();
    }

    public void complete() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"complete");
        ConfigRepository configRepository = ((ConfigDocumentCollectionFederatedPostImpl)this.getNewDocumentCollection()).getDmgrConfigRepository();
        ConfigRepository configRepository2 = ((ConfigDocumentCollectionFederatedPostImpl)this.getNewDocumentCollection()).getFederatedConfigRepository();
        Tr.debug((TraceComponent)_tc, (String)"Modifying WAS_CELL entry in setupCmdLine.(sh|bat) to reflect Federation");
        SetupCmdLine setupCmdLine = new SetupCmdLine(this.getOldDocumentCollection().getChild("cells").getChildren()[0].getName());
        setupCmdLine.update();
        Tr.debug((TraceComponent)_tc, (String)"Stopping/Disabling old NodeAgent.");
        DisableOldEnvironment.stopAndDisableNodeIfItExists(this.getScenario());
        Tr.debug((TraceComponent)_tc, (String)"Uploading migrated files to dmgr master Repository");
        String string = ((ProfileImpl)this.getScenario().getOldProductImage().getProfile()).getOwningNodeName();
        String string2 = ((ProfileImpl)this.getScenario().getNewProductImage().getProfile()).getOwningNodeName();
        this._uploadConfigRepository = new UploadConfigRepository(configRepository, configRepository2, string, string2, this.getNewDocumentCollection(), this.getOldDocumentCollection());
        this._uploadConfigRepository.upload();
        Tr.debug((TraceComponent)_tc, (String)"Installing Applications");
        this.installApplications();
        Tr.debug((TraceComponent)_tc, (String)"Syncing node with DeploymentManager's Repository");
        SyncNodeAgent syncNodeAgent = new SyncNodeAgent((ConfigDocumentCollectionFederatedPostImpl)this.getNewDocumentCollection());
        syncNodeAgent.syncWithDM();
        Tr.debug((TraceComponent)_tc, (String)"Performing updatePluginCfg");
        this.updatePluginCfg();
        UpgradeBase.get_newOSInfo().changeOwnership(WASPostUpgrade.get_configRoot());
        UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.managed.node.cell.info.not.migrated", "Cell-level documents are not merged. Any changes that you make to the standalone cell-level documents before using the WASPostUpgrade command must be repeated on the new cell. For example, virtual hosts. "), true);
    }

    protected void installApplications() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"installApplications");
        Iterator iterator = this._baseInstalledApplications.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Tr.debug((TraceComponent)_tc, (String)("Installing Applications for server: " + string));
            Vector vector = (Vector)this._baseInstalledApplications.get(string);
            ApplicationMigrationHelper applicationMigrationHelper = new ApplicationMigrationHelper(this.getScenario());
            applicationMigrationHelper.installApplications(this.getNewDocumentCollection(), vector);
        }
    }

    public void rollback() throws Exception {
        super.rollback();
        if (this._uploadConfigRepository != null) {
            this._uploadConfigRepository.rollback();
        }
    }

    protected void initCellDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initCellDocumentTransforms", (Object)vector);
        vector.add(SECURITY_FILE_MAPPING);
        vector.add(new BasicTransformMapping(new TransformMappingKey("cell.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("admin-authz.xml"), CopyDocumentProcessor.class));
        vector.add(RESOURCE_CELL_FILE_MAPPING);
        vector.add(new BasicTransformMapping(new TransformMappingKey("multibroker.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("namebindings.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("namestore.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("naming-authz.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("pmirm.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("variables.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("virtualhosts.xml"), CopyDocumentProcessor.class));
        vector.add(LIBRARIES_FILE_MAPPING);
        vector.add(new BasicTransformMapping(new TransformMappingKey("coregroupbridge.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("sibws-webservices.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("sibws-wssecurity.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("resources-pme.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("resources-pme502.xml"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("amwas.amjacc.template.properties"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("amwas.pdjlog.template.properties"), CopyDocumentProcessor.class));
        vector.add(new BasicTransformMapping(new TransformMappingKey("filter.policy"), CopyDocumentProcessor.class));
    }

    protected void populateNodeLevelTransform(DocumentTransform documentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"populateNodeLevelTransforms", (Object)documentTransform);
        String string = ((ProfileImpl)this.getScenario().getNewProductImage().getProfile()).getOwningNodeName();
        Vector vector = documentTransform.getChild("nodes").getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            DocumentTransform documentTransform2 = (DocumentTransform)vector.get(i);
            if (!documentTransform2.getName().equals(string)) continue;
            Tr.debug((TraceComponent)_tc, (String)("Population Transforms for owning node: " + documentTransform2.getName()));
            this.populateOwningNodeLevelTransforms(documentTransform2);
        }
    }

    protected void populateOwningNodeLevelTransforms(DocumentTransform documentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"populateOwningNodeLevelTransforms", (Object)documentTransform);
        this.initOwningNodeDocumentTransforms(documentTransform.getTransformMappings());
        Vector vector = documentTransform.getChild("servers").getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            DocumentTransform documentTransform2 = (DocumentTransform)vector.get(i);
            if (this.isServerSupported(documentTransform2.getOldDocumentCollection())) {
                Tr.debug((TraceComponent)_tc, (String)("Populating server level Transforms for level: " + documentTransform2.getName()));
                this.initOwningServerDocumentTransforms(documentTransform2.getTransformMappings());
                continue;
            }
            Tr.debug((TraceComponent)_tc, (String)("Not populating server " + documentTransform2.getName() + ".  serverType not supported."));
        }
    }

    protected void initClustersDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initClustersDocumentTransforms", (Object)vector);
        vector.add(RESOURCE_CLUSTER_FILE_MAPPING);
        vector.add(new BasicTransformMapping(new TransformMappingKey("cluster.xml"), CopyDocumentProcessor.class));
    }

    protected void initNodeGroupDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initNodeGroupDocumentTransforms", (Object)vector);
        vector.add(new BasicTransformMapping(new TransformMappingKey("nodegroup.xml"), CopyDocumentProcessor.class));
    }

    protected void initOwningNodeDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initOwningNodeDocumentTransforms", (Object)vector);
        super.initNodeDocumentTransforms(vector);
        vector.add(NODE_FILE_MAPPING);
        for (int i = 0; i < vector.size(); ++i) {
            TransformMappingKey transformMappingKey;
            TransformMapping transformMapping = (TransformMapping)vector.get(i);
            if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
                Tr.debug((TraceComponent)_tc, (String)"Replacing ResourceConfig DocumentProcessor with ...Federated.ResourceConfig DocumentProcessor.");
                transformMappingKey = new TransformMappingKey("resources.xml");
                this.replaceDocumentProcessor(transformMapping, transformMappingKey, class$com$ibm$ws$migration$postupgrade$Federated$ResourceConfig == null ? ConfigTransactionalDocumentTransform.class$("com.ibm.ws.migration.postupgrade.Federated.ResourceConfig") : class$com$ibm$ws$migration$postupgrade$Federated$ResourceConfig);
            } else {
                Tr.debug((TraceComponent)_tc, (String)"Replacing ResourceConfig DocumentProcessor with ...Federated.R60.ResourceConfig DocumentProcessor.");
                transformMappingKey = new TransformMappingKey("resources.xml");
                this.replaceDocumentProcessor(transformMapping, transformMappingKey, class$com$ibm$ws$migration$postupgrade$Federated$R60$ResourceConfig == null ? ConfigTransactionalDocumentTransform.class$("com.ibm.ws.migration.postupgrade.Federated.R60.ResourceConfig") : class$com$ibm$ws$migration$postupgrade$Federated$R60$ResourceConfig);
            }
            transformMappingKey = new TransformMappingKey("serverindex.xml");
            this.replaceDocumentProcessor(transformMapping, transformMappingKey, class$com$ibm$ws$migration$postupgrade$Federated$ServerIndexConfig == null ? ConfigTransactionalDocumentTransform.class$("com.ibm.ws.migration.postupgrade.Federated.ServerIndexConfig") : class$com$ibm$ws$migration$postupgrade$Federated$ServerIndexConfig);
        }
    }

    protected void initOwningServerDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initOwningServerDocumentTransforms", (Object)vector);
        super.initServerDocumentTransforms(vector);
        for (int i = 0; i < vector.size(); ++i) {
            TransformMappingKey transformMappingKey;
            TransformMapping transformMapping = (TransformMapping)vector.get(i);
            TransformMappingKey transformMappingKey2 = new TransformMappingKey("server.xml");
            this.replaceDocumentProcessor(transformMapping, transformMappingKey2, class$com$ibm$ws$migration$postupgrade$Federated$ServerConfig == null ? ConfigTransactionalDocumentTransform.class$("com.ibm.ws.migration.postupgrade.Federated.ServerConfig") : class$com$ibm$ws$migration$postupgrade$Federated$ServerConfig);
            if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
                Tr.debug((TraceComponent)_tc, (String)"Replacing ResourceConfig DocumentProcessor with ...Federated.ResourceConfig DocumentProcessor.");
                transformMappingKey = new TransformMappingKey("resources.xml");
                this.replaceDocumentProcessor(transformMapping, transformMappingKey, class$com$ibm$ws$migration$postupgrade$Federated$ResourceConfig == null ? ConfigTransactionalDocumentTransform.class$("com.ibm.ws.migration.postupgrade.Federated.ResourceConfig") : class$com$ibm$ws$migration$postupgrade$Federated$ResourceConfig);
                continue;
            }
            Tr.debug((TraceComponent)_tc, (String)"Replacing ResourceConfig DocumentProcessor with ...Federated.R60.ResourceConfig DocumentProcessor.");
            transformMappingKey = new TransformMappingKey("resources.xml");
            this.replaceDocumentProcessor(transformMapping, transformMappingKey, class$com$ibm$ws$migration$postupgrade$Federated$R60$ResourceConfig == null ? ConfigTransactionalDocumentTransform.class$("com.ibm.ws.migration.postupgrade.Federated.R60.ResourceConfig") : class$com$ibm$ws$migration$postupgrade$Federated$R60$ResourceConfig);
        }
    }
}

