/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.Federated;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class DMgrConnectionInfo {
    public static final String ADMINCLIENTPROCESSTYPEPROPERTY = "processType";
    public static final String ADMINCLIENTVERSIONPROPERTY = "version";
    public static final String ValidAdminClientProcessType = "DeploymentManager";
    public static final String ValidAdminClientMinimumVersion = "6.1";
    private static TraceComponent _tc = Tr.register((Class)DMgrConnectionInfo.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static final String SOAP_PORT = "SOAP_PORT";
    private static final String SOAP_HOST = "SOAP_HOST";
    private static final String RMI_PORT = "RMI_PORT";
    private static final String RMI_HOST = "RMI_HOST";
    private static boolean _isGlobalSecurityEnabled = false;
    private static String _globalSecurityUserID = null;
    private static String _globalSecurityPassword = null;
    private static String _keyStore = null;
    private static String _keyStorePassword = null;
    private static String _keyStoreType = null;
    private static String _trustStore = null;
    private static String _trustStorePassword = null;
    private static String _trustStoreType = null;
    private Configuration _configuration = null;
    private HashMap _connInfo = new HashMap();
    private Properties _DMConnectProps = null;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$serverindex$ServerIndex;

    public DMgrConnectionInfo(Configuration configuration) {
        Tr.entry((TraceComponent)_tc, (String)"DMgrConnectionINfo", (Object)new Object[]{configuration});
        this._configuration = configuration;
        this.gatherJMXConnInfo();
    }

    private void gatherJMXConnInfo() {
        Tr.entry((TraceComponent)_tc, (String)"gatherJMXConnInfo");
        try {
            File file = new File(this._configuration.getCellDirectory(), "nodes");
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() || !this._configuration.isDeploymentManagerNode(fileArray[i])) continue;
                ServerIndex serverIndex = (ServerIndex)this._configuration.locateConfigFileObject(new File(fileArray[i], "serverindex.xml"), class$com$ibm$websphere$models$config$serverindex$ServerIndex == null ? DMgrConnectionInfo.class$("com.ibm.websphere.models.config.serverindex.ServerIndex") : class$com$ibm$websphere$models$config$serverindex$ServerIndex);
                EList eList = serverIndex.getServerEntries();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry = (ServerEntry)iterator.next();
                    if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                    EList eList2 = serverEntry.getSpecialEndpoints();
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        EndPoint endPoint;
                        NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                        String string = namedEndPoint.getEndPointName();
                        if (string.equals("SOAP_CONNECTOR_ADDRESS")) {
                            endPoint = namedEndPoint.getEndPoint();
                            this._connInfo.put(SOAP_PORT, new Integer(endPoint.getPort()).toString());
                            this._connInfo.put(SOAP_HOST, endPoint.getHost());
                        }
                        if (!string.equals("BOOTSTRAP_ADDRESS")) continue;
                        endPoint = namedEndPoint.getEndPoint();
                        this._connInfo.put(RMI_PORT, new Integer(endPoint.getPort()).toString());
                        this._connInfo.put(RMI_HOST, endPoint.getHost());
                    }
                }
                this.processSecurityFile();
                this.processSOAPClientProps();
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)exception.toString());
        }
    }

    public void initializeAdminClient() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"initializeAdminClient");
        Properties properties = new Properties();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (this._connInfo.containsKey(SOAP_PORT)) {
            string = "SOAP";
            string2 = (String)this._connInfo.get(SOAP_HOST);
            string3 = (String)this._connInfo.get(SOAP_PORT);
            string4 = "com.ibm.SOAP.requestTimeout";
        } else if (this._connInfo.containsKey(RMI_PORT)) {
            string = "RMI";
            string2 = (String)this._connInfo.get(RMI_HOST);
            string3 = (String)this._connInfo.get(RMI_PORT);
            string4 = "com.ibm.CORBA.RequestTimeout";
        }
        Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: host=" + string2));
        properties.setProperty("host", string2);
        Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: type=" + string));
        properties.setProperty("type", string);
        Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: port=" + string3));
        properties.setProperty("port", string3);
        properties.setProperty("securityEnabled", new Boolean(_isGlobalSecurityEnabled).toString());
        Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: securityEnabled=" + new Boolean(_isGlobalSecurityEnabled).toString()));
        properties.setProperty("autoAcceptSignerForThisConnectionOnly", "true");
        if (_isGlobalSecurityEnabled) {
            properties.setProperty("username", _globalSecurityUserID);
            properties.setProperty("password", _globalSecurityPassword);
            properties.setProperty("javax.net.ssl.keyStore", _keyStore);
            properties.setProperty("javax.net.ssl.keyStorePassword", _keyStorePassword);
            Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: javax.net.ssl.keyStore = " + _keyStore));
            if (_keyStoreType != null) {
                properties.setProperty("com.ibm.ssl.keyStoreType", _keyStoreType);
                Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: com.ibm.ssl.keyStoreType = " + _keyStoreType));
            }
            properties.setProperty("javax.net.ssl.trustStore", _trustStore);
            properties.setProperty("javax.net.ssl.trustStorePassword", _trustStorePassword);
            Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: javax.net.ssl.trustStore = " + _trustStore));
            if (_trustStoreType != null) {
                properties.setProperty("com.ibm.ssl.trustStoreType", _trustStoreType);
                Tr.debug((TraceComponent)_tc, (String)("Initialize AdminClient: com.ibm.ssl.trustStoreType = " + _trustStoreType));
            }
        }
        try {
            AdminClientFactory.createAdminClient((Properties)properties);
            AdminClient adminClient = AdminClientFactory.createAdminClient((Properties)properties);
            Hashtable<String, String> hashtable = adminClient.getServerMBean().getKeyPropertyList();
            String string5 = hashtable.get(ADMINCLIENTPROCESSTYPEPROPERTY);
            String string6 = hashtable.get(ADMINCLIENTVERSIONPROPERTY);
            if (!ValidAdminClientProcessType.equals(string5)) {
                Tr.debug((TraceComponent)_tc, (String)("Error: DMGR process type=(" + string5 + ") is invalid for federated migration"));
                String string7 = LoggerImpl.get_nls().getString("advise.incorrect.repository.connection", "Incorrect Deployment Manager connection established.");
                UpgradeBase.get_logger().println(string7);
                throw new UpgradeException(string7, null, false);
            }
            if (string6 != null && !string6.toString().startsWith(ValidAdminClientMinimumVersion)) {
                Tr.debug((TraceComponent)_tc, (String)("Error: DMGR version=(" + string5 + ") is not at the correct minimum level of (" + ValidAdminClientMinimumVersion + ")"));
                String string8 = LoggerImpl.get_nls().getString("advise.incorrect.repository.connection", "Incorrect Deployment Manager connection established.");
                throw new UpgradeException(string8, null, false);
            }
            this._DMConnectProps = properties;
        }
        catch (ConnectorException connectorException) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.failed.jmx.connection", new Object[]{string2, string, string3}, "Failed to establish JMX connection with DeploymentManager node {0} using connector type of {1} on port {2}.  WASPostMigration will now exit.  No changes have been made to the local WebSphere Application Server environment."));
            throw new UpgradeException(connectorException);
        }
    }

    public Properties getDMConnectProps() {
        Tr.entry((TraceComponent)_tc, (String)"getDMConnectProps");
        return this._DMConnectProps;
    }

    private void processSecurityFile() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"processSecurityFile");
        File file = new File(this._configuration.getCellDirectory(), "security.xml");
        Security security = (Security)this._configuration.locateConfigFileObject(file, Security.class);
        _isGlobalSecurityEnabled = security.isEnabled();
        if (WASPostUpgrade.get_userName() != null) {
            _isGlobalSecurityEnabled = security.isEnabled();
            _globalSecurityUserID = WASPostUpgrade.get_userName();
            _globalSecurityPassword = WASPostUpgrade.get_password();
        } else if (_isGlobalSecurityEnabled) {
            UserRegistry userRegistry = security.getActiveUserRegistry();
            _globalSecurityUserID = userRegistry.getServerId();
            _globalSecurityPassword = userRegistry.getServerPassword();
        }
    }

    private void processSOAPClientProps() throws UpgradeException {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"processSOAPClientProps");
        Properties properties = new Properties();
        File file = null;
        if (WASPostUpgrade.is_wasPostUpgrade()) {
            object = UpgradeBase.get_oldOSInfo().getProfileName();
            Tr.debug((TraceComponent)_tc, (String)("oldProfileName is " + (String)object));
            String string = WASPostUpgrade.get_oldInstanceName();
            Tr.debug((TraceComponent)_tc, (String)("oldInstanceName is " + string));
            if (UpgradeBase.get_oldOSInfo().releaseVersion().isR50() || UpgradeBase.get_oldOSInfo().releaseVersion().isR51() || OSInfoFactory.isISeries()) {
                if (string == null) {
                    Tr.debug((TraceComponent)_tc, (String)"Not migrating v5.x instance");
                    file = new File(new File(new File(UpgradeBase.get_backupDirectory().getAbsolutePath(), "websphere_backup"), "properties"), "soap.client.props");
                } else {
                    Tr.debug((TraceComponent)_tc, (String)"Migrating a v5.x instance");
                    file = new File(new File(new File(new File(UpgradeBase.get_backupDirectory().getAbsolutePath(), "profiles"), string), "properties"), "soap.client.props");
                }
            } else {
                Tr.debug((TraceComponent)_tc, (String)"Old release is v6.x");
                file = new File(new File(new File(new File(UpgradeBase.get_backupDirectory().getAbsolutePath(), "profiles"), (String)object), "properties"), "soap.client.props");
            }
        } else {
            file = new File(this._configuration.getPropertiesDirectory(), "soap.client.props");
        }
        Tr.debug((TraceComponent)_tc, (String)("soap.client.props in use: " + file.getAbsolutePath()));
        try {
            object = new FileInputStream(file);
            properties.load((InputStream)object);
        }
        catch (Exception exception) {
            Tr.entry((TraceComponent)_tc, (String)("Unable to load soap.client.properties while trying to establish a connection " + exception));
        }
        _keyStore = properties.getProperty("com.ibm.ssl.keyStore");
        Tr.entry((TraceComponent)_tc, (String)("set _keyStore to " + _keyStore));
        _keyStorePassword = properties.getProperty("com.ibm.ssl.keyStorePassword");
        _keyStoreType = properties.getProperty("com.ibm.ssl.keyStoreType");
        Tr.entry((TraceComponent)_tc, (String)("set _keyStoreType to " + _keyStoreType));
        _trustStore = properties.getProperty("com.ibm.ssl.trustStore");
        Tr.entry((TraceComponent)_tc, (String)("set _trustStore to " + _trustStore));
        _trustStorePassword = properties.getProperty("com.ibm.ssl.trustStorePassword");
        _trustStoreType = properties.getProperty("com.ibm.ssl.trustStoreType");
        Tr.entry((TraceComponent)_tc, (String)("set _trustStoreType to " + _trustStoreType));
    }
}

