/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.Federated;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.Iterator;
import java.util.List;

public class SecurityConfig
extends com.ibm.ws.migration.postupgrade.common.SecurityConfig {
    private static TraceComponent _tc = Tr.register((Class)SecurityConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static String _keyStoreNodeName = "SSLConfigNodeAlias_key";
    protected static String _trustStoreNodeName = "SSLConfigNodeAlias_trust";

    public SecurityConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
    }

    public void processContents(List list, List list2) throws Exception {
        String string;
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"processContents");
        Security security = (Security)list.get(0);
        list2.set(0, security);
        super.processContents(list, list2);
        Security security2 = (Security)list2.get(0);
        Iterator iterator = security2.getKeyStores().iterator();
        while (iterator.hasNext()) {
            object = (KeyStore)iterator.next();
            string = object.getLocation();
            if (string == null) continue;
            try {
                this.processPath(string);
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)("Can not process path: " + string), (Object)exception);
            }
        }
        object = security2.getRepertoire().iterator();
        while (object.hasNext()) {
            string = (SSLConfig)object.next();
            String string2 = string.getSetting().getKeyFileName();
            String string3 = string.getSetting().getTrustFileName();
            try {
                if (string2 != null) {
                    this.processPath(string2);
                }
                if (string3 == null) continue;
                this.processPath(string3);
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Failed to run processPath ", (Object)exception);
            }
        }
    }

    public KeyStore getKeyStore(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getKeyStore", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        KeyStore keyStore = null;
        SslFactory sslFactory = SslPackage.eINSTANCE.getSslFactory();
        if (bl) {
            String string = secureSocketLayer.getKeyFileName();
            boolean bl2 = secureSocketLayer.isEnableCryptoHardwareSupport();
            if (bl2) {
                keyStore = this.convertCryptoHardwareToken(secureSocketLayer);
            } else if (string != null) {
                keyStore = sslFactory.createKeyStore();
                ++_keyStoreCount;
                if (this.getSystemSSL() && !this.getDaemonConfig()) {
                    string = SecurityConfig.updateRACFlocation(string);
                    secureSocketLayer.setKeyFilePassword("password");
                    secureSocketLayer.setKeyFileFormat(KeyFileFormatKind.JCERACFKS_LITERAL);
                }
                boolean bl3 = true;
                String string2 = secureSocketLayer.getKeyFileFormat().getName();
                if (string2.equals("JCERACFKS") || string2.equals("JCE4758KS")) {
                    bl3 = false;
                }
                keyStore.setLocation(string);
                keyStore.setPassword(secureSocketLayer.getKeyFilePassword());
                keyStore.setType(string2);
                keyStore.setFileBased(bl3);
                keyStore.setInitializeAtStartup(false);
                keyStore.setManagementScope(_managementScope);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(_keyStoreNodeName);
                stringBuffer.append("_");
                stringBuffer.append(_keyStoreCount);
                keyStore.setName(stringBuffer.toString());
            }
        }
        return keyStore;
    }

    public KeyStore getTrustStore(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        String string;
        Tr.entry((TraceComponent)_tc, (String)"getTrustStore", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        KeyStore keyStore = null;
        SslFactory sslFactory = SslPackage.eINSTANCE.getSslFactory();
        if (bl && (string = secureSocketLayer.getTrustFileName()) != null) {
            keyStore = sslFactory.createKeyStore();
            ++_trustStoreCount;
            boolean bl2 = true;
            boolean bl3 = secureSocketLayer.isEnableCryptoHardwareSupport();
            String string2 = secureSocketLayer.getKeyFileFormat().toString();
            if (bl3 || string2.equals("JCERACFKS") || string2.equals("JCE4758KS")) {
                bl2 = false;
            }
            keyStore.setLocation(string);
            keyStore.setPassword(secureSocketLayer.getTrustFilePassword());
            keyStore.setType(string2);
            keyStore.setFileBased(bl2);
            keyStore.setInitializeAtStartup(false);
            keyStore.setManagementScope(_managementScope);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(_trustStoreNodeName);
            stringBuffer.append("_");
            stringBuffer.append(_trustStoreCount);
            keyStore.setName(stringBuffer.toString());
        }
        return keyStore;
    }
}

