/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.Federated;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroupMember;
import com.ibm.websphere.models.config.topology.nodegroup.NodegroupFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ServerIndexConfig
extends com.ibm.ws.migration.postupgrade.common.ServerIndexConfig {
    private static TraceComponent _tc = Tr.register((Class)ServerIndexConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static Vector endPointsToUpdate = new Vector();

    public ServerIndexConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
    }

    public void migrate() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        super.migrate();
        this.addToDefaultNodeGroup();
        WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getNewDocumentCollection().openDocument("serverindex.xml", WCCMDocument.class, false, false);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        EList eList = serverIndex.getEndPointRefs();
        Tr.debug((TraceComponent)_tc, (String)("Size of the existing endPoint refs is: " + eList.size()));
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            Tr.debug((TraceComponent)_tc, (String)("Processing server entry: " + serverEntry.getServerName()));
            if (!serverEntry.getServerType().equals("NODE_AGENT")) continue;
            Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
            Tr.debug((TraceComponent)_tc, (String)"Got a NodeAgent");
            while (iterator2.hasNext()) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                String string = namedEndPoint.getEndPointName();
                Tr.debug((TraceComponent)_tc, (String)("Processing named end point: " + string));
                if (!endPointsToUpdate.contains(string) || eList.contains(namedEndPoint)) continue;
                eList.add(namedEndPoint);
                Tr.debug((TraceComponent)_tc, (String)"Adding endpoint");
            }
        }
        wCCMDocument.close();
    }

    public void addToDefaultNodeGroup() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addToDefaultNodeGroup");
        if (!((ReleaseVersionImpl)this.getTransform().getScenario().getOldProductImage().getReleaseVersion()).isR60()) {
            NodeGroupMember nodeGroupMember;
            String string = this.getTransform().getNewDocumentCollection().getName();
            WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getNewDocumentCollection().getParent().getParent().getChild("nodegroups").getChild("DefaultNodeGroup").openDocument("nodegroup.xml", WCCMDocument.class, true, false);
            NodeGroup nodeGroup = (NodeGroup)UtilityImpl.locateConfigFileObject(wCCMDocument, NodeGroup.class);
            Iterator iterator = nodeGroup.getMembers().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                nodeGroupMember = (NodeGroupMember)iterator.next();
                if (!nodeGroupMember.getNodeName().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                nodeGroupMember = NodegroupFactory.eINSTANCE.createNodeGroupMember();
                nodeGroupMember.setNodeName(string);
                nodeGroup.getMembers().add((Object)nodeGroupMember);
            }
            wCCMDocument.close();
        }
    }

    public List getDeployedApplications(boolean bl, ServerEntry serverEntry) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getDeployedApplications", (Object)new Object[]{new Boolean(bl), serverEntry});
        if (!WASPostUpgrade.get_includeApps().equals("false")) {
            EList eList = serverEntry.getDeployedApplications();
            if (!eList.isEmpty()) {
                Object[] objectArray = new String[eList.size()];
                eList.toArray(objectArray);
                String string = serverEntry.getServerName();
                String[] stringArray = this.getAppsToExclude(string);
                block0: for (int i = 0; i < objectArray.length; ++i) {
                    Tr.debug((TraceComponent)_tc, (String)("The apps deploy information is " + (String)objectArray[i]));
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!((String)objectArray[i]).startsWith(stringArray[j])) continue;
                        eList.remove(objectArray[i]);
                        Tr.debug((TraceComponent)_tc, (String)("Removed the deployInfo from the Deployed Applications EList " + (String)objectArray[i]));
                        continue block0;
                    }
                }
            }
            return eList;
        }
        return new BasicEList();
    }

    protected String[] getAppsToExclude(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getAppsToExclude", (Object)string);
        String string2 = this.getTransform().getOldDocumentCollection().getName();
        String[] stringArray = new String[]{"UDDIRegistry." + string2 + "." + string + ".ear", "wsgw." + string + "." + string2 + ".ear", "wsgwauth." + string + "." + string2 + ".ear", "wsgwsoap1." + string + "." + string2 + ".ear", "wsgwsoap2." + string + "." + string2 + ".ear", "wsgwsoaphttp1." + string + "." + string2 + ".ear", "wsgwsoaphttp2." + string + "." + string2 + ".ear", "wsgwsoapjms1." + string + "." + string2 + ".ear", "wsgwsoapjms2." + string + "." + string2 + ".ear"};
        return stringArray;
    }

    public boolean arePrimaryKeysEqual(ServerEntry serverEntry, ServerEntry serverEntry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + serverEntry.getClass().getName()));
        boolean bl = super.arePrimaryKeysEqual(serverEntry, serverEntry2);
        if (bl) {
            try {
                this._configHelper.addHAManagerSettings(this.getTransform().getNewDocumentCollection().getChild("servers").getChild(serverEntry2.getServerName()), (WCCMDocument)this.getNewDocument(), serverEntry2.getServerName());
            }
            catch (Exception exception) {
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.unable.to.add.to.coregroup", new Object[]{serverEntry2.getServerName()}, "Unable to add server {0} to the default coregroup");
                UpgradeBase.get_logger().println(string);
                UpgradeBase.get_logger().printStackTrace(exception);
            }
        }
        return bl;
    }

    static {
        endPointsToUpdate.add("NODE_MULTICAST_DISCOVERY_ADDRESS");
        endPointsToUpdate.add("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS");
        endPointsToUpdate.add("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
        endPointsToUpdate.add("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
        endPointsToUpdate.add("ORB_LISTENER_ADDRESS");
        endPointsToUpdate.add("NODE_DISCOVERY_ADDRESS");
    }
}

