/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.Federated;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.ConfigDocumentCollectionFederatedPostImpl;
import com.ibm.ws.migration.postupgrade.Federated.SyncInvoker;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.util.Properties;

public class SyncNodeAgent {
    private static TraceComponent _tc = Tr.register((Class)SyncNodeAgent.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static boolean _isGlobalSecurityEnabled = false;
    private static final String SYNCNODE_COMMAND = "syncNode";
    private static final String CONNTYPE_ATTR = "-conntype";
    private static final String USERNAME_ATTR = "-username";
    private static final String PASSWORD_ATTR = "-password";
    private static final String CONNTYPE_SOAP = "SOAP";
    private static final String CONNTYPE_RMI = "RMI";
    private String _soapHost = null;
    private String _soapPort = null;
    private String _rmiHost = null;
    private String _rmiPort = null;
    private String _userName = null;
    private String _password = null;
    private Properties _remoteConnectionProperties = null;

    public SyncNodeAgent(ConfigDocumentCollectionFederatedPostImpl configDocumentCollectionFederatedPostImpl) {
        this._remoteConnectionProperties = configDocumentCollectionFederatedPostImpl.getRemoteConnectionProperties();
    }

    public void syncWithDM() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"syncWithDM");
        UpgradeBase.get_newOSInfo().changeOwnership(WASPostUpgrade.get_configRoot());
        SyncInvoker syncInvoker = new SyncInvoker(UpgradeBase.get_newOSInfo());
        String string = null;
        int n = -1;
        UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.synchronize.attempt", new Object[]{this._remoteConnectionProperties.get("type")}, "Attempting to synchronize with DeploymentManager using the {0} protocol."));
        string = this.createCommandString(SYNCNODE_COMMAND);
        n = syncInvoker.exec(string, SYNCNODE_COMMAND, CONNTYPE_SOAP);
        if (n != -1) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.synchronize.attempt.successful", "Synchronization with DeploymentManager successful."));
        }
    }

    private String createCommandString(String string) {
        Tr.entry((TraceComponent)_tc, (String)"createCommandString", (Object)string);
        File file = new File(new File(UpgradeBase.get_userRoot(), "bin"), string + UpgradeBase.get_newOSInfo().fetchExecutableExtension());
        StringBuffer stringBuffer = new StringBuffer(FileUtilities.quotedFileName(file.getAbsolutePath()));
        stringBuffer.append(" ");
        stringBuffer.append(UpgradeBase.get_newOSInfo().instance()).append(" ");
        stringBuffer.append(this._remoteConnectionProperties.get("host")).append(" ").append(this._remoteConnectionProperties.get("port")).append(" ");
        stringBuffer.append(CONNTYPE_ATTR).append(" ").append(this._remoteConnectionProperties.get("type")).append(" ");
        if (this._remoteConnectionProperties.get("securityEnabled").equals("true")) {
            stringBuffer.append(USERNAME_ATTR).append(" ").append(this._remoteConnectionProperties.get("username")).append(" ");
            stringBuffer.append(PASSWORD_ATTR).append(" ").append(this._remoteConnectionProperties.get("password")).append(" ");
        }
        if (UpgradeBase.get_cmdLineArgs() != null) {
            String string2 = (String)UpgradeBase.get_cmdLineArgs().get("-traceString");
            boolean bl = OSInfoFactory.isZSeries();
            if (!bl || bl && string2 != null && string2.indexOf("*=all=disabled") == -1) {
                stringBuffer.append("-trace");
            }
        }
        return stringBuffer.toString();
    }
}

