/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.Federated;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.wsspi.migration.document.DocumentCollection;

public class UploadConfigRepository {
    private static TraceComponent _tc = Tr.register((Class)UploadConfigRepository.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static DocumentContentSource[] _documentsBeforeUpload = null;
    private ConfigRepository _dmgrRepository = null;
    private ConfigRepository _federatedRepository = null;
    private String _owningNodeName = null;
    private DocumentCollection _newDocumentCollection = null;
    private DocumentCollection _oldDocumentCollection = null;
    private boolean _rollbackEnabled = false;

    public UploadConfigRepository(ConfigRepository configRepository, ConfigRepository configRepository2, String string, String string2, DocumentCollection documentCollection, DocumentCollection documentCollection2) {
        Tr.entry((TraceComponent)_tc, (String)"UploadConfigRepository", (Object)new Object[]{configRepository, configRepository2, string, string2, documentCollection, documentCollection2});
        this._dmgrRepository = configRepository;
        this._federatedRepository = configRepository2;
        this._owningNodeName = string;
        this._newDocumentCollection = documentCollection;
        this._oldDocumentCollection = documentCollection2;
    }

    public void upload() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"upload");
        this.prepareForRollback();
        String string = this._oldDocumentCollection.getChild("cells").getChildren()[0].getName();
        String[] stringArray = this._federatedRepository.listResourceNames("cells/" + string + "/" + "nodegroups" + "/" + "DefaultNodeGroup", 1, Integer.MAX_VALUE);
        String[] stringArray2 = this._federatedRepository.listResourceNames("cells/" + string + "/" + "coregroups", 1, Integer.MAX_VALUE);
        String[] stringArray3 = this._federatedRepository.listResourceNames("cells/" + string + "/" + "buses", 1, Integer.MAX_VALUE);
        String[] stringArray4 = new String[]{"cells/" + string + "/" + "security.xml"};
        String[] stringArray5 = this._federatedRepository.listResourceNames("cells/" + string + "/" + "nodes" + "/" + this._owningNodeName, 1, Integer.MAX_VALUE);
        String[] stringArray6 = new String[stringArray.length + stringArray2.length + stringArray5.length + stringArray4.length + stringArray3.length];
        System.arraycopy(stringArray, 0, stringArray6, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray6, stringArray.length, stringArray2.length);
        System.arraycopy(stringArray5, 0, stringArray6, stringArray.length + stringArray2.length, stringArray5.length);
        System.arraycopy(stringArray4, 0, stringArray6, stringArray5.length + stringArray.length + stringArray2.length, stringArray4.length);
        System.arraycopy(stringArray3, 0, stringArray6, stringArray5.length + stringArray.length + stringArray2.length + stringArray4.length, stringArray3.length);
        DocumentContentSource[] documentContentSourceArray = this._federatedRepository.extract(stringArray6);
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            DocumentContentSource documentContentSource = documentContentSourceArray[i];
            String string2 = documentContentSource.getDocument().getURI();
            try {
                DocumentContentSource documentContentSource2 = this._dmgrRepository.extract(string2);
                documentContentSource2.setSource(documentContentSource.getSource());
                this._dmgrRepository.modify(documentContentSource2);
            }
            catch (RepositoryException repositoryException) {
                DocumentContentSource documentContentSource3 = new DocumentContentSource(new Document(string2), documentContentSource.getSource());
                this._dmgrRepository.create(documentContentSource3);
            }
            this._rollbackEnabled = true;
        }
    }

    public void prepareForRollback() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"prepareForRollback");
        String string = this._oldDocumentCollection.getChild("cells").getChildren()[0].getName();
        String[] stringArray = this._dmgrRepository.listResourceNames("cells/" + string + "/" + "nodegroups" + "/" + "DefaultNodeGroup", 1, Integer.MAX_VALUE);
        String[] stringArray2 = this._dmgrRepository.listResourceNames("cells/" + string + "/" + "coregroups" + "/" + "DefaultCoreGroup", 1, Integer.MAX_VALUE);
        String[] stringArray3 = new String[]{"cells/" + string + "/" + "security.xml"};
        String[] stringArray4 = this._dmgrRepository.listResourceNames("cells/" + string + "/" + "nodes" + "/" + this._owningNodeName, 1, Integer.MAX_VALUE);
        String[] stringArray5 = new String[stringArray.length + stringArray2.length + stringArray4.length + stringArray3.length];
        System.arraycopy(stringArray, 0, stringArray5, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray5, stringArray.length, stringArray2.length);
        System.arraycopy(stringArray4, 0, stringArray5, stringArray.length + stringArray2.length, stringArray4.length);
        System.arraycopy(stringArray3, 0, stringArray5, stringArray4.length + stringArray2.length + stringArray.length, stringArray3.length);
        _documentsBeforeUpload = this._dmgrRepository.extract(stringArray5);
    }

    public void rollback() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"rollback");
        if (this._rollbackEnabled) {
            String string = this._oldDocumentCollection.getChild("cells").getChildren()[0].getName();
            String[] stringArray = this._dmgrRepository.listResourceNames("cells/" + string + "/" + "nodes" + "/" + this._owningNodeName, 1, Integer.MAX_VALUE);
            DocumentContentSource[] documentContentSourceArray = this._dmgrRepository.extract(stringArray);
            Document[] documentArray = new Document[documentContentSourceArray.length];
            for (int i = 0; i < documentArray.length; ++i) {
                documentArray[i] = documentContentSourceArray[i].getDocument();
            }
            Tr.debug((TraceComponent)_tc, (String)"Deleting node level files in the master repository");
            this._dmgrRepository.update(new DocumentContentSource[0], new DocumentContentSource[0], documentArray);
            Tr.debug((TraceComponent)_tc, (String)"Recreating node level files in master repository");
            this._dmgrRepository.update(_documentsBeforeUpload, new DocumentContentSource[0], new Document[0]);
        }
    }
}

