/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.NetworkDeployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ApplicationInvoker;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ApplicationMigrationHelper
extends com.ibm.ws.migration.postupgrade.common.ApplicationMigrationHelper {
    private static TraceComponent _tc = Tr.register((Class)ApplicationMigrationHelper.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    public static final String EAR_SUFFIX = ".ear";
    protected static final String _uddiDisplayName = "UDDI Registry";
    protected static final String _uddiEarName = "uddi";
    protected static final String[] _uddiJarFiles = new String[]{"uddicloudscapeuserfunc.jar", "uddiresourcebundles.jar"};

    public ApplicationMigrationHelper(Scenario scenario) {
        super(scenario);
    }

    protected boolean installApplication(String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"installApplication", (Object)new Object[]{string, string2});
        try {
            String string3;
            Iterator iterator = _deploymentObjectMappings.keySet().iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (!string2.equals(string3)) continue;
                _deployment = (Deployment)_deploymentObjectMappings.get(string3);
                break;
            }
            string3 = this.getExecutableString(string, string2);
            if (WASPostUpgrade.get_includeApps().equals("true")) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.using.wsadmin", new Object[]{string2}, "Using wsadmin to deploy the application {0}."));
                int n = new ApplicationInvoker(UpgradeBase.get_newOSInfo()).exec(string3, "wsadmin");
                if (n != 0) {
                    UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.unable.to.deploy.app", new Object[]{string2}, "Unable to deploy the application {0}."));
                    return false;
                }
                String string4 = this._scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getUrl().getPath();
                String string5 = this._scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getUrl().getPath();
                boolean bl = false;
                if (string2.toLowerCase().startsWith("uddiregistry.") && string2.toLowerCase().endsWith(EAR_SUFFIX)) {
                    Tr.debug((TraceComponent)_tc, (String)("The ear file " + string2 + " is the UDDI Registry application"));
                    bl = true;
                }
                if (bl && (((ReleaseVersionImpl)this._scenario.getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this._scenario.getOldProductImage().getReleaseVersion()).isR51())) {
                    String string6 = string4 + "applications" + File.separator + string2;
                    Tr.debug((TraceComponent)_tc, (String)("The new deployed app location is " + string6));
                    String string7 = string5 + "applications" + File.separator + string2;
                    Tr.debug((TraceComponent)_tc, (String)("The old deployed app location is " + string7));
                    this.copyUddiJarFiles(string6, string7);
                }
            }
        }
        catch (Exception exception) {
            String string8 = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string8, exception);
        }
        return true;
    }

    protected void copyUddiJarFiles(String string, String string2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyUddiJarFiles", (Object)new Object[]{string, string2});
        for (int i = 0; i < _uddiJarFiles.length; ++i) {
            Tr.debug((TraceComponent)_tc, (String)("The jar file in the list is " + _uddiJarFiles[i]));
            File file = new File(string2, _uddiJarFiles[i]);
            if (file.exists()) {
                File file2 = new File(string, _uddiJarFiles[i]);
                Tr.debug((TraceComponent)_tc, (String)("Copying the jar file to " + file2.getAbsolutePath()));
                FileUtilities.copyFile(file, file2);
                continue;
            }
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.object.locate", new Object[]{file.getAbsolutePath(), "UDDI Jar File"}, "Unable to locate object {0} of type {1}."));
        }
    }

    protected boolean isGatewayOrUddiAppOnBase(String string) {
        Tr.entry((TraceComponent)_tc, (String)"isGatewayOrUddiAppOnBase", (Object)string);
        return false;
    }

    private static String removeNameSpaces(String string) {
        Tr.entry((TraceComponent)_tc, (String)"removeNameSpaces", (Object)new Object[]{string});
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    protected String getNodeName(ServerTarget serverTarget) {
        Tr.entry((TraceComponent)_tc, (String)"getNodeName", (Object)new Object[]{serverTarget});
        String string = serverTarget.getNodeName();
        Tr.debug((TraceComponent)_tc, (String)("Setting node name for app deployment on ND to " + string));
        return string;
    }

    public void updateAdminApps() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"updateAdminApps");
    }
}

