/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.NetworkDeployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ConfigurationWCCMFile;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.ISeriesInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.StopInvoker;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

public class DisableOldEnvironment {
    private static TraceComponent _tc = Tr.register((Class)DisableOldEnvironment.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static boolean _isGlobalSecurityEnabled = false;
    public static String STOP_MANAGER = "stopManager";
    public static String STOP_NODE = "stopNode";
    private static Scenario _scenario = null;

    public static void disableDmgr(Scenario scenario) {
        Tr.entry((TraceComponent)_tc, (String)"disableDmgr", (Object)scenario);
        _scenario = scenario;
        if (DisableOldEnvironment.disable(STOP_MANAGER)) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.deployment.manager.conflict", "Do not use the existing deployment manager in the old configuration. It has been disabled."));
        }
    }

    public static void disableNode(Scenario scenario) {
        Tr.entry((TraceComponent)_tc, (String)"disableNode", (Object)scenario);
        _scenario = scenario;
        if (DisableOldEnvironment.disable(STOP_NODE)) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.nodeagent.conflict", "Do not use the node agent in the old configuration. It has been disabled."));
        }
    }

    public static void stopAndDisableNodeIfItExists(Scenario scenario) throws UpgradeException {
        try {
            String string = STOP_NODE + UpgradeBase.get_oldOSInfo().fetchExecutableExtension();
            File file = new File(scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("bin").getAliasUrl().getFile(), string);
            if (file.exists()) {
                DisableOldEnvironment.stopNode(scenario);
                DisableOldEnvironment.disableNode(scenario);
            }
        }
        catch (NotFoundException notFoundException) {
        }
        catch (UpgradeException upgradeException) {
            throw upgradeException;
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
    }

    private static boolean renameOldServerIndex() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"renameOldServerIndex");
        String string = _scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getUrl().getFile();
        String string2 = ((ProfileImpl)_scenario.getOldProductImage().getProfile()).getOwningNodeName();
        String string3 = _scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
        File file = new File(new File(new File(new File(new File(string, "cells"), string3), "nodes"), string2), "serverindex.xml");
        String string4 = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - "serverindex.xml".length()) + "serverindex.xml_disabled";
        File file2 = new File(string4);
        if (!file2.exists() && file.exists()) {
            file2.createNewFile();
            FileUtilities.copyFile(file, file2);
            UpgradeBase.get_oldOSInfo().changeOwnership(file2);
            Configuration configuration = new Configuration(new File(string), string3, string2, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
            ConfigurationWCCMFile configurationWCCMFile = (ConfigurationWCCMFile)configuration.getConfigurationFile(file, false);
            ServerIndex serverIndex = configuration.locateServerIndex(file.getParentFile());
            Iterator iterator = serverIndex.getServerEntries().iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER") && !serverEntry.getServerType().equals("NODE_AGENT")) continue;
                Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
                while (iterator2.hasNext()) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                    namedEndPoint.getEndPoint().setHost("");
                    namedEndPoint.getEndPoint().setPort(0);
                }
                break block0;
            }
            configurationWCCMFile.close();
            DisableOldEnvironment.createJaclToReverseDisablement(string4);
            return true;
        }
        return false;
    }

    private static void createJaclToReverseDisablement(String string) throws Exception {
        File file;
        Tr.entry((TraceComponent)_tc, (String)"createJaclToReverseDisablement", (Object)string);
        File file2 = new File(_scenario.getOldProductImage().getProfile().getDocumentCollection().getUrl().getFile(), "bin");
        if (file2.exists() && !(file = new File(file2, "migrationDisablementReversal.jacl")).exists()) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("if { 1==[file exists " + FileUtilities.quotedFileName(string.replace('\\', '/')) + "] } {");
            bufferedWriter.newLine();
            String string2 = ((ProfileImpl)_scenario.getOldProductImage().getProfile()).getOwningNodeName();
            String string3 = _scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
            String string4 = _scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getChild("nodes").getChild(((ProfileImpl)_scenario.getOldProductImage().getProfile()).getOwningNodeName()).getUrl().getFile();
            bufferedWriter.write("file delete ");
            bufferedWriter.write(FileUtilities.quotedFileName(new File(string4, "serverindex.xml").getAbsolutePath().replace('\\', '/')));
            bufferedWriter.newLine();
            bufferedWriter.write("file rename -force ");
            bufferedWriter.write(FileUtilities.quotedFileName(string.replace('\\', '/')));
            bufferedWriter.write(" ");
            bufferedWriter.write(FileUtilities.quotedFileName(new File(string4, "serverindex.xml").getAbsolutePath().replace('\\', '/')));
            bufferedWriter.newLine();
            bufferedWriter.write("}");
            bufferedWriter.close();
        }
    }

    private static boolean disable(String string) {
        Tr.entry((TraceComponent)_tc, (String)"disable", (Object)string);
        try {
            return DisableOldEnvironment.renameOldServerIndex();
        }
        catch (UpgradeException upgradeException) {
            Tr.debug((TraceComponent)_tc, (String)("Received this exception, it is expected if the old configuration has already been disabled: " + upgradeException.getMessage()));
        }
        catch (Exception exception) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.unable.to.execute", new Object[]{exception.toString()}, "The migration function cannot run program: {0}."), exception);
        }
        return false;
    }

    public static void stopNode(Scenario scenario) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"stopNode", (Object)scenario);
        _scenario = scenario;
        int n = DisableOldEnvironment.stop(STOP_NODE);
        if (n < 0) {
            String string = LoggerImpl.get_nls().getFormattedMessage("usage.earmigrate.failure", new Object[]{STOP_NODE}, "MIGR0327E: A failure occurred with {0}.");
            throw new UpgradeException(string, null, false);
        }
    }

    public static void stopDmgr(Scenario scenario) {
        Tr.entry((TraceComponent)_tc, (String)"stopDmgr", (Object)scenario);
        _scenario = scenario;
        DisableOldEnvironment.stop(STOP_MANAGER);
    }

    private static boolean checkForPid(String string) {
        Tr.entry((TraceComponent)_tc, (String)"checkForPid", (Object)string);
        try {
            Serializable serializable;
            String string2 = null;
            if (((ReleaseVersionImpl)_scenario.getOldProductImage().getReleaseVersion()).isR60()) {
                string2 = _scenario.getOldProductImage().getProfile().getDocumentCollection().getAliasUrl().getPath();
            } else {
                serializable = FileUtilities.restoreHashTable(new File(UpgradeBase.get_backupDirectory(), "websphere_backup_cmd_line_args.ser"));
                string2 = (String)((Hashtable)serializable).get("-currentWASDirectory");
            }
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append(string2);
            ((StringBuilder)serializable).append(File.separator).append("logs").append(File.separator).append(string).append(File.separator).append(string).append(".pid");
            File file = new File(((StringBuilder)serializable).toString());
            if (file.exists()) {
                Tr.event((TraceComponent)_tc, (String)("checkForPid - Found " + ((StringBuilder)serializable).toString()));
                return true;
            }
            Tr.event((TraceComponent)_tc, (String)("checkForPid - Could not find " + ((StringBuilder)serializable).toString()));
            return false;
        }
        catch (Exception exception) {
            Tr.event((TraceComponent)_tc, (String)"Exception occurred in checkForPid", (Object)exception);
            return true;
        }
    }

    private static int stop(String string) {
        Tr.entry((TraceComponent)_tc, (String)"stopProcess", (Object)string);
        if (!DisableOldEnvironment.checkForPid(STOP_MANAGER.equals(string) ? "dmgr" : "nodeagent")) {
            Tr.event((TraceComponent)_tc, (String)"Could not find the corresponding .pid file. The corresponding server might be down");
            return 0;
        }
        String string2 = null;
        try {
            String string3 = _scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getUrl().getFile();
            String string4 = ((ProfileImpl)_scenario.getOldProductImage().getProfile()).getOwningNodeName();
            String string5 = _scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
            File file = new File(new File(new File(new File(new File(string3, "cells"), string5), "nodes"), string4), "serverindex.xml");
            if (file.exists()) {
                Object object;
                Hashtable hashtable = FileUtilities.restoreHashTable(new File(UpgradeBase.get_backupDirectory(), "websphere_backup_cmd_line_args.ser"));
                Object object2 = null;
                object2 = ((ReleaseVersionImpl)_scenario.getOldProductImage().getReleaseVersion()).isR60() ? new File(_scenario.getOldProductImage().getProfile().getDocumentCollection().getUrl().getFile()) : new File((String)hashtable.get("-currentWASDirectory"));
                ReleaseVersionImpl releaseVersionImpl = (ReleaseVersionImpl)_scenario.getOldProductImage().getReleaseVersion();
                if (System.getProperty("os.name").equals("OS/400")) {
                    if (releaseVersionImpl.isR50() || releaseVersionImpl.isR51()) {
                        object = new ISeriesInfo((File)object2, null, null);
                        object2 = new File(((ISeriesInfo)object).calculateInstallRoot().getAbsolutePath());
                    } else {
                        object2 = object = new File(_scenario.getOldProductImage().getProfile().getAliasUrl().getFile());
                    }
                    Tr.debug((TraceComponent)_tc, (String)("oldWebSphereDirectoryString is " + object2));
                }
                if (((File)(object2 = new File((File)object2, "bin"))).exists()) {
                    object = new StringBuffer(256).append(((File)object2).getAbsolutePath()).append(File.separator).append(string).append(UpgradeBase.get_oldOSInfo().fetchExecutableExtension());
                    object = new StringBuffer(FileUtilities.quotedFileName(((StringBuffer)object).toString()));
                    StringBuffer stringBuffer = ((StringBuffer)object).append(" ");
                    if (!OSInfoFactory.isISeries() || !releaseVersionImpl.isR60() && !releaseVersionImpl.isR61()) {
                        ((StringBuffer)object).append(UpgradeBase.get_oldOSInfo().instance());
                    }
                    ((StringBuffer)object).append(DisableOldEnvironment.processSecurityFile());
                    string2 = stringBuffer.toString();
                    Tr.debug((TraceComponent)_tc, (String)"Final string for executable: ", (Object)UtilityImpl.replacePassword(string2));
                    return new StopInvoker(UpgradeBase.get_oldOSInfo()).exec(string2, string);
                }
                Tr.error((TraceComponent)_tc, (String)("Cannot stop from directory: " + object2));
            }
        }
        catch (UpgradeException upgradeException) {
            Tr.debug((TraceComponent)_tc, (String)("Received this exception, it is expected if the old configuration has already been disabled: " + upgradeException.getMessage()));
            return 0;
        }
        catch (Exception exception) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.unable.to.execute", new Object[]{string2}, "The migration function cannot run program: {0}."), exception);
        }
        return -1;
    }

    private static String processSecurityFile() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processSecurityFile");
        WCCMDocument wCCMDocument = (WCCMDocument)_scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].openDocument("security.xml", WCCMDocument.class, false, true);
        Security security = (Security)UtilityImpl.locateConfigFileObject(wCCMDocument, Security.class);
        _isGlobalSecurityEnabled = security.isEnabled();
        StringBuffer stringBuffer = new StringBuffer();
        if (_isGlobalSecurityEnabled && WASPostUpgrade.get_userName() != null) {
            stringBuffer.append(" -username ").append(WASPostUpgrade.get_userName());
            stringBuffer.append(" -password ").append(WASPostUpgrade.get_password());
        } else if (_isGlobalSecurityEnabled) {
            UserRegistry userRegistry = security.getActiveUserRegistry();
            stringBuffer.append(" -username ").append(userRegistry.getServerId());
            stringBuffer.append(" -password ").append(userRegistry.getServerPassword());
        }
        wCCMDocument.close();
        return stringBuffer.toString();
    }
}

