/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.NetworkDeployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.HostFactory;
import com.ibm.websphere.models.config.host.HostPackage;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ServerConfig
extends com.ibm.ws.migration.postupgrade.common.ServerConfig {
    private static TraceComponent _tc = Tr.register((Class)ServerConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected ObjectRequestBroker _objectRequestBroker = null;
    protected int _httpTransport;
    protected int _httpsTransport;
    protected String _oldServerName;

    public ServerConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this.getProcessorHelper().addOverride(WebContainer.class, "setEnableServletCaching", new Class[]{Boolean.TYPE});
    }

    public void migrate() throws Exception {
        Property property;
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        super.migrate();
        Iterator iterator = this._objectRequestBroker.getProperties().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            property = (Property)iterator.next();
            if (!property.getName().equals("com.ibm.websphere.ObjectIDVersionCompatibility")) continue;
            bl = true;
        }
        if (!bl) {
            property = PropertiesFactory.eINSTANCE.createProperty();
            property.setName("com.ibm.websphere.ObjectIDVersionCompatibility");
            property.setValue("1");
            this._objectRequestBroker.getProperties().add((Object)property);
        }
    }

    public void processContents(List list, List list2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processContents");
        if (OSInfoFactory.isZSeries()) {
            this.getTransportPorts(list, list2);
        }
        super.processContents(list, list2);
        if (OSInfoFactory.isZSeries()) {
            this.updateEndPoints();
            this.updateVirtualHost();
            if (WASPostUpgrade.is_scriptCompatibility()) {
                this.disableAdminChains(list2);
            } else if (!WASPostUpgrade.is_wasPostUpgrade()) {
                this.enableAdminChains(list2);
            }
        }
    }

    public void getTransportPorts(List list, List list2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getTransportPorts", (Object)new Object[]{list, list2});
        Server server = (Server)list.get(0);
        this._oldServerName = server.getName();
        Iterator iterator = server.getComponents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ApplicationServer)) continue;
            ApplicationServer applicationServer = (ApplicationServer)e;
            Iterator iterator2 = applicationServer.getComponents().iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof WebContainer)) continue;
                WebContainer webContainer = (WebContainer)e2;
                Iterator iterator3 = webContainer.getTransports().iterator();
                while (iterator3.hasNext()) {
                    Object e3 = iterator3.next();
                    if (!(e3 instanceof HTTPTransport)) continue;
                    HTTPTransport hTTPTransport = (HTTPTransport)e3;
                    if (hTTPTransport.isSslEnabled()) {
                        this._httpsTransport = hTTPTransport.getAddress().getPort();
                        continue;
                    }
                    this._httpTransport = hTTPTransport.getAddress().getPort();
                }
            }
        }
    }

    protected void updateEndPoints() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"updateEndPoints");
        WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getNewDocumentCollection().getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, false);
        ServerIndex serverIndex = (ServerIndex)wCCMDocument.getList().get(0);
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string = serverEntry.getServerName();
            if (!string.equals(this._serverName)) continue;
            Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
            while (iterator2.hasNext()) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                if (namedEndPoint.getEndPointName().equals("WC_adminhost")) {
                    namedEndPoint.getEndPoint().setPort(this._httpTransport);
                    continue;
                }
                if (!namedEndPoint.getEndPointName().equals("WC_adminhost_secure")) continue;
                namedEndPoint.getEndPoint().setPort(this._httpsTransport);
            }
        }
        wCCMDocument.close();
    }

    protected void updateVirtualHost() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"updateVirtualHost");
        WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getNewDocumentCollection().getParent().getParent().getParent().getParent().openDocument("virtualhosts.xml", WCCMDocument.class, false, false);
        List list = wCCMDocument.getList();
        for (int i = 0; i < list.size(); ++i) {
            VirtualHost virtualHost = (VirtualHost)list.get(i);
            if (!virtualHost.getName().equals("admin_host")) continue;
            EList eList = virtualHost.getAliases();
            String string = String.valueOf(this._httpTransport);
            String string2 = String.valueOf(this._httpsTransport);
            HostFactory hostFactory = HostPackage.eINSTANCE.getHostFactory();
            HostAlias hostAlias = hostFactory.createHostAlias();
            hostAlias.setHostname("*");
            hostAlias.setPort(string);
            eList.add(hostAlias);
            HostAlias hostAlias2 = hostFactory.createHostAlias();
            hostAlias2.setHostname("*");
            hostAlias2.setPort(string2);
            eList.add(hostAlias2);
        }
        wCCMDocument.close();
    }

    public void setValue(Property property, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setValue", (Object)new Object[]{property, string});
        super.setValue(property, string);
        if (property.getName() != null && OSInfoFactory.isZSeries() && property.getName().equals("was.wlmTimeout")) {
            property.setValue("0");
        }
    }

    public boolean arePrimaryKeysEqual(ObjectRequestBroker objectRequestBroker, ObjectRequestBroker objectRequestBroker2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + objectRequestBroker.getClass().getName()));
        this._objectRequestBroker = objectRequestBroker2;
        return super.arePrimaryKeysEqual(objectRequestBroker, objectRequestBroker2);
    }

    public void setEnableServletCaching(WebContainer webContainer, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"setEnableServletCaching", (Object)new Object[]{webContainer, new Boolean(bl)});
        webContainer.setEnableServletCaching(false);
    }

    public void setSslConfig(Transport transport, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setSslConfig", (Object)new Object[]{transport, string});
        if (string != null) {
            transport.setSslConfig(string);
        }
    }
}

