/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.document.CellDocumentCollectionImpl;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.CellsDocumentCollectionImpl;
import com.ibm.ws.migration.document.ConfigDocumentCollectionFederatedPostImpl;
import com.ibm.ws.migration.document.ConfigDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionFederatedHelper;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionHelper;
import com.ibm.ws.migration.document.FileDocumentCollection;
import com.ibm.ws.migration.document.NodeDocumentCollectionDmgrPostImpl;
import com.ibm.ws.migration.document.NodeDocumentCollectionImpl;
import com.ibm.ws.migration.document.NodesDocumentCollectionDmgrPostImpl;
import com.ibm.ws.migration.document.NodesDocumentCollectionImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionDmgrPostImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionFederatedPostImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.TextDocument;
import com.ibm.ws.migration.postupgrade.BasicPostUpgradeManager;
import com.ibm.ws.migration.utility.ArgumentException;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProductImageImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.ScenarioImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.utility.Profile;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.util.Properties;

public class Restore {
    private static TraceComponent _tc = Tr.register((Class)Restore.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private Configuration _oldConfiguration = null;
    private Configuration _newConfiguration = null;
    private static String _owningNodeName = null;
    static /* synthetic */ Class class$com$ibm$ws$migration$document$TextDocument;

    public static String get_owningNodeName() {
        Tr.entry((TraceComponent)_tc, (String)"get_owningNodeName");
        return _owningNodeName;
    }

    public Restore() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"Restore");
        UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.information.postupgrade.start", "Starting to restore previous WebSphere environment."));
        try {
            File file = UpgradeBase.get_oldOSInfo().installRoot();
            File file2 = UpgradeBase.get_newOSInfo().installRoot();
            File file3 = UpgradeBase.get_oldOSInfo().userRoot();
            File file4 = UpgradeBase.get_newOSInfo().userRoot();
            this._oldConfiguration = new Configuration(new File(file3, "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
            this._newConfiguration = new Configuration(new File(file4, "config"), null, null, false, UpgradeBase.get_newOSInfo().releaseVersion(), false, true);
            _owningNodeName = this._oldConfiguration.getOwningNodeName();
            File file5 = null;
            File file6 = null;
            if (!UpgradeBase.get_oldOSInfo().releaseVersion().isClient()) {
                file5 = new File(this._oldConfiguration.getNodeVariables().getProperty("WAS_INSTALL_ROOT"));
                file6 = new File(this._oldConfiguration.resolveEntryPath(this._oldConfiguration.getNodeVariables().getProperty("USER_INSTALL_ROOT")));
            } else {
                file5 = file;
                file6 = file3;
            }
            BasicDocumentCollection basicDocumentCollection = this.createProfileDocumentCollection(false, file6, file3);
            BasicDocumentCollection basicDocumentCollection2 = this.createProfileDocumentCollection(true, file4, file4);
            basicDocumentCollection2.setPeer(basicDocumentCollection);
            basicDocumentCollection.setPeer(basicDocumentCollection2);
            ProfileImpl profileImpl = null;
            ProfileImpl profileImpl2 = null;
            if (UpgradeBase.get_oldOSInfo().releaseVersion().isClient()) {
                profileImpl = new ProfileImpl(basicDocumentCollection, this._oldConfiguration.getOwningNodeName(), false, false, file3, UpgradeBase.get_oldOSInfo());
                profileImpl2 = new ProfileImpl(basicDocumentCollection2, this._newConfiguration.getOwningNodeName(), false, false, file4, UpgradeBase.get_newOSInfo());
            } else {
                profileImpl = new ProfileImpl(basicDocumentCollection, this._oldConfiguration.getOwningNodeName(), this._oldConfiguration.isDeploymentManagerConfiguration(), this._oldConfiguration.isFederatedNode(), file3, UpgradeBase.get_oldOSInfo());
                profileImpl2 = new ProfileImpl(basicDocumentCollection2, this._newConfiguration.getOwningNodeName(), this._newConfiguration.isDeploymentManagerConfiguration(), this._newConfiguration.isFederatedNode(), file4, UpgradeBase.get_newOSInfo());
            }
            this.validateCorrectProfileCombination(profileImpl, profileImpl2);
            ReleaseVersion releaseVersion = UpgradeBase.get_oldOSInfo().releaseVersion();
            ReleaseVersion releaseVersion2 = UpgradeBase.get_newOSInfo().releaseVersion();
            if (!releaseVersion.isClient()) {
                this._newConfiguration.backupConfig();
            }
            boolean bl = false;
            if (releaseVersion.isR50() || releaseVersion.isR51() || releaseVersion.isR60()) {
                bl = true;
            }
            boolean bl2 = false;
            if (releaseVersion2.isR61()) {
                bl2 = true;
            }
            String string = this.getVersion(releaseVersion);
            String string2 = this.getVersion(releaseVersion2);
            ReleaseVersionImpl releaseVersionImpl = new ReleaseVersionImpl(false, bl, string, releaseVersion);
            ReleaseVersionImpl releaseVersionImpl2 = new ReleaseVersionImpl(true, bl2, string2, releaseVersion2);
            ProductImageImpl productImageImpl = new ProductImageImpl(file5, file, profileImpl, releaseVersionImpl, UpgradeBase.get_oldOSInfo());
            ProductImageImpl productImageImpl2 = new ProductImageImpl(file2, file2, profileImpl2, releaseVersionImpl2, UpgradeBase.get_newOSInfo());
            ScenarioImpl scenarioImpl = new ScenarioImpl(UpgradeBase.get_backupDirectory().toURL(), productImageImpl, productImageImpl2, UpgradeBase.get_logger());
            basicDocumentCollection.setScenario(scenarioImpl);
            basicDocumentCollection2.setScenario(scenarioImpl);
            this.performScenarioVerification(scenarioImpl);
            BasicPostUpgradeManager basicPostUpgradeManager = new BasicPostUpgradeManager(scenarioImpl);
            if (!UpgradeBase.get_oldOSInfo().releaseVersion().isClient() && this._oldConfiguration.isFederatedNode()) {
                String string3 = profileImpl.getOwningNodeName();
                String string4 = profileImpl2.getOwningNodeName();
                Tr.debug((TraceComponent)_tc, (String)("Node Name Must Match: " + string3 + " == " + string4));
                if (string3 == null) {
                    if (string4 != null) {
                        if (!string4.equals(string3)) {
                            String string5 = LoggerImpl.get_nls().getFormattedMessage("advise.node.name.must.match", new Object[]{string3}, "The node name of the new configuration must be the same as the old configuration: {0} for this environment.");
                            throw new ArgumentException(string5, null, true);
                        }
                    } else {
                        Tr.debug((TraceComponent)_tc, (String)"WARNING: Old Nodename and New Nodename are both null");
                    }
                } else if (!string3.equals(string4)) {
                    String string6 = LoggerImpl.get_nls().getFormattedMessage("advise.node.name.must.match", new Object[]{string3}, "The node name of the new configuration must be the same as the old configuration: {0} for this environment.");
                    throw new ArgumentException(string6, null, true);
                }
            } else {
                Tr.debug((TraceComponent)_tc, (String)"Nonfederated migration detected, node names can mismatch");
            }
            basicPostUpgradeManager.migrate();
        }
        catch (UpgradeException upgradeException) {
            throw upgradeException;
        }
        catch (Exception exception) {
            throw new UpgradeException(exception);
        }
    }

    protected void validateCorrectProfileCombination(Profile profile, Profile profile2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"validateCorrectProfileCombination", (Object)new Object[]{profile, profile2});
        if (profile.isDeploymentManager() ? !profile2.isDeploymentManager() : (profile.isNodeFederated() ? profile2.isNodeFederated() || profile2.isDeploymentManager() : profile.isApplicationServer() && (profile2.isNodeFederated() || profile2.isDeploymentManager()))) {
            throw new UpgradeException(LoggerImpl.get_nls().getString("advise.invalid.WAS.combination", "The specified WebSphere migration backup directory is not compatible with this WebSphere version."), null, true);
        }
    }

    private void performScenarioVerification(Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"performScenarioVerification", (Object)scenario);
        if (scenario.getOldProductImage().getProfile().isDeploymentManager()) {
            this.verifyCellNameMatchDMgrMigration(scenario);
            DocumentCollection[] documentCollectionArray = scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getChild("nodes").getChildren();
            DocumentCollection[] documentCollectionArray2 = scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getChild("nodes").getChildren();
            for (int i = 0; i < documentCollectionArray.length; ++i) {
                NodeDocumentCollectionImpl nodeDocumentCollectionImpl = (NodeDocumentCollectionImpl)documentCollectionArray[i];
                if (nodeDocumentCollectionImpl.isDeploymentManager()) continue;
                boolean bl = false;
                while (i < documentCollectionArray2.length) {
                    NodeDocumentCollectionImpl nodeDocumentCollectionImpl2 = (NodeDocumentCollectionImpl)documentCollectionArray2[i];
                    if (!nodeDocumentCollectionImpl2.isDeploymentManager() && nodeDocumentCollectionImpl.getName().equals(nodeDocumentCollectionImpl2.getName())) {
                        TextDocument textDocument = (TextDocument)nodeDocumentCollectionImpl2.openDocument("node-metadata.properties", class$com$ibm$ws$migration$document$TextDocument == null ? Restore.class$("com.ibm.ws.migration.document.TextDocument") : class$com$ibm$ws$migration$document$TextDocument, false, true);
                        Properties properties = new Properties();
                        properties.load(textDocument.getInputStream());
                        String string = properties.getProperty("com.ibm.websphere.baseProductVersion");
                        textDocument.close();
                        if (string.startsWith("6.1")) {
                            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.failed.node.already.federated", new Object[]{nodeDocumentCollectionImpl2.getName()}, "Federated node {0} already exists in current configuration.  Migration cannot continue.");
                            UpgradeBase.get_logger().println(string2);
                            throw new Exception(string2);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void verifyCellNameMatchDMgrMigration(Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"verifyCellNameMatchDMgrMigration", (Object)scenario);
        DocumentCollection documentCollection = scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0];
        String string = documentCollection.getName();
        String string2 = scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
        if (!string.equals(string2)) {
            String string3 = LoggerImpl.get_nls().getFormattedMessage("advise.cell.not.match", new Object[]{string, string2}, "The cell name {0} from the old configuration does not match the cell name {1} in the target profile. No migration can occur.");
            UpgradeBase.get_logger().println(string3);
            throw new Exception(string3);
        }
        String string4 = ((ProfileImpl)scenario.getOldProductImage().getProfile()).getOwningNodeName();
        String string5 = ((ProfileImpl)scenario.getNewProductImage().getProfile()).getOwningNodeName();
        if (string4 != null && !string4.equals(string5)) {
            try {
                DocumentCollection documentCollection2 = documentCollection.getChild("nodes");
                try {
                    documentCollection2.getChild(string5);
                    String string6 = LoggerImpl.get_nls().getFormattedMessage("advise.node.name.must.match", new Object[]{string4}, "The node name of the new configuration must be the same as the old configuration: {0} for this environment..");
                    UpgradeBase.get_logger().println(string6);
                    throw new UpgradeException(string6, null, false);
                }
                catch (NotFoundException notFoundException) {
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private BasicDocumentCollection createProfileDocumentCollection(boolean bl, File file, File file2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createProfileDocumentCollection", (Object)new Object[]{new Boolean(bl), file, file2});
        String string = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(File.separator) + 1);
        BasicDocumentCollection basicDocumentCollection = null;
        if (UpgradeBase.get_oldOSInfo().releaseVersion().isClient()) {
            BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(false, true, BasicDocumentCollection.class, FileDocumentCollection.class);
            basicDocumentCollection = new BasicDocumentCollection(string, null, descriptor, file.toURL(), file2.toURL());
        } else if (bl) {
            BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(false, true, BasicDocumentCollection.class, FileDocumentCollection.class);
            basicDocumentCollection = new BasicDocumentCollection(string, null, descriptor, file.toURL(), file2.toURL());
            BasicDocumentCollection.Descriptor descriptor2 = null;
            if (this._oldConfiguration.isFederatedNode()) {
                descriptor2 = new BasicDocumentCollection.Descriptor(descriptor, ConfigDocumentCollectionFederatedPostImpl.class, ConfigRepositoryDocumentCollectionFederatedHelper.class);
                descriptor.setChildDescriptor("config", descriptor2);
            } else {
                descriptor2 = new BasicDocumentCollection.Descriptor(descriptor, ConfigDocumentCollectionPostImpl.class, ConfigRepositoryDocumentCollectionHelper.class);
                descriptor.setChildDescriptor("config", descriptor2);
            }
            BasicDocumentCollection.Descriptor descriptor3 = new BasicDocumentCollection.Descriptor(descriptor2, CellsDocumentCollectionImpl.class);
            descriptor2.setChildDescriptor("cells", descriptor3);
            BasicDocumentCollection.Descriptor descriptor4 = new BasicDocumentCollection.Descriptor(descriptor2, CellDocumentCollectionPostImpl.class);
            descriptor3.setDefaultChildDescriptor(descriptor4);
            BasicDocumentCollection.Descriptor descriptor5 = new BasicDocumentCollection.Descriptor(descriptor2, BasicDocumentCollection.class);
            descriptor4.setDefaultChildDescriptor(descriptor5);
            BasicDocumentCollection.Descriptor descriptor6 = null;
            if (this._oldConfiguration.isDeploymentManagerConfiguration()) {
                descriptor6 = new BasicDocumentCollection.Descriptor(descriptor2, NodesDocumentCollectionDmgrPostImpl.class);
                descriptor4.setChildDescriptor("nodes", descriptor6);
            } else {
                descriptor6 = new BasicDocumentCollection.Descriptor(descriptor2, NodesDocumentCollectionImpl.class);
                descriptor4.setChildDescriptor("nodes", descriptor6);
            }
            BasicDocumentCollection.Descriptor descriptor7 = new BasicDocumentCollection.Descriptor(true, false, BasicDocumentCollection.class, ConfigRepositoryDocumentCollectionHelper.class);
            descriptor2.setChildDescriptor("templates", descriptor7);
            descriptor2.setChildDescriptor("temp", descriptor7);
            descriptor2.setChildDescriptor("backup", descriptor7);
            descriptor2.setChildDescriptor(".repository", descriptor7);
            BasicDocumentCollection.Descriptor descriptor8 = null;
            if (this._oldConfiguration.isDeploymentManagerConfiguration()) {
                descriptor8 = new BasicDocumentCollection.Descriptor(descriptor2, NodeDocumentCollectionDmgrPostImpl.class);
                descriptor6.setDefaultChildDescriptor(descriptor8);
            } else {
                descriptor8 = new BasicDocumentCollection.Descriptor(descriptor2, NodeDocumentCollectionImpl.class);
                descriptor6.setDefaultChildDescriptor(descriptor8);
            }
            BasicDocumentCollection.Descriptor descriptor9 = new BasicDocumentCollection.Descriptor(descriptor2, BasicDocumentCollection.class);
            descriptor8.setDefaultChildDescriptor(descriptor9);
            if (this._oldConfiguration.isDeploymentManagerConfiguration()) {
                BasicDocumentCollection.Descriptor descriptor10 = new BasicDocumentCollection.Descriptor(descriptor2, ServerDocumentCollectionDmgrPostImpl.class);
                descriptor9.setDefaultChildDescriptor(descriptor10);
            } else if (this._oldConfiguration.isFederatedNode()) {
                BasicDocumentCollection.Descriptor descriptor11 = new BasicDocumentCollection.Descriptor(descriptor2, ServerDocumentCollectionFederatedPostImpl.class);
                descriptor9.setDefaultChildDescriptor(descriptor11);
            } else {
                BasicDocumentCollection.Descriptor descriptor12 = new BasicDocumentCollection.Descriptor(descriptor2, ServerDocumentCollectionPostImpl.class);
                descriptor9.setDefaultChildDescriptor(descriptor12);
            }
        } else {
            BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(true, false, BasicDocumentCollection.class, FileDocumentCollection.class);
            basicDocumentCollection = new BasicDocumentCollection(string, null, descriptor, file.toURL(), file2.toURL());
            BasicDocumentCollection.Descriptor descriptor13 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor.setChildDescriptor("config", descriptor13);
            BasicDocumentCollection.Descriptor descriptor14 = new BasicDocumentCollection.Descriptor(descriptor, CellsDocumentCollectionImpl.class);
            descriptor13.setChildDescriptor("cells", descriptor14);
            BasicDocumentCollection.Descriptor descriptor15 = new BasicDocumentCollection.Descriptor(descriptor, CellDocumentCollectionImpl.class);
            descriptor14.setDefaultChildDescriptor(descriptor15);
            BasicDocumentCollection.Descriptor descriptor16 = new BasicDocumentCollection.Descriptor(descriptor13, BasicDocumentCollection.class);
            descriptor15.setDefaultChildDescriptor(descriptor16);
            BasicDocumentCollection.Descriptor descriptor17 = null;
            if (this._oldConfiguration.isDeploymentManagerConfiguration() || this._oldConfiguration.isFederatedNode()) {
                descriptor17 = new BasicDocumentCollection.Descriptor(descriptor13, NodesDocumentCollectionDmgrPostImpl.class);
                descriptor15.setChildDescriptor("nodes", descriptor17);
            } else {
                descriptor17 = new BasicDocumentCollection.Descriptor(descriptor13, NodesDocumentCollectionImpl.class);
                descriptor15.setChildDescriptor("nodes", descriptor17);
            }
            descriptor13.setChildDescriptor("templates", BasicDocumentCollection.HIDE_CHILD);
            descriptor13.setChildDescriptor("temp", BasicDocumentCollection.HIDE_CHILD);
            descriptor13.setChildDescriptor("backup", BasicDocumentCollection.HIDE_CHILD);
            descriptor13.setChildDescriptor(".repository", BasicDocumentCollection.HIDE_CHILD);
            BasicDocumentCollection.Descriptor descriptor18 = new BasicDocumentCollection.Descriptor(descriptor, NodeDocumentCollectionImpl.class);
            descriptor17.setDefaultChildDescriptor(descriptor18);
            BasicDocumentCollection.Descriptor descriptor19 = new BasicDocumentCollection.Descriptor(descriptor, BasicDocumentCollection.class);
            descriptor18.setDefaultChildDescriptor(descriptor19);
            BasicDocumentCollection.Descriptor descriptor20 = new BasicDocumentCollection.Descriptor(descriptor, ServerDocumentCollectionImpl.class);
            descriptor19.setDefaultChildDescriptor(descriptor20);
        }
        return basicDocumentCollection;
    }

    private String getVersion(ReleaseVersion releaseVersion) {
        Tr.entry((TraceComponent)_tc, (String)"getVersion", (Object)releaseVersion);
        String string = null;
        if (releaseVersion.isBase()) {
            string = "BASE";
        } else if (releaseVersion.isClient()) {
            string = "CLIENT";
        } else if (releaseVersion.isExpressServerProductInstalled("embeddedEXPRESS")) {
            string = "embeddedEXPRESS";
        } else if (releaseVersion.isExpressServerProductInstalled("EXPRESS")) {
            string = "EXPRESS";
        } else if (releaseVersion.areExtendedServerProductsInstalled() && releaseVersion.installedExtendedServerProducts().contains("ND")) {
            string = "ND";
        }
        return string;
    }
}

