/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.Restore;
import com.ibm.ws.migration.postupgrade.ValidReleaseCombinations;
import com.ibm.ws.migration.postupgrade.common.PortUsage;
import com.ibm.ws.migration.utility.ArgumentException;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class WASPostUpgrade
extends UpgradeBase {
    private static TraceComponent _tc = Tr.register((Class)WASPostUpgrade.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static final String BASE = "BASE";
    private static final String ND = "ND";
    private static final String CLIENT = "CLIENT";
    private static final String EXPRESS = "EXPRESS";
    private static final String BOBCAT = "embeddedEXPRESS";
    private static String[] _cmdLineArguments = null;
    private static boolean _replacePorts = true;
    private static String _includeApps = "true";
    private static File _configRoot = null;
    private static boolean _backupConfig = true;
    protected static final String[] POSITIONAL_PARMS = new String[]{"-backupDirectory"};
    public static final String SCRIPT_COMPATIBILITY_PARAMETER = "-scriptCompatibility";
    public static final String BACKUP_DIRECTORY_PARAMETER = "-backupDirectory";
    public static final String CURRENT_WAS_DIRECTORY_PARAMETER = "-currentWASDirectory";
    public static final String TRACESTRING_PARAMETER = "-traceString";
    public static final String TRACEFILE_PARAMETER = "-traceFile";
    public static final String PORT_BLOCK_PARAMETER = "-portBlock";
    public static final String BACKUP_CONFIG_PARAMETER = "-backupConfig";
    public static final String REPLACE_PORTS_PARAMETER = "-replacePorts";
    public static final String OLD_PROFILE_PARAMETER = "-oldProfile";
    public static final String PROFILE_NAME_PARAMETER = "-profileName";
    public static final String INCLUDE_APPS_PARAMETER = "-includeApps";
    public static final String ZWAS_HIDDEN_PARAMETER = "-zWAS";
    public static final String SUMMARY_LOG_NAME_HIDDEN_PARAMETER = "-summaryLogName";
    public static final String USERNAME_HIDDEN_PARAMETER = "-username";
    public static final String PASSWORD_HIDDEN_PARAMETER = "-password";
    public static final String DCS_HOST_HIDDEN_PARAMETER = "-DCSHost";
    public static final String CONTROLLER_HIDDEN_PARAMETER = "-controller";
    public static final String SERVANT_HIDDEN_PARAMETER = "-servant";
    public static final String DAEMON_HIDDEN_PARAMETER = "-daemon";
    public static final String ADJUNCT_HIDDEN_PARAMETER = "-adjunct";
    public static final String APP_INSTALL_DIRECTORY_PARAMETER = "-appInstallDirectory";
    public static final String KEEP_APP_DIRECTORY_PARAMETER = "-keepAppDirectory";
    public static final String KEEP_DMGR_ENABLED_PARAMETER = "-keepDmgrEnabled";
    private static String _dcsHost = null;
    private static String _controller = null;
    private static String _servant = null;
    private static String _daemon = null;
    private static String _adjunct = null;
    private File _summaryLog = null;
    private static String _userName = null;
    private static String _password = null;
    private static String _appInstallDirectory = null;
    private static boolean _keepAppDirectory = false;
    private static boolean _keepDmgrEnabled = false;
    private static String _oldInstanceName = null;
    private static boolean _scriptCompatibility = true;
    private static boolean _wasPostUpgrade = true;

    public WASPostUpgrade() {
    }

    public WASPostUpgrade(String[] stringArray) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"WASPostUpgrade", (Object)stringArray);
        _cmdLineArguments = stringArray;
        this.parseArgs(stringArray);
        this.parsePositionalParms(stringArray, POSITIONAL_PARMS);
        this.setupTrace("WASPostUpgrade");
    }

    public void restore() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"restore");
        this.checkArguments();
        String string = null;
        string = "WASPostUpgrade.log";
        UpgradeBase._logger = new LoggerImpl(new File(UpgradeBase._userRoot, "logs"), string, this._summaryLog);
        this.verifyBackupDirectory();
        File file = new File(UpgradeBase._backupDirectory, "websphere_backup");
        UpgradeBase._oldOSInfo = OSInfoFactory.createOSInfo(file, file);
        if (this.checkOldWASVersion(UpgradeBase._oldOSInfo.releaseVersion())) {
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.invalid.WAS.directory", new Object[]{(String)UpgradeBase._cmdLineArgs.get(BACKUP_DIRECTORY_PARAMETER)}, "The directory {0} does not contain a WebSphere version that can be upgraded."), null, true);
        }
        this.checkReleaseVersionCombination();
        this.checkArgumentReplacePorts();
        this.checkOldInstance();
        Restore restore = new Restore();
        UpgradeBase._logger.println(LoggerImpl.get_nls().getString("advise.information.postupgrade.complete", "Completed restoring of the previous WebSphere environment."));
        String string2 = null;
        string2 = LoggerImpl.loggedError() ? LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "Completed with errors.") : (LoggerImpl.loggedWarning() ? LoggerImpl.get_nls().getString("advise.logging.completed.with.warnings", "Migration completed successfully, with one or more warnings.") : LoggerImpl.get_nls().getString("advise.logging.completed", "Completed successfully."));
        UpgradeBase._logger.println(string2);
    }

    protected void checkReleaseVersionCombination() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkReleaseVersionCombination");
        ReleaseVersion releaseVersion = UpgradeBase._oldOSInfo.releaseVersion();
        ReleaseVersion releaseVersion2 = UpgradeBase._newOSInfo.releaseVersion();
        if (!ValidReleaseCombinations.getReleaseCombinations().contains(this.stringifyReleaseVersions(releaseVersion, releaseVersion2))) {
            throw new UpgradeException(LoggerImpl.get_nls().getString("advise.invalid.WAS.combination", "The specified WebSphere migration backup directory is not compatible with this WebSphere version."), null, true);
        }
    }

    protected String stringifyReleaseVersions(ReleaseVersion releaseVersion, ReleaseVersion releaseVersion2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"stringifyReleaseVersions");
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(releaseVersion.version());
        stringBuffer.append(this.addExtendedProductInfo(releaseVersion));
        stringBuffer.append(this.addExtendedProductInfo(releaseVersion2));
        return stringBuffer.toString();
    }

    protected String addExtendedProductInfo(ReleaseVersion releaseVersion) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"addExtendedProductInfo");
        if (releaseVersion.areExtendedServerProductsInstalled()) {
            if (releaseVersion.installedExtendedServerProducts().contains(ND)) {
                return ND;
            }
        }
        if (releaseVersion.isClient()) {
            return CLIENT;
        }
        if (releaseVersion.isBase()) {
            return BASE;
        }
        if (releaseVersion.isExpressServerProductInstalled(EXPRESS)) {
            return EXPRESS;
        }
        if (releaseVersion.isExpressServerProductInstalled(BOBCAT)) {
            return BOBCAT;
        }
        String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{"addExtendedProductInfo"}, "An unexpected internal error occurred, exception {0}.");
        throw new UpgradeException(string, null, false);
    }

    protected void parseArgs(String[] stringArray) throws UpgradeException {
        super.parseArgs(stringArray);
        String string = System.getProperty("com.ibm.websphere.migration.serverRoot");
        if (string == null) {
            return;
        }
        UpgradeBase._cmdLineArgs.put(CURRENT_WAS_DIRECTORY_PARAMETER, string);
        try {
            for (int i = 1; i < stringArray.length; ++i) {
                UpgradeBase._cmdLineArgs.put(stringArray[i++], stringArray[i]);
            }
        }
        catch (Exception exception) {
            throw new ArgumentException(LoggerImpl.get_nls().getString("advise.cmd.line.illegal.number.arg", "Illegal number of arguments, there must be an even number of optional parameters."), exception, true);
        }
    }

    protected void checkNewWASVersion() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkNewWASVersion");
        if (!UpgradeBase._currentRelease.isR61()) {
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unsupported.version", new Object[0], "The currently installed version of WebSphere is not supported by this command."), null, true);
        }
    }

    protected void checkIfFederated() throws UpgradeException {
        Configuration configuration;
        Tr.entry((TraceComponent)_tc, (String)"checkIfFederated");
        ReleaseVersion releaseVersion = UpgradeBase._currentRelease;
        if (!releaseVersion.isClient() && (configuration = new Configuration(_configRoot, (String)UpgradeBase._cmdLineArgs.get("-cellName"), null, false, releaseVersion, false, false)).isFederatedNode()) {
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.already.federated", new Object[0], "This node has already been federated into a cell manager configuration."), null, true);
        }
    }

    protected void checkArgumentSummaryLogName() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentSummaryLogName");
        if (UpgradeBase._cmdLineArgs.containsKey(SUMMARY_LOG_NAME_HIDDEN_PARAMETER)) {
            this._summaryLog = new File((String)UpgradeBase._cmdLineArgs.get(SUMMARY_LOG_NAME_HIDDEN_PARAMETER));
        }
    }

    protected void checkArgumentSecurityCredentials() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentSecurityCredentials");
        try {
            if (UpgradeBase._cmdLineArgs.containsKey(USERNAME_HIDDEN_PARAMETER)) {
                _userName = (String)UpgradeBase._cmdLineArgs.get(USERNAME_HIDDEN_PARAMETER);
                if (!UpgradeBase._cmdLineArgs.containsKey(PASSWORD_HIDDEN_PARAMETER)) {
                    Tr.debug((TraceComponent)_tc, (String)"username supplied without a password.");
                }
                if ((_password = (String)UpgradeBase._cmdLineArgs.get(PASSWORD_HIDDEN_PARAMETER)).startsWith("{xor}")) {
                    _password = PasswordUtil.decode((String)_password);
                }
            }
        }
        catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
            throw new UpgradeException(invalidPasswordDecodingException);
        }
        catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
            throw new UpgradeException(unsupportedCryptoAlgorithmException);
        }
    }

    protected void checkArgumentZWAS() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentZWAS");
        if (OSInfoFactory.isZSeries() && !UpgradeBase._cmdLineArgs.containsKey(ZWAS_HIDDEN_PARAMETER)) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.zos.invalid.direct.invocation", new Object[]{"WASPostUpgrade"}, "{0} command not supported on z/OS for direct invocation from the Unix shell.  Use the WebSphere z/OS Customization Dialog migration option instead.");
            UpgradeBase._logger.println(string);
            throw new UpgradeException(string, null, true);
        }
    }

    protected void checkArgumentBackupConfig() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentBackupConfig");
        if (UpgradeBase._cmdLineArgs.containsKey(BACKUP_CONFIG_PARAMETER)) {
            String string = (String)UpgradeBase._cmdLineArgs.get(BACKUP_CONFIG_PARAMETER);
            if ((string = string.toLowerCase()).equals("true") || string.equals("false")) {
                _backupConfig = !string.equals("false");
            } else {
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.value", new Object[]{"backupConfig", string}, "Invalid value specified for {0}: {1}.");
                throw new ArgumentException(string2, null, true);
            }
        }
    }

    protected void checkArgumentIncludeApps() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentIncludeApps");
        if (UpgradeBase._cmdLineArgs.containsKey(INCLUDE_APPS_PARAMETER)) {
            String string = (String)UpgradeBase._cmdLineArgs.get(INCLUDE_APPS_PARAMETER);
            if ((string = string.toLowerCase()).equals("true") || string.equals("false")) {
                _includeApps = string.equals("false") ? "false" : "true";
            } else if (string.equals("script")) {
                _includeApps = "script";
            } else {
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.value", new Object[]{"includeApps", string}, "Invalid value specified for {0}: {1}.");
                throw new ArgumentException(string2, null, true);
            }
        }
    }

    protected void checkArgumentReplacePorts() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentReplacePorts");
        if (!UpgradeBase._currentRelease.isClient() && UpgradeBase._cmdLineArgs.containsKey(REPLACE_PORTS_PARAMETER)) {
            String string = (String)UpgradeBase._cmdLineArgs.get(REPLACE_PORTS_PARAMETER);
            if ((string = string.toLowerCase()).equals("true") || string.equals("false")) {
                _replacePorts = !string.equals("false");
            } else {
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.value", new Object[]{"replacePorts", string}, "Invalid value specified for {0}: {1}.");
                throw new ArgumentException(string2, null, true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkArgumentScriptCompatibility() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentScriptCompatibility");
        if (!UpgradeBase._cmdLineArgs.containsKey(SCRIPT_COMPATIBILITY_PARAMETER)) {
            _scriptCompatibility = true;
            return;
        }
        String string = (String)UpgradeBase._cmdLineArgs.get(SCRIPT_COMPATIBILITY_PARAMETER);
        if (!(string = string.toLowerCase()).equals("true") && !string.equals("false")) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.value", new Object[]{SCRIPT_COMPATIBILITY_PARAMETER, string}, "Invalid value specified for {0}: {1}.");
            throw new ArgumentException(string2, null, true);
        }
        if (string.equals("true")) {
            _scriptCompatibility = true;
            return;
        }
        _scriptCompatibility = false;
    }

    protected void checkArgumentPortBlock() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentPortBlock");
        if (!UpgradeBase._currentRelease.isClient()) {
            String string = null;
            if (UpgradeBase._cmdLineArgs.containsKey(PORT_BLOCK_PARAMETER)) {
                string = (String)UpgradeBase._cmdLineArgs.get(PORT_BLOCK_PARAMETER);
            }
            if (string != null && string.length() > 0) {
                PortUsage.setPortBlock(string);
            }
        }
    }

    protected void checkArgumentController() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentController");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey(CONTROLLER_HIDDEN_PARAMETER)) {
            _controller = string = (String)UpgradeBase._cmdLineArgs.get(CONTROLLER_HIDDEN_PARAMETER);
            Tr.debug((TraceComponent)_tc, (String)("_controller=" + _controller));
        }
    }

    protected void checkArgumentServant() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentServant");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey(SERVANT_HIDDEN_PARAMETER)) {
            _servant = string = (String)UpgradeBase._cmdLineArgs.get(SERVANT_HIDDEN_PARAMETER);
            Tr.debug((TraceComponent)_tc, (String)("_servant=" + _servant));
        }
    }

    protected void checkArgumentDaemon() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentDaemon");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey(DAEMON_HIDDEN_PARAMETER)) {
            _daemon = string = (String)UpgradeBase._cmdLineArgs.get(DAEMON_HIDDEN_PARAMETER);
            Tr.debug((TraceComponent)_tc, (String)("_daemon=" + _daemon));
        }
    }

    protected void checkArgumentAdjunct() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentAdjunct");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey(ADJUNCT_HIDDEN_PARAMETER)) {
            _adjunct = string = (String)UpgradeBase._cmdLineArgs.get(ADJUNCT_HIDDEN_PARAMETER);
            Tr.debug((TraceComponent)_tc, (String)("_adjunct=" + _adjunct));
        }
    }

    protected void checkArgumentDCSHost() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentDCSHost");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey(DCS_HOST_HIDDEN_PARAMETER)) {
            string = (String)UpgradeBase._cmdLineArgs.get(DCS_HOST_HIDDEN_PARAMETER);
            _dcsHost = string.equals("GENERIC") ? "*" : string;
            Tr.debug((TraceComponent)_tc, (String)("_dcsHost=" + _dcsHost));
        }
    }

    protected void checkArgumentAppInstallDirectoryParameter() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentAppInstallDirectoryParameter");
        if (UpgradeBase._cmdLineArgs.containsKey(APP_INSTALL_DIRECTORY_PARAMETER)) {
            _appInstallDirectory = (String)UpgradeBase._cmdLineArgs.get(APP_INSTALL_DIRECTORY_PARAMETER);
            Tr.event((TraceComponent)_tc, (String)"Initialize appInstallDir to: ", (Object)new Object[]{_appInstallDirectory});
            try {
                if (UpgradeBase._newOSInfo != null) {
                    _appInstallDirectory = this.fixPrefix(_appInstallDirectory, UpgradeBase._newOSInfo.userRoot(), UtilityImpl.PROFILE_ROOT);
                    _appInstallDirectory = this.fixPrefix(_appInstallDirectory, UpgradeBase._newOSInfo.installRoot(), UtilityImpl.WAS_ROOT);
                }
                Tr.event((TraceComponent)_tc, (String)"Updated appInstallDir to: ", (Object)new Object[]{_appInstallDirectory});
            }
            catch (Exception exception) {
                Tr.event((TraceComponent)_tc, (String)"Unexpected error when updating appInstallDir: ", (Object)new Object[]{_appInstallDirectory, exception});
            }
        }
    }

    private String fixPrefix(String string, File file, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"fixPrefix", (Object)new Object[]{string, file, string2});
        String string3 = string;
        if (string != null && !string.startsWith("${") && file != null && string2 != null) {
            String string4;
            File file2 = new File(string);
            if ((string = file2.getAbsolutePath()).startsWith(string4 = file.getAbsolutePath())) {
                String string5 = string.substring(string4.length());
                string3 = "${" + string2 + "}";
                if (string5 != null && !string5.startsWith(File.separator)) {
                    string3 = string3 + File.separator;
                }
                string3 = string3 + string5;
                Tr.event((TraceComponent)_tc, (String)"fixPrefix collapsed absolute path ", (Object)new Object[]{string, file, string2, string3});
            } else {
                try {
                    string = file2.getCanonicalPath();
                    string4 = file.getCanonicalPath();
                    if (string.startsWith(string4)) {
                        String string6 = string.substring(string4.length());
                        string3 = "${" + string2 + "}";
                        if (string6 != null && !string6.startsWith(File.separator)) {
                            string3 = string3 + File.separator;
                        }
                        string3 = string3 + string6;
                        Tr.event((TraceComponent)_tc, (String)"fixPrefix collapsed canonical path ", (Object)new Object[]{string, string4, string2, string3});
                    }
                }
                catch (IOException iOException) {
                    Tr.event((TraceComponent)_tc, (String)"fixPrefix failed because canonical path failed", (Object)new Object[]{iOException, string, file, string2});
                }
            }
        }
        Tr.exit((TraceComponent)_tc, (String)"fixPrefix", (Object)new Object[]{string, string3});
        return string3;
    }

    protected void checkKeepAppDirectory() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkKeepAppDirectory");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey(KEEP_APP_DIRECTORY_PARAMETER)) {
            string = (String)UpgradeBase._cmdLineArgs.get(KEEP_APP_DIRECTORY_PARAMETER);
            if (UpgradeBase._cmdLineArgs.containsKey(APP_INSTALL_DIRECTORY_PARAMETER) && string.toLowerCase().equals("true")) {
                throw new ArgumentException(LoggerImpl.get_nls().getFormattedMessage("advise.conflicting.parameters", new Object[0], "Conflicting parameters, -keepAppDirectory true and -appInstallDirectory, have both been specified."), null, true);
            }
            try {
                _keepAppDirectory = new Boolean(string);
                Tr.debug((TraceComponent)_tc, (String)("_keepAppsDirectory=" + _keepAppDirectory));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.value", new Object[]{KEEP_APP_DIRECTORY_PARAMETER, string}, "Invalid value specified for {0}: {1}.");
                throw new ArgumentException(string2, null, true);
            }
        }
    }

    protected void checkKeepDmgrEnabled() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkKeepDmgrEnabled");
        String string = null;
        if (UpgradeBase._cmdLineArgs.containsKey(KEEP_DMGR_ENABLED_PARAMETER)) {
            string = (String)UpgradeBase._cmdLineArgs.get(KEEP_DMGR_ENABLED_PARAMETER);
            try {
                _keepDmgrEnabled = new Boolean(string);
                Tr.debug((TraceComponent)_tc, (String)("_keepDmgrEnabled=" + _keepDmgrEnabled));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.value", new Object[]{KEEP_DMGR_ENABLED_PARAMETER, string}, "Invalid value specified for {0}: {1}.");
                throw new ArgumentException(string2, null, true);
            }
        }
    }

    protected void checkInstanceAndProfileArguments() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkInstanceAndProfileArguments");
        if (!UpgradeBase._currentRelease.isClient() && UpgradeBase._cmdLineArgs.containsKey(OLD_PROFILE_PARAMETER)) {
            _oldInstanceName = (String)UpgradeBase._cmdLineArgs.get(OLD_PROFILE_PARAMETER);
        }
        if (UpgradeBase._cmdLineArgs.containsKey(PROFILE_NAME_PARAMETER)) {
            this._newProfileName = (String)UpgradeBase._cmdLineArgs.get(PROFILE_NAME_PARAMETER);
        }
    }

    protected void checkOldInstance() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkOldInstance");
        if (UpgradeBase._currentRelease.isClient()) {
            return;
        }
        if (_oldInstanceName == null) {
            OSInfo oSInfo = UpgradeBase._oldOSInfo.getDefaultInstance();
            if (oSInfo == null) {
                String string = LoggerImpl.get_nls().getString("advise.default.instance.missing", "The backup directory does not contain a default profile.");
                throw new ArgumentException(string, null, true);
            }
            UpgradeBase._oldOSInfo = oSInfo;
        } else {
            OSInfo oSInfo = UpgradeBase._oldOSInfo.getInstance(_oldInstanceName);
            if (oSInfo == null) {
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.old.instance.incorrect", new Object[]{_oldInstanceName}, "The backup directory does not contain instance {0}.");
                throw new ArgumentException(string, null, true);
            }
            UpgradeBase._oldOSInfo = oSInfo;
        }
    }

    protected void checkArguments() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArguments");
        super.checkArguments();
        String[] stringArray = new String[]{BACKUP_DIRECTORY_PARAMETER, CURRENT_WAS_DIRECTORY_PARAMETER, TRACESTRING_PARAMETER, TRACEFILE_PARAMETER, PORT_BLOCK_PARAMETER, BACKUP_CONFIG_PARAMETER, REPLACE_PORTS_PARAMETER, OLD_PROFILE_PARAMETER, PROFILE_NAME_PARAMETER, INCLUDE_APPS_PARAMETER, ZWAS_HIDDEN_PARAMETER, USERNAME_HIDDEN_PARAMETER, PASSWORD_HIDDEN_PARAMETER, SCRIPT_COMPATIBILITY_PARAMETER, DCS_HOST_HIDDEN_PARAMETER, CONTROLLER_HIDDEN_PARAMETER, SERVANT_HIDDEN_PARAMETER, DAEMON_HIDDEN_PARAMETER, ADJUNCT_HIDDEN_PARAMETER, APP_INSTALL_DIRECTORY_PARAMETER, KEEP_APP_DIRECTORY_PARAMETER, KEEP_DMGR_ENABLED_PARAMETER, SUMMARY_LOG_NAME_HIDDEN_PARAMETER};
        Enumeration enumeration = UpgradeBase._cmdLineArgs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!WASPostUpgrade.isInvalidKey(stringArray, string)) continue;
            throw new ArgumentException(LoggerImpl.get_nls().getFormattedMessage("advise.cmd.line.illegal", new Object[]{string}, "Illegal Argument Specified: {0}"), null, true);
        }
        this.checkArgumentZWAS();
        UpgradeBase._newOSInfo.validatePostUpgradeParms(UpgradeBase._cmdLineArgs);
        this.checkInstanceAndProfileArguments();
        this.checkNewProfile();
        _configRoot = UpgradeBase._newOSInfo.configRoot();
        System.setProperty("was.install.root", UpgradeBase._newOSInfo.installRoot().getAbsolutePath());
        System.setProperty("user.install.root", UpgradeBase._newOSInfo.userRoot().getAbsolutePath());
        System.setProperty("was.repository.root", UpgradeBase._newOSInfo.configRoot().getAbsolutePath());
        this.checkArgumentPortBlock();
        this.checkArgumentDCSHost();
        this.checkArgumentAppInstallDirectoryParameter();
        this.checkKeepAppDirectory();
        this.checkKeepDmgrEnabled();
        this.checkArgumentController();
        this.checkArgumentServant();
        this.checkArgumentDaemon();
        this.checkArgumentAdjunct();
        this.checkArgumentSummaryLogName();
        if (!UpgradeBase._currentRelease.isClient()) {
            this.checkIfFederated();
        }
        if (!UpgradeBase._currentRelease.isClient()) {
            this.checkArgumentBackupConfig();
            this.checkArgumentIncludeApps();
            this.checkArgumentScriptCompatibility();
        }
        this.checkArgumentSecurityCredentials();
    }

    protected void checkRequiredArguments() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkRequiredArguments");
        super.checkRequiredArguments();
        String string = System.getProperty("was.install.root");
        File file = null;
        if (string != null) {
            file = new File(string);
        }
        UpgradeBase._newOSInfo = OSInfoFactory.createOSInfo(UpgradeBase._userRoot, file);
        UpgradeBase._currentRelease = UpgradeBase._newOSInfo.releaseVersion();
        this.checkNewWASVersion();
        UpgradeBase._installRoot = UpgradeBase._newOSInfo.installRoot();
    }

    protected void verifyBackupDirectory() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"verifyBackupDirectory", (Object)UpgradeBase._backupDirectory);
        if (UpgradeBase._backupDirectory.exists()) {
            if (!UpgradeBase._backupDirectory.isDirectory()) {
                String string = LoggerImpl.get_nls().getString("advise.invalid.backup.directory", "The backup directory cannot be used, it is a file.");
                Tr.debug((TraceComponent)_tc, (String)string);
                throw new ArgumentException(string, null, true);
            }
        } else {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.backup.notexist", new Object[]{UpgradeBase._backupDirectory}, "The input backup directory does not exist {0}.");
            Tr.debug((TraceComponent)_tc, (String)string);
            throw new ArgumentException(string, null, true);
        }
        File file = new File(UpgradeBase._backupDirectory, "websphere_backup");
        OSInfo oSInfo = OSInfoFactory.createOSInfo(file, file);
        ReleaseVersion releaseVersion = oSInfo.releaseVersion();
        if (releaseVersion.isR50() || releaseVersion.isR51() || releaseVersion.isR60()) {
            return;
        }
        throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.unsupported.backup.version", new Object[]{releaseVersion.version(), UpgradeBase._newOSInfo.getProfileName()}, "The version of WebSphere {0} in the specified backup directory cannot be migrated to profile {1}"), null, true);
    }

    public static String retrieveUsage() {
        Tr.entry((TraceComponent)_tc, (String)"retrieveUsage");
        StringBuffer stringBuffer = new StringBuffer(256);
        try {
            File file = new File(UpgradeBase._backupDirectory, "websphere_backup");
            OSInfo oSInfo = OSInfoFactory.createOSInfo(file, file);
            ReleaseVersion releaseVersion = oSInfo.releaseVersion();
            stringBuffer.append(LoggerImpl.get_nls().getString("usage.post.line1", "WASPostUpgrade") + _lineSeparator);
            stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.line2", "<backupDirectoryName>") + _lineSeparator);
            if (OSInfoFactory.isISeries()) {
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line6b", "[ -profileName < profile name > ]") + _lineSeparator);
            } else {
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line6", "[ -oldProfile < old profile name > ] [ -profileName < profile name > ]") + _lineSeparator);
            }
            boolean bl = false;
            if (releaseVersion != null && releaseVersion != ReleaseVersion.UNKNOWN) {
                bl = releaseVersion.isClient();
            }
            if (!bl) {
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line9", "[ -portBlock < port starting block >]") + _lineSeparator);
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line10", "[ -backupConfig < true | false >]") + _lineSeparator);
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line12", "[ -replacePorts < true | false >]") + _lineSeparator);
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line13", "[ -includeApps < true | false | script >]") + _lineSeparator);
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line14", "[ -scriptCompatibility < true | false >]") + _lineSeparator);
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line15", "[ -appInstallDirectory < application install location >]") + _lineSeparator);
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line16", "[-keepDmgrEnabled < true | false >]") + _lineSeparator);
                stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.post.line17", "[-keepAppDirectory < true | false >]") + _lineSeparator);
            }
            stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.line9", "[ -traceString <trace spec> [-traceFile <file name>]]") + _lineSeparator);
        }
        catch (Exception exception) {
            return "";
        }
        return stringBuffer.toString();
    }

    private static void serializeLogMessages(Vector vector, File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"serializeLogMessages", (Object)file.getAbsolutePath());
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(vector);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UpgradeException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        try {
            WASPostUpgrade.copyright("Product Upgrade PostUpgrade tool, Version 1.0");
            if (stringArray.length == 0) {
                WASPostUpgrade.displayOutput(WASPostUpgrade.retrieveUsage());
                System.exit(-1);
            }
            object = new WASPostUpgrade(stringArray);
            ((WASPostUpgrade)object).restore();
            if (LoggerImpl.loggedError()) {
                System.exit(-1);
            } else {
                System.exit(0);
            }
        }
        catch (UpgradeException upgradeException) {
            bl = WASPostUpgrade.handleException(upgradeException);
            if (upgradeException.shouldDisplayHelp()) {
                WASPostUpgrade.displayOutput(WASPostUpgrade.retrieveUsage());
            }
        }
        catch (Throwable throwable) {
            WASPostUpgrade.handleException(throwable);
            bl = true;
        }
        object = null;
        object = LoggerImpl.loggedError() || bl ? LoggerImpl.get_nls().getString("advise.logging.completed.with.failures", "Failed.") : LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "Completed with errors.");
        WASPostUpgrade.displayOutput((String)object);
        System.exit(-1);
    }

    public static String[] get_cmdLineArguments() {
        return _cmdLineArguments;
    }

    public static void set_cmdLineArguments(String[] stringArray) {
        _cmdLineArguments = stringArray;
    }

    public static File get_configRoot() {
        return _configRoot;
    }

    public static void set_configRoot(File file) {
        _configRoot = file;
    }

    public static boolean is_replacePorts() {
        return _replacePorts;
    }

    public static void set_replacePorts(boolean bl) {
        _replacePorts = bl;
    }

    public static boolean is_backupConfig() {
        return _backupConfig;
    }

    public static String get_includeApps() {
        return _includeApps;
    }

    public static void set_includeApps(String string) {
        _includeApps = string;
    }

    public static String get_appInstallDirectory() {
        return _appInstallDirectory;
    }

    public static void set_appInstallDirectory(String string) {
        _appInstallDirectory = string;
    }

    public static String get_controller() {
        return _controller;
    }

    public static void set_controller(String string) {
        _controller = string;
    }

    public static String get_adjunct() {
        return _adjunct;
    }

    public static void set_adjunct(String string) {
        _adjunct = string;
    }

    public static String get_daemon() {
        return _daemon;
    }

    public static void set_daemon(String string) {
        _daemon = string;
    }

    public static String get_dcsHost() {
        return _dcsHost;
    }

    public static void set_dcsHost(String string) {
        _dcsHost = string;
    }

    public static boolean is_keepAppDirectory() {
        return _keepAppDirectory;
    }

    public static void set_keepAppDirectory(boolean bl) {
        _keepAppDirectory = bl;
    }

    public static boolean is_keepDmgrEnabled() {
        return _keepDmgrEnabled;
    }

    public static void set_keepDmgrEnabled(boolean bl) {
        _keepDmgrEnabled = bl;
    }

    public static String get_password() {
        return _password;
    }

    public static void set_password(String string) {
        _password = string;
    }

    public static boolean is_scriptCompatibility() {
        return _scriptCompatibility;
    }

    public static void set_scriptCompatibility(boolean bl) {
        _scriptCompatibility = bl;
    }

    public static boolean is_wasPostUpgrade() {
        return _wasPostUpgrade;
    }

    public static void set_wasPostUpgrade(boolean bl) {
        _wasPostUpgrade = bl;
    }

    public static String get_servant() {
        return _servant;
    }

    public static void set_servant(String string) {
        _servant = string;
    }

    public static String get_userName() {
        return _userName;
    }

    public static void set_userName(String string) {
        _userName = string;
    }

    public static String get_oldInstanceName() {
        return _oldInstanceName;
    }

    public void set_oldInstanceName(String string) {
        _oldInstanceName = string;
    }

    public File get_summaryLog() {
        return this._summaryLog;
    }

    public void set_summaryLog(File file) {
        this._summaryLog = file;
    }

    public static void set_backupConfig(boolean bl) {
        _backupConfig = bl;
    }
}

