/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ApplicationInvoker;
import com.ibm.ws.migration.utility.ConfigRepositoryConnectionImpl;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class ApplicationMigrationHelper {
    private static TraceComponent _tc = Tr.register((Class)ApplicationMigrationHelper.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    protected static Hashtable _deploymentObjectMappings = new Hashtable();
    protected Scenario _scenario = null;
    protected static final String EAR_SUFFIX = ".ear";
    protected static final CommonarchiveFactory _factory = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    protected static String _connectionInfo = null;
    protected static Properties _connectionProps = null;
    protected static Deployment _deployment = null;
    protected static final String[] _gatewayAppsToExclude = new String[]{"wsgw.", "wsgwauth.", "wsgwsoap1.", "wsgwsoap2.", "wsgwsoaphttp1.", "wsgwsoaphttp2.", "wsgwsoapjms1.", "wsgwsoapjms2."};

    public ApplicationMigrationHelper(Scenario scenario) {
        this._scenario = scenario;
        _connectionProps = ConfigRepositoryConnectionImpl.getRemoteConnectionProperties();
        _connectionInfo = _connectionProps != null ? this.getConnectionInformation() : "-conntype NONE";
        try {
            ReleaseVersion releaseVersion = UpgradeBase.get_oldOSInfo().releaseVersion();
            boolean bl = releaseVersion.isEEInstalled();
        }
        catch (UpgradeException upgradeException) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{upgradeException}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string, upgradeException);
        }
    }

    protected boolean extractEARFile(DocumentTransform documentTransform, String string) {
        Tr.entry((TraceComponent)_tc, (String)"extractEARFile", (Object)new Object[]{documentTransform, string});
        try {
            String string2 = documentTransform.getScenario().getOldProductImage().getProfile().getDirectory().getName();
            String string3 = documentTransform.getScenario().getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
            String string4 = null;
            string4 = ((ReleaseVersionImpl)this._scenario.getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this._scenario.getOldProductImage().getReleaseVersion()).isR51() || this._scenario.getOldProductImage().getOperatingSystem().isISeries() ? (WASPostUpgrade.get_oldInstanceName() == null ? UpgradeBase.get_backupDirectory().getAbsolutePath() + File.separator + "websphere_backup" + File.separator + "config" + File.separator + "cells" + File.separator + string3 + File.separator + "applications" + File.separator + string + File.separator + string : UpgradeBase.get_backupDirectory().getAbsolutePath() + File.separator + "profiles" + File.separator + string2 + File.separator + "config" + File.separator + "cells" + File.separator + string3 + File.separator + "applications" + File.separator + string + File.separator + string) : UpgradeBase.get_backupDirectory().getAbsolutePath() + File.separator + "profiles" + File.separator + string2 + File.separator + "config" + File.separator + "cells" + File.separator + string3 + File.separator + "applications" + File.separator + string + File.separator + string;
            String string5 = this._scenario.getNewProductImage().getProfile().getDirectory().getAbsolutePath() + File.separator + "installableApps" + File.separator + string;
            File file = new File(string5);
            boolean bl = file.exists();
            boolean bl2 = false;
            if (bl) {
                try {
                    this._scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getChild("applications").getChild(string);
                    bl2 = true;
                }
                catch (NotFoundException notFoundException) {
                    FileUtilities.deleteDirectoryAndContents(file);
                }
            }
            if (bl2) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.not.migrating.app", new Object[]{string, "Ear File"}, "Will not be migrating object {0} of type {1}, it is already installed."));
                return false;
            }
            EARFile eARFile = _factory.openEARFile(string4);
            eARFile.extractTo(string5, 94);
            eARFile.close();
            File file2 = new File(new File(new File(new File(new File(new File(new File(new File(string5, "META-INF"), "ibmconfig"), "cells"), "defaultCell"), "applications"), "defaultApp"), "deployments"), "defaultApp");
            if (file2.exists()) {
                FileUtilities.deleteDirectoryAndContents(file2);
            }
            this.getDeploymentObject(documentTransform, string);
        }
        catch (Exception exception) {
            String string6 = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string6, exception);
            return false;
        }
        return true;
    }

    protected void getDeploymentObject(DocumentTransform documentTransform, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getDeploymentObject", (Object)new Object[]{documentTransform, string});
        Tr.debug((TraceComponent)_tc, (String)("Attempting to access the deployment.xml file for " + string));
        WCCMDocument wCCMDocument = (WCCMDocument)documentTransform.getOldDocumentCollection().getChild("deployments").getChildren()[0].openDocument("deployment.xml", WCCMDocument.class);
        List list = wCCMDocument.getList();
        if (list == null) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{wCCMDocument}, "Unable to read configuration file {0}.");
            UpgradeBase.get_logger().println(string2);
            throw new UpgradeException(string2, null, false);
        }
        Deployment deployment = (Deployment)list.get(0);
        _deploymentObjectMappings.put(string, deployment);
        wCCMDocument.close();
    }

    protected boolean isSampleOrAdminApp(String string, String[] stringArray, String[] stringArray2) {
        int n;
        Tr.entry((TraceComponent)_tc, (String)"isSampleOrAdminApp");
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            Tr.debug((TraceComponent)_tc, (String)("The sample app in the list is " + stringArray[n]));
            if (!string.equals(stringArray[n])) continue;
            bl = true;
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.not.migrating.sample", new Object[]{string, "Ear File"}, "Will not be migrating object {0} of type {1}, it is a sample."));
            return bl;
        }
        for (n = 0; n < stringArray2.length; ++n) {
            Tr.debug((TraceComponent)_tc, (String)("The admin app in the list is " + stringArray2[n]));
            if (!string.equals(stringArray2[n])) continue;
            bl = true;
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.not.migrating.admin.app", new Object[]{string, "Ear File"}, "Will not be migrating object {0} of type {1}, it is an administrative app."));
            return bl;
        }
        return bl;
    }

    protected boolean isGatewayOrUddiAppOnBase(String string) {
        Tr.entry((TraceComponent)_tc, (String)"isGatewayOrUddiAppOnBase", (Object)string);
        String string2 = ((ProfileImpl)this._scenario.getNewProductImage().getProfile()).getOwningNodeName();
        if (((ReleaseVersionImpl)this._scenario.getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this._scenario.getOldProductImage().getReleaseVersion()).isR51()) {
            if (string.toLowerCase().startsWith("uddiregistry.") && string.toLowerCase().endsWith(EAR_SUFFIX)) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.not.migrating.admin.app", new Object[]{string, "Ear File"}, "Will not be migrating object {0} of type {1}, it is an administrative app."));
                return true;
            }
            Tr.debug((TraceComponent)_tc, (String)("The number of gateway apps on the list is " + _gatewayAppsToExclude.length));
            for (int i = 0; i < _gatewayAppsToExclude.length; ++i) {
                Tr.debug((TraceComponent)_tc, (String)("The gateway app is " + _gatewayAppsToExclude[i] + " and the node name is " + string2));
                if (!string.toLowerCase().startsWith(_gatewayAppsToExclude[i]) || !string.toLowerCase().endsWith(EAR_SUFFIX)) continue;
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.not.migrating.admin.app", new Object[]{string, "Ear File"}, "Will not be migrating object {0} of type {1}, it is an administrative app."));
                return true;
            }
        }
        return false;
    }

    protected boolean installApplication(String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"installApplication", (Object)new Object[]{string2});
        try {
            String string3;
            Iterator iterator = _deploymentObjectMappings.keySet().iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (!string2.equals(string3)) continue;
                _deployment = (Deployment)_deploymentObjectMappings.get(string3);
                break;
            }
            string3 = this.getExecutableString(string, string2);
            if (WASPostUpgrade.get_includeApps().equals("true")) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.using.wsadmin", new Object[]{string2}, "Using wsadmin to deploy the application {0}."));
                int n = new ApplicationInvoker(UpgradeBase.get_newOSInfo()).exec(string3, "wsadmin");
                if (n != 0) {
                    UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.unable.to.deploy.app", new Object[]{string2}, "Unable to deploy the application {0}."));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            String string4 = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string4, exception);
        }
        return true;
    }

    protected void setDeployment(DocumentCollection documentCollection, String string) throws Exception {
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild("cells").getChildren()[0].getChild("applications").getChild(string).getChild("deployments").getChildren()[0].openDocument("deployment.xml", WCCMDocument.class, false, true);
        List list = wCCMDocument.getList();
        if (list == null) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{wCCMDocument}, "Unable to read configuration file {0}.");
            UpgradeBase.get_logger().println(string2);
            throw new UpgradeException(string2, null, false);
        }
        _deployment = (Deployment)list.get(0);
        wCCMDocument.close();
    }

    public void installApplications(DocumentCollection documentCollection, Vector vector) throws Exception {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            int n = string.indexOf("/");
            String string2 = string.substring(0, n);
            this.setDeployment(documentCollection, string2);
            String string3 = documentCollection.getChild("cells").getChildren()[0].getName();
            String string4 = new File(new File(new File(new File(new File(new File(this._scenario.getNewProductImage().getProfile().getDirectory().getAbsolutePath(), "config"), "cells"), string3), "applications"), string2), string2).getAbsolutePath();
            this.installApplication(string4, string2);
        }
    }

    protected String getExecutableString(String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"getExecutableString", (Object)new Object[]{string, string2});
        String string3 = FileUtilities.quotedFileName(new File(new File(UpgradeBase.get_installRoot(), "bin"), "wsadmin" + UpgradeBase.get_newOSInfo().fetchExecutableExtension()).getAbsolutePath());
        Tr.debug((TraceComponent)_tc, (String)("The wsadmin path is " + string3));
        boolean bl = false;
        if (string2.toLowerCase().startsWith("uddiregistry.") && string2.toLowerCase().endsWith(EAR_SUFFIX)) {
            Tr.debug((TraceComponent)_tc, (String)("The ear file " + string2 + " is the UDDI Registry application"));
            bl = true;
        }
        String string4 = ApplicationMigrationHelper.removeNameSpaces(string2);
        String string5 = null;
        String string6 = UpgradeBase.get_newOSInfo().instance();
        Tr.debug((TraceComponent)_tc, (String)("The instance is " + string6));
        String string7 = "";
        if (WASPostUpgrade.get_appInstallDirectory() != null) {
            string7 = "-installed.ear.destination " + WASPostUpgrade.get_appInstallDirectory();
        }
        if (bl) {
            String string8 = this.getuddiDeployDestination(string);
            string5 = string3 + " " + _connectionInfo + string6 + " -f " + new File(new File(UpgradeBase.get_installRoot(), "bin"), "uddiDeploy.jacl") + string8;
            Tr.debug((TraceComponent)_tc, (String)("The final string for install executable " + UtilityImpl.replacePassword(string5)));
        } else {
            this.createJaclFile(string, string2);
            string5 = string3 + " " + string7 + " " + _connectionInfo + string6 + " -f " + FileUtilities.quotedFileName(new File(UpgradeBase.get_backupDirectory(), "install_" + string4 + ".jacl").getAbsolutePath());
            String string9 = FileUtilities.quotedFileName(new File(UpgradeBase.get_backupDirectory(), "migration.props").getAbsolutePath());
            File file = new File(string9);
            if (file.exists()) {
                string5 = string5 + " -p " + string9;
            }
            Tr.debug((TraceComponent)_tc, (String)("The final string for install executable " + UtilityImpl.replacePassword(string5)));
        }
        return string5;
    }

    protected void createJaclFile(String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"createJaclFile", (Object)new Object[]{string, string2});
        try {
            String string3;
            String string4 = null;
            if (string2.toLowerCase().equals("query.ear")) {
                string3 = this._scenario.getNewProductImage().getInstallationDirectory().getAbsolutePath() + File.separator + "installableApps" + File.separator + "query.ear";
                string4 = FileUtilities.quotedFileName(string3.replace('\\', '/'));
            } else if (string2.toLowerCase().equals("schedulercalendars.ear")) {
                if (!this.isSchedulerCalenderUserApp()) {
                    string3 = new File(new File(this._scenario.getNewProductImage().getInstallationDirectory().getAbsolutePath(), "systemApps"), "SchedulerCalendars.ear").getAbsolutePath();
                    string4 = FileUtilities.quotedFileName(string3.replace('\\', '/'));
                } else {
                    string4 = FileUtilities.quotedFileName(string.replace('\\', '/'));
                }
            } else {
                string4 = FileUtilities.quotedFileName(string.replace('\\', '/'));
            }
            Tr.debug((TraceComponent)_tc, (String)("The ear file location is " + string4));
            string3 = this.getDeployOptions(string2, string);
            Tr.debug((TraceComponent)_tc, (String)("The deploy options are " + string3));
            String string5 = ApplicationMigrationHelper.removeNameSpaces(string2);
            File file = new File(UpgradeBase.get_backupDirectory(), "install_" + string5 + ".jacl");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            String string6 = "set earfile " + string4;
            printStream.println(string6);
            String string7 = "$AdminApp install $earfile " + string3;
            printStream.println(string7);
            String string8 = "$AdminConfig save";
            printStream.println(string8);
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            String string9 = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string9, exception);
        }
    }

    protected boolean isSchedulerCalenderUserApp() {
        Tr.debug((TraceComponent)_tc, (String)"isSchedulerCalenderUserApp");
        try {
            DocumentCollection[] documentCollectionArray = this._scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getChild("applications").getChildren();
            for (int i = 0; i < documentCollectionArray.length; ++i) {
                if (!documentCollectionArray[i].getName().toLowerCase().equals("schedulercalendars.ear")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Exception found while verifying SchedulerCalender is User Application: ", (Object)exception);
            return false;
        }
        return false;
    }

    protected String getDeployOptions(String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"getDeployOptions", (Object)new Object[]{string, string2});
        ApplicationDeployment applicationDeployment = (ApplicationDeployment)_deployment.getDeployedObject();
        int n = string.lastIndexOf(EAR_SUFFIX);
        String string3 = string.substring(0, n);
        String string4 = "{-nodeployejb -appname " + FileUtilities.quotedFileName(string3) + " ";
        if (applicationDeployment.isSetCreateMBeansForResources()) {
            string4 = applicationDeployment.isCreateMBeansForResources() ? string4 + "-createMBeansForResources " : string4 + "-nocreateMBeansForResources ";
        }
        if (applicationDeployment.isSetReloadEnabled()) {
            string4 = applicationDeployment.isReloadEnabled() ? string4 + "-reloadEnabled " : string4 + "-noreloadEnabled ";
        }
        if (applicationDeployment.isSetReloadInterval()) {
            string4 = string4 + "-reloadInterval " + applicationDeployment.getReloadInterval() + " ";
        }
        string4 = string4 + "-custom enhancedEarDisableValidation=true ";
        if (string.toLowerCase().equals("schedulercalendars.ear") && !this.isSchedulerCalenderUserApp()) {
            string4 = string4 + "-systemApp ";
        }
        String string5 = this.getDeployDestination(string2);
        return string4 + string5;
    }

    protected String getDeployDestination(String string) {
        Tr.entry((TraceComponent)_tc, (String)"getDeployDestination", (Object)new Object[]{string});
        String string2 = null;
        EList eList = _deployment.getDeploymentTargets();
        if (eList.size() == 1) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(0);
            if (deploymentTarget instanceof ServerTarget) {
                ServerTarget serverTarget = (ServerTarget)deploymentTarget;
                String string3 = this.getNodeName(serverTarget);
                string2 = "-server " + FileUtilities.quotedFileName(deploymentTarget.getName()) + " -node " + string3;
                Tr.debug((TraceComponent)_tc, (String)("The enterprise app is installed on server " + deploymentTarget.getName() + "and on node " + string3));
            } else {
                string2 = "-cluster " + FileUtilities.quotedFileName(deploymentTarget.getName());
                Tr.debug((TraceComponent)_tc, (String)("The enterprise app is installed on cluster " + deploymentTarget.getName()));
            }
        } else {
            string2 = "-MapModulesToServers {" + this.mapModulesToDeploymentTargets(_deployment, string) + "}";
        }
        string2 = string2 + "}";
        Tr.debug((TraceComponent)_tc, (String)("The deploy destination is " + string2));
        return string2;
    }

    protected String mapModulesToDeploymentTargets(Deployment deployment, String string) {
        Tr.entry((TraceComponent)_tc, (String)"mapModulesToDeploymentTargets", (Object)new Object[]{deployment, string});
        ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        EList eList = applicationDeployment.getModules();
        Iterator iterator = eList.iterator();
        String string2 = "";
        try {
            File file = new File(string);
            if (file.exists()) {
                EARFile eARFile = _factory.openEARFile(string);
                while (iterator.hasNext()) {
                    String string3;
                    ModuleDeployment moduleDeployment = (ModuleDeployment)iterator.next();
                    String string4 = moduleDeployment.getUri();
                    if (string4.toLowerCase().endsWith(".jar")) {
                        string3 = this.getJarDisplayName(eARFile, string4);
                        Tr.debug((TraceComponent)_tc, (String)("The module " + string4 + " display name is " + string3));
                        if (string3 != null) {
                            string3 = this.fixUpDisplayName(string3);
                            string2 = string2 + " {" + FileUtilities.quotedFileName(string3) + " " + string4 + ",META-INF/ejb-jar.xml ";
                            Tr.debug((TraceComponent)_tc, (String)("The module string is " + FileUtilities.quotedFileName(string3) + " " + string4 + ",META-INF/ejb-jar.xml"));
                        }
                    } else if (string4.toLowerCase().endsWith(".war")) {
                        string3 = this.getWarDisplayName(eARFile, string4);
                        Tr.debug((TraceComponent)_tc, (String)("The module " + string4 + " display name is " + string3));
                        if (string3 != null) {
                            string3 = this.fixUpDisplayName(string3);
                            string2 = string2 + "{" + FileUtilities.quotedFileName(string3) + " " + string4 + ",WEB-INF/web.xml ";
                            Tr.debug((TraceComponent)_tc, (String)("The module string is " + FileUtilities.quotedFileName(string3) + " " + string4 + ",WEB-INF/web.xml"));
                        }
                    } else if (string4.toLowerCase().endsWith(".rar")) {
                        string3 = this.getRarDisplayName(eARFile, string4);
                        Tr.debug((TraceComponent)_tc, (String)("The module " + string4 + " display name is " + string3));
                        if (string3 != null) {
                            string3 = this.fixUpDisplayName(string3);
                            string2 = string2 + "{" + FileUtilities.quotedFileName(string3) + " " + string4 + ",META-INF/ra.xml ";
                            Tr.debug((TraceComponent)_tc, (String)("The module string is " + FileUtilities.quotedFileName(string3) + " " + string4 + ",META-INF/ra.xml"));
                        }
                    }
                    string2 = this.getDeploymentTargets(string2, moduleDeployment);
                }
                eARFile.close();
            }
        }
        catch (Exception exception) {
            String string5 = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string5, exception);
        }
        return string2;
    }

    protected String getJarDisplayName(EARFile eARFile, String string) {
        Tr.entry((TraceComponent)_tc, (String)"getJarDisplayName", (Object)new Object[]{eARFile, string});
        List list = eARFile.getEJBJarFiles();
        Iterator iterator = list.iterator();
        String string2 = string;
        while (iterator.hasNext()) {
            EJBJarFile eJBJarFile = (EJBJarFile)iterator.next();
            if (!eJBJarFile.getURI().equalsIgnoreCase(string)) continue;
            if (eJBJarFile.getDeploymentDescriptor().getDisplayName() != null) {
                string2 = eJBJarFile.getDeploymentDescriptor().getDisplayName();
            }
            return string2;
        }
        return string2;
    }

    protected String getWarDisplayName(EARFile eARFile, String string) {
        Tr.entry((TraceComponent)_tc, (String)"getWarDisplayName", (Object)new Object[]{eARFile, string});
        List list = eARFile.getWARFiles();
        Iterator iterator = list.iterator();
        String string2 = string;
        while (iterator.hasNext()) {
            WARFile wARFile = (WARFile)iterator.next();
            if (!wARFile.getURI().equalsIgnoreCase(string)) continue;
            if (wARFile.getDeploymentDescriptor().getDisplayName() != null) {
                string2 = wARFile.getDeploymentDescriptor().getDisplayName();
            }
            return string2;
        }
        return string2;
    }

    protected String getRarDisplayName(EARFile eARFile, String string) {
        Tr.entry((TraceComponent)_tc, (String)"getRarDisplayName", (Object)new Object[]{eARFile, string});
        List list = eARFile.getRARFiles();
        Iterator iterator = list.iterator();
        String string2 = string;
        while (iterator.hasNext()) {
            RARFile rARFile = (RARFile)iterator.next();
            if (!rARFile.getURI().equalsIgnoreCase(string)) continue;
            if (rARFile.getDeploymentDescriptor().getDisplayName() != null) {
                string2 = rARFile.getDeploymentDescriptor().getDisplayName();
            }
            return string2;
        }
        return string2;
    }

    protected String fixUpDisplayName(String string) {
        Tr.entry((TraceComponent)_tc, (String)"fixUpDisplayName", (Object)string);
        String string2 = string;
        string2 = string2.replaceAll("\\(", "\\\\(");
        string2 = string2.replaceAll("\\)", "\\\\)");
        return string2;
    }

    protected String getDeploymentTargets(String string, ModuleDeployment moduleDeployment) {
        Tr.entry((TraceComponent)_tc, (String)"getDeploymentTargets", (Object)new Object[]{string, moduleDeployment});
        try {
            String string2 = this._scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
            int n = 0;
            EList eList = moduleDeployment.getTargetMappings();
            Iterator iterator = eList.iterator();
            String string3 = "";
            while (iterator.hasNext()) {
                DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)iterator.next();
                String string4 = deploymentTargetMapping.getTarget().getName();
                Tr.debug((TraceComponent)_tc, (String)("The deployment target name is " + string4));
                if (n != 0) {
                    string3 = string3 + "+";
                }
                if (deploymentTargetMapping.getTarget() instanceof ServerTarget) {
                    Tr.debug((TraceComponent)_tc, (String)("The module " + moduleDeployment.getUri() + " is installed on server " + string4));
                    ServerTarget serverTarget = (ServerTarget)deploymentTargetMapping.getTarget();
                    String string5 = this.getNodeName(serverTarget);
                    string3 = string3 + "WebSphere:cell=" + string2 + ",node=" + string5 + ",server=" + string4;
                } else {
                    Tr.debug((TraceComponent)_tc, (String)("The module " + moduleDeployment.getUri() + " is installed on cluster " + string4));
                    string3 = string3 + "WebSphere:cell=" + string2 + ",cluster=" + string4;
                }
                ++n;
            }
            string = string + FileUtilities.quotedFileName(string3);
        }
        catch (Exception exception) {
            String string6 = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string6, exception);
        }
        string = string + "}";
        return string;
    }

    protected String getuddiDeployDestination(String string) {
        Tr.entry((TraceComponent)_tc, (String)"getDeployDestination", (Object)new Object[]{string});
        String string2 = null;
        EList eList = _deployment.getDeploymentTargets();
        if (eList.size() == 1) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(0);
            if (deploymentTarget instanceof ServerTarget) {
                ServerTarget serverTarget = (ServerTarget)deploymentTarget;
                String string3 = this.getNodeName(serverTarget);
                string2 = " " + string3 + " " + FileUtilities.quotedFileName(deploymentTarget.getName());
                Tr.debug((TraceComponent)_tc, (String)("The enterprise app is installed on server " + deploymentTarget.getName()));
            } else {
                string2 = FileUtilities.quotedFileName(deploymentTarget.getName());
                Tr.debug((TraceComponent)_tc, (String)("The enterprise app is installed on cluster " + deploymentTarget.getName()));
            }
        }
        Tr.debug((TraceComponent)_tc, (String)("The deploy destination is " + string2));
        return string2;
    }

    private static String removeNameSpaces(String string) {
        Tr.entry((TraceComponent)_tc, (String)"removeNameSpaces", (Object)new Object[]{string});
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public void installApplications(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            String string2 = (String)vector.get(i);
            int n = string2.indexOf("/");
            if (n != -1) {
                string = string2.substring(0, n);
                String string3 = new File(new File(this._scenario.getNewProductImage().getProfile().getDirectory().getAbsolutePath(), "installableApps"), string).getAbsolutePath();
                this.installApplication(string3, string);
                continue;
            }
            string = new File(new File(this._scenario.getNewProductImage().getProfile().getDirectory().getAbsolutePath(), "installableApps"), string2).getAbsolutePath();
            this.installApplication(string, string2);
        }
    }

    protected String getConnectionInformation() {
        Tr.entry((TraceComponent)_tc, (String)"getConnectionInformation");
        StringBuffer stringBuffer = new StringBuffer(256).append("-conntype ").append(_connectionProps.getProperty("type")).append(" -port ").append(_connectionProps.getProperty("port")).append(" -host ").append(_connectionProps.getProperty("host"));
        if (Boolean.valueOf(_connectionProps.getProperty("securityEnabled")).booleanValue()) {
            stringBuffer.append(" -username ").append(_connectionProps.getProperty("username")).append(" -password ").append(_connectionProps.getProperty("password"));
        }
        try {
            AdminClient adminClient = AdminClientFactory.createAdminClient((Properties)_connectionProps);
        }
        catch (ConnectorException connectorException) {
            Tr.debug((TraceComponent)_tc, (String)connectorException.toString());
            String string = "-conntype NONE";
            return string;
        }
        Tr.debug((TraceComponent)_tc, (String)("The connection string for wsadmin is " + UtilityImpl.replacePassword(stringBuffer.toString())));
        return stringBuffer.toString();
    }

    protected String getNodeName(ServerTarget serverTarget) {
        Tr.entry((TraceComponent)_tc, (String)"getNodeName", (Object)new Object[]{serverTarget});
        String string = ((ProfileImpl)this._scenario.getNewProductImage().getProfile()).getOwningNodeName();
        return string;
    }

    public void updateAdminApps() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"updateAdminApps");
        String[] stringArray = new String[]{"filetransfer", "isclite"};
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(UpgradeBase.get_backupDirectory(), "update_" + stringArray[i] + ".jacl");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            String string = "$AdminApp edit " + stringArray[i] + " {-MapWebModToVH {{.* .* default_host}}}";
            printStream.println(string);
            String string2 = "$AdminConfig save";
            printStream.println(string2);
            printStream.flush();
            printStream.close();
            String string3 = FileUtilities.quotedFileName(new File(new File(UpgradeBase.get_installRoot(), "bin"), "wsadmin" + UpgradeBase.get_newOSInfo().fetchExecutableExtension()).getAbsolutePath());
            Tr.debug((TraceComponent)_tc, (String)("The wsadmin path is " + string3));
            String string4 = UpgradeBase.get_newOSInfo().instance();
            Tr.debug((TraceComponent)_tc, (String)("The instance is " + string4));
            String string5 = string3 + " " + _connectionInfo + string4 + " -f " + FileUtilities.quotedFileName(new File(UpgradeBase.get_backupDirectory(), "update_" + stringArray[i] + ".jacl").getAbsolutePath());
            int n = new ApplicationInvoker(UpgradeBase.get_newOSInfo()).exec(string5, "wsadmin");
        }
    }
}

